/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.Transaction.RecoverableXAResource;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.SibRaEngineComponent;
import com.ibm.ws.sib.ra.impl.SibRaConnection;
import com.ibm.ws.sib.ra.impl.SibRaConnectionInfo;
import com.ibm.ws.sib.ra.impl.SibRaConnectionRequestInfo;
import com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.ra.recovery.SibRaRecoveryManager;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionListener;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import com.ibm.wsspi.sib.core.SIXAResource;
import com.ibm.wsspi.sib.core.exception.SIConnectionDroppedException;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIConnectionUnavailableException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.DissociatableManagedConnection;
import javax.resource.spi.LazyEnlistableConnectionManager;
import javax.resource.spi.LazyEnlistableManagedConnection;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

final class SibRaManagedConnection
implements ManagedConnection,
LazyEnlistableManagedConnection,
DissociatableManagedConnection {
    private final SibRaManagedConnectionFactory _factory;
    private final SICoreConnection _coreConnection;
    private final SibRaConnectionInfo _connectionInfo;
    private final Set _eventListeners = new HashSet();
    private PrintWriter _logWriter;
    private final Set _connections = new HashSet();
    private SibRaLocalTransaction _localTransaction;
    private SibRaXaResource _xaResource;
    private ManagedConnectionMetaData _metaData;
    private final SibRaConnectionListener _connectionListener;
    private Exception _connectionException;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaManagedConnection.class);
    private static final TraceComponent LOCAL_TRAN_TRACE = SibRaUtils.getTraceComponent(SibRaLocalTransaction.class);
    private static final TraceComponent XA_RESOURCE_TRACE = SibRaUtils.getTraceComponent(SibRaXaResource.class);
    private static TraceComponent LISTENER_TRACE = SibRaUtils.getTraceComponent(SibRaConnectionListener.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String FFDC_PROBE_1 = "1";
    private static final String FFDC_PROBE_2 = "2";
    private static final String FFDC_PROBE_3 = "3";
    private static final String FFDC_PROBE_4 = "4";
    private static final String FFDC_PROBE_5 = "5";
    private static final String FFDC_PROBE_6 = "6";
    private static final String FFDC_PROBE_7 = "7";
    private static final String FFDC_PROBE_8 = "8";
    private static final String FFDC_PROBE_9 = "9";
    private static final String FFDC_PROBE_10 = "10";
    private static final String FFDC_PROBE_11 = "11";
    private static final String FFDC_PROBE_12 = "12";

    SibRaManagedConnection(SibRaManagedConnectionFactory sibRaManagedConnectionFactory, SibRaConnectionInfo sibRaConnectionInfo, SICoreConnection sICoreConnection) throws SIConnectionDroppedException, SIConnectionUnavailableException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaManagedConnection", (Object)new Object[]{sibRaManagedConnectionFactory, sibRaConnectionInfo, sICoreConnection});
        }
        this._factory = sibRaManagedConnectionFactory;
        this._connectionInfo = sibRaConnectionInfo;
        this._coreConnection = sICoreConnection;
        this._connectionListener = new SibRaConnectionListener();
        this._coreConnection.addConnectionListener((SICoreConnectionListener)this._connectionListener);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaManagedConnection");
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)new Object[]{SibRaUtils.subjectToString(subject), connectionRequestInfo});
        }
        SibRaConnection sibRaConnection = null;
        if (connectionRequestInfo instanceof SibRaConnectionRequestInfo) {
            SibRaConnectionRequestInfo sibRaConnectionRequestInfo = (SibRaConnectionRequestInfo)connectionRequestInfo;
            SICoreConnection sICoreConnection = null;
            try {
                this._connectionException = null;
                sICoreConnection = this._coreConnection.cloneConnection();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection.getConnection", (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
                }
                this.connectionErrorOccurred((Exception)((Object)sIException), true);
                this._connectionException = sIException;
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection.getConnection", (String)FFDC_PROBE_7, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
                }
                this.connectionErrorOccurred((Exception)((Object)sIErrorException), true);
                this._connectionException = sIErrorException;
            }
            if (sICoreConnection != null) {
                sibRaConnectionRequestInfo.setCoreConnection(sICoreConnection);
                sibRaConnection = new SibRaConnection(this, sibRaConnectionRequestInfo, sICoreConnection);
                this._connections.add(sibRaConnection);
            } else {
                sibRaConnection = new SibRaConnection(this, sibRaConnectionRequestInfo, sICoreConnection);
            }
        } else {
            throw new ResourceAdapterInternalException(NLS.getFormattedMessage("UNRECOGNISED_REQUEST_INFO_CWSIV0401", new Object[]{connectionRequestInfo, SibRaConnectionRequestInfo.class}, null));
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getConnection", (Object)sibRaConnection);
        }
        return sibRaConnection;
    }

    public void destroy() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"destroy");
        }
        this.cleanup();
        try {
            this._coreConnection.close();
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection.destroy", (String)FFDC_PROBE_2, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIException));
            }
            throw new ResourceException(NLS.getFormattedMessage("CONNECTION_CLOSE_CWSIV0402", new Object[]{sIException}, null), (Throwable)sIException);
        }
        catch (SIErrorException sIErrorException) {
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection.destroy", (String)FFDC_PROBE_8, (Object)this);
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)sIErrorException));
            }
            throw new ResourceException(NLS.getFormattedMessage("CONNECTION_CLOSE_CWSIV0402", new Object[]{sIErrorException}, null), (Throwable)sIErrorException);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"destroy");
        }
    }

    public void cleanup() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
        Iterator iterator = this._connections.iterator();
        while (iterator.hasNext()) {
            SibRaConnection sibRaConnection = (SibRaConnection)iterator.next();
            sibRaConnection.invalidate();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"cleanup");
        }
    }

    public void associateConnection(Object object) throws ResourceAdapterInternalException {
        SibRaConnection sibRaConnection;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"associateConnection", (Object)object);
        }
        if (object instanceof SibRaConnection) {
            sibRaConnection = (SibRaConnection)object;
            SibRaManagedConnection sibRaManagedConnection = sibRaConnection.getManagedConnection();
            if (sibRaManagedConnection != null) {
                sibRaManagedConnection._connections.remove(object);
            }
        } else {
            ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException(NLS.getFormattedMessage("UNRECOGNISED_CONNECTION_CWSIV0403", new Object[]{object, SibRaConnection.class}, null));
            if (TRACE.isEventEnabled()) {
                SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)resourceAdapterInternalException);
            }
            throw resourceAdapterInternalException;
        }
        sibRaConnection.setManagedConnection(this);
        this._connections.add(sibRaConnection);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"associateConnection");
        }
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"addConnectionEventListener", (Object)connectionEventListener);
        }
        this._eventListeners.add(connectionEventListener);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"addConnectionEventListener");
        }
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"removeConnectionEventListener", (Object)connectionEventListener);
        }
        this._eventListeners.remove(connectionEventListener);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"removeConnectionEventListener");
        }
    }

    public XAResource getXAResource() throws ResourceException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getXAResource");
        }
        if (this._xaResource == null) {
            this._xaResource = new SibRaXaResource();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getXAResource", (Object)this._xaResource);
        }
        return this._xaResource;
    }

    public LocalTransaction getLocalTransaction() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getLocalTransaction");
        }
        if (this._localTransaction == null) {
            this._localTransaction = new SibRaLocalTransaction();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getLocalTransaction", (Object)this._localTransaction);
        }
        return this._localTransaction;
    }

    public ManagedConnectionMetaData getMetaData() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getMetaData");
        }
        if (this._metaData == null) {
            this._metaData = new SibRaMetaData();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getMetaData", (Object)this._metaData);
        }
        return this._metaData;
    }

    public void setLogWriter(PrintWriter printWriter) {
        this._logWriter = printWriter;
    }

    public PrintWriter getLogWriter() {
        return this._logWriter;
    }

    public void dissociateConnections() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"dissociateConnections");
        }
        Iterator iterator = this._connections.iterator();
        while (iterator.hasNext()) {
            SibRaConnection sibRaConnection = (SibRaConnection)iterator.next();
            sibRaConnection.setManagedConnection(null);
        }
        this._connections.clear();
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"dissociateConnections");
        }
    }

    boolean matches(SibRaConnectionInfo sibRaConnectionInfo, SICoreConnection sICoreConnection) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"matches", (Object)new Object[]{sibRaConnectionInfo, sICoreConnection});
        }
        boolean bl = sICoreConnection != null ? this._coreConnection.isEquivalentTo(sICoreConnection) : this._connectionInfo.equals(sibRaConnectionInfo);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"matches", (Object)bl);
        }
        return bl;
    }

    SITransaction getContainerTransaction(ConnectionManager connectionManager) throws ResourceException {
        SITransaction sITransaction;
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getContainerTransaction", (Object)connectionManager);
        }
        if ((sITransaction = this.getCurrentTransaction()) == null && connectionManager instanceof LazyEnlistableConnectionManager) {
            ((LazyEnlistableConnectionManager)connectionManager).lazyEnlist((ManagedConnection)this);
            sITransaction = this.getCurrentTransaction();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getContainerTransaction", (Object)sITransaction);
        }
        return sITransaction;
    }

    private SITransaction getCurrentTransaction() {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"getCurrentTransaction");
        }
        SIUncoordinatedTransaction sIUncoordinatedTransaction = null;
        if (this._localTransaction != null) {
            sIUncoordinatedTransaction = this._localTransaction.getCurrentTransaction();
        }
        if (sIUncoordinatedTransaction == null && this._xaResource != null) {
            sIUncoordinatedTransaction = this._xaResource.getCurrentTransaction();
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"getCurrentTransaction", (Object)sIUncoordinatedTransaction);
        }
        return sIUncoordinatedTransaction;
    }

    void localTransactionStarted(SibRaConnection sibRaConnection) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"localTransactionStarted", (Object)sibRaConnection);
        }
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 2);
        connectionEvent.setConnectionHandle((Object)sibRaConnection);
        Iterator iterator = this._eventListeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
            connectionEventListener.localTransactionStarted(connectionEvent);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"localTransactionStarted");
        }
    }

    void localTransactionCommitted(SibRaConnection sibRaConnection) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"localTransactionCommitted", (Object)sibRaConnection);
        }
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 3);
        connectionEvent.setConnectionHandle((Object)sibRaConnection);
        Iterator iterator = this._eventListeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
            connectionEventListener.localTransactionCommitted(connectionEvent);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"localTransactionStarted");
        }
    }

    void localTransactionRolledBack(SibRaConnection sibRaConnection) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"localTransactionRolledBack", (Object)sibRaConnection);
        }
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 4);
        connectionEvent.setConnectionHandle((Object)sibRaConnection);
        Iterator iterator = this._eventListeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
            connectionEventListener.localTransactionRolledback(connectionEvent);
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"localTransactionRolledBack");
        }
    }

    void connectionClosed(SibRaConnection sibRaConnection) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"connectionClosed", (Object)sibRaConnection);
        }
        ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 1);
        connectionEvent.setConnectionHandle((Object)sibRaConnection);
        Iterator iterator = this._eventListeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener connectionEventListener = (ConnectionEventListener)iterator.next();
            connectionEventListener.connectionClosed(connectionEvent);
        }
        this._connections.remove(sibRaConnection);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"connectionClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void connectionErrorOccurred(Exception exception, boolean bl) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"connectionErrorOccurred");
        }
        if (!SibRaEngineComponent.isServerStopping()) {
            ArrayList arrayList;
            ConnectionEvent connectionEvent = new ConnectionEvent((ManagedConnection)this, 5, exception);
            Object object = this._eventListeners;
            synchronized (object) {
                arrayList = new ArrayList(this._eventListeners);
            }
            if (bl) {
                object = arrayList.iterator();
                while (object.hasNext()) {
                    Object e = object.next();
                    if (!(e instanceof ConnectionEventListener)) continue;
                    ((ConnectionEventListener)e).connectionErrorOccurred(connectionEvent);
                }
            }
        }
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"connectionErrorOccurred");
        }
    }

    public Exception getConnectionException() {
        return this._connectionException;
    }

    private final class SibRaConnectionListener
    implements SICoreConnectionListener {
        private SibRaConnectionListener() {
        }

        public void asynchronousException(ConsumerSession consumerSession, Throwable throwable) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"asynchronousException", (Object)new Object[]{consumerSession, throwable});
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"asynchronousException");
            }
        }

        public void meQuiescing(SICoreConnection sICoreConnection) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meQuiescing", (Object)sICoreConnection);
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meQuiescing");
            }
        }

        public void commsFailure(SICoreConnection sICoreConnection, SIConnectionLostException sIConnectionLostException) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"commsFailure", (Object)new Object[]{sICoreConnection, sIConnectionLostException});
            }
            SibRaManagedConnection.this.connectionErrorOccurred((Exception)((Object)sIConnectionLostException), false);
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"commsFailure");
            }
        }

        public void meTerminated(SICoreConnection sICoreConnection) {
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meTerminated", (Object)sICoreConnection);
            }
            SibRaManagedConnection.this.connectionErrorOccurred(null, false);
            if (LISTENER_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LISTENER_TRACE, (String)"meTerminated");
            }
        }
    }

    private final class SibRaXaResource
    implements RecoverableXAResource {
        private final SIXAResource _delegateXaResource;
        private final int _xaRecoveryToken;

        public SibRaXaResource() throws ResourceException {
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaXaResource");
            }
            SibRaRecoveryManager sibRaRecoveryManager = SibRaRecoveryManager.getInstance();
            String string = SibRaManagedConnection.this._connectionInfo.getBusName();
            String string2 = SibRaManagedConnection.this._coreConnection.getMeUuid();
            String string3 = SibRaManagedConnection.this._coreConnection.getMeName();
            this._xaRecoveryToken = SibRaManagedConnection.this._factory.getXARecoveryAlias() == null ? sibRaRecoveryManager.getRecoveryToken(string, string3, string2, SibRaManagedConnection.this._connectionInfo.getUserName(), SibRaManagedConnection.this._connectionInfo.getPassword()) : sibRaRecoveryManager.getRecoveryToken(string, string3, string2, SibRaManagedConnection.this._factory.getXARecoveryAlias());
            try {
                this._delegateXaResource = SibRaManagedConnection.this._coreConnection.getSIXAResource();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaXaResource.SibRaXaResource", (String)SibRaManagedConnection.FFDC_PROBE_6, (Object)this);
                if (XA_RESOURCE_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (Exception)((Object)sIException));
                }
                throw new ResourceException(NLS.getFormattedMessage("XARESOURCE_CREATE_CWSIV0408", new Object[]{sIException}, null), (Throwable)sIException);
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaXaResource.SibRaXaResource", (String)SibRaManagedConnection.FFDC_PROBE_12, (Object)this);
                if (XA_RESOURCE_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (Exception)((Object)sIErrorException));
                }
                throw new ResourceException(NLS.getFormattedMessage("XARESOURCE_CREATE_CWSIV0408", new Object[]{sIErrorException}, null), (Throwable)sIErrorException);
            }
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaXaResource");
            }
        }

        public int getXARecoveryToken() {
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"getXARecoveryToken");
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"getXARecoveryToken", (Object)new Integer(this._xaRecoveryToken));
            }
            return this._xaRecoveryToken;
        }

        public void commit(Xid xid, boolean bl) throws XAException {
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"commit", (Object)new Object[]{xid, bl});
            }
            this._delegateXaResource.commit(xid, bl);
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"commit");
            }
        }

        public void end(Xid xid, int n) throws XAException {
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"end", (Object)new Object[]{xid, new Integer(n)});
            }
            this._delegateXaResource.end(xid, n);
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"end");
            }
        }

        public void forget(Xid xid) throws XAException {
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"forget", (Object)xid);
            }
            this._delegateXaResource.forget(xid);
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"forget");
            }
        }

        public int getTransactionTimeout() throws XAException {
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"getTransactionTimeout");
            }
            int n = this._delegateXaResource.getTransactionTimeout();
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"getTransactionTimeout", (Object)new Integer(n));
            }
            return n;
        }

        public boolean isSameRM(XAResource xAResource) throws XAException {
            boolean bl;
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"isSameRM", (Object)xAResource);
            }
            if (xAResource instanceof SibRaXaResource) {
                SibRaXaResource sibRaXaResource = (SibRaXaResource)((Object)xAResource);
                bl = this._delegateXaResource.isSameRM((XAResource)sibRaXaResource._delegateXaResource);
            } else {
                bl = this._delegateXaResource.isSameRM(xAResource);
            }
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"isSameRM", (Object)bl);
            }
            return bl;
        }

        public int prepare(Xid xid) throws XAException {
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"prepare", (Object)xid);
            }
            int n = this._delegateXaResource.prepare(xid);
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"prepare", (Object)new Integer(n));
            }
            return n;
        }

        public Xid[] recover(int n) throws XAException {
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"recover", (Object)new Integer(n));
            }
            Xid[] xidArray = this._delegateXaResource.recover(n);
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"recover", (Object)xidArray);
            }
            return xidArray;
        }

        public void rollback(Xid xid) throws XAException {
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"rollback", (Object)xid);
            }
            this._delegateXaResource.rollback(xid);
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"rollback");
            }
        }

        public boolean setTransactionTimeout(int n) throws XAException {
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"setTransactionTimeout", (Object)new Integer(n));
            }
            boolean bl = this._delegateXaResource.setTransactionTimeout(n);
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"setTransactionTimeout", (Object)bl);
            }
            return bl;
        }

        public void start(Xid xid, int n) throws XAException {
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"start", (Object)new Object[]{xid, new Integer(n)});
            }
            this._delegateXaResource.start(xid, n);
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"start");
            }
        }

        private SIXAResource getCurrentTransaction() {
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"getCurrentTransaction");
            }
            SIXAResource sIXAResource = this._delegateXaResource.isEnlisted() ? this._delegateXaResource : null;
            if (XA_RESOURCE_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)XA_RESOURCE_TRACE, (String)"getCurrentTransaction", (Object)sIXAResource);
            }
            return sIXAResource;
        }
    }

    private final class SibRaLocalTransaction
    implements LocalTransaction {
        private SIUncoordinatedTransaction _uncoordinatedTransaction;

        private SibRaLocalTransaction() {
        }

        public void begin() throws ResourceException {
            if (LOCAL_TRAN_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (String)"begin");
            }
            if (this._uncoordinatedTransaction != null) {
                LocalTransactionException localTransactionException = new LocalTransactionException(NLS.getString("ACTIVE_LOCAL_TRAN_CWSIV0404"));
                if (LOCAL_TRAN_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (Exception)localTransactionException);
                }
                throw localTransactionException;
            }
            try {
                this._uncoordinatedTransaction = SibRaManagedConnection.this._coreConnection.createUncoordinatedTransaction();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaLocalTransaction.begin", (String)SibRaManagedConnection.FFDC_PROBE_3, (Object)this);
                if (LOCAL_TRAN_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (Exception)((Object)sIException));
                }
                throw new ResourceException(NLS.getFormattedMessage("LOCAL_TRAN_BEGIN_CWSIV0405", new Object[]{sIException}, null), (Throwable)sIException);
            }
            catch (SIErrorException sIErrorException) {
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaLocalTransaction.begin", (String)SibRaManagedConnection.FFDC_PROBE_9, (Object)this);
                if (LOCAL_TRAN_TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (Exception)((Object)sIErrorException));
                }
                throw new ResourceException(NLS.getFormattedMessage("LOCAL_TRAN_BEGIN_CWSIV0405", new Object[]{sIErrorException}, null), (Throwable)sIErrorException);
            }
            if (LOCAL_TRAN_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (String)"begin");
            }
        }

        public void commit() throws ResourceException {
            if (LOCAL_TRAN_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (String)"commit");
            }
            if (this._uncoordinatedTransaction == null) {
                Iterator iterator = SibRaManagedConnection.this._connections.iterator();
                while (iterator.hasNext()) {
                    SibRaConnection sibRaConnection = (SibRaConnection)iterator.next();
                    sibRaConnection.commitApplicationLocalTransaction();
                }
            } else {
                try {
                    this._uncoordinatedTransaction.commit();
                    this._uncoordinatedTransaction = null;
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaLocalTranssaction.commit", (String)SibRaManagedConnection.FFDC_PROBE_4, (Object)this);
                    if (LOCAL_TRAN_TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (Exception)((Object)sIException));
                    }
                    throw new ResourceException(NLS.getFormattedMessage("LOCAL_TRAN_COMMIT_CWSIV0406", new Object[]{sIException}, null), (Throwable)sIException);
                }
                catch (SIErrorException sIErrorException) {
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaLocalTranssaction.commit", (String)SibRaManagedConnection.FFDC_PROBE_10, (Object)this);
                    if (LOCAL_TRAN_TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (Exception)((Object)sIErrorException));
                    }
                    throw new ResourceException(NLS.getFormattedMessage("LOCAL_TRAN_COMMIT_CWSIV0406", new Object[]{sIErrorException}, null), (Throwable)sIErrorException);
                }
            }
            if (LOCAL_TRAN_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (String)"commit");
            }
        }

        public void rollback() throws ResourceException {
            if (LOCAL_TRAN_TRACE.isEntryEnabled()) {
                SibTr.entry((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (String)"rollback");
            }
            if (this._uncoordinatedTransaction == null) {
                Iterator iterator = SibRaManagedConnection.this._connections.iterator();
                while (iterator.hasNext()) {
                    SibRaConnection sibRaConnection = (SibRaConnection)iterator.next();
                    sibRaConnection.rollbackApplicationLocalTransaction();
                }
            } else {
                try {
                    this._uncoordinatedTransaction.rollback();
                    this._uncoordinatedTransaction = null;
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaLocalTranssaction.rollback", (String)SibRaManagedConnection.FFDC_PROBE_5, (Object)this);
                    if (LOCAL_TRAN_TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (Exception)((Object)sIException));
                    }
                    throw new ResourceException(NLS.getFormattedMessage("LOCAL_TRAN_ROLLBACK_CWSIV0407", new Object[]{sIException}, null), (Throwable)sIException);
                }
                catch (SIErrorException sIErrorException) {
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.ra.impl.SibRaManagedConnection$SibRaLocalTranssaction.rollback", (String)SibRaManagedConnection.FFDC_PROBE_11, (Object)this);
                    if (LOCAL_TRAN_TRACE.isEventEnabled()) {
                        SibTr.exception((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (Exception)((Object)sIErrorException));
                    }
                    throw new ResourceException(NLS.getFormattedMessage("LOCAL_TRAN_ROLLBACK_CWSIV0407", new Object[]{sIErrorException}, null), (Throwable)sIErrorException);
                }
            }
            if (LOCAL_TRAN_TRACE.isEntryEnabled()) {
                SibTr.exit((Object)this, (TraceComponent)LOCAL_TRAN_TRACE, (String)"rollback");
            }
        }

        private SIUncoordinatedTransaction getCurrentTransaction() {
            return this._uncoordinatedTransaction;
        }
    }

    private final class SibRaMetaData
    implements ManagedConnectionMetaData {
        private SibRaMetaData() {
        }

        public String getEISProductName() {
            return "";
        }

        public String getEISProductVersion() {
            return "";
        }

        public int getMaxConnections() {
            return 0;
        }

        public String getUserName() {
            return SibRaManagedConnection.this._connectionInfo.getUserName();
        }
    }
}

