/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.ra.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.ra.impl.SibRaConnection;
import com.ibm.ws.sib.ra.impl.SibRaConnectionRequestInfo;
import com.ibm.ws.sib.ra.impl.SibRaManagedConnectionFactory;
import com.ibm.ws.sib.ra.impl.SibRaUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SICoreConnectionFactory;
import com.ibm.wsspi.sib.core.exception.SIAuthenticationException;
import java.io.Serializable;
import java.util.Map;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.security.auth.Subject;

final class SibRaConnectionFactory
implements SICoreConnectionFactory,
Serializable {
    private static final long serialVersionUID = -2706996958601844542L;
    private final SibRaManagedConnectionFactory _managedConnectionFactory;
    private final ConnectionManager _connectionManager;
    private static final TraceComponent TRACE = SibRaUtils.getTraceComponent(SibRaConnectionFactory.class);
    private static final TraceNLS NLS = SibRaUtils.getTraceNls();
    private static final String FFDC_PROBE_1 = "1";

    SibRaConnectionFactory(SibRaManagedConnectionFactory sibRaManagedConnectionFactory, ConnectionManager connectionManager) {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionFactory", (Object)new Object[]{sibRaManagedConnectionFactory, connectionManager});
        }
        this._managedConnectionFactory = sibRaManagedConnectionFactory;
        this._connectionManager = connectionManager;
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"SibRaConnectionFactory");
        }
    }

    public SICoreConnection createConnection(String string, String string2, Map map) throws SIResourceException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIAuthenticationException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)new Object[]{string, string2, map});
        }
        SibRaConnectionRequestInfo sibRaConnectionRequestInfo = new SibRaConnectionRequestInfo(string, string2, map);
        SibRaConnection sibRaConnection = this.createConnection(sibRaConnectionRequestInfo);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)sibRaConnection);
        }
        return sibRaConnection;
    }

    public SICoreConnection createConnection(Subject subject, Map map) throws SIResourceException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIAuthenticationException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)new Object[]{SibRaUtils.subjectToString(subject), map});
        }
        SibRaConnectionRequestInfo sibRaConnectionRequestInfo = new SibRaConnectionRequestInfo(subject, map);
        SibRaConnection sibRaConnection = this.createConnection(sibRaConnectionRequestInfo);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)sibRaConnection);
        }
        return sibRaConnection;
    }

    private SibRaConnection createConnection(ConnectionRequestInfo connectionRequestInfo) throws SIResourceException, SINotPossibleInCurrentConfigurationException, SIIncorrectCallException, SIAuthenticationException {
        if (TRACE.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)connectionRequestInfo);
        }
        SibRaConnection sibRaConnection = null;
        boolean bl = true;
        do {
            try {
                Object object = this._connectionManager.allocateConnection((ManagedConnectionFactory)this._managedConnectionFactory, connectionRequestInfo);
                if (object instanceof SibRaConnection) {
                    sibRaConnection = (SibRaConnection)object;
                    sibRaConnection.setConnectionFactory(this);
                    bl = sibRaConnection.isCoreConnectionInValid();
                    if (bl) {
                        SibTr.info((TraceComponent)TRACE, (String)NLS.getFormattedMessage("CONNECTION_ERROR_RETRY_CWSIV0356", new Object[]{sibRaConnection.getManagedConnection().getConnectionException()}, null));
                    }
                    continue;
                }
                ResourceAdapterInternalException resourceAdapterInternalException = new ResourceAdapterInternalException(NLS.getFormattedMessage("INCORRECT_CONNECTION_TYPE_CWSIV0101", new Object[]{object, SibRaConnection.class}, null));
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)resourceAdapterInternalException);
                }
                throw resourceAdapterInternalException;
            }
            catch (ResourceException resourceException) {
                FFDCFilter.processException((Throwable)resourceException, (String)"com.ibm.ws.sib.ra.impl.SibRaConnectionFactory.createConnection", (String)FFDC_PROBE_1, (Object)this);
                if (TRACE.isEventEnabled()) {
                    SibTr.exception((Object)this, (TraceComponent)TRACE, (Exception)((Object)resourceException));
                }
                if (resourceException.getCause() instanceof SIResourceException) {
                    throw (SIResourceException)resourceException.getCause();
                }
                if (resourceException.getCause() instanceof SIErrorException) {
                    throw (SIErrorException)resourceException.getCause();
                }
                if (resourceException.getCause() instanceof SINotPossibleInCurrentConfigurationException) {
                    throw (SINotPossibleInCurrentConfigurationException)resourceException.getCause();
                }
                if (resourceException.getCause() instanceof SIIncorrectCallException) {
                    throw (SIIncorrectCallException)resourceException.getCause();
                }
                if (resourceException.getCause() instanceof SIAuthenticationException) {
                    throw (SIAuthenticationException)resourceException.getCause();
                }
                throw new SIResourceException(NLS.getString("CONNECTION_FACTORY_EXCEPTION_CWSIV0100"), (Throwable)resourceException);
            }
        } while (bl);
        if (TRACE.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)TRACE, (String)"createConnection", (Object)sibRaConnection);
        }
        return sibRaConnection;
    }

    public String toString() {
        StringBuffer stringBuffer = SibRaUtils.startToString(this);
        SibRaUtils.addFieldToString(stringBuffer, "managedConnectionFactory", this._managedConnectionFactory);
        SibRaUtils.addFieldToString(stringBuffer, "connectionManager", this._connectionManager);
        SibRaUtils.endToString(stringBuffer);
        return stringBuffer.toString();
    }

    ConnectionManager getConnectionManager() {
        return this._connectionManager;
    }

    SibRaManagedConnectionFactory getManagedConnectionFactory() {
        return this._managedConnectionFactory;
    }

    static {
        if (TRACE.isDebugEnabled()) {
            SibTr.debug((TraceComponent)TRACE, (String)"Source info: @(#)SIB/ws/code/sib.ra.impl/src/com/ibm/ws/sib/ra/impl/SibRaConnectionFactory.java, SIB.ra, WAS602.SIB, o0610.11 1.10.1.1");
        }
    }
}

