/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.MessageDecodeFailedException;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerMessageFactory;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerResponseMessage;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerSubscription;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerSubscriptionQuery;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerSubscriptionResponse;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerUuidQuery;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerUuidResponse;
import com.ibm.ws.sib.mfp.mqinterop.util.HexString;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.psb.BridgeController;
import com.ibm.ws.sib.psb.PSBFactoryPoint;
import com.ibm.ws.sib.psb.admin.BridgeControllerAdmin;
import com.ibm.ws.sib.psb.config.DestinationData;
import com.ibm.ws.sib.psb.config.InboundProfile;
import com.ibm.ws.sib.psb.config.MappingProfile;
import com.ibm.ws.sib.psb.config.brokers.EBInboundProfile;
import com.ibm.ws.sib.psb.config.brokers.impl.EBInboundProfileImpl;
import com.ibm.ws.sib.psb.impl.BridgeControllerImpl;
import com.ibm.ws.sib.psb.impl.EB_PubSubController;
import com.ibm.ws.sib.utils.TopicWildcardTranslation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.Distribution;
import com.ibm.wsspi.sib.core.LockedMessageEnumeration;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class PSBCleanup {
    private static final TraceComponent tc = SibTr.register((Class)PSBCleanup.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");
    private static final TraceComponent ebCleanupTC = SibTr.register((Class)EBCleanup.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");
    private static final String brokerAdminQ = "SYSTEM.BROKER.ADMIN.QUEUE";
    private ArrayList controllerList;
    private JsMessagingEngine engine;
    private MPCoreConnection connection;
    private HashSet ebSubscriptionsInUse = new HashSet();
    private HashSet ebSubscriptionQueuesInUse = new HashSet();
    private int activeEBCleanupCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PSBCleanup(ArrayList arrayList) throws SIException {
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"PSBCleanup(ArrayList)");
        }
        this.controllerList = arrayList;
        this.engine = ((BridgeController)arrayList.get(0)).getEngine();
        this.connection = (MPCoreConnection)PSBFactoryPoint.getInstance().createLocalConnection(this.engine);
        for (int i = 0; i < arrayList.size(); ++i) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Controller " + i + " of " + arrayList.size()));
            }
            BridgeController bridgeController = (BridgeController)arrayList.get(i);
            object2 = bridgeController.getMappingRegistry();
            object = object2.getActiveProfiles();
            for (int j = 0; j < ((MappingProfile[])object).length; ++j) {
                InboundProfile inboundProfile = object[j].getInboundProfile();
                if (!(inboundProfile instanceof EBInboundProfile)) continue;
                EBInboundProfile eBInboundProfile = (EBInboundProfile)inboundProfile;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("eb subscription in use : " + eBInboundProfile));
                }
                String string = eBInboundProfile.getSubscriberQueue().getName();
                this.ebSubscriptionQueuesInUse.add(string);
                this.ebSubscriptionsInUse.add(eBInboundProfile);
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Total active EBInboundProfiles: " + this.ebSubscriptionsInUse.size()));
        }
        PSBCleanup pSBCleanup = this;
        synchronized (pSBCleanup) {
            for (int i = 0; i < arrayList.size(); ++i) {
                object2 = (BridgeControllerImpl)arrayList.get(i);
                object = ((BridgeControllerImpl)object2).getBridgeControllerAdmin();
                EBCleanup eBCleanup = new EBCleanup(this.connection, (BridgeControllerAdmin)object);
                ++this.activeEBCleanupCount;
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("activeEBCleanupCount is " + this.activeEBCleanupCount));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"PSBCleanup(ArrayList)");
        }
    }

    private synchronized void ebCleanupComplete() {
        block6: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"ebCleanupComplete()");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("activeEBCleanupCount is " + this.activeEBCleanupCount));
            }
            try {
                --this.activeEBCleanupCount;
                if (this.activeEBCleanupCount <= 0 && this.connection != null) {
                    this.connection.close();
                    this.connection = null;
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"PSBCleanup", (String)"ebCleanupComplete#1");
                if (!tc.isEventEnabled()) break block6;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ebCleanupComplete()");
        }
    }

    private boolean ebSubscriptionsInUseContains(EBInboundProfile eBInboundProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ebSubscriptionsInUseContains(EBInboundProfile)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("requiredProfile : " + eBInboundProfile));
        }
        boolean bl = false;
        if (this.ebSubscriptionsInUse != null) {
            Iterator iterator = this.ebSubscriptionsInUse.iterator();
            while (iterator.hasNext()) {
                EBInboundProfile eBInboundProfile2;
                Object e = iterator.next();
                if (!(e instanceof EBInboundProfile) || !(eBInboundProfile2 = (EBInboundProfile)e).equalsForCleanup(eBInboundProfile)) continue;
                bl = true;
                break;
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return boolean : " + bl));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ebSubscriptionsInUseContains(EBInboundProfile)");
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/impl/PSBCleanup.java, SIB.psb, WAS602.SIB, o0610.11 1.35");
        }
    }

    private class EBCleanup
    implements AsynchConsumerCallback {
        private SICoreConnection connection;
        private BridgeControllerAdmin controllerAdmin;
        private SIDestinationAddress replyDest;
        private ConsumerSession consumer;
        private int state;
        private final int WAITING_FOR_UUID = 1;
        private final int WAITING_FOR_SUBSCRIPTION_LIST = 2;
        private final int WAITING_FOR_DELETE_SUB_RESPONSE = 3;
        private int numResponsesExpected;

        EBCleanup(SICoreConnection sICoreConnection, BridgeControllerAdmin bridgeControllerAdmin) {
            if (ebCleanupTC.isEntryEnabled()) {
                SibTr.entry((TraceComponent)ebCleanupTC, (String)"EBCleanup");
            }
            this.connection = sICoreConnection;
            this.controllerAdmin = bridgeControllerAdmin;
            try {
                MQBrokerUuidQuery mQBrokerUuidQuery = MQBrokerMessageFactory.instance().createBrokerUuidQuery();
                this.replyDest = sICoreConnection.createTemporaryDestination(Distribution.ONE, "PSB");
                if (ebCleanupTC.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)ebCleanupTC, (String)("tempReplyQueue: " + this.replyDest.getDestinationName()));
                    SibTr.debug((TraceComponent)ebCleanupTC, (String)("  tempReplyBus: " + this.replyDest.getBusName()));
                }
                this.consumer = sICoreConnection.createConsumerSession(this.replyDest, DestinationType.QUEUE, null, Reliability.RELIABLE_NONPERSISTENT, false, true, Reliability.NONE, false, null);
                this.consumer.registerAsynchConsumerCallback((AsynchConsumerCallback)this, 0, 0L, 1, null);
                this.consumer.start(false);
                this.state = 1;
                ArrayList<SIDestinationAddress> arrayList = new ArrayList<SIDestinationAddress>();
                arrayList.add(this.replyDest);
                mQBrokerUuidQuery.setReverseRoutingPath(arrayList);
                EB_PubSubController.setupControlMessageApiHeader((JsApiMessage)mQBrokerUuidQuery, null, null, sICoreConnection.getResolvedUserid());
                SIDestinationAddress sIDestinationAddress = EB_PubSubController.createSIDestAddressForMQQueue(PSBCleanup.brokerAdminQ, bridgeControllerAdmin.getBrokerQMgrName(), bridgeControllerAdmin.getForeignBusName());
                sICoreConnection.send((SIBusMessage)mQBrokerUuidQuery, null, sIDestinationAddress, DestinationType.QUEUE, null, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"PSBCleanup$EventBrokerQuery", (String)"EventBrokerQuery#1");
                if (ebCleanupTC.isEventEnabled()) {
                    SibTr.exception((TraceComponent)ebCleanupTC, (Exception)((Object)sIException));
                }
                this.ebQueryClose();
            }
            catch (MessageDecodeFailedException messageDecodeFailedException) {
                FFDCFilter.processException((Throwable)messageDecodeFailedException, (String)"PSBCleanup$EventBrokerQuery", (String)"EventBrokerQuery#2");
                if (ebCleanupTC.isEventEnabled()) {
                    SibTr.exception((TraceComponent)ebCleanupTC, (Exception)((Object)messageDecodeFailedException));
                }
                this.ebQueryClose();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"PSBCleanup$EventBrokerQuery", (String)"EventBrokerQuery#3");
                if (ebCleanupTC.isEventEnabled()) {
                    SibTr.exception((TraceComponent)ebCleanupTC, (Exception)exception);
                }
                this.ebQueryClose();
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"EBCleanup");
            }
        }

        public void consumeMessages(LockedMessageEnumeration lockedMessageEnumeration) {
            if (ebCleanupTC.isEntryEnabled()) {
                SibTr.entry((TraceComponent)ebCleanupTC, (String)"consumeMessages");
            }
            boolean bl = false;
            try {
                SIBusMessage sIBusMessage = lockedMessageEnumeration.nextLocked();
                if (sIBusMessage != null) {
                    if (this.state == 1) {
                        if (!(sIBusMessage instanceof MQBrokerUuidResponse)) {
                            if (ebCleanupTC.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)ebCleanupTC, (String)("Expected uuid response, received " + sIBusMessage));
                            }
                        } else {
                            MQBrokerUuidResponse mQBrokerUuidResponse = (MQBrokerUuidResponse)sIBusMessage;
                            if (ebCleanupTC.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)ebCleanupTC, (String)("event broker uuid = " + mQBrokerUuidResponse.getBrokerUuid()));
                            }
                            MQBrokerSubscriptionQuery mQBrokerSubscriptionQuery = MQBrokerMessageFactory.instance().createBrokerSubscriptionQuery();
                            mQBrokerSubscriptionQuery.setBrokerUuid(mQBrokerUuidResponse.getBrokerUuid());
                            mQBrokerSubscriptionQuery.setBrokerName(mQBrokerUuidResponse.getBrokerName());
                            ArrayList<SIDestinationAddress> arrayList = new ArrayList<SIDestinationAddress>();
                            arrayList.add(this.replyDest);
                            mQBrokerSubscriptionQuery.setReverseRoutingPath(arrayList);
                            EB_PubSubController.setupControlMessageApiHeader((JsApiMessage)mQBrokerSubscriptionQuery, null, null, this.connection.getResolvedUserid());
                            SIDestinationAddress sIDestinationAddress = EB_PubSubController.createSIDestAddressForMQQueue(PSBCleanup.brokerAdminQ, this.controllerAdmin.getBrokerQMgrName(), this.controllerAdmin.getForeignBusName());
                            this.connection.send((SIBusMessage)mQBrokerSubscriptionQuery, null, sIDestinationAddress, DestinationType.QUEUE, null, null);
                            this.state = 2;
                        }
                    } else if (this.state == 2) {
                        if (!(sIBusMessage instanceof MQBrokerSubscriptionResponse)) {
                            if (ebCleanupTC.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)ebCleanupTC, (String)("Expected subscription response, received " + sIBusMessage));
                            }
                        } else {
                            List list = ((MQBrokerSubscriptionResponse)sIBusMessage).getSubscriptions();
                            if (list != null) {
                                this.numResponsesExpected = this.cleanupEBSubscriptions(list);
                                if (this.numResponsesExpected > 0) {
                                    this.state = 3;
                                } else {
                                    bl = true;
                                }
                            } else if (ebCleanupTC.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)ebCleanupTC, (String)"No subscriptions active");
                            }
                        }
                    } else if (this.state == 3) {
                        if (sIBusMessage instanceof MQBrokerResponseMessage) {
                            MQBrokerResponseMessage mQBrokerResponseMessage = (MQBrokerResponseMessage)sIBusMessage;
                            if (ebCleanupTC.isDebugEnabled()) {
                                int n = EBInboundProfileImpl.getBrokerResponseReasonCode(mQBrokerResponseMessage);
                                SibTr.debug((TraceComponent)ebCleanupTC, (String)"");
                                SibTr.debug((TraceComponent)ebCleanupTC, (String)("Received delete subscription response " + sIBusMessage));
                                SibTr.debug((TraceComponent)ebCleanupTC, (String)("      topic: " + mQBrokerResponseMessage.getFullResponseTopic()));
                                SibTr.debug((TraceComponent)ebCleanupTC, (String)("   correlID: " + mQBrokerResponseMessage.getFullResponseCorrelationId()));
                                SibTr.debug((TraceComponent)ebCleanupTC, (String)("subscrQueue: " + mQBrokerResponseMessage.getFullResponseQueueName()));
                                SibTr.debug((TraceComponent)ebCleanupTC, (String)(" completion: " + mQBrokerResponseMessage.getCompletion()));
                                SibTr.debug((TraceComponent)ebCleanupTC, (String)(" reasonCode: " + n));
                            }
                            if (--this.numResponsesExpected <= 0) {
                                bl = true;
                            }
                        } else if (ebCleanupTC.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)ebCleanupTC, (String)("Expected delete subscription response, received " + sIBusMessage));
                        }
                    }
                    lockedMessageEnumeration.deleteCurrent(null);
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"PSBCleanup$EventBrokerQuery", (String)"consumeMessages:1");
                if (ebCleanupTC.isEventEnabled()) {
                    SibTr.exception((TraceComponent)ebCleanupTC, (Exception)((Object)sIException));
                }
                bl = true;
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"PSBCleanup$EventBrokerQuery", (String)"consumeMessages:2");
                if (ebCleanupTC.isEventEnabled()) {
                    SibTr.exception((TraceComponent)ebCleanupTC, (Throwable)throwable);
                }
                bl = true;
            }
            if (bl) {
                this.ebQueryClose();
            }
            if (ebCleanupTC.isEntryEnabled()) {
                SibTr.exit((TraceComponent)ebCleanupTC, (String)"consumeMessages");
            }
        }

        private int cleanupEBSubscriptions(List list) {
            if (ebCleanupTC.isEntryEnabled()) {
                SibTr.entry((TraceComponent)ebCleanupTC, (String)"cleanupEBSubscriptions");
            }
            int n = 0;
            String string = this.controllerAdmin.getBrokerControlQueue();
            String string2 = this.controllerAdmin.getForeignBusName();
            String string3 = this.controllerAdmin.getBrokerQMgrName();
            String string4 = this.controllerAdmin.getMQLinkQMgrName();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    Object object;
                    MQBrokerSubscription mQBrokerSubscription = (MQBrokerSubscription)iterator.next();
                    String string5 = mQBrokerSubscription.getTopic();
                    String string6 = TopicWildcardTranslation.getInstance().convertEventBrokerToSIB(string5);
                    String string7 = mQBrokerSubscription.getSubscriptionPoint();
                    String string8 = mQBrokerSubscription.getQueue();
                    String string9 = mQBrokerSubscription.getQueueManager();
                    String string10 = mQBrokerSubscription.getClientId();
                    String string11 = null;
                    if (string10 != null && (string8 == null || string9 == null || string11 == null)) {
                        object = new StringTokenizer(string10, ":");
                        if (((StringTokenizer)object).hasMoreTokens()) {
                            ((StringTokenizer)object).nextToken();
                        }
                        if (((StringTokenizer)object).hasMoreTokens()) {
                            string9 = ((StringTokenizer)object).nextToken();
                        }
                        if (((StringTokenizer)object).hasMoreTokens()) {
                            string8 = ((StringTokenizer)object).nextToken();
                        }
                        if (((StringTokenizer)object).hasMoreTokens()) {
                            string11 = ((StringTokenizer)object).nextToken();
                        }
                    }
                    if (string8 == null || string9 == null || !string8.startsWith("_PPSB") || !string9.equals(string4)) {
                        if (!ebCleanupTC.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)"");
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)"This does not appear to be a PSB subscription:");
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)("  queueName: " + string8));
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)("       qMgr: " + string9));
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)("      topic: " + string5));
                        continue;
                    }
                    object = new EBInboundProfileImpl(string6, new DestinationData[0], string, string2, string3, string7, string4, null);
                    ((EBInboundProfileImpl)object).setCorrelId(HexString.parseHex((String)string11));
                    if (ebCleanupTC.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)"");
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)"Received record of PSB subscription from broker: ");
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)("    ebSyntaxTopic: " + string5));
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)("            topic: " + string6));
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)("             qMgr: " + string9));
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)("            qName: " + string8));
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)("         correlID: " + string11));
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)("         subPoint: " + string7));
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)("           userId: " + mQBrokerSubscription.getUserid()));
                        SibTr.debug((TraceComponent)ebCleanupTC, (String)("         clientID: " + string10));
                    }
                    if (!PSBCleanup.this.ebSubscriptionQueuesInUse.contains(string8) || !PSBCleanup.this.ebSubscriptionsInUseContains((EBInboundProfile)object)) {
                        if (ebCleanupTC.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)ebCleanupTC, (String)("Deleting unused EB subscription " + object + " queueInUse? " + PSBCleanup.this.ebSubscriptionQueuesInUse.contains(string8) + " subscriptionInUse? " + PSBCleanup.this.ebSubscriptionsInUse.contains(object)));
                        }
                        EB_PubSubController.closeSubscription((EBInboundProfile)object, this.connection, string8, this.replyDest.getDestinationName());
                        ++n;
                        continue;
                    }
                    if (!ebCleanupTC.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)ebCleanupTC, (String)"This is an active PSB subscription for this instance.");
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"BridgeControllerAdminImpl", (String)"getProfiles#1");
                    if (!ebCleanupTC.isEventEnabled()) continue;
                    SibTr.exception((TraceComponent)ebCleanupTC, (Exception)exception);
                }
            }
            if (ebCleanupTC.isEntryEnabled()) {
                SibTr.exit((TraceComponent)ebCleanupTC, (String)"cleanupEBSubscriptions");
            }
            return n;
        }

        private void ebQueryClose() {
            block6: {
                if (ebCleanupTC.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)ebCleanupTC, (String)"ebQueryClose");
                }
                try {
                    if (this.consumer != null) {
                        this.consumer.stop();
                        this.consumer.deregisterAsynchConsumerCallback();
                        this.consumer.close();
                        this.consumer = null;
                    }
                    if (this.connection != null && this.replyDest != null) {
                        this.connection.deleteTemporaryDestination(this.replyDest);
                        this.replyDest = null;
                    }
                    PSBCleanup.this.ebCleanupComplete();
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"PSBCleanup$EventBrokerQuery", (String)"ebQueryClose#1");
                    if (!ebCleanupTC.isEventEnabled()) break block6;
                    SibTr.exception((TraceComponent)ebCleanupTC, (Exception)((Object)sIException));
                }
            }
            if (ebCleanupTC.isEntryEnabled()) {
                SibTr.exit((TraceComponent)ebCleanupTC, (String)"ebQueryClose");
            }
        }
    }
}

