/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsEngineComponent;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.processor.Administrator;
import com.ibm.ws.sib.processor.SIMPAdmin;
import com.ibm.ws.sib.psb.BridgeController;
import com.ibm.ws.sib.psb.DestinationManager;
import com.ibm.ws.sib.psb.MappingProfileRegistry;
import com.ibm.ws.sib.psb.config.BrokerItemStream;
import com.ibm.ws.sib.psb.config.DestinationData;
import com.ibm.ws.sib.psb.config.InboundProfile;
import com.ibm.ws.sib.psb.config.MappingProfile;
import com.ibm.ws.sib.psb.config.OutboundProfile;
import com.ibm.ws.sib.psb.config.brokers.EBInboundProfile;
import com.ibm.ws.sib.psb.config.brokers.SIBInboundProfile;
import com.ibm.ws.sib.psb.config.brokers.SIBOutboundProfile;
import com.ibm.ws.sib.utils.TopicWildcardTranslation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MappingProfileRegistryImpl
implements MappingProfileRegistry {
    private static final TraceComponent tc = SibTr.register((Class)MappingProfileRegistryImpl.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");
    private BridgeController bridgeController;
    private BrokerItemStream stateStream;
    private Set mappings;
    private TopicWildcardTranslation wildcardChecker;

    public MappingProfileRegistryImpl(BridgeController bridgeController) {
        block10: {
            block9: {
                this.bridgeController = null;
                this.stateStream = null;
                this.mappings = null;
                this.wildcardChecker = null;
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"MappingProfileRegistryImpl(BridgeController)");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("bridgeController : " + bridgeController));
                }
                this.bridgeController = bridgeController;
                this.stateStream = bridgeController.getStateStream();
                this.mappings = new HashSet();
                try {
                    if (this.stateStream != null) {
                        AbstractItem abstractItem;
                        NonLockingCursor nonLockingCursor = this.stateStream.newNonLockingItemCursor(null);
                        while ((abstractItem = nonLockingCursor.next()) != null) {
                            if (!(abstractItem instanceof MappingProfile)) continue;
                            this.mappings.add(abstractItem);
                            ((MappingProfile)((Object)abstractItem)).setBridgeController(bridgeController);
                            ((MappingProfile)((Object)abstractItem)).setItemStream(this.stateStream);
                            ((MappingProfile)((Object)abstractItem)).setActive(false);
                            ((MappingProfile)((Object)abstractItem)).getInboundProfile().setStatus(0);
                        }
                    }
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"MappingProfileRegistryImpl", (String)"MappingProfileRegistryImpl#1");
                    if (!tc.isEventEnabled()) break block9;
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                }
            }
            try {
                this.wildcardChecker = TopicWildcardTranslation.getInstance();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"MappingProfileRegistryImpl", (String)"MappingProfileRegistryImpl#2");
                if (!tc.isEventEnabled()) break block10;
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MappingProfileRegistryImpl(BridgeController)");
        }
    }

    public DestinationData[] getActiveDestinations() {
        DestinationData[] destinationDataArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getActiveDestinations()");
        }
        Iterator iterator = this.mappings.iterator();
        HashSet<DestinationData> hashSet = new HashSet<DestinationData>();
        while (iterator.hasNext()) {
            destinationDataArray = (DestinationData[])iterator.next();
            if (!destinationDataArray.isActive()) continue;
            DestinationData[] destinationDataArray2 = destinationDataArray.getDestinations();
            for (int i = 0; i < destinationDataArray2.length; ++i) {
                DestinationData destinationData = destinationDataArray2[i];
                if (hashSet.add(destinationData)) continue;
                throw new IllegalStateException("destination " + destinationData + " referenced by multiple mappings.");
            }
        }
        destinationDataArray = hashSet.toArray(new DestinationData[0]);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return DestinationData[] : " + destinationDataArray));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getActiveDestinations()");
        }
        return destinationDataArray;
    }

    public MappingProfile[] getActiveProfiles() {
        MappingProfile[] mappingProfileArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getActiveProfiles()");
        }
        Iterator iterator = this.mappings.iterator();
        HashSet<MappingProfile[]> hashSet = new HashSet<MappingProfile[]>();
        while (iterator.hasNext()) {
            mappingProfileArray = (MappingProfile[])iterator.next();
            if (!mappingProfileArray.isActive()) continue;
            hashSet.add(mappingProfileArray);
        }
        mappingProfileArray = hashSet.toArray(new MappingProfile[0]);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return MappingProfile[" + mappingProfileArray.length + "] : " + mappingProfileArray));
            for (int i = 0; i < mappingProfileArray.length; ++i) {
                SibTr.debug((TraceComponent)tc, (String)("   profile[" + i + "]: " + mappingProfileArray[i]));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getActiveProfiles()");
        }
        return mappingProfileArray;
    }

    public MappingProfile[] getInactiveProfiles() {
        MappingProfile[] mappingProfileArray;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInactiveProfiles()");
        }
        Iterator iterator = this.mappings.iterator();
        HashSet<MappingProfile[]> hashSet = new HashSet<MappingProfile[]>();
        while (iterator.hasNext()) {
            mappingProfileArray = (MappingProfile[])iterator.next();
            if (mappingProfileArray.isActive()) continue;
            hashSet.add(mappingProfileArray);
            if (!tc.isDebugEnabled()) continue;
            SibTr.debug((TraceComponent)tc, (String)("Inactive profile: " + mappingProfileArray));
        }
        mappingProfileArray = hashSet.toArray(new MappingProfile[0]);
        if (mappingProfileArray == null) {
            mappingProfileArray = new MappingProfile[]{};
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return MappingProfile[" + mappingProfileArray.length + "] : " + mappingProfileArray));
            for (int i = 0; i < mappingProfileArray.length; ++i) {
                SibTr.debug((TraceComponent)tc, (String)("   profile[" + i + "]: " + mappingProfileArray[i]));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getInactiveProfiles()");
        }
        return mappingProfileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(MappingProfile[] mappingProfileArray) {
        try {
            Object object;
            MappingProfile mappingProfile;
            MappingProfile mappingProfile2;
            int n;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"merge(MappingProfile[])");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("profiles : " + mappingProfileArray));
            }
            if (mappingProfileArray == null) {
                throw new IllegalArgumentException("null profiles array");
            }
            DestinationManager destinationManager = this.bridgeController.getDestinationManager();
            SICoreConnection sICoreConnection = this.bridgeController.getCoreConnection();
            JsMessagingEngine jsMessagingEngine = this.bridgeController.getEngine();
            JsEngineComponent jsEngineComponent = jsMessagingEngine.getMessageProcessor();
            SIMPAdmin sIMPAdmin = (SIMPAdmin)jsEngineComponent;
            Administrator administrator = sIMPAdmin.getAdministrator();
            for (n = 0; n < mappingProfileArray.length; ++n) {
                int n2;
                mappingProfile2 = mappingProfileArray[n];
                mappingProfile = this.getProfile(mappingProfile2);
                if (mappingProfile == null) {
                    object = mappingProfile2.getDestinations();
                    for (n2 = 0; n2 < ((DestinationData[])object).length; ++n2) {
                        destinationManager.createDestination(object[n2], sICoreConnection);
                    }
                    mappingProfile2.getInboundProfile().completeNewProfile();
                    this.addProfile(mappingProfile2);
                    mappingProfile2.setActive(true);
                    continue;
                }
                object = mappingProfile.getDestinations();
                for (n2 = 0; n2 < ((DestinationData[])object).length; ++n2) {
                    if (object[n2].getName() != null && destinationManager.destinationExists(object[n2], administrator)) continue;
                    SibTr.debug((TraceComponent)tc, (String)(object[n2] + " missing, recreating"));
                    destinationManager.createDestination(object[n2], sICoreConnection);
                }
                mappingProfile.setTransactionalitySettings(mappingProfile2.getTransactionalitySettings());
                mappingProfile.save();
                mappingProfile.setActive(true);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Re-linking bi-directional profiles");
            }
            for (n = 0; n < mappingProfileArray.length; ++n) {
                mappingProfile2 = mappingProfileArray[n];
                mappingProfile = mappingProfile2.getLinkedMapping();
                if (mappingProfile == null) continue;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Linked profile found");
                }
                object = this.getProfile(mappingProfile2);
                MappingProfile mappingProfile3 = this.getProfile(mappingProfile);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("current: " + object));
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)(" linked: " + mappingProfile3));
                }
                if (object == null || mappingProfile3 == null) {
                    if (!tc.isDebugEnabled()) continue;
                    SibTr.debug((TraceComponent)tc, (String)"WARNING - we failed to find the linked real profiles:");
                    continue;
                }
                OutboundProfile outboundProfile = object.getOutboundProfile();
                InboundProfile inboundProfile = mappingProfile3.getInboundProfile();
                outboundProfile.relinkProfile(inboundProfile);
                object.save();
                mappingProfile3.save();
            }
            MappingProfile[] mappingProfileArray2 = this.getInactiveProfiles();
            for (int i = 0; i < mappingProfileArray2.length; ++i) {
                mappingProfile = mappingProfileArray2[i];
                object = mappingProfile.getDestinations();
                for (int j = 0; j < ((DestinationData[])object).length; ++j) {
                    if (object[j].getName() != null && destinationManager.destinationExists(object[j], administrator)) continue;
                    SibTr.debug((TraceComponent)tc, (String)(object[j] + " missing, recreating"));
                    destinationManager.createDestination((DestinationData)object[j], sICoreConnection);
                }
                mappingProfile.save();
            }
            this.validateTopicMappings();
            Object var16_20 = null;
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"merge(MappingProfile[])");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"merge(MappingProfile[])");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProfile(MappingProfile mappingProfile) {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteProfile(MappingProfile)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("mapingProfile : " + mappingProfile));
            }
            if (!this.mappings.contains(mappingProfile)) {
                throw new IllegalArgumentException("registry does not contain mapping profile " + mappingProfile);
            }
            this.mappings.remove(mappingProfile);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteProfile(MappingProfile)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteProfile(MappingProfile)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MappingProfile getProfile(MappingProfile mappingProfile) {
        Iterator iterator;
        Object object = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getProfile(MappingProfile)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("newProfile : " + mappingProfile));
            }
            if (this.mappings.contains(mappingProfile)) {
                iterator = this.mappings.iterator();
                while (iterator.hasNext()) {
                    MappingProfile mappingProfile2 = (MappingProfile)iterator.next();
                    if (!((Object)mappingProfile2).equals(mappingProfile)) continue;
                    object = mappingProfile2;
                    break;
                }
                if (object == null) {
                    throw new IllegalStateException("Inconsistency in mappings list - multithreaded access?");
                }
            }
            iterator = object;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            block10: {
                Object var6_6 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("return MappingProfile : " + object));
                }
                if (!tc.isEntryEnabled()) break block10;
                SibTr.exit((TraceComponent)tc, (String)"getProfile(MappingProfile)");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return MappingProfile : " + object));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getProfile(MappingProfile)");
        }
        return iterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addProfile(MappingProfile mappingProfile) {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"addProfile(MappingProfile)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("newProfile : " + mappingProfile));
            }
            if (this.mappings.contains(mappingProfile)) {
                throw new IllegalArgumentException("This mapping already exists in the registry.");
            }
            this.mappings.add(mappingProfile);
            mappingProfile.setBridgeController(this.bridgeController);
            mappingProfile.setItemStream(this.stateStream);
            mappingProfile.add();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addProfile(MappingProfile)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addProfile(MappingProfile)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeProfile(MappingProfile mappingProfile) {
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"removeProfile(MappingProfile)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("profile : " + mappingProfile));
            }
            if (!this.mappings.contains(mappingProfile)) {
                throw new IllegalArgumentException("This mapping does not exist in the registry.");
            }
            mappingProfile.remove();
            this.mappings.remove(mappingProfile);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeProfile(MappingProfile)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeProfile(MappingProfile)");
        }
    }

    private boolean isValidTopic(MappingProfile mappingProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isValidTopic");
        }
        boolean bl = true;
        String string = mappingProfile.getInboundProfile().getInboundTopic();
        String string2 = mappingProfile.getOutboundProfile().getOutboundTopic();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Topic: " + string + " " + string2));
        }
        if (string == null || string2 == null) {
            bl = false;
        } else if (!string.equals(string2)) {
            SibTr.error((TraceComponent)tc, (String)"ERR_TOPIC_MANGLING_CWSIL0007", (Object)mappingProfile);
            bl = false;
        } else {
            String string3 = string;
            if (!this.wildcardChecker.isValidSIBTopic(string3)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Topic syntax is not valid.");
                }
                bl = false;
            }
            int n = string3.indexOf(46);
            if (bl) {
                if (n == -1) {
                    if (!("//*".equals(string3) || string3.indexOf("*") == -1 && string3.indexOf("//") == -1)) {
                        String string4 = "ERR_SINGLELEVEL_WILDCARD_CWSIL0010";
                        if (string3.indexOf("//") != -1) {
                            string4 = "ERR_MULTILEVEL_WILDCARD_CWSIL0011";
                        }
                        SibTr.error((TraceComponent)tc, (String)string4, (Object)mappingProfile);
                        bl = false;
                    }
                } else {
                    int n2 = string3.indexOf("//.");
                    if (n2 != -1) {
                        if (n2 != string3.length() - 3) {
                            SibTr.error((TraceComponent)tc, (String)"ERR_MULTILEVEL_WILDCARD_CWSIL0011", (Object)mappingProfile);
                            bl = false;
                        }
                    } else if (string3.indexOf("*") != -1 || string3.indexOf("//") != -1) {
                        String string5 = "ERR_SINGLELEVEL_WILDCARD_CWSIL0010";
                        if (string3.indexOf("//") != -1) {
                            string5 = "ERR_MULTILEVEL_WILDCARD_CWSIL0011";
                        }
                        SibTr.error((TraceComponent)tc, (String)string5, (Object)mappingProfile);
                        bl = false;
                    } else {
                        String string6 = "ERR_SINGLELEVEL_WILDCARD_CWSIL0010";
                        SibTr.error((TraceComponent)tc, (String)string6, (Object)mappingProfile);
                        bl = false;
                    }
                }
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("isValid? " + bl));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isValidTopic");
        }
        return bl;
    }

    private void removeOverlappingProfiles(MappingProfile mappingProfile, ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeOverlappingProfiles");
        }
        InboundProfile inboundProfile = mappingProfile.getInboundProfile();
        OutboundProfile outboundProfile = mappingProfile.getOutboundProfile();
        String string = inboundProfile.getInboundTopic();
        String string2 = outboundProfile.getOutboundTopic();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3;
            String string4;
            MappingProfile mappingProfile2 = (MappingProfile)arrayList.get(i);
            InboundProfile inboundProfile2 = mappingProfile2.getInboundProfile();
            OutboundProfile outboundProfile2 = mappingProfile2.getOutboundProfile();
            String string5 = inboundProfile2.getInboundTopic();
            String string6 = outboundProfile2.getOutboundTopic();
            if (!mappingProfile2.isActive() || inboundProfile.getBrokerType() != inboundProfile2.getBrokerType()) continue;
            if (inboundProfile instanceof EBInboundProfile) {
                string4 = ((EBInboundProfile)inboundProfile).getSubscriptionPoint();
                string3 = ((EBInboundProfile)inboundProfile2).getSubscriptionPoint();
                if (string3 != null ? !string3.equals(string4) : string4 != null) continue;
            }
            if (inboundProfile instanceof SIBInboundProfile && !(string4 = ((SIBInboundProfile)inboundProfile).getTopicSpace()).equals(string3 = ((SIBInboundProfile)inboundProfile2).getTopicSpace()) || outboundProfile instanceof SIBOutboundProfile && !(string4 = ((SIBOutboundProfile)outboundProfile).getTopicSpace()).equals(string3 = ((SIBOutboundProfile)outboundProfile2).getTopicSpace())) continue;
            if (string.equals(string5)) {
                if (tc.isDebugEnabled() && !string2.equals(string6)) {
                    SibTr.debug((TraceComponent)tc, (String)"Inconsistent topic mapping - inbound topics are equal, but outbound topics are not equal.");
                }
                SibTr.error((TraceComponent)tc, (String)"WARN_DUPLICATE_MAPPING_CWSIL0008", (Object)mappingProfile);
                mappingProfile.setActive(false);
                break;
            }
            if (string2.equals(string6)) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Inconsistent topic mapping - outbound topics are equal, but inbound topics are not equal.");
                }
                SibTr.error((TraceComponent)tc, (String)"WARN_DUPLICATE_MAPPING_CWSIL0008", (Object)mappingProfile);
                mappingProfile.setActive(false);
                break;
            }
            if (string.endsWith("//.") && string5.startsWith(string.substring(0, string.length() - 2))) {
                SibTr.error((TraceComponent)tc, (String)"WARN_OVERLAPPING_MAPPING_CWSIL0009", (Object)new Object[]{mappingProfile2, mappingProfile});
                mappingProfile2.setActive(false);
            }
            if (string5.endsWith("//.") && string.startsWith(string5.substring(0, string5.length() - 2))) {
                SibTr.error((TraceComponent)tc, (String)"WARN_OVERLAPPING_MAPPING_CWSIL0009", (Object)new Object[]{mappingProfile, mappingProfile2});
                mappingProfile.setActive(false);
                break;
            }
            if (string.equals("//*")) {
                SibTr.error((TraceComponent)tc, (String)"WARN_OVERLAPPING_MAPPING_CWSIL0009", (Object)new Object[]{mappingProfile2, mappingProfile});
                mappingProfile2.setActive(false);
            }
            if (!string5.equals("//*")) continue;
            SibTr.error((TraceComponent)tc, (String)"WARN_OVERLAPPING_MAPPING_CWSIL0009", (Object)new Object[]{mappingProfile2, mappingProfile});
            mappingProfile.setActive(false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeOverlappingProfiles");
        }
    }

    private void validateTopicMappings() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"validateTopicMappings");
        }
        ArrayList<MappingProfile> arrayList = new ArrayList<MappingProfile>();
        Iterator iterator = this.mappings.iterator();
        while (iterator.hasNext()) {
            MappingProfile mappingProfile = (MappingProfile)iterator.next();
            if (!mappingProfile.isActive()) continue;
            if (!this.isValidTopic(mappingProfile)) {
                mappingProfile.setActive(false);
                continue;
            }
            this.removeOverlappingProfiles(mappingProfile, arrayList);
            if (!mappingProfile.isActive()) continue;
            arrayList.add(mappingProfile);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"validateTopicMappings");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/impl/MappingProfileRegistryImpl.java, SIB.psb, WAS602.SIB, o0610.11 1.40");
        }
    }
}

