/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.processor.Administrator;
import com.ibm.ws.sib.processor.MPCoreConnection;
import com.ibm.ws.sib.psb.DestinationManager;
import com.ibm.ws.sib.psb.config.DestinationData;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SICoreConnection;
import java.util.Calendar;

public class DestinationManagerImpl
implements DestinationManager {
    private static final TraceComponent tc = SibTr.register((Class)DestinationManagerImpl.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");
    static int destinationCount;
    static Object destinationCountLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDestination(DestinationData destinationData, SICoreConnection sICoreConnection) {
        try {
            block11: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"createDestination(DestinationData, SICoreConnection)");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("destinationData : " + destinationData));
                    SibTr.debug((TraceComponent)tc, (String)("siCoreConnection : " + sICoreConnection));
                }
                if (destinationData == null) {
                    throw new IllegalArgumentException("destinationData is null");
                }
                if (sICoreConnection == null) {
                    throw new IllegalArgumentException("siCoreConnection is null");
                }
                String string = destinationData.getNamePrefix();
                if (string == null) {
                    throw new IllegalArgumentException("destination name prefix is null");
                }
                MPCoreConnection mPCoreConnection = (MPCoreConnection)sICoreConnection;
                try {
                    JsDestinationAddress jsDestinationAddress = mPCoreConnection.createSystemDestination(string);
                    destinationData.setDestAddress(jsDestinationAddress);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"DestinationManagerImpl.createDestination", (String)"createDestination#1");
                    if (!tc.isEventEnabled()) break block11;
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createDestination(DestinationData, SICoreConnection)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createDestination(DestinationData, SICoreConnection)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDestination(DestinationData destinationData, SICoreConnection sICoreConnection) {
        try {
            block11: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"deleteDestination(DestinationData, SICoreConnection)");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("destinationData : " + destinationData));
                    SibTr.debug((TraceComponent)tc, (String)("siCoreConnection : " + sICoreConnection));
                }
                if (destinationData == null) {
                    throw new IllegalArgumentException("destinationData is null");
                }
                if (sICoreConnection == null) {
                    throw new IllegalArgumentException("siCoreConnection is null");
                }
                String string = destinationData.getName();
                if (string == null) {
                    throw new IllegalArgumentException("destination name is null");
                }
                MPCoreConnection mPCoreConnection = (MPCoreConnection)sICoreConnection;
                try {
                    JsDestinationAddress jsDestinationAddress = destinationData.getDestAddress();
                    mPCoreConnection.deleteSystemDestination(jsDestinationAddress);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"DestinationManagerImpl.deleteDestination", (String)"deleteDestination#1");
                    if (!tc.isEventEnabled()) break block11;
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                }
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteDestination(DestinationData, SICoreConnection)");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteDestination(DestinationData, SICoreConnection)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean destinationExists(DestinationData destinationData, Administrator administrator) {
        boolean bl;
        boolean bl2 = false;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"destinationExists(DestinationData, Administrator)");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("destinationData : " + destinationData));
                SibTr.debug((TraceComponent)tc, (String)("administrator : " + administrator));
            }
            if (destinationData == null) {
                throw new IllegalArgumentException("destinationData is null");
            }
            if (administrator == null) {
                throw new IllegalArgumentException("administrator is null");
            }
            String string = destinationData.getName();
            if (string == null) {
                throw new IllegalArgumentException("destination name is null");
            }
            bl = bl2 = administrator.destinationExists(string);
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            block10: {
                Object var7_7 = null;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("return boolean : " + bl2));
                }
                if (!tc.isEntryEnabled()) break block10;
                SibTr.exit((TraceComponent)tc, (String)"destinationExists(DestinationData, Administrator)");
            }
            throw throwable;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return boolean : " + bl2));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destinationExists(DestinationData, Administrator)");
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSystemDestinationPrefix() {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSystemDestinationPrefix()");
        }
        String string = Long.toHexString(Calendar.getInstance().getTimeInMillis());
        Object object = destinationCountLock;
        synchronized (object) {
            if (destinationCount == 999) {
                destinationCount = 0;
            }
            n = ++destinationCount;
        }
        object = n < 10 ? "00" + n : (n < 100 ? "0" + n : "" + n);
        String string2 = "PSB." + string + "." + (String)object;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return String : " + string2));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSystemDestinationPrefix()");
        }
        return string2;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/impl/DestinationManagerImpl.java, SIB.psb, WAS602.SIB, o0610.11 1.16");
        }
        destinationCount = 0;
        destinationCountLock = new Object();
    }
}

