/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.config.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.psb.config.BrokerItemStream;
import com.ibm.ws.sib.psb.config.DestinationData;
import com.ibm.ws.sib.psb.config.InboundProfile;
import com.ibm.ws.sib.psb.config.MappingProfile;
import com.ibm.ws.sib.psb.config.OutboundProfile;
import com.ibm.ws.sib.psb.config.brokers.EBInboundProfile;
import com.ibm.ws.sib.psb.config.brokers.EBOutboundProfile;
import com.ibm.ws.sib.psb.config.brokers.SIBInboundProfile;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class BrokerItemStreamImpl
extends ItemStream
implements BrokerItemStream {
    private static TraceComponent tc = SibTr.register((Class)BrokerItemStreamImpl.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");
    private String name = "";
    private transient ExternalAutoCommitTransaction autoCommitTransaction = null;

    public BrokerItemStreamImpl() throws MessageStoreException {
    }

    BrokerItemStreamImpl(String string) {
        this.name = string;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName()");
        }
        String string = this.name;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return String : " + string));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName()");
        }
        return string;
    }

    public boolean isEmpty() throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isEmpty()");
        }
        boolean bl = this.findFirstMatchingItem(null) == null;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return boolean : " + bl));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isEmpty()");
        }
        return bl;
    }

    public void empty() throws MessageStoreException {
        Item item;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"empty()");
        }
        ExternalAutoCommitTransaction externalAutoCommitTransaction = this.getAutoCommitTransaction();
        while ((item = this.findFirstMatchingItem(null)) != null) {
            item.remove(externalAutoCommitTransaction, -2L);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"empty()");
        }
    }

    public void remove() throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove()");
        }
        ExternalAutoCommitTransaction externalAutoCommitTransaction = this.getAutoCommitTransaction();
        this.remove(externalAutoCommitTransaction, -2L);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove()");
        }
    }

    public void addItem(Item item) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addItem(Item)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("item : " + item));
        }
        this.addItem(item, this.getAutoCommitTransaction());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addItem(Item)");
        }
    }

    public void requestItemUpdate(Item item) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"requestItemUpdate(Item)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("item : " + item));
        }
        if (item.getItemStream() != this) {
            throw new IllegalStateException("Item " + item + " not in ItemStream " + this);
        }
        item.requestUpdate(this.getAutoCommitTransaction());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"requestItemUpdate(Item)");
        }
    }

    public void removeItem(Item item) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeItem(Item)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("item : " + item));
        }
        if (item.getItemStream() != this) {
            throw new IllegalStateException("Item " + item + " not in ItemStream " + this);
        }
        item.remove(this.getAutoCommitTransaction(), -2L);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeItem(Item)");
        }
    }

    public String getBrokerQMgrName() throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrokerQMgrName()");
        }
        String string = null;
        int n = -1;
        String string2 = null;
        int n2 = -1;
        String string3 = null;
        Item item = this.findFirstMatchingItem(null);
        if (item != null) {
            MappingProfile mappingProfile = (MappingProfile)((Object)item);
            InboundProfile inboundProfile = mappingProfile.getInboundProfile();
            n = inboundProfile.getBrokerType();
            OutboundProfile outboundProfile = mappingProfile.getOutboundProfile();
            n2 = outboundProfile.getBrokerType();
            if (n != 1 && n2 != 1) {
                throw new IllegalStateException("BrokerItemStreamImpl.getBrokerQMgrName#1 : invalid mapping, broker types are " + n + " and " + n2 + ".");
            }
            switch (n) {
                case 1: {
                    string2 = null;
                    break;
                }
                case 2: {
                    string2 = ((EBInboundProfile)inboundProfile).getRemoteQMName();
                    break;
                }
                default: {
                    throw new IllegalStateException("BrokerItemStreamImpl.getBrokerQMgrName#2 : unknown broker type " + inboundProfile.getBrokerType() + ".");
                }
            }
            switch (n2) {
                case 1: {
                    string3 = null;
                    break;
                }
                case 2: {
                    string3 = ((EBOutboundProfile)outboundProfile).getRemoteQMName();
                    break;
                }
                default: {
                    throw new IllegalStateException("BrokerItemStreamImpl.getBrokerQMgrName#3 : unknown broker type " + outboundProfile.getBrokerType() + ".");
                }
            }
            if (string2 != null) {
                string = string2;
            }
            if (string3 != null) {
                string = string3;
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)("return String : " + string));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrokerQMgrName()");
        }
        return string;
    }

    public List getSIBDestinationList() throws MessageStoreException {
        Item item;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBDestinationList()");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((item = this.findFirstMatchingItem(null)) != null) {
            MappingProfile mappingProfile = (MappingProfile)((Object)item);
            DestinationData[] destinationDataArray = mappingProfile.getInboundProfile().getDestinations();
            for (int i = 0; i < destinationDataArray.length; ++i) {
                arrayList.add(destinationDataArray[i].getName());
            }
            DestinationData[] destinationDataArray2 = mappingProfile.getOutboundProfile().getDestinations();
            for (int i = 0; i < destinationDataArray2.length; ++i) {
                arrayList.add(destinationDataArray2[i].getName());
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return List : " + arrayList));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBDestinationList()");
        }
        return arrayList;
    }

    public List getSIBDurableSubscriptionList() throws MessageStoreException {
        Item item;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSIBDurableSubscriptionList()");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((item = this.findFirstMatchingItem(null)) != null) {
            MappingProfile mappingProfile = (MappingProfile)((Object)item);
            InboundProfile inboundProfile = mappingProfile.getInboundProfile();
            if (!(inboundProfile instanceof SIBInboundProfile)) continue;
            SIBInboundProfile sIBInboundProfile = (SIBInboundProfile)inboundProfile;
            arrayList.add(sIBInboundProfile.getDurableSubscriptionName());
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return List : " + arrayList));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSIBDurableSubscriptionList()");
        }
        return arrayList;
    }

    public List getEBDurableSubscriptionList() throws MessageStoreException {
        Item item;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEBDurableSubscriptionList()");
        }
        ArrayList<EBInboundProfile> arrayList = new ArrayList<EBInboundProfile>();
        while ((item = this.findFirstMatchingItem(null)) != null) {
            MappingProfile mappingProfile = (MappingProfile)((Object)item);
            InboundProfile inboundProfile = mappingProfile.getInboundProfile();
            if (!(inboundProfile instanceof EBInboundProfile)) continue;
            EBInboundProfile eBInboundProfile = (EBInboundProfile)inboundProfile;
            arrayList.add(eBInboundProfile);
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return List : " + arrayList));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEBDurableSubscriptionList()");
        }
        return arrayList;
    }

    public int getStorageStrategy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStorageStrategy()");
        }
        int n = 4;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return int : " + n));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStorageStrategy()");
        }
        return n;
    }

    public byte[] getPersistentData() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData()");
        }
        byte[] byArray = new byte[4 + this.name.length()];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.putInt(this.name.length());
        byteBuffer.put(this.name.getBytes());
        if (tc.isDebugEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)("return byte[] " + byArray));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData()");
        }
        return byArray;
    }

    public void restore(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore(byte[])");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("data : " + byArray));
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        int n = byteBuffer.getInt();
        byte[] byArray2 = new byte[n];
        byteBuffer.get(byArray2);
        this.name = new String(byArray2);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("name is " + this.name));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore(byte[])");
        }
    }

    ExternalAutoCommitTransaction getAutoCommitTransaction() {
        if (this.autoCommitTransaction == null) {
            this.autoCommitTransaction = this.getOwningMessageStore().getTransactionFactory().createAutoCommitTransaction();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("BrokerItemStream " + this + ", getAutoCommitTransaction() created " + this.autoCommitTransaction));
            }
        }
        return this.autoCommitTransaction;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/config/impl/BrokerItemStreamImpl.java, SIB.psb, WAS602.SIB, o0610.11 1.22");
        }
    }
}

