/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.config.brokers.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIMessageException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.api.jms.JmsInternalConstants;
import com.ibm.ws.sib.api.jms.MQRequestReplyUtils;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.mqcontrol.MQPublicationInfo;
import com.ibm.ws.sib.psb.config.InboundProfile;
import com.ibm.ws.sib.psb.config.OutboundProfile;
import com.ibm.ws.sib.psb.config.brokers.EBInboundProfile;
import com.ibm.ws.sib.psb.config.brokers.EBOutboundProfile;
import com.ibm.ws.sib.psb.impl.EB_PubSubController;
import com.ibm.ws.sib.psb.impl.RequestReplyHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SICoreConnection;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.SIUncoordinatedTransaction;
import java.util.ArrayList;
import java.util.HashMap;
import javax.jms.JMSException;

public class EBReqReplHelper
extends RequestReplyHelper {
    private static TraceComponent tc = SibTr.register((Class)EBReqReplHelper.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");
    public static final String MQJMS_TEMPORARY_TOPIC_PREFIX = "MQ/MQJMS/TT";

    public EBReqReplHelper() {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/config/brokers/impl/EBReqReplHelper.java, SIB.psb, WAS602.SIB, o0610.11 1.15");
        }
    }

    protected boolean isTemporaryTopic(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTemporaryTopic", (Object)string);
        }
        boolean bl = false;
        if (string != null && string.startsWith(MQJMS_TEMPORARY_TOPIC_PREFIX)) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isTemporaryTopic", (Object)new Boolean(bl));
        }
        return bl;
    }

    protected String addReplyIdentifier(String string, OutboundProfile outboundProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addReplyIdentifier", (Object)new Object[]{string, outboundProfile});
        }
        String string2 = "";
        if (string != null) {
            string2 = string;
        }
        if (!(outboundProfile instanceof EBOutboundProfile)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"PSB - INVALID STATE - got passed the wrong type of profile.");
            }
            throw new IllegalStateException();
        }
        EBOutboundProfile eBOutboundProfile = (EBOutboundProfile)outboundProfile;
        string2 = string2 + eBOutboundProfile.getVirtualQMName() + "/" + eBOutboundProfile.getRemoteQMName();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addReplyIdentifier", (Object)string2);
        }
        return string2;
    }

    protected String addRoutingInfo(String string, SIBusMessage sIBusMessage, InboundProfile inboundProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addRoutingInfo", (Object)new Object[]{string, sIBusMessage, inboundProfile});
        }
        String string2 = "";
        if (string != null) {
            string2 = string;
        }
        if (inboundProfile instanceof EBInboundProfile) {
            EBInboundProfile eBInboundProfile = (EBInboundProfile)inboundProfile;
            String string3 = eBInboundProfile.getBrokerStreamName();
            if (string3 != null && !"".equals(string3)) {
                String string4 = eBInboundProfile.getRemoteQMName();
                String string5 = sIBusMessage.getReplyDiscriminator();
                string2 = string2 + string4 + "/" + string3 + "/" + string5;
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"brokerStreamName is null - mark replyMsg as broken");
                }
                String string6 = sIBusMessage.getReplyDiscriminator();
                string2 = string2 + "NO_BROKER_STREAM/" + string6;
                if (sIBusMessage instanceof JsJmsMessage) {
                    try {
                        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(1);
                        hashMap.put("blockedDestinationCode", JmsInternalConstants.PSB_REPLY_DATA_MISSING);
                        MQRequestReplyUtils.getInstance().updateJMSDestinationProperty((JsJmsMessage)sIBusMessage, "JMSReplyTo", hashMap);
                    }
                    catch (JMSException jMSException) {
                        FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.sib.psb.config.brokers.impl.EBReqReplHelper.addRoutingInfo", (String)"addRoutingInfo#1", (Object)this);
                        if (tc.isDebugEnabled()) {
                            SibTr.exception((TraceComponent)tc, (Exception)((Object)jMSException));
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Msg was not JsJmsMessage - could not block the destination.");
                }
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"PSB - INVALID STATE - got passed the wrong type of profile.");
            }
            throw new IllegalStateException();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addRoutingInfo", (Object)string2);
        }
        return string2;
    }

    protected String removeReplyIdentifier(String string, InboundProfile inboundProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeReplyIdentifier", (Object)new Object[]{string, inboundProfile});
        }
        String string2 = null;
        String[] stringArray = this.tokenizeWithConditions(string, "/", 3);
        string2 = stringArray.length == 3 ? stringArray[2] : string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeReplyIdentifier", (Object)string2);
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SIBusMessage parseRoutingInfo(String string, OutboundProfile outboundProfile, SIBusMessage sIBusMessage, SIUncoordinatedTransaction sIUncoordinatedTransaction) throws SIException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"parseRoutingInfo", (Object)new Object[]{string, outboundProfile, sIBusMessage, sIUncoordinatedTransaction});
        }
        SIBusMessage sIBusMessage2 = null;
        String[] stringArray = this.tokenizeWithConditions(string, "/", 3);
        if (stringArray.length == 3) {
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            String string4 = stringArray[2];
            if (sIBusMessage instanceof JsJmsMessage) {
                MQPublicationInfo mQPublicationInfo = ((JsJmsMessage)sIBusMessage).getMQPublicationInfo();
                ArrayList<String> arrayList = new ArrayList<String>(1);
                arrayList.add(string4);
                mQPublicationInfo.setTopics(arrayList);
                ((JsJmsMessage)sIBusMessage).setMQPublicationInfo(mQPublicationInfo);
                sIBusMessage.setDiscriminator(string4);
                HashMap<String, String> hashMap = new HashMap<String, String>(2);
                hashMap.put("topicName", string4);
                this.updateJMSDestination((JsJmsMessage)sIBusMessage, hashMap);
                EBOutboundProfile eBOutboundProfile = (EBOutboundProfile)outboundProfile;
                String string5 = eBOutboundProfile.getForeignBusName();
                try {
                    SIDestinationAddress sIDestinationAddress = EB_PubSubController.createSIDestAddressForMQQueue(string3, string2, string5);
                    SICoreConnection sICoreConnection = eBOutboundProfile.getConnection();
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"Send the reply message");
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("destination: " + sIDestinationAddress));
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("      topic: " + string4));
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)("reversePath: " + sIBusMessage.getReverseRoutingPath()));
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)(" replyTopic: " + sIBusMessage.getReplyDiscriminator()));
                    }
                    sICoreConnection.send(sIBusMessage, (SITransaction)sIUncoordinatedTransaction, sIDestinationAddress, DestinationType.QUEUE, null, null);
                }
                catch (SIException sIException) {
                    FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.psb.config.brokers.impl.EBReqReplHelper.parseRoutingInfo", (String)"parseRoutingInfo#1", (Object)this);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"parseRoutingInfo", (Object)((Object)sIException));
                    }
                    throw sIException;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.psb.config.brokers.impl.EBReqReplHelper.parseRoutingInfo", (String)"parseRoutingInfo#2", (Object)this);
                    SIErrorException sIErrorException = new SIErrorException((Throwable)exception);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"parseRoutingInfo", (Object)((Object)sIErrorException));
                    }
                    throw sIErrorException;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"PSB - INVALID STATE - got passed a non-JsJmsMessage so can't set publication info");
                }
                throw new IllegalStateException();
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Routing information was not in the format expected - throw exception to force retry.");
        }
        throw new SIMessageException();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"parseRoutingInfo", sIBusMessage2);
        }
        return sIBusMessage2;
    }

    protected void updateOutboundMsgAttributes(SIBusMessage sIBusMessage, OutboundProfile outboundProfile) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateOutboundMsgAttributes");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"NO-OP");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateOutboundMsgAttributes");
        }
    }
}

