/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.config.brokers.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.exception.WsRuntimeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsJmsMessage;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerCommand;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerResponseItem;
import com.ibm.ws.sib.mfp.mqcontrol.MQBrokerResponseMessage;
import com.ibm.ws.sib.mfp.mqcontrol.MQPublicationInfo;
import com.ibm.ws.sib.mfp.mqinterop.CMQC;
import com.ibm.ws.sib.mfp.mqinterop.util.HexString;
import com.ibm.ws.sib.psb.DestinationManager;
import com.ibm.ws.sib.psb.PSBFactoryPoint;
import com.ibm.ws.sib.psb.config.DestinationData;
import com.ibm.ws.sib.psb.config.MappingProfile;
import com.ibm.ws.sib.psb.config.brokers.EBInboundProfile;
import com.ibm.ws.sib.psb.config.brokers.impl.EBOutboundProfileImpl;
import com.ibm.ws.sib.psb.config.impl.DestinationDataImpl;
import com.ibm.ws.sib.psb.config.impl.InboundProfileImpl;
import com.ibm.ws.sib.utils.TopicWildcardTranslation;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import java.util.List;

public class EBInboundProfileImpl
extends InboundProfileImpl
implements EBInboundProfile {
    private static TraceComponent tc = SibTr.register((Class)EBInboundProfileImpl.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");
    private static final long serialVersionUID = 8717537619056213733L;
    private String subscriptionPoint = null;
    private String brokerControlQ;
    private String foreignBus;
    private String remoteQM;
    private String virtualQMName;
    private byte[] correlId;
    private String brokerStreamName;
    private transient String ebSyntaxTopic = null;
    private static final int EB_RESPONSE_NOT_REGISTERED = 3073;

    public EBInboundProfileImpl(String string, DestinationData[] destinationDataArray, String string2, String string3, String string4, String string5, String string6, String string7) {
        super(string, 2, destinationDataArray);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"EBInboundProfileImpl");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Creating EBInboundProfile for  brokerControlQueue " + string2 + ", foreignBusName " + string3 + ", remoteQMName " + string4 + ", subscriptionPoint" + string5 + ", virtualQMName " + string6 + ", brokerStreamName " + string7));
        }
        this.verifyParameter(string2, "BrokerControlQueueName");
        this.verifyParameter(string3, "ForeignBusName");
        this.verifyParameter(string4, "RemoteQueueManagerName");
        this.verifyParameter(string6, "VirtualQMName");
        if (!"".equals(string5)) {
            this.subscriptionPoint = string5;
        }
        this.virtualQMName = string6;
        this.brokerControlQ = string2;
        this.foreignBus = string3;
        this.remoteQM = string4;
        this.brokerStreamName = string7;
        DestinationManager destinationManager = PSBFactoryPoint.getInstance().getDestinationManager();
        String string8 = destinationManager.createSystemDestinationPrefix();
        DestinationDataImpl destinationDataImpl = new DestinationDataImpl(string8, 1);
        DestinationData[] destinationDataArray2 = new DestinationData[]{destinationDataImpl};
        this.setDestinations(destinationDataArray2);
        this.setCleanup(false);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"EBInboundProfileImpl");
        }
    }

    public String getSubscriptionPoint() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionPoint");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return subscription point : " + this.subscriptionPoint));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionPoint");
        }
        return this.subscriptionPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DestinationData getSubscriberQueue() {
        DestinationData[] destinationDataArray;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"getSubscriberQueue");
            }
            if ((destinationDataArray = this.getDestinations()) == null || destinationDataArray.length != 1) {
                throw new IllegalStateException("inbound profile doesn't have single destination");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Return subscriber queue : " + destinationDataArray[0]));
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getSubscriberQueue");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriberQueue");
        }
        return destinationDataArray[0];
    }

    public String getVirtualQMName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getVirtualQMName");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return local bus : " + this.virtualQMName));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getVirtualQMName");
        }
        return this.virtualQMName;
    }

    public String getBrokerControlName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrokerControlName");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return broker control Q : " + this.brokerControlQ));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrokerControlName");
        }
        return this.brokerControlQ;
    }

    public String getRemoteQMName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteQMName");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return remote queue manager : " + this.remoteQM));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteQMName");
        }
        return this.remoteQM;
    }

    public String getForeignBusName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignBusName");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return foreign bus name : " + this.remoteQM));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getForeignBusName");
        }
        return this.foreignBus;
    }

    public byte[] getCorrelId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCorrelId");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return correl id : " + (this.correlId == null ? "null" : HexString.hexString((byte[])this.correlId))));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCorrelId");
        }
        return this.correlId;
    }

    public void setCorrelId(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCorrelId");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Set correl id to " + (byArray == null ? "null" : HexString.hexString((byte[])byArray))));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCorrelId");
        }
        this.correlId = byArray;
    }

    public String getBrokerStreamName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrokerStreamName");
        }
        String string = this.brokerStreamName;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrokerStreamName", (Object)string);
        }
        return string;
    }

    public void completeNewProfile() {
        Object object;
        Object object2;
        MappingProfile mappingProfile;
        block15: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"completeNewProfile");
            }
            try {
                this.correlId = new byte[CMQC.MQCI_NONE_ARRAY.length];
                mappingProfile = this.getMappingProfile();
                if (mappingProfile != null) {
                    object2 = mappingProfile.getBridgeController().getCoreConnection();
                    if (object2 != null) {
                        object = object2.createUniqueId();
                        this.correlId[0] = 83;
                        this.correlId[1] = 73;
                        this.correlId[2] = 66;
                        System.arraycopy(object, 0, this.correlId, 3, ((Object)object).length);
                        this.setCorrelId(this.correlId);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Setting correlId for new subscription :  topic " + this.getInboundEBConvertedTopic() + " correlId " + HexString.hexString((byte[])this.correlId)));
                        }
                    } else if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"CoreConnection was NULL - this should not have happened.");
                    }
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"The MappingProfile was not set - this should only ever happen in unit tests!");
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"EBInboundProfileImpl", (String)"completeNewProfile#1");
                if (!tc.isEventEnabled()) break block15;
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        mappingProfile = this.getMappingProfile();
        object2 = null;
        if (mappingProfile != null) {
            object2 = mappingProfile.getLinkedMapping();
            if (object2 != null) {
                object = (EBOutboundProfileImpl)object2.getOutboundProfile();
                ((EBOutboundProfileImpl)object).relinkProfile(this);
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"This mapping profile was null - should only happen in unit tests.");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"completeNewProfile");
        }
    }

    public String getInboundEBConvertedTopic() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInboundEBConvertedTopic");
        }
        if (this.ebSyntaxTopic == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Calculating for the first time");
            }
            try {
                this.ebSyntaxTopic = TopicWildcardTranslation.getInstance().convertSIBToEventBroker(this.getInboundTopic());
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("ebSyntaxTopic: " + this.ebSyntaxTopic));
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"EBInboundProfileImpl", (String)"<init>#1");
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)exception);
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException();
                illegalArgumentException.initCause(exception);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"EBInboundProfileImpl");
                }
                throw illegalArgumentException;
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("ebTopic: " + this.ebSyntaxTopic));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getInboundEBConvertedTopic");
        }
        return this.ebSyntaxTopic;
    }

    public JsJmsMessage convertInboundToCanonicalForm(SIBusMessage sIBusMessage) {
        JsJmsMessage jsJmsMessage;
        JsJmsMessage jsJmsMessage2 = null;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"convertInboundToCanonicalForm");
            }
            if (sIBusMessage instanceof MQBrokerResponseMessage) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"MQBrokerResponseMessage received.");
                }
                jsJmsMessage2 = this.handleEBBrokerResponse((MQBrokerResponseMessage)sIBusMessage);
            } else {
                jsJmsMessage2 = !(sIBusMessage instanceof JsJmsMessage) ? this.processNonJsJmsMessage(sIBusMessage) : this.processJsJmsMessage((JsJmsMessage)sIBusMessage);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("return: " + jsJmsMessage2));
            }
            jsJmsMessage = jsJmsMessage2;
            Object var5_5 = null;
        }
        catch (WsRuntimeException wsRuntimeException) {
            try {
                FFDCFilter.processException((Throwable)wsRuntimeException, (String)"com.ibm.ws.sib.psb.impl.EBInboundProfileImpl.convertInboundToCanonicalForm", (String)"convertInboundToCanonicalForm#1");
                throw wsRuntimeException;
            }
            catch (Throwable throwable) {
                block10: {
                    Object var5_6 = null;
                    if (!tc.isEntryEnabled()) break block10;
                    SibTr.exit((TraceComponent)tc, (String)"convertInboundToCanonicalForm");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"convertInboundToCanonicalForm");
        }
        return jsJmsMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsJmsMessage handleEBBrokerResponse(MQBrokerResponseMessage mQBrokerResponseMessage) {
        JsJmsMessage jsJmsMessage;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleEBBrokerResponse");
        }
        JsJmsMessage jsJmsMessage2 = null;
        try {
            String string;
            boolean bl = false;
            byte[] byArray = this.getCorrelId();
            String string2 = null;
            if (byArray != null) {
                string2 = HexString.hexString((byte[])byArray);
            }
            if ((string = mQBrokerResponseMessage.getFullResponseCorrelationId()) == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Obtaining correlID from message header");
                }
                string = mQBrokerResponseMessage.getCorrelationId();
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)(" profileCorrelID: " + string2));
                SibTr.debug((TraceComponent)tc, (String)("receivedCorrelID: " + string));
            }
            if (byArray != null && string != null) {
                boolean bl2 = bl = string.equals(string2) || string.equals("ID:" + string2);
            }
            if (!bl) {
                SibTr.error((TraceComponent)tc, (String)"ERR_EB_RESPONSE_MISMATCH_CWSIL0018", (Object)new Object[]{this.getRemoteQMName(), string2, string, this.getMappingProfile()});
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"correlID matches");
                }
                int n = mQBrokerResponseMessage.getCompletion();
                MQBrokerCommand mQBrokerCommand = mQBrokerResponseMessage.getFullResponseCommand();
                if (mQBrokerCommand == null) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Command object is null.");
                    }
                    SibTr.error((TraceComponent)tc, (String)"WARN_EB_RESPONSE_NOCOMMAND_CWSIL0017", (Object)new Object[]{this.getRemoteQMName(), this.getMappingProfile()});
                } else {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Command: " + mQBrokerCommand.getName()));
                    }
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("  completion: " + n));
                    }
                    int n2 = 0;
                    if (n != 0) {
                        n2 = EBInboundProfileImpl.getBrokerResponseReasonCode(mQBrokerResponseMessage);
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("  reasonCode: " + n2));
                        }
                    }
                    jsJmsMessage2 = this.processBrokerReponse(mQBrokerCommand, n, n2);
                }
            }
            jsJmsMessage = jsJmsMessage2;
            Object var11_11 = null;
        }
        catch (Throwable throwable) {
            block19: {
                Object var11_12 = null;
                if (!tc.isEntryEnabled()) break block19;
                SibTr.exit((TraceComponent)tc, (String)"handleEBBrokerResponse");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleEBBrokerResponse");
        }
        return jsJmsMessage;
    }

    public static int getBrokerResponseReasonCode(MQBrokerResponseMessage mQBrokerResponseMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrokerResponseReasonCode", (Object)mQBrokerResponseMessage);
        }
        List list = mQBrokerResponseMessage.getResponses();
        int n = 0;
        if (list != null && list.size() > 0) {
            MQBrokerResponseItem mQBrokerResponseItem = (MQBrokerResponseItem)list.get(0);
            n = mQBrokerResponseItem.getReason();
            if (list.size() > 1 && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Expected one response, received " + list.size()), (Object)list.toArray());
            }
        } else {
            n = 0;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("There were no responses in this message - returning " + n));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrokerResponseReasonCode", (Object)new Integer(n));
        }
        return n;
    }

    private JsJmsMessage processBrokerReponse(MQBrokerCommand mQBrokerCommand, int n, int n2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processBrokerReponse", (Object)new Object[]{mQBrokerCommand, new Integer(n), new Integer(n2)});
        }
        boolean bl = this.isCleanup();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("isCleanup: " + bl));
        }
        if (!bl) {
            if (mQBrokerCommand == MQBrokerCommand.REGISTER_SUBSCRIBER) {
                if (n == 0) {
                    this.subscriptionOpened(true);
                } else {
                    this.subscriptionOpened(false);
                    SibTr.error((TraceComponent)tc, (String)"ERR_EB_REGSUB_FAIL_CWSIL0001", (Object)new Object[]{this.getRemoteQMName(), this, new Integer(n2)});
                }
            } else if (mQBrokerCommand == MQBrokerCommand.DEREGISTER_SUBSCRIBER) {
                if (n == 0) {
                    this.subscriptionClosed(true);
                } else if (n == 3073) {
                    this.subscriptionClosed(true);
                } else {
                    this.subscriptionClosed(false);
                    SibTr.error((TraceComponent)tc, (String)"ERR_EB_DEREGSUB_FAIL_CWSIL0003", (Object)new Object[]{this.getRemoteQMName(), this, new Integer(n2)});
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Received an unexpected broker response for command " + mQBrokerCommand));
                    SibTr.debug((TraceComponent)tc, (String)("cc=" + n + ", rc=" + n2));
                }
                SibTr.error((TraceComponent)tc, (String)"ERR_EB_RESPONSE_COMMAND_CWSIL0016", (Object)new Object[]{this.getRemoteQMName(), mQBrokerCommand, "cc=" + n + ", rc=" + n2, this.getMappingProfile()});
            }
        } else if (mQBrokerCommand == MQBrokerCommand.DEREGISTER_SUBSCRIBER) {
            if (n == 0) {
                this.subscriptionClosed(true);
            } else {
                this.subscriptionClosed(false);
                SibTr.error((TraceComponent)tc, (String)"ERR_EB_DEREGSUB_FAIL_CWSIL0003", (Object)new Object[]{this.getRemoteQMName(), this, new Integer(n2)});
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Unexpected command message received - ignoring");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processBrokerReponse", null);
        }
        return null;
    }

    private JsJmsMessage processJsJmsMessage(JsJmsMessage jsJmsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processJsJmsMessage");
        }
        JsJmsMessage jsJmsMessage2 = null;
        boolean bl = this.isCleanup();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("isCleanup: " + bl));
        }
        if (!bl) {
            MQPublicationInfo mQPublicationInfo = jsJmsMessage.getMQPublicationInfo();
            if (mQPublicationInfo != null) {
                List list = mQPublicationInfo.getTopics();
                if (list != null && list.size() > 0) {
                    if (tc.isDebugEnabled() && list.size() > 1) {
                        SibTr.debug((TraceComponent)tc, (String)("Expected one topic, received " + list.size()), (Object)list.toArray());
                    }
                    jsJmsMessage.setDiscriminator((String)list.get(0));
                    jsJmsMessage2 = jsJmsMessage;
                } else {
                    SibTr.error((TraceComponent)tc, (String)"ERR_MISSING_TOPIC_CWSIL0006", (Object)new Object[]{this.getRemoteQMName(), jsJmsMessage.getClass(), this.getMappingProfile()});
                    jsJmsMessage2 = null;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Received a message on the subscriber queue which isneither a broker response nor a publication.");
                }
                SibTr.error((TraceComponent)tc, (String)"ERR_EB_MESSAGE_CWSIL0002", (Object)new Object[]{this.getRemoteQMName(), jsJmsMessage.getClass(), this.getMappingProfile()});
                throw new WsRuntimeException("Unexpected message received from event broker");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processJsJmsMessage", jsJmsMessage2);
        }
        return jsJmsMessage2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsJmsMessage processNonJsJmsMessage(SIBusMessage sIBusMessage) {
        JsJmsMessage jsJmsMessage;
        try {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"processNonJsJmsMessage");
            }
            JsJmsMessage jsJmsMessage2 = null;
            boolean bl = this.isCleanup();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("isCleanup: " + bl));
            }
            if (!bl) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Non-JsJmsMessage received");
                    SibTr.debug((TraceComponent)tc, (String)("System UUID: " + sIBusMessage.getSystemMessageId()));
                    if (sIBusMessage instanceof JsApiMessage) {
                        SibTr.debug((TraceComponent)tc, (String)("Api MsgID: " + ((JsApiMessage)sIBusMessage).getApiMessageId()));
                    }
                    SibTr.debug((TraceComponent)tc, (String)("msg: " + sIBusMessage));
                }
                SibTr.error((TraceComponent)tc, (String)"ERR_EB_JS_PUBLISH_CWSIL0005", (Object)new Object[]{this.getRemoteQMName(), sIBusMessage.getClass(), this.getMappingProfile()});
                WsRuntimeException wsRuntimeException = new WsRuntimeException("Cannot handle publication of messages of class " + sIBusMessage.getClass());
                if (tc.isEntryEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)wsRuntimeException));
                }
                throw wsRuntimeException;
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("return: " + jsJmsMessage2));
            }
            jsJmsMessage = jsJmsMessage2;
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            block10: {
                Object var6_7 = null;
                if (!tc.isEntryEnabled()) break block10;
                SibTr.exit((TraceComponent)tc, (String)"processNonJsJmsMessage");
            }
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processNonJsJmsMessage");
        }
        return jsJmsMessage;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        EBInboundProfileImpl eBInboundProfileImpl = (EBInboundProfileImpl)object;
        if (!this.commonEquals(eBInboundProfileImpl)) {
            return false;
        }
        return !(this.brokerStreamName == null ? eBInboundProfileImpl.brokerStreamName != null : !this.brokerStreamName.equals(eBInboundProfileImpl.brokerStreamName));
    }

    private boolean commonEquals(EBInboundProfileImpl eBInboundProfileImpl) {
        if (this.subscriptionPoint == null && eBInboundProfileImpl.subscriptionPoint != null) {
            return false;
        }
        if (this.subscriptionPoint != null && !this.subscriptionPoint.equals(eBInboundProfileImpl.subscriptionPoint)) {
            return false;
        }
        if (!this.brokerControlQ.equals(eBInboundProfileImpl.brokerControlQ)) {
            return false;
        }
        if (!this.foreignBus.equals(eBInboundProfileImpl.foreignBus)) {
            return false;
        }
        if (!this.remoteQM.equals(eBInboundProfileImpl.remoteQM)) {
            return false;
        }
        return this.virtualQMName.equals(eBInboundProfileImpl.virtualQMName);
    }

    public int hashCode() {
        try {
            int n = 17;
            n += 23 * super.hashCode();
            if (this.subscriptionPoint != null) {
                n += 29 * this.subscriptionPoint.hashCode();
            }
            n += 31 * this.brokerControlQ.hashCode();
            n += 37 * this.foreignBus.hashCode();
            n += 41 * this.remoteQM.hashCode();
            n += 43 * this.virtualQMName.hashCode();
            if (this.brokerStreamName != null) {
                n += 47 * this.brokerStreamName.hashCode();
            }
            return n;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.psb.impl.EBInboundProfileImpl.hashCode", (String)"hashCode#1");
            if (tc.isDebugEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
            return 1;
        }
    }

    public boolean equalsForCleanup(EBInboundProfile eBInboundProfile) {
        EBInboundProfileImpl eBInboundProfileImpl = (EBInboundProfileImpl)eBInboundProfile;
        if (!this.commonEquals(eBInboundProfileImpl)) {
            return false;
        }
        if (this.correlId == null && eBInboundProfileImpl.correlId != null) {
            return false;
        }
        if (this.correlId != null && eBInboundProfileImpl.correlId == null) {
            return false;
        }
        if (this.correlId != null && this.correlId.length != eBInboundProfileImpl.correlId.length) {
            return false;
        }
        if (this.correlId != null) {
            for (int i = 0; i < this.correlId.length; ++i) {
                if (this.correlId[i] == eBInboundProfileImpl.correlId[i]) continue;
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return super.toString() + ", subscriptionPoint=" + this.subscriptionPoint + ", queueManager=" + this.remoteQM + ", foreignBus=" + this.foreignBus + ", virtualQMName=" + this.virtualQMName + ", controlQ=" + this.brokerControlQ + ", ebSyntaxTopic=" + this.ebSyntaxTopic + ", correlID=" + (this.correlId == null ? "null" : HexString.hexString((byte[])this.correlId));
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/config/brokers/impl/EBInboundProfileImpl.java, SIB.psb, WAS602.SIB, o0610.11 1.36");
        }
    }
}

