/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.psb.admin.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.sibresources.SIBus;
import com.ibm.websphere.sib.admin.SIBPSBSubscription;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.JsBus;
import com.ibm.ws.sib.admin.JsEObject;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.processor.SIMPAdmin;
import com.ibm.ws.sib.psb.BridgeController;
import com.ibm.ws.sib.psb.DestinationManager;
import com.ibm.ws.sib.psb.MappingProfileRegistry;
import com.ibm.ws.sib.psb.PSBFactory;
import com.ibm.ws.sib.psb.PSBFactoryPoint;
import com.ibm.ws.sib.psb.PubSubController;
import com.ibm.ws.sib.psb.admin.BridgeControllerAdmin;
import com.ibm.ws.sib.psb.config.Bridge;
import com.ibm.ws.sib.psb.config.DestinationData;
import com.ibm.ws.sib.psb.config.InboundProfile;
import com.ibm.ws.sib.psb.config.MappingProfile;
import com.ibm.ws.sib.psb.config.OutboundProfile;
import com.ibm.ws.sib.psb.config.brokers.impl.EBInboundProfileImpl;
import com.ibm.ws.sib.psb.config.brokers.impl.EBOutboundProfileImpl;
import com.ibm.ws.sib.psb.config.brokers.impl.SIBInboundProfileImpl;
import com.ibm.ws.sib.psb.config.brokers.impl.SIBOutboundProfileImpl;
import com.ibm.ws.sib.psb.config.impl.MappingProfileImpl;
import com.ibm.ws.sib.psb.config.impl.TransactionalitySettingsImpl;
import com.ibm.ws.sib.psb.impl.DistinctReplyMappingHelper;
import com.ibm.ws.sib.psb.impl.RequestReplyHelper;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BridgeControllerAdminImpl
implements BridgeControllerAdmin {
    private static final TraceComponent tc = SibTr.register((Class)BridgeControllerAdminImpl.class, (String)"SIBPsb", (String)"com.ibm.ws.sib.psb.CWSILMessages");
    private String name;
    private String description;
    private String brokerQMgrName;
    private String mqLinkName;
    private String mqLinkUuid;
    private String mqLinkQmgrName;
    private String mqLinkTargetUuid;
    private ArrayList adminProfileList = new ArrayList();
    private AdminTransactionality profileTransactionality = new AdminTransactionality();
    private JsMessagingEngine engine;
    private BridgeController bridgeController;
    private String localBusName;
    private String foreignBusName;
    private boolean destinationChangePending;
    private static final String brokerControlQ = "SYSTEM.BROKER.CONTROL.QUEUE";
    private static final int BI_DIRECTIONAL = 0;
    private static final int FROM_MQ = 1;
    private static final int TO_MQ = 2;
    private static final String WILDCARD_SUFFIX = "//.";

    public BridgeControllerAdminImpl() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BridgeControllerAdminImpl()");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return BridgeControllerAdminImpl : " + this));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"BridgeControllerAdminImpl()");
        }
    }

    public BridgeControllerAdminImpl(String string, String string2, String string3, String string4, String string5, String string6, String string7, ArrayList arrayList) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BridgeControllerAdminImpl(String, String, String, String, String, String, String, ArrayList");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("name :" + string));
            SibTr.debug((TraceComponent)tc, (String)("description :" + string2));
            SibTr.debug((TraceComponent)tc, (String)("brokerQM :" + string3));
            SibTr.debug((TraceComponent)tc, (String)("mqLinkName :" + string4));
            SibTr.debug((TraceComponent)tc, (String)("mqLinkUuid :" + string5));
            SibTr.debug((TraceComponent)tc, (String)("mqLinkQmgrName :" + string6));
            SibTr.debug((TraceComponent)tc, (String)("mqLinkTargetUuid :" + string7));
            SibTr.debug((TraceComponent)tc, (String)("adminProfileList :" + arrayList));
        }
        this.name = string;
        this.description = string2;
        this.brokerQMgrName = string3;
        this.mqLinkName = string4;
        this.mqLinkUuid = string5;
        this.mqLinkQmgrName = string6;
        this.mqLinkTargetUuid = string7;
        if (arrayList != null) {
            this.adminProfileList = arrayList;
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return BridgeControllerAdminImpl : " + this));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"BridgeControllerAdminImpl(String, String, String, String, String, String, String, ArrayList");
        }
    }

    public void configure(JsEObject jsEObject) {
        String string;
        String string2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"configure");
        }
        this.mqLinkQmgrName = jsEObject.getParent().getAttribute("qmName");
        this.mqLinkName = jsEObject.getParent().getAttribute("name");
        this.mqLinkUuid = jsEObject.getParent().getAttribute("uuid");
        this.mqLinkTargetUuid = jsEObject.getParent().getAttribute("targetUuid");
        String[] stringArray = jsEObject.getAttributeNames();
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            string = jsEObject.getAttribute(stringArray[i]);
            this.setAttribute(string2, string);
        }
        Map map = jsEObject.getChildren();
        string2 = map.get("transactionality");
        if (string2 != null) {
            if (string2 instanceof JsEObject) {
                this.profileTransactionality = new AdminTransactionality(true, (JsEObject)string2);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"profileTransactionality was of unexpected type;");
                SibTr.debug((TraceComponent)tc, (String)("profile transactionality = " + string2));
            }
        }
        if ((string = map.get("topicMapping")) != null && string instanceof List) {
            List list = (List)((Object)string);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object object;
                String string3;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Processing a TopicMapping: " + this.adminProfileList.size()));
                }
                AdminMappingProfile adminMappingProfile = new AdminMappingProfile();
                JsEObject jsEObject2 = (JsEObject)iterator.next();
                String[] stringArray2 = jsEObject2.getAttributeNames();
                for (int i = 0; i < stringArray2.length; ++i) {
                    string3 = stringArray2[i];
                    object = jsEObject2.getAttribute(stringArray2[i]);
                    adminMappingProfile.setAttribute(string3, (String)object);
                }
                Map map2 = jsEObject2.getChildren();
                string3 = map2.get("transactionality");
                if (string3 != null && string3 instanceof JsEObject) {
                    object = new AdminTransactionality(true, (JsEObject)string3);
                    adminMappingProfile.transactionality = (AdminTransactionality)object;
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("topic transactionality = " + string3));
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("TopicMapping parsed OK: " + this.adminProfileList.size()));
                }
                this.adminProfileList.add(adminMappingProfile);
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"TopicMapping was of unexpected type;");
            SibTr.debug((TraceComponent)tc, (String)("topicMapping = " + string));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"configure");
        }
    }

    public void setAttribute(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAttribute");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("set " + string + "=" + string2));
        }
        if (string.equalsIgnoreCase("name")) {
            string = string2;
        } else if (string.equalsIgnoreCase("brokerQueueManager")) {
            this.brokerQMgrName = string2;
        } else if (string.equalsIgnoreCase("description")) {
            this.description = string2;
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Received unexpected attribute " + string + " with value " + string2));
            }
            SibTr.warning((TraceComponent)tc, (String)"INVALID_ATTRIBUTE_CWSIL0012", (Object)new Object[]{this.getClass(), string, string2});
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAttribute");
        }
    }

    public void initialize(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialize");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("PSB for ME " + jsMessagingEngine));
        }
        this.engine = jsMessagingEngine;
        this.localBusName = jsMessagingEngine.getBusName();
        JsBus jsBus = (JsBus)jsMessagingEngine.getBus();
        ForeignBusDefinition foreignBusDefinition = jsBus.getForeignBusForLink(this.mqLinkTargetUuid);
        if (foreignBusDefinition != null) {
            this.foreignBusName = foreignBusDefinition.getName();
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"getForeignBusForLink returned null.");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("PSB for foreignBus " + this.foreignBusName));
        }
        PSBFactory pSBFactory = PSBFactoryPoint.getInstance();
        this.bridgeController = pSBFactory.createBridgeController(this);
        pSBFactory.getBridge().addBridgeController(this.bridgeController);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialize");
        }
    }

    public void start(int n) {
        block8: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"start");
            }
            try {
                if (this.bridgeController != null) {
                    this.bridgeController.start();
                } else if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"BridgeController is null.");
                }
                Bridge bridge = PSBFactoryPoint.getInstance().getBridge();
                if (bridge.allBridgeControllersStarted()) {
                    bridge.reconcileEBSubscriptions();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"BridgeControllerAdminImpl", (String)"start#1");
                if (!tc.isEventEnabled()) break block8;
                SibTr.exception((TraceComponent)tc, (Throwable)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"start");
        }
    }

    public void stop(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        if (this.bridgeController != null) {
            this.bridgeController.stop();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void setCustomProperty(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setCustomProperty");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("unexpected custom property " + string + "=" + string2));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setCustomProperty");
        }
    }

    public void busReloaded(SIBus sIBus, boolean bl, boolean bl2, boolean bl3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"busReloaded(SIBus, boolean, boolean, boolean)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("newBus : " + sIBus));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("busChg : " + bl));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("destChg : " + bl2));
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("medChg : " + bl3));
        }
        if (bl2) {
            this.destinationChangePending = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"busReloaded(SIBus, boolean, boolean, boolean)");
        }
    }

    public void engineReloaded(JsMessagingEngine jsMessagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"engineReloaded(JsMessagingEngine)");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("engine : " + jsMessagingEngine));
        }
        if (this.destinationChangePending) {
            this.destinationChangePending = false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"engineReloaded(JsMessagingEngine)");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"destroy");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public String getBrokerQMgrName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrokerQMgrName");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return " + this.brokerQMgrName));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrokerQMgrName");
        }
        return this.brokerQMgrName;
    }

    public JsMessagingEngine getEngine() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEngine");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return " + this.engine));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEngine");
        }
        return this.engine;
    }

    public String getForeignBusName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignBusName");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return " + this.foreignBusName));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getForeignBusName");
        }
        return this.foreignBusName;
    }

    public String getLocalBusName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalBusName");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return " + this.localBusName));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalBusName");
        }
        return this.localBusName;
    }

    public String getMQLinkName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkName");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return " + this.mqLinkName));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkName");
        }
        return this.mqLinkName;
    }

    public String getMQLinkUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkUuid");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return " + this.mqLinkUuid));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkUuid");
        }
        return this.mqLinkUuid;
    }

    public String getMQLinkQMgrName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMQLinkQMgrName");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return " + this.mqLinkQmgrName));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMQLinkQMgrName");
        }
        return this.mqLinkQmgrName;
    }

    public String getBrokerControlQueue() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBrokerControlQueue");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Return SYSTEM.BROKER.CONTROL.QUEUE");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBrokerControlQueue");
        }
        return brokerControlQ;
    }

    public BridgeController getBridgeController() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBridgeController");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Return " + this.bridgeController));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBridgeController");
        }
        return this.bridgeController;
    }

    public MappingProfile[] getProfiles() {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProfiles");
        }
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        RequestReplyHelper requestReplyHelper = RequestReplyHelper.getRequestReplyHelper(2);
        DistinctReplyMappingHelper distinctReplyMappingHelper = requestReplyHelper.getReplyMappingHelper();
        RequestReplyHelper requestReplyHelper2 = RequestReplyHelper.getRequestReplyHelper(1);
        DistinctReplyMappingHelper distinctReplyMappingHelper2 = requestReplyHelper2.getReplyMappingHelper();
        for (int i = 0; i < this.adminProfileList.size(); ++i) {
            try {
                Object object;
                Serializable serializable;
                AdminMappingProfile adminMappingProfile;
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Processing profile #" + i));
                }
                if (!(adminMappingProfile = (AdminMappingProfile)this.adminProfileList.get(i)).checkValid()) continue;
                AdminTransactionality adminTransactionality = adminMappingProfile.transactionality;
                if (adminTransactionality == null || adminTransactionality.isInherited) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Transactionality inherited.");
                    }
                    adminTransactionality = this.profileTransactionality;
                }
                TransactionalitySettingsImpl transactionalitySettingsImpl = new TransactionalitySettingsImpl(adminTransactionality.messageType, adminTransactionality.batchSize);
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("profileDirection: " + adminMappingProfile.direction));
                }
                MappingProfile mappingProfile = null;
                if (adminMappingProfile.direction == 0 || adminMappingProfile.direction == 1) {
                    serializable = new EBInboundProfileImpl(adminMappingProfile.topic, new DestinationData[0], brokerControlQ, this.foreignBusName, this.brokerQMgrName, adminMappingProfile.subscriptionPoint, this.mqLinkQmgrName, adminMappingProfile.brokerStreamQ);
                    object = new SIBOutboundProfileImpl(adminMappingProfile.topic, new DestinationData[0], adminMappingProfile.topicSpace, this.brokerQMgrName);
                    mappingProfile = new MappingProfileImpl(this.bridgeController, (InboundProfile)serializable, (OutboundProfile)object, transactionalitySettingsImpl);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Profile #" + i + " FROM_MQ added: " + mappingProfile));
                    }
                    arrayList.add(mappingProfile);
                    if (distinctReplyMappingHelper2.isDistinctReplyMappingRequired((OutboundProfile)object)) {
                        this.processEBtoSIBReplyMapping(adminMappingProfile, (SIBOutboundProfileImpl)object, transactionalitySettingsImpl, arrayList, requestReplyHelper2);
                    }
                }
                serializable = null;
                if (adminMappingProfile.direction == 0 || adminMappingProfile.direction == 2) {
                    object = PSBFactoryPoint.getInstance().getDestinationManager();
                    String string = "_P" + object.createSystemDestinationPrefix();
                    SIBInboundProfileImpl sIBInboundProfileImpl = new SIBInboundProfileImpl(adminMappingProfile.topic, new DestinationData[0], adminMappingProfile.topicSpace, string);
                    EBOutboundProfileImpl eBOutboundProfileImpl = new EBOutboundProfileImpl(adminMappingProfile.topic, new DestinationData[0], adminMappingProfile.brokerStreamQ, this.foreignBusName, this.brokerQMgrName, this.mqLinkQmgrName);
                    serializable = new MappingProfileImpl(this.bridgeController, sIBInboundProfileImpl, eBOutboundProfileImpl, transactionalitySettingsImpl);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Profile #" + i + " TO_MQ added: " + serializable));
                    }
                    arrayList.add(serializable);
                    if (distinctReplyMappingHelper.isDistinctReplyMappingRequired(eBOutboundProfileImpl)) {
                        this.processSIBtoEBReplyMapping(adminMappingProfile, eBOutboundProfileImpl, transactionalitySettingsImpl, arrayList, requestReplyHelper);
                    }
                }
                if (adminMappingProfile.direction != 0) continue;
                mappingProfile.setLinkedMapping((MappingProfile)serializable);
                serializable.setLinkedMapping(mappingProfile);
                continue;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"BridgeControllerAdminImpl", (String)"getProfiles#1");
                if (!tc.isEventEnabled()) continue;
                SibTr.exception((TraceComponent)tc, (Exception)exception);
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Finished parsing all profiles that were defined in admin");
        }
        MappingProfile[] mappingProfileArray = new MappingProfile[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            mappingProfileArray[n] = (MappingProfile)arrayList.get(n);
        }
        if (tc.isDebugEnabled()) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Returning " + mappingProfileArray.length + " profiles."));
            }
            for (n = 0; n < mappingProfileArray.length; ++n) {
                SibTr.debug((TraceComponent)tc, (String)("Profile #" + n + ": " + mappingProfileArray[n]));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getProfiles");
        }
        return mappingProfileArray;
    }

    public void serverStarted() {
    }

    public void serverStopping() {
    }

    public List getSubscriptions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptions()");
        }
        ArrayList<SIBPSBSubscription> arrayList = new ArrayList<SIBPSBSubscription>();
        MappingProfileRegistry mappingProfileRegistry = null;
        if (this.bridgeController != null) {
            mappingProfileRegistry = this.bridgeController.getMappingRegistry();
        }
        if (mappingProfileRegistry != null) {
            int n;
            MappingProfile[] mappingProfileArray = mappingProfileRegistry.getActiveProfiles();
            MappingProfile[] mappingProfileArray2 = mappingProfileRegistry.getInactiveProfiles();
            for (n = 0; n < mappingProfileArray.length; ++n) {
                arrayList.add(mappingProfileArray[n].toSIBPSBSubscription());
            }
            for (n = 0; n < mappingProfileArray2.length; ++n) {
                arrayList.add(mappingProfileArray2[n].toSIBPSBSubscription());
            }
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("return List : " + arrayList));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptions()");
        }
        return arrayList;
    }

    public void unsubscribe() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unsubscribe()");
        }
        MappingProfileRegistry mappingProfileRegistry = null;
        if (this.bridgeController != null) {
            mappingProfileRegistry = this.bridgeController.getMappingRegistry();
        }
        if (mappingProfileRegistry != null) {
            PSBFactory pSBFactory = PSBFactoryPoint.getInstance();
            MappingProfile[] mappingProfileArray = mappingProfileRegistry.getActiveProfiles();
            for (int i = 0; i < mappingProfileArray.length; ++i) {
                InboundProfile inboundProfile = mappingProfileArray[i].getInboundProfile();
                PubSubController pubSubController = pSBFactory.getPubSubController(inboundProfile.getBrokerType());
                inboundProfile.setCleanup(true);
                pubSubController.closeSubscription(inboundProfile);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unsubscribe()");
        }
    }

    private void processEBtoSIBReplyMapping(AdminMappingProfile adminMappingProfile, SIBOutboundProfileImpl sIBOutboundProfileImpl, TransactionalitySettingsImpl transactionalitySettingsImpl, List list, RequestReplyHelper requestReplyHelper) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processEBtoSIBReplyMapping");
        }
        if (adminMappingProfile.brokerStreamQ != null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"brokerStreamQueue specified OK");
            }
            String string = requestReplyHelper.getReplySubscriptionTopicName(sIBOutboundProfileImpl);
            string = string + WILDCARD_SUFFIX;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("replyTopicName: " + string));
            }
            DestinationManager destinationManager = PSBFactoryPoint.getInstance().getDestinationManager();
            String string2 = "_P" + destinationManager.createSystemDestinationPrefix();
            SIBInboundProfileImpl sIBInboundProfileImpl = new SIBInboundProfileImpl(string, new DestinationData[0], adminMappingProfile.topicSpace, string2);
            EBOutboundProfileImpl eBOutboundProfileImpl = new EBOutboundProfileImpl(string, new DestinationData[0], adminMappingProfile.brokerStreamQ, this.foreignBusName, this.brokerQMgrName, this.mqLinkQmgrName);
            MappingProfileImpl mappingProfileImpl = new MappingProfileImpl(this.bridgeController, sIBInboundProfileImpl, eBOutboundProfileImpl, transactionalitySettingsImpl);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Adding the reply profile: " + mappingProfileImpl));
            }
            list.add(mappingProfileImpl);
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"The brokerStreamQueue was not defined, so we cannot route any reply messages on this topic.");
            }
            SibTr.warning((TraceComponent)tc, (String)"WARN_INSUFF_STREAMQUEUE_DATA_FOR_REPLY_CWSIL0020", (Object)new Object[]{sIBOutboundProfileImpl});
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processEBtoSIBReplyMapping");
        }
    }

    private void processSIBtoEBReplyMapping(AdminMappingProfile adminMappingProfile, EBOutboundProfileImpl eBOutboundProfileImpl, TransactionalitySettingsImpl transactionalitySettingsImpl, List list, RequestReplyHelper requestReplyHelper) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"processSIBtoEBReplyMapping");
        }
        String string = requestReplyHelper.getReplySubscriptionTopicName(eBOutboundProfileImpl);
        string = string + WILDCARD_SUFFIX;
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("replyTopicName: " + string));
        }
        EBInboundProfileImpl eBInboundProfileImpl = new EBInboundProfileImpl(string, new DestinationData[0], brokerControlQ, this.foreignBusName, this.brokerQMgrName, null, this.mqLinkQmgrName, adminMappingProfile.brokerStreamQ);
        SIBOutboundProfileImpl sIBOutboundProfileImpl = new SIBOutboundProfileImpl(string, new DestinationData[0], adminMappingProfile.topicSpace, this.brokerQMgrName);
        MappingProfileImpl mappingProfileImpl = new MappingProfileImpl(this.bridgeController, eBInboundProfileImpl, sIBOutboundProfileImpl, transactionalitySettingsImpl);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Adding the reply profile: " + mappingProfileImpl));
        }
        list.add(mappingProfileImpl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"processSIBtoEBReplyMapping");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"@(#)SIB/ws/code/sib.psb.impl/src/com/ibm/ws/sib/psb/admin/impl/BridgeControllerAdminImpl.java, SIB.psb, WAS602.SIB, o0610.11 1.38");
        }
    }

    private class AdminTransactionality {
        private int batchSize = 10;
        private String messageType = "ALL";
        private boolean isTopicSpecific;
        private boolean isInherited;

        AdminTransactionality() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AdminTransactionality");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Default constructor, configuring the default values.");
            }
            this.batchSize = 10;
            this.messageType = "ALL";
            this.isTopicSpecific = false;
            this.isInherited = false;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AdminTransactionality");
            }
        }

        AdminTransactionality(boolean bl, JsEObject jsEObject) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AdminTransactionality", (Object)new Boolean(bl));
            }
            this.isTopicSpecific = bl;
            if (this.isTopicSpecific) {
                this.isInherited = true;
            }
            if (jsEObject != null) {
                String[] stringArray = jsEObject.getAttributeNames();
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    String string2 = jsEObject.getAttribute(stringArray[i]);
                    this.setAttribute(string, string2);
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"adminTransSettings is null.");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AdminTransactionality");
            }
        }

        protected void setAttribute(String string, String string2) {
            block17: {
                if (tc.isEntryEnabled()) {
                    SibTr.entry((TraceComponent)tc, (String)"setAttribute");
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("set " + string + "=" + string2));
                }
                if (string.equalsIgnoreCase("batchSize")) {
                    try {
                        this.batchSize = Integer.parseInt(string2);
                        if (this.batchSize >= 1) break block17;
                        SibTr.error((TraceComponent)tc, (String)"INVALID_ATTRIBUTE_CWSIL0012", (Object)new Object[]{this.getClass(), string, string2});
                        this.batchSize = 10;
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Batch size should be a positive integer > 1, defaulted to " + this.batchSize));
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        SibTr.error((TraceComponent)tc, (String)"INVALID_ATTRIBUTE_CWSIL0012", (Object)new Object[]{this.getClass(), string, string2});
                    }
                } else if (string.equalsIgnoreCase("messageType")) {
                    if ("INHERIT".equals(string2)) {
                        if (this.isTopicSpecific) {
                            this.isInherited = true;
                        } else {
                            if (tc.isDebugEnabled()) {
                                SibTr.debug((TraceComponent)tc, (String)"Cannot set transactionality of broker profile to inherited");
                            }
                            SibTr.error((TraceComponent)tc, (String)"INVALID_ATTRIBUTE_CWSIL0012", (Object)new Object[]{this.getClass(), string, string2});
                        }
                    } else if ("ALL".equals(string2) || "PERSISTENT".equals(string2)) {
                        this.messageType = string2;
                    } else {
                        SibTr.error((TraceComponent)tc, (String)"INVALID_ATTRIBUTE_CWSIL0012", (Object)new Object[]{this.getClass(), string, string2});
                    }
                } else {
                    SibTr.error((TraceComponent)tc, (String)"INVALID_ATTRIBUTE_CWSIL0012", (Object)new Object[]{this.getClass(), string, string2});
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setAttribute");
            }
        }
    }

    private class AdminMappingProfile {
        private int direction = 0;
        private String topic;
        private String subscriptionPoint;
        private String topicSpace;
        private String brokerStreamQ;
        private AdminTransactionality transactionality;
        private String cachedToString = null;

        public AdminMappingProfile() {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"AdminMappingProfile");
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"AdminMappingProfile");
            }
        }

        protected void setAttribute(String string, String string2) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"setAttribute");
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("set " + string + "=" + string2));
            }
            this.cachedToString = null;
            if (string.equalsIgnoreCase("topicName")) {
                this.topic = string2;
            } else if (string.equalsIgnoreCase("direction")) {
                if (string2.equalsIgnoreCase("BI_DIRECTIONAL")) {
                    this.direction = 0;
                } else if (string2.equalsIgnoreCase("FROM_MQ")) {
                    this.direction = 1;
                } else if (string2.equalsIgnoreCase("TO_MQ")) {
                    this.direction = 2;
                } else {
                    SibTr.error((TraceComponent)tc, (String)"INVALID_ATTRIBUTE_CWSIL0012", (Object)new Object[]{this.getClass(), string, string2});
                }
            } else if (string.equalsIgnoreCase("topicSpace")) {
                this.topicSpace = string2;
            } else if (string.equalsIgnoreCase("subscriptionPoint")) {
                if (string2 != null && !"".equals(string2.trim())) {
                    this.subscriptionPoint = string2;
                }
            } else if (string.equalsIgnoreCase("brokerStreamQueue")) {
                if (string2 != null && !"".equals(string2.trim())) {
                    this.brokerStreamQ = string2;
                }
            } else {
                SibTr.error((TraceComponent)tc, (String)"INVALID_ATTRIBUTE_CWSIL0012", (Object)new Object[]{this.getClass(), string, string2});
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"setAttribute");
            }
        }

        private boolean checkValid() {
            boolean bl;
            Object object;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"checkValid");
            }
            boolean bl2 = false;
            boolean bl3 = false;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("        topic: " + this.topic));
                SibTr.debug((TraceComponent)tc, (String)("   topicSpace: " + this.topicSpace));
                object = null;
                switch (this.direction) {
                    case 2: {
                        object = "JS->MQ";
                        break;
                    }
                    case 1: {
                        object = "MQ->JS";
                        break;
                    }
                    case 0: {
                        object = "JS<->MQ";
                        break;
                    }
                    default: {
                        object = "UNKNOWN (" + this.direction + ")";
                    }
                }
                SibTr.debug((TraceComponent)tc, (String)("    direction: " + (String)object));
                SibTr.debug((TraceComponent)tc, (String)("brokerStreamQ: " + this.brokerStreamQ));
            }
            if (this.topic == null || this.topic.equals("")) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"ERROR - topic is null or empty");
                }
                bl2 = true;
            } else if (this.topicSpace == null || this.topicSpace.equals("")) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"ERROR - topicSpace is null or empty");
                }
                bl2 = true;
            } else if (!(this.direction != 0 && this.direction != 2 || this.brokerStreamQ != null && !this.brokerStreamQ.equals(""))) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"ERROR - brokerStreamQ required, but not entered.");
                }
                bl2 = true;
            }
            if (bl2) {
                SibTr.error((TraceComponent)tc, (String)"ERR_INCOMPLETE_MAPPING_CWSIL0013", (Object)this);
            } else {
                object = ((SIMPAdmin)BridgeControllerAdminImpl.this.engine.getMessageProcessor()).getAdministrator();
                if (!object.destinationExists(this.topicSpace)) {
                    bl3 = true;
                    SibTr.error((TraceComponent)tc, (String)"TOPICSPACE_DOESNOT_EXIST_CWSIL0019", (Object)new Object[]{this.topicSpace, this});
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("incompleteMapping: " + bl2));
                SibTr.debug((TraceComponent)tc, (String)("invalidDestination: " + bl3));
            }
            boolean bl4 = bl = !bl2 && !bl3;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkValid", (Object)new Boolean(bl));
            }
            return bl;
        }

        public String toString() {
            if (this.cachedToString == null) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Topic Mapping : ");
                stringBuffer.append("direction= " + this.direction);
                stringBuffer.append(", topic= " + this.topic);
                if (this.topic == null || this.topic.equals("")) {
                    stringBuffer.append("(NOT VALID)");
                }
                stringBuffer.append(", topicSpace= " + this.topicSpace);
                if (this.topicSpace == null || this.topicSpace.equals("")) {
                    stringBuffer.append("(NOT VALID)");
                }
                if (this.direction == 0 || this.direction == 2) {
                    stringBuffer.append(", subscriptionPoint= " + this.subscriptionPoint);
                }
                if (this.direction == 0 || this.direction == 1) {
                    stringBuffer.append(", brokerStreamQ= " + this.brokerStreamQ);
                    if (this.brokerStreamQ == null || this.brokerStreamQ.equals("")) {
                        stringBuffer.append("(NOT VALID)");
                    }
                }
                this.cachedToString = stringBuffer.toString();
            }
            return this.cachedToString;
        }
    }
}

