/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.linkedlist;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.utils.linkedlist.Cursor;
import com.ibm.ws.sib.processor.utils.linkedlist.LinkedList;
import com.ibm.ws.sib.utils.ras.SibTr;

public class Entry {
    protected LinkedList parentList = null;
    protected Entry previous = null;
    protected Entry next = null;
    protected Cursor firstCursor = null;
    private static final TraceComponent tc = SibTr.register((Class)Entry.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;

    public Entry getPrevious() {
        this.checkEntryParent();
        Entry entry = null;
        if (!this.isFirst()) {
            entry = this.previous;
        }
        return entry;
    }

    public Entry getNext() {
        Entry entry = null;
        if (!this.isLast()) {
            entry = this.next;
        }
        return entry;
    }

    Entry forceInsertAfter(Entry entry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceInsertAfter", (Object)new Object[]{entry});
        }
        this.checkEntryParent();
        if (entry.parentList == null) {
            Entry entry2 = this.getNext();
            entry.previous = this;
            entry.next = entry2;
            entry.parentList = this.parentList;
            if (entry2 != null) {
                entry2.previous = entry;
            }
            this.next = entry;
            if (this.isLast()) {
                this.parentList.last = entry;
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"forceInsertAfter", (Object)entry);
            }
            return entry;
        }
        SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Entry", "1:164:1.17"}, null));
        FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Entry.forceInsertAfter", (String)"1:170:1.17", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
        SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Entry", "1:177:1.17"});
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceInsertAfter", (Object)((Object)sIErrorException));
        }
        throw sIErrorException;
    }

    Entry forceRemove() {
        Entry entry;
        Entry entry2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceRemove");
        }
        this.checkEntryParent();
        Entry entry3 = null;
        if (this.firstCursor != null) {
            entry2 = this.firstCursor;
            while (entry2 != null) {
                ((Cursor)entry2).previous();
                entry2 = this.firstCursor;
            }
        }
        if ((entry2 = this.getPrevious()) != null) {
            entry2.next = this.next;
        }
        if ((entry = this.getNext()) != null) {
            entry.previous = entry2;
        }
        if (this.isFirst()) {
            this.parentList.first = entry;
        }
        if (this.isLast()) {
            this.parentList.last = entry2;
        }
        this.next = null;
        this.previous = null;
        this.parentList = null;
        entry3 = this;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceRemove", (Object)entry3);
        }
        return entry3;
    }

    void checkEntryParent() {
        if (this.parentList == null) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Entry", "1:261:1.17"}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Entry.checkEntryParent", (String)"1:268:1.17", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Entry", "1:275:1.17"});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkEntryParent", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
    }

    boolean isFirst() {
        return this.parentList.first == this;
    }

    boolean isLast() {
        return this.parentList.last == this;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.parentList == null) {
            stringBuffer.append("Entry not in list");
        } else {
            stringBuffer.append(string);
            stringBuffer.append(super.toString());
            Cursor cursor = this.firstCursor;
            while (cursor != null) {
                stringBuffer.append("\n");
                stringBuffer.append(string);
                stringBuffer.append("\\-->");
                stringBuffer.append(cursor);
                cursor = (Cursor)cursor.next;
            }
        }
        return stringBuffer.toString();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/utils/linkedlist/Entry.java, SIB.processor, WAS602.SIB, o0610.11 1.17");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

