/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.linkedlist;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.utils.linkedlist.Entry;
import com.ibm.ws.sib.processor.utils.linkedlist.LinkedList;
import com.ibm.ws.sib.utils.ras.SibTr;

public class Cursor
extends Entry {
    private static final TraceComponent tc = SibTr.register((Class)Cursor.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    protected Entry current = null;
    protected String name = "Cursor";
    protected boolean atTop = false;
    protected boolean atBottom = false;

    Cursor(String string, LinkedList linkedList, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Cursor", (Object)new Object[]{string, linkedList, new Boolean(bl)});
        }
        this.name = string;
        this.parentList = linkedList;
        this.current = null;
        this.atTop = bl;
        boolean bl2 = this.atBottom = !bl;
        if (bl) {
            Cursor cursor = linkedList.firstTopCursor;
            if (cursor != null) {
                cursor.previous = this;
                this.next = cursor;
            }
            linkedList.firstTopCursor = this;
        } else {
            Cursor cursor = linkedList.firstBottomCursor;
            if (cursor != null) {
                cursor.previous = this;
                this.next = cursor;
            }
            linkedList.firstBottomCursor = this;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Cursor", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry next() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"next");
        }
        this.checkEntryParent();
        Entry entry = null;
        LinkedList linkedList = this.parentList;
        synchronized (linkedList) {
            entry = this.getNextEntry();
            if (entry == null) {
                if (this.current == this.parentList.last) {
                    this.moveToBottom();
                } else if (!this.atBottom) {
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"Cursor", "1:160:1.15"}, null));
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Cursor.next", (String)"1:166:1.15", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"next", (Object)((Object)sIErrorException));
                    }
                    throw sIErrorException;
                }
            } else {
                this.moveCursor(entry);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"next", (Object)entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry previous() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"previous");
        }
        this.checkEntryParent();
        Entry entry = null;
        LinkedList linkedList = this.parentList;
        synchronized (linkedList) {
            entry = this.getPreviousEntry();
            if (entry == null) {
                if (this.current == this.parentList.first) {
                    this.moveToTop();
                } else if (!this.atTop) {
                    SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Cursor", "1:228:1.15"}, null));
                    FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Cursor.previous", (String)"1:234:1.15", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"previous", (Object)((Object)sIErrorException));
                    }
                    throw sIErrorException;
                }
            } else {
                this.moveCursor(entry);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"previous", (Object)entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry getPreviousEntry() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPreviousEntry");
        }
        this.checkEntryParent();
        Entry entry = null;
        LinkedList linkedList = this.parentList;
        synchronized (linkedList) {
            if (this.atBottom) {
                entry = this.parentList.last;
            } else if (!this.atTop) {
                entry = this.current.getPrevious();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPreviousEntry", (Object)entry);
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Entry getNextEntry() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNextEntry");
        }
        this.checkEntryParent();
        Entry entry = null;
        LinkedList linkedList = this.parentList;
        synchronized (linkedList) {
            if (this.atTop) {
                entry = this.parentList.first;
            } else if (!this.atBottom) {
                entry = this.current.getNext();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNextEntry", (Object)entry);
        }
        return entry;
    }

    public synchronized Entry current() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"current");
        }
        this.checkEntryParent();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"current", (Object)this.current);
        }
        return this.current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveToTop() {
        LinkedList linkedList;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveToTop");
        }
        this.checkEntryParent();
        LinkedList linkedList2 = linkedList = this.parentList;
        synchronized (linkedList2) {
            this.forceRemove();
            this.parentList = linkedList;
            this.atTop = true;
            this.next = linkedList.firstTopCursor;
            if (this.next != null) {
                this.next.previous = this;
            }
            linkedList.firstTopCursor = this;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveToTop");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveToBottom() {
        LinkedList linkedList;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveToBottom");
        }
        this.checkEntryParent();
        LinkedList linkedList2 = linkedList = this.parentList;
        synchronized (linkedList2) {
            this.forceRemove();
            this.parentList = linkedList;
            this.atBottom = true;
            this.next = linkedList.firstBottomCursor;
            if (this.next != null) {
                this.next.previous = this;
            }
            linkedList.firstBottomCursor = this;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveToBottom");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveCursor(Entry entry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveCursor", (Object)new Object[]{entry});
        }
        this.checkEntryParent();
        if (entry != this.current) {
            if (entry != null && entry.parentList == this.parentList) {
                LinkedList linkedList;
                LinkedList linkedList2 = linkedList = this.parentList;
                synchronized (linkedList2) {
                    this.forceRemove();
                    this.next = entry.firstCursor;
                    if (this.next != null) {
                        this.next.previous = this;
                    }
                    entry.firstCursor = this;
                    this.previous = null;
                    this.parentList = linkedList;
                    this.current = entry;
                }
            } else {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Cursor", "1:457:1.15"}, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Cursor.moveCursor", (String)"1:463:1.15", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"moveCursor", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveCursor");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void moveCursor(Cursor cursor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveCursor", (Object)new Object[]{cursor});
        }
        this.checkEntryParent();
        LinkedList linkedList = this.parentList;
        synchronized (linkedList) {
            if (cursor != null && cursor.parentList == this.parentList) {
                if (cursor.current != this.current) {
                    if (cursor.atTop) {
                        this.moveToTop();
                    } else if (cursor.atBottom) {
                        this.moveToBottom();
                    } else {
                        this.moveCursor(cursor.current);
                    }
                } else if (cursor.current == null) {
                    if (cursor.atTop && this.atBottom) {
                        this.moveToTop();
                    } else if (cursor.atBottom && this.atTop) {
                        this.moveToBottom();
                    }
                }
            } else {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.utils.linkedlist.Cursor", "1:541:1.15"}, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.utils.linkedlist.Cursor.moveCursor", (String)"1:547:1.15", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"moveCursor", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveCursor");
        }
    }

    Entry forceRemove() {
        Entry entry = null;
        this.checkEntryParent();
        if (this.atTop) {
            if (this.parentList.firstTopCursor == this) {
                this.parentList.firstTopCursor = (Cursor)this.next;
            }
            this.atTop = false;
        } else if (this.atBottom) {
            if (this.parentList.firstBottomCursor == this) {
                this.parentList.firstBottomCursor = (Cursor)this.next;
            }
            this.atBottom = false;
        } else {
            if (this.current.firstCursor == this) {
                this.current.firstCursor = (Cursor)this.next;
            }
            this.current = null;
        }
        entry = super.forceRemove();
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void finished() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"finished");
        }
        this.checkEntryParent();
        LinkedList linkedList = this.parentList;
        synchronized (linkedList) {
            this.forceRemove();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"finished");
        }
    }

    synchronized void checkEntryParent() {
        super.checkEntryParent();
    }

    public String toString() {
        return "Cursor(" + this.name + ")";
    }

    public synchronized boolean isAtBottom() {
        return this.atBottom;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/utils/linkedlist/Cursor.java, SIB.processor, WAS602.SIB, o0610.11 1.15");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

