/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.index;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.utils.index.FilteredIndexIterator;
import com.ibm.ws.sib.processor.utils.index.IndexFilter;
import com.ibm.ws.sib.processor.utils.linkedlist.Cursor;
import com.ibm.ws.sib.processor.utils.linkedlist.LinkedList;
import com.ibm.ws.sib.processor.utils.linkedlist.SimpleLinkedListEntry;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;

public class Index {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)Index.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected LinkedList list;
    protected HashMap index;

    public Index() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Index");
        }
        this.list = new LinkedList();
        this.index = new HashMap(10);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Index", (Object)this);
        }
    }

    public synchronized Entry put(Object object, Object object2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{object2});
        }
        Entry entry = this.put(object, object2, new Type());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)entry);
        }
        return entry;
    }

    protected synchronized Entry put(Object object, Object object2, Type type) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{object2, type});
        }
        Entry entry = new Entry(object, object2, type);
        this.add(entry);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)entry);
        }
        return entry;
    }

    public synchronized Entry add(Entry entry) {
        Entry entry2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"add", (Object)new Object[]{entry});
        }
        if ((entry2 = (Entry)this.index.get(entry.key)) != null) {
            this.list.remove(entry2);
        }
        this.list.insertAtBottom(entry);
        this.index.put(entry.key, entry);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"add", (Object)entry);
        }
        return entry;
    }

    public synchronized Object remove(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{object});
        }
        Object object2 = null;
        Entry entry = (Entry)this.index.remove(object);
        if (entry != null) {
            this.list.remove(entry);
            object2 = entry.data;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove", object2);
        }
        return object2;
    }

    public synchronized boolean containsKey(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"containsKey", (Object)new Object[]{object});
        }
        boolean bl = this.index.containsKey(object);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"containsKey", (Object)new Boolean(bl));
        }
        return bl;
    }

    public synchronized Object get(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"get", (Object)new Object[]{object});
        }
        Object object2 = this.get(object, null);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"get", (Object)object2);
        }
        return object2;
    }

    public synchronized Object get(Object object, IndexFilter indexFilter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"get", (Object)new Object[]{object, indexFilter});
        }
        Object object2 = null;
        Entry entry = (Entry)this.index.get(object);
        if (entry != null && (indexFilter == null || indexFilter.matches(entry.type))) {
            object2 = entry.data;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"get", (Object)object2);
        }
        return object2;
    }

    public synchronized Type getType(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getType", (Object)new Object[]{object});
        }
        Entry entry = (Entry)this.index.get(object);
        Type type = null;
        if (entry != null) {
            type = entry.type;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getType", (Object)type);
        }
        return type;
    }

    public synchronized void setType(Object object, Type type) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setType", (Object)new Object[]{object, type});
        }
        Entry entry = (Entry)this.index.get(object);
        entry.type = (Type)type.clone();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setType");
        }
    }

    public synchronized Cursor newCursor() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newCursor");
        }
        Cursor cursor = this.list.newCursor("Index Cursor");
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"newCursor", (Object)cursor);
        }
        return cursor;
    }

    public synchronized SIMPIterator iterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"iterator");
        }
        FilteredIndexIterator filteredIndexIterator = new FilteredIndexIterator(this, null);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"iterator", (Object)filteredIndexIterator);
        }
        return filteredIndexIterator;
    }

    public synchronized SIMPIterator iterator(IndexFilter indexFilter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"iterator", (Object)indexFilter);
        }
        FilteredIndexIterator filteredIndexIterator = new FilteredIndexIterator(this, indexFilter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"iterator", (Object)filteredIndexIterator);
        }
        return filteredIndexIterator;
    }

    protected synchronized void remove(Entry entry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{entry});
        }
        this.list.remove(entry);
        this.index.remove(entry.key);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public synchronized int size() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"size");
        }
        int n = this.index.size();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"size", (Object)new Integer(n));
        }
        return n;
    }

    public synchronized boolean isEmpty() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isEmpty");
        }
        boolean bl = this.index.isEmpty();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isEmpty", (Object)new Boolean(bl));
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/utils/index/Index.java, SIB.processor, WAS602.SIB, o0610.11 1.14");
        }
    }

    public static class Entry
    extends SimpleLinkedListEntry {
        public Object key;
        public Type type;

        protected Entry(Object object, Object object2, Type type) {
            super(object2);
            this.key = object;
            this.type = type;
        }
    }

    public static class Type
    implements Cloneable {
        public Object clone() {
            Object object = null;
            try {
                object = super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                FFDCFilter.processException((Throwable)cloneNotSupportedException, (String)"com.ibm.ws.sib.processor.utils.index.Type.clone", (String)"1:83:1.14", (Object)this);
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.index.Index", "1:89:1.14"});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.utils.LockManager", "1:96:1.14", cloneNotSupportedException}, null), (Throwable)cloneNotSupportedException);
            }
            return object;
        }
    }
}

