/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils.index;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.processor.utils.index.IndexFilter;
import com.ibm.ws.sib.processor.utils.linkedlist.Cursor;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.NoSuchElementException;

public class FilteredIndexIterator
implements SIMPIterator {
    private static final TraceComponent tc = SibTr.register((Class)FilteredIndexIterator.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Index index;
    private Cursor cursor;
    private IndexFilter filter;
    private Index.Entry next;
    private Index.Entry removable;

    public FilteredIndexIterator(Index index) {
        this(index, null);
    }

    public FilteredIndexIterator(Index index, IndexFilter indexFilter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"FilteredIndexIterator", (Object)new Object[]{index, indexFilter});
        }
        this.index = index;
        this.cursor = index.newCursor();
        this.filter = indexFilter;
        this.next = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"FilteredIndexIterator", (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean hasNext() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasNext");
        }
        if (this.next == null) {
            Index index = this.index;
            synchronized (index) {
                this.next = (Index.Entry)this.cursor.next();
                if (this.filter != null) {
                    while (this.next != null && !this.filter.matches(this.next.type)) {
                        this.next = (Index.Entry)this.cursor.next();
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasNext", (Object)new Boolean(this.next != null));
        }
        return this.next != null;
    }

    public synchronized Object next() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"next");
        }
        Object object = null;
        if (!this.hasNext()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"next", (Object)"NoSuchElementException");
            }
            throw new NoSuchElementException(nls.getFormattedMessage("NO_ELEMENTS_ERROR_CWSIP0601", null, null));
        }
        object = this.next.data;
        this.removable = this.next;
        this.next = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"next", (Object)object);
        }
        return object;
    }

    public synchronized void remove() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove");
        }
        if (this.removable == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"remove", (Object)"IllegalStateException");
            }
            throw new IllegalStateException(nls.getFormattedMessage("NO_ELEMENTS_ERROR_CWSIP0602", null, null));
        }
        this.index.remove(this.removable);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public void finished() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"finished");
        }
        this.cursor.finished();
        this.cursor = null;
        this.filter = null;
        this.index = null;
        this.next = null;
        this.removable = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"finished");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/utils/index/FilteredIndexIterator.java, SIB.processor, WAS602.SIB, o0610.11 1.9");
        }
    }
}

