/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.NoSuchElementException;

public class Queue {
    private volatile Object[] m_array;
    private volatile int m_head = 0;
    private volatile int m_tail = 0;
    private static final TraceComponent tc = SibTr.register((Class)Queue.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public Queue() {
        this.m_array = new Object[4];
    }

    public Queue(int n) {
        if (n < 1) {
            n = 3;
        }
        this.m_array = new Object[n + 1];
    }

    public final boolean isEmpty() {
        return this.m_head == this.m_tail;
    }

    public final void makeEmpty() {
        this.m_head = this.m_tail;
    }

    public final void makeEmptyAndClean() {
        this.makeEmpty();
        for (int i = 0; i < this.m_array.length; ++i) {
            this.m_array[i] = null;
        }
    }

    public final int size() {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"size");
        }
        int n2 = n = this.m_tail >= this.m_head ? this.m_tail - this.m_head : this.m_array.length - this.m_head + this.m_tail;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"size", (Object)new Integer(n));
        }
        return n;
    }

    public final void enqueue(Object object) {
        this.m_array[this.m_tail++] = object;
        if (this.m_tail == this.m_array.length) {
            this.m_tail = 0;
        }
        if (this.m_head == this.m_tail) {
            this.expand_array();
        }
    }

    public final Object dequeue() throws NoSuchElementException {
        if (this.m_head == this.m_tail) {
            throw new NoSuchElementException();
        }
        Object object = this.m_array[this.m_head];
        this.m_array[this.m_head++] = null;
        if (this.m_head == this.m_array.length) {
            this.m_head = 0;
        }
        return object;
    }

    public final Object peek() throws NoSuchElementException {
        if (this.m_head == this.m_tail) {
            throw new NoSuchElementException();
        }
        return this.m_array[this.m_head];
    }

    private final void expand_array() {
        int n = this.m_array.length;
        Object[] objectArray = new Object[n * 2];
        System.arraycopy(this.m_array, this.m_head, objectArray, this.m_head, n - this.m_head);
        System.arraycopy(this.m_array, 0, objectArray, n, this.m_tail);
        this.m_tail += n;
        this.m_array = objectArray;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/utils/Queue.java, SIB.processor, WAS602.SIB, o0610.11 1.17");
        }
    }
}

