/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.utils;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.IdentityHashMap;
import java.util.Iterator;

public final class AdvancedLockManager {
    private static final TraceComponent tc = SibTr.register((Class)AdvancedLockManager.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Object iMutex = new Object();
    private boolean iExclusivelyLocked = false;
    private int readLockCount = 0;
    private int readerThreadCount = 0;
    private int iExclusiveLockCount = 0;
    private Thread iExclusiveLockHolder = null;
    private IdentityHashMap readerThreads = new IdentityHashMap();

    public synchronized void lock() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"lock", (Object)this);
        }
        boolean bl = false;
        while (!this.tryLock()) {
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Waiting for lock");
                }
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLock() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"tryLock", (Object)this);
        }
        boolean bl = false;
        Object object = this.iMutex;
        synchronized (object) {
            if (!this.iExclusivelyLocked || this.iExclusiveLockHolder == Thread.currentThread()) {
                this.incrementThreadLockCount();
                bl = true;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"tryLock", (Object)new Boolean(bl));
        }
        return bl;
    }

    private void incrementThreadLockCount() {
        Thread thread;
        LockCount lockCount;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"incrementThreadLockCount", (Object)this);
        }
        if ((lockCount = (LockCount)this.readerThreads.get(thread = Thread.currentThread())) == null) {
            lockCount = new LockCount();
            this.readerThreads.put(thread, lockCount);
        }
        if (lockCount.count == 0) {
            ++this.readerThreadCount;
        }
        ++lockCount.count;
        ++this.readLockCount;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"incrementThreadLockCount");
        }
    }

    private void decrementThreadLockCount() {
        Thread thread;
        LockCount lockCount;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"decrementThreadLockCount", (Object)this);
        }
        if ((lockCount = (LockCount)this.readerThreads.get(thread = Thread.currentThread())) != null && lockCount.count > 0) {
            --lockCount.count;
            if (lockCount.count == 0) {
                --this.readerThreadCount;
            }
            --this.readLockCount;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"decrementThreadLockCount");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlock() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlock", (Object)this);
        }
        Object object = this.iMutex;
        synchronized (object) {
            if (this.readLockCount == 0) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"unlock", (Object)"SIErrorException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.utils.AdvancedLockManager", "1:237:1.3"});
                throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.utils.AdvancedLockManager", "1:244:1.3"}, null));
            }
            this.decrementThreadLockCount();
            if (this.readLockCount == 0) {
                this.notifyAll();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlock");
        }
    }

    public synchronized void lockExclusive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"lockExclusive", (Object)this);
        }
        boolean bl = false;
        while (!this.tryLockExclusive()) {
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"Waiting to get exclusive lock");
                }
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        while (this.alienReadLocksHeld()) {
            try {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Waiting for read lock thread count to reach 0 or 1(this thread) " + this.readerThreadCount));
                }
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
        }
        if (bl) {
            Thread.currentThread().interrupt();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"lockExclusive");
        }
    }

    private boolean alienReadLocksHeld() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alienReadLocksHeld", (Object)this);
        }
        boolean bl = false;
        if (this.readerThreadCount > 1) {
            bl = true;
        } else if (this.readerThreadCount == 1) {
            Thread thread = Thread.currentThread();
            LockCount lockCount = (LockCount)this.readerThreads.get(thread);
            boolean bl2 = bl = lockCount == null || lockCount.count == 0;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alienReadLocksHeld", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryLockExclusive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"tryLockExclusive", (Object)this);
        }
        boolean bl = false;
        Object object = this.iMutex;
        synchronized (object) {
            if (!this.iExclusivelyLocked) {
                this.iExclusivelyLocked = true;
                this.iExclusiveLockHolder = Thread.currentThread();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Got exclusive lock for thread " + this.iExclusiveLockHolder));
                }
                bl = true;
                ++this.iExclusiveLockCount;
            } else if (this.iExclusiveLockHolder == Thread.currentThread()) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Already hold exclusive lock " + (this.iExclusiveLockCount + 1)));
                }
                bl = true;
                ++this.iExclusiveLockCount;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"tryLockExclusive", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlockExclusive() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unlockExclusive", (Object)this);
        }
        Object object = this.iMutex;
        synchronized (object) {
            if (Thread.currentThread() == this.iExclusiveLockHolder) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Unlocking current thread " + (this.iExclusiveLockCount - 1)));
                }
                if (--this.iExclusiveLockCount == 0) {
                    this.iExclusivelyLocked = false;
                    this.iExclusiveLockHolder = null;
                    this.notifyAll();
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Thread not the current thread to unlock exclusively");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unlockExclusive");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Current thread: ");
        stringBuffer.append(Thread.currentThread());
        stringBuffer.append("\n");
        Object object = this.iMutex;
        synchronized (object) {
            stringBuffer.append("Exclusive Lock:\n");
            if (this.iExclusiveLockHolder != null) {
                stringBuffer.append(this.iExclusiveLockHolder);
                stringBuffer.append(" = ");
                stringBuffer.append(this.iExclusiveLockCount);
                stringBuffer.append("\n");
            }
            stringBuffer.append("Read Locks:\n");
            Iterator iterator = this.readerThreads.keySet().iterator();
            while (iterator.hasNext()) {
                Thread thread = (Thread)iterator.next();
                stringBuffer.append(thread);
                stringBuffer.append(" = ");
                stringBuffer.append(((LockCount)this.readerThreads.get((Object)thread)).count);
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }

    private static class LockCount {
        public int count = 0;

        private LockCount() {
        }
    }
}

