/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.stats;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItemReference;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream;
import com.ibm.ws.sib.processor.stats.SIMPInstrumentation;
import com.ibm.ws.sib.processor.stats.TopicspaceInstrumentation;
import com.ibm.ws.sib.processor.stats.WSSIBDurableSubscriptionStats;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;

public class DurableSubscriptionInstrumentation
extends SIMPInstrumentation
implements WSSIBDurableSubscriptionStats,
StatisticActionListener {
    static TraceComponent tc = SibTr.register((Class)DurableSubscriptionInstrumentation.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected StatsInstance stats;
    protected String statsName;
    protected SPICountStatistic messagesConsumedTotal;
    protected SPICountStatistic messagesConsumedBestEffort;
    protected SPICountStatistic messagesConsumedExpress;
    protected SPICountStatistic messagesConsumedReliableNonPersistent;
    protected SPICountStatistic messagesConsumedReliablePersistent;
    protected SPICountStatistic messagesConsumedAssured;
    protected SPITimeStatistic aggregateMessageWaitTime;
    protected SPITimeStatistic localMessageWaitTime;
    protected SPICountStatistic localOldestMessage;
    protected SPICountStatistic availableMessageCount;
    private ReferenceStream instrumentedSub;
    private BaseDestinationHandler topicspace;

    public DurableSubscriptionInstrumentation(BaseDestinationHandler baseDestinationHandler, ConsumerDispatcherState consumerDispatcherState, SubscriptionItemStream subscriptionItemStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DurableSubscriptionInstrumentation", (Object)new Object[]{baseDestinationHandler, consumerDispatcherState, subscriptionItemStream});
        }
        if (!StatsFactory.isPMIEnabled()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"DurableSubscriptionInstrumentation");
            }
            return;
        }
        this.instrumentedSub = subscriptionItemStream;
        this.topicspace = baseDestinationHandler;
        TopicspaceInstrumentation topicspaceInstrumentation = baseDestinationHandler.getTopicspaceStats();
        this.statsName = consumerDispatcherState.getSubscriberID();
        DurableSubscriptionInstrumentation durableSubscriptionInstrumentation = this;
        try {
            this.stats = StatsFactory.createStatsInstance((String)this.statsName, (StatsGroup)topicspaceInstrumentation.getDurableSubscriptionStatsGroup(), null, (StatisticActionListener)durableSubscriptionInstrumentation);
        }
        catch (StatsFactoryException statsFactoryException) {
            FFDCFilter.processException((Throwable)statsFactoryException, (String)"com.ibm.ws.sib.processor.stats.DurableSubscriptionInstrumentation.DurableSubscriptionInstrumentation", (String)"1:191:1.53", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)statsFactoryException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DurableSubscriptionInstrumentation", (Object)this);
        }
    }

    public void statisticCreated(SPIStatistic sPIStatistic) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"statisticCreated", (Object)sPIStatistic);
        }
        int n = sPIStatistic.getId();
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("id = " + n));
        }
        switch (n) {
            case 51: {
                this.messagesConsumedTotal = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 52: {
                this.messagesConsumedBestEffort = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 53: {
                this.messagesConsumedExpress = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 54: {
                this.messagesConsumedReliableNonPersistent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 55: {
                this.messagesConsumedReliablePersistent = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 56: {
                this.messagesConsumedAssured = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 57: {
                this.aggregateMessageWaitTime = (SPITimeStatistic)sPIStatistic;
                break;
            }
            case 58: {
                this.localMessageWaitTime = (SPITimeStatistic)sPIStatistic;
                break;
            }
            case 59: {
                this.localOldestMessage = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 60: {
                this.availableMessageCount = (SPICountStatistic)sPIStatistic;
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)"Invalid id specified!");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"statisticCreated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void updateStatisticOnRequest(int var1_1) {
        if (DurableSubscriptionInstrumentation.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)DurableSubscriptionInstrumentation.tc, (String)"updateStatisticOnRequest", (Object)new Integer(var1_1));
        }
        switch (var1_1) {
            case 59: {
                var2_2 = null;
                try {
                    var2_2 = (MessageItemReference)this.instrumentedSub.findOldestReference();
                }
                catch (MessageStoreException var3_4) {
                    FFDCFilter.processException((Throwable)var3_4, (String)"com.ibm.ws.sib.processor.stats.DurableSubscriptionInstrumentation.updateStatisticOnRequest", (String)"1:291:1.53", (Object)this);
                    if (!DurableSubscriptionInstrumentation.tc.isDebugEnabled()) ** GOTO lbl13
                    SibTr.debug((TraceComponent)DurableSubscriptionInstrumentation.tc, (String)("Couldn't retrieve oldest message : " + var3_4.toString()));
                }
lbl13:
                // 3 sources

                var3_5 = 0L;
                if (null != var2_2) {
                    var3_5 = var2_2.calculateWaitTimeUpdate(System.currentTimeMillis());
                }
                var5_6 = this.localOldestMessage;
                synchronized (var5_6) {
                    this.localOldestMessage.setCount(var3_5);
                }
                if (!DurableSubscriptionInstrumentation.tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)DurableSubscriptionInstrumentation.tc, (String)("OLDEST_MESSAGE: " + var3_5));
                SibTr.debug((TraceComponent)DurableSubscriptionInstrumentation.tc, (String)("Destination Name: " + this.topicspace.getName()));
                SibTr.debug((TraceComponent)DurableSubscriptionInstrumentation.tc, (String)("Destination UUID: " + this.topicspace.getUuid()));
                break;
            }
            case 60: {
                var2_3 = this.instrumentedSub.getStatistics().getAvailableItemCount();
                var4_8 = this.availableMessageCount;
                synchronized (var4_8) {
                    this.availableMessageCount.setCount(var2_3);
                }
                if (!DurableSubscriptionInstrumentation.tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)DurableSubscriptionInstrumentation.tc, (String)("AVAILABLE_MESSAGE_COUNT: " + var2_3));
                SibTr.debug((TraceComponent)DurableSubscriptionInstrumentation.tc, (String)("Destination Name: " + this.topicspace.getName()));
                SibTr.debug((TraceComponent)DurableSubscriptionInstrumentation.tc, (String)("Destination UUID: " + this.topicspace.getUuid()));
                break;
            }
            default: {
                if (!DurableSubscriptionInstrumentation.tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)DurableSubscriptionInstrumentation.tc, (String)("Invalid updateStatisticOnRequest id " + var1_1 + "specified!"));
            }
        }
        if (DurableSubscriptionInstrumentation.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)DurableSubscriptionInstrumentation.tc, (String)"updateStatisticOnRequest");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConsume(SIMPMessage sIMPMessage) {
        Reliability reliability;
        SPITimeStatistic sPITimeStatistic;
        long l;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"onConsume", (Object)sIMPMessage);
        }
        long l2 = -1L;
        if (null != this.localMessageWaitTime && this.localMessageWaitTime.isEnabled()) {
            l = sIMPMessage.getLatestWaitTimeUpdate();
            sPITimeStatistic = this.localMessageWaitTime;
            synchronized (sPITimeStatistic) {
                this.localMessageWaitTime.add(l);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("LOCAL_MESSAGE_WAIT_TIME: " + this.localMessageWaitTime.getMean()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.topicspace.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.topicspace.getUuid()));
            }
        }
        if (null != this.aggregateMessageWaitTime && this.aggregateMessageWaitTime.isEnabled()) {
            l = sIMPMessage.getAggregateWaitTime();
            sPITimeStatistic = this.aggregateMessageWaitTime;
            synchronized (sPITimeStatistic) {
                this.aggregateMessageWaitTime.add(l);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("AGGREGATE_MESSAGE_WAIT_TIME: " + this.aggregateMessageWaitTime.getMean()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.topicspace.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.topicspace.getUuid()));
            }
        }
        if (null != this.messagesConsumedTotal && this.messagesConsumedTotal.isEnabled()) {
            if (l2 < 0L) {
                l2 = System.currentTimeMillis();
            }
            SPICountStatistic sPICountStatistic = this.messagesConsumedTotal;
            synchronized (sPICountStatistic) {
                this.messagesConsumedTotal.increment(l2, 1L);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("MESSAGES_CONSUMED_TOTAL: " + this.messagesConsumedTotal.getCount()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.topicspace.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.topicspace.getUuid()));
            }
        }
        if (Reliability.BEST_EFFORT_NONPERSISTENT == (reliability = sIMPMessage.getReliability())) {
            if (null != this.messagesConsumedBestEffort && this.messagesConsumedBestEffort.isEnabled()) {
                if (l2 < 0L) {
                    l2 = System.currentTimeMillis();
                }
                SPICountStatistic sPICountStatistic = this.messagesConsumedBestEffort;
                synchronized (sPICountStatistic) {
                    this.messagesConsumedBestEffort.increment(l2, 1L);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_CONSUMED_BEST_EFFORT: " + this.messagesConsumedBestEffort.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.topicspace.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.topicspace.getUuid()));
                }
            }
        } else if (Reliability.EXPRESS_NONPERSISTENT == reliability) {
            if (null != this.messagesConsumedExpress && this.messagesConsumedExpress.isEnabled()) {
                if (l2 < 0L) {
                    l2 = System.currentTimeMillis();
                }
                SPICountStatistic sPICountStatistic = this.messagesConsumedExpress;
                synchronized (sPICountStatistic) {
                    this.messagesConsumedExpress.increment(l2, 1L);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_CONSUMED_EXPRESS: " + this.messagesConsumedExpress.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.topicspace.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.topicspace.getUuid()));
                }
            }
        } else if (Reliability.RELIABLE_NONPERSISTENT == reliability) {
            if (null != this.messagesConsumedReliableNonPersistent && this.messagesConsumedReliableNonPersistent.isEnabled()) {
                if (l2 < 0L) {
                    l2 = System.currentTimeMillis();
                }
                SPICountStatistic sPICountStatistic = this.messagesConsumedReliableNonPersistent;
                synchronized (sPICountStatistic) {
                    this.messagesConsumedReliableNonPersistent.increment(l2, 1L);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_CONSUMED_RELIABLE_NONPERSISTENT: " + this.messagesConsumedReliableNonPersistent.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.topicspace.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.topicspace.getUuid()));
                }
            }
        } else if (Reliability.RELIABLE_PERSISTENT == reliability) {
            if (null != this.messagesConsumedReliablePersistent && this.messagesConsumedReliablePersistent.isEnabled()) {
                if (l2 < 0L) {
                    l2 = System.currentTimeMillis();
                }
                SPICountStatistic sPICountStatistic = this.messagesConsumedReliablePersistent;
                synchronized (sPICountStatistic) {
                    this.messagesConsumedReliablePersistent.increment(l2, 1L);
                }
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("MESSAGES_CONSUMED_RELIABLE_PERSISTENT: " + this.messagesConsumedReliablePersistent.getCount()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.topicspace.getName()));
                    SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.topicspace.getUuid()));
                }
            }
        } else if (Reliability.ASSURED_PERSISTENT == reliability && null != this.messagesConsumedAssured && this.messagesConsumedAssured.isEnabled()) {
            if (l2 < 0L) {
                l2 = System.currentTimeMillis();
            }
            SPICountStatistic sPICountStatistic = this.messagesConsumedAssured;
            synchronized (sPICountStatistic) {
                this.messagesConsumedAssured.increment(l2, 1L);
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("MESSAGES_CONSUMED_ASSURED: " + this.messagesConsumedAssured.getCount()));
                SibTr.debug((TraceComponent)tc, (String)("Destination Name: " + this.topicspace.getName()));
                SibTr.debug((TraceComponent)tc, (String)("Destination UUID: " + this.topicspace.getUuid()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"onConsume");
        }
    }

    public void terminate() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"terminate");
        }
        DurableSubscriptionInstrumentation.terminate(this.stats);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"terminate");
        }
    }

    public SPIStatistic getStatistic(int n) {
        switch (n) {
            case 51: {
                return this.messagesConsumedTotal;
            }
            case 52: {
                return this.messagesConsumedBestEffort;
            }
            case 53: {
                return this.messagesConsumedExpress;
            }
            case 54: {
                return this.messagesConsumedReliableNonPersistent;
            }
            case 55: {
                return this.messagesConsumedReliablePersistent;
            }
            case 56: {
                return this.messagesConsumedAssured;
            }
            case 57: {
                return this.aggregateMessageWaitTime;
            }
            case 58: {
                return this.localMessageWaitTime;
            }
            case 59: {
                return this.localOldestMessage;
            }
            case 60: {
                return this.availableMessageCount;
            }
        }
        return null;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/stats/DurableSubscriptionInstrumentation.java, SIB.processor, WAS602.SIB, o0610.11 1.53");
        }
    }
}

