/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPIncorrectCallException;
import com.ibm.ws.sib.processor.exceptions.SIMPInvalidRuntimeIDException;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionIndex;
import com.ibm.ws.sib.processor.impl.indexes.SubscriptionTypeFilter;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.runtime.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.ControllableIterator;
import com.ibm.ws.sib.processor.runtime.MediatedMessageHandlerControl;
import com.ibm.ws.sib.processor.runtime.RemoteTopicSpaceControl;
import com.ibm.ws.sib.processor.runtime.RemoteTopicSpaceIterator;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLocalSubscriptionControllable;
import com.ibm.ws.sib.processor.runtime.SIMPLocalTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.anycast.AttachedRemoteSubscriberIterator;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIDestinationLockedException;
import com.ibm.wsspi.sib.core.exception.SIDurableSubscriptionNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Topicspace
extends MediatedMessageHandlerControl
implements SIMPTopicSpaceControllable {
    private static TraceComponent tc = SibTr.register((Class)Topicspace.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private SubscriptionIndex _subIndex;

    public Topicspace(MessageProcessor messageProcessor, BaseDestinationHandler baseDestinationHandler) {
        super(messageProcessor, baseDestinationHandler);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Topicspace");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Topicspace", (Object)this);
        }
    }

    public SIMPIterator getAttachedRemoteSubscriberIterator() throws SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAttachedRemoteSubscriberIterator");
        }
        this.assertMessageHandlerNotCorrupt();
        Collection collection = this.baseDest.getPseudoDurableAIHMap().values();
        AttachedRemoteSubscriberIterator attachedRemoteSubscriberIterator = new AttachedRemoteSubscriberIterator(collection);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAttachedRemoteSubscriberIterator", (Object)attachedRemoteSubscriberIterator);
        }
        return attachedRemoteSubscriberIterator;
    }

    private SubscriptionIndex getSubscriptionIndex() {
        if (this._subIndex == null) {
            this._subIndex = this.baseDest.getSubscriptionIndex();
        }
        return this._subIndex;
    }

    protected SIMPIterator getDurableSubscriptionIterator() throws SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDurableSubscriptionIterator");
        }
        this.assertMessageHandlerNotCorrupt();
        SubscriptionTypeFilter subscriptionTypeFilter = new SubscriptionTypeFilter();
        subscriptionTypeFilter.DURABLE = Boolean.TRUE;
        ControllableIterator controllableIterator = new ControllableIterator(this.getSubscriptionIndex().iterator(subscriptionTypeFilter));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDurableSubscriptionIterator", (Object)controllableIterator);
        }
        return controllableIterator;
    }

    public SIMPIterator getLocalSubscriptionIterator() throws SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptionIterator");
        }
        this.assertMessageHandlerNotCorrupt();
        SubscriptionTypeFilter subscriptionTypeFilter = new SubscriptionTypeFilter();
        subscriptionTypeFilter.LOCAL = Boolean.TRUE;
        ControllableIterator controllableIterator = new ControllableIterator(this.getSubscriptionIndex().iterator(subscriptionTypeFilter));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptionIterator", (Object)controllableIterator);
        }
        return controllableIterator;
    }

    protected SIMPIterator getInternalLocalSubscriptionIterator() throws SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getInternalLocalSubscriptionIterator");
        }
        this.assertMessageHandlerNotCorrupt();
        SubscriptionTypeFilter subscriptionTypeFilter = new SubscriptionTypeFilter();
        subscriptionTypeFilter.LOCAL = Boolean.TRUE;
        BasicSIMPIterator basicSIMPIterator = new BasicSIMPIterator(this.getSubscriptionIndex().iterator(subscriptionTypeFilter));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getInternalLocalSubscriptionIterator", (Object)basicSIMPIterator);
        }
        return basicSIMPIterator;
    }

    public SIMPLocalSubscriptionControllable getLocalSubscriptionControlByID(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptionControlByID", (Object)string);
        }
        this.assertMessageHandlerNotCorrupt();
        ControllableSubscription controllableSubscription = this.getSubscription(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptionControlByID", (Object)controllableSubscription.getControlAdapter());
        }
        return (SIMPLocalSubscriptionControllable)((Object)controllableSubscription.getControlAdapter());
    }

    private ControllableSubscription getSubscription(String string) throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscription", (Object)string);
        }
        SIBUuid12 sIBUuid12 = new SIBUuid12(string);
        SubscriptionTypeFilter subscriptionTypeFilter = new SubscriptionTypeFilter();
        subscriptionTypeFilter.LOCAL = Boolean.TRUE;
        ControllableSubscription controllableSubscription = this.getSubscriptionIndex().findByUuid(sIBUuid12, subscriptionTypeFilter);
        if (controllableSubscription == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptionControlByID", (Object)"SIMPControllableNotFoundException");
            }
            throw new SIMPControllableNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_NOT_FOUND_ERROR_CWSIP0271", new Object[]{string}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscription", (Object)controllableSubscription);
        }
        return controllableSubscription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteLocalSubscriptionControlByID(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException, SIDurableSubscriptionNotFoundException, SIDestinationLockedException, SIResourceException, SIIncorrectCallException {
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteLocalSubscriptionControlByID", (Object)string);
        }
        this.assertMessageHandlerNotCorrupt();
        ControllableSubscription controllableSubscription = this.getSubscription(string);
        if (!controllableSubscription.isDurable()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"deleteLocalSubscriptionControlByID", (Object)"SIMPIncorrectCallException");
            }
            throw new SIMPIncorrectCallException(nls.getFormattedMessage("SUBSCRIPTION_DELETE_ERROR_CWSIP0272", new Object[]{string}, null));
        }
        HashMap hashMap2 = hashMap = this.destinationManager.getDurableSubscriptionsTable();
        synchronized (hashMap2) {
            ConsumerDispatcher consumerDispatcher = (ConsumerDispatcher)hashMap.get(controllableSubscription.getConsumerDispatcherState().getSubscriberID());
            if (consumerDispatcher == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"deleteSubscription", (Object)"SIDestinationNotFoundException");
                }
                throw new SIMPControllableNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_DOESNT_EXIST_ERROR_CWSIP0146", new Object[]{controllableSubscription.getConsumerDispatcherState().getSubscriberID(), this.messageProcessor.getMessagingEngineName()}, null));
            }
            BaseDestinationHandler baseDestinationHandler = consumerDispatcher.getDestination();
            baseDestinationHandler.deleteDurableSubscription(controllableSubscription.getConsumerDispatcherState().getSubscriberID(), null, this.messageProcessor.getMessagingEngineName());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteLocalSubscriptionControlByID");
        }
    }

    public SIMPLocalTopicSpaceControllable getLocalTopicSpaceControl() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalTopicSpaceControl");
        }
        SIMPLocalTopicSpaceControllable sIMPLocalTopicSpaceControllable = null;
        PubSubMessageItemStream pubSubMessageItemStream = this.baseDest.getPublishPoint();
        if (pubSubMessageItemStream != null) {
            sIMPLocalTopicSpaceControllable = (SIMPLocalTopicSpaceControllable)((Object)pubSubMessageItemStream.getControlAdapter());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalTopicSpaceControl", (Object)sIMPLocalTopicSpaceControllable);
        }
        return sIMPLocalTopicSpaceControllable;
    }

    public SIMPIterator getRemoteTopicSpaceIterator() {
        RemoteTopicSpaceIterator.PublishConsumePairing publishConsumePairing;
        Object object;
        Object object2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteTopicSpaceIterator");
        }
        HashMap hashMap = this.baseDest.cloneAllPubSubOutputHandlers();
        Map map = this.baseDest.getPseudoDurableAIHMap();
        HashMap<Object, RemoteTopicSpaceIterator.PublishConsumePairing> hashMap2 = new HashMap<Object, RemoteTopicSpaceIterator.PublishConsumePairing>();
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            object2 = (PubSubOutputHandler)iterator.next();
            object = ((PubSubOutputHandler)object2).getTargetMEUuid();
            publishConsumePairing = new RemoteTopicSpaceIterator.PublishConsumePairing((PubSubOutputHandler)object2, null);
            hashMap2.put(object, publishConsumePairing);
        }
        object2 = map.values().iterator();
        while (object2.hasNext()) {
            object = (AnycastInputHandler)object2.next();
            publishConsumePairing = ((AnycastInputHandler)object).getLocalisationME().getUuid();
            Object v = hashMap2.get(publishConsumePairing);
            if (v != null) {
                ((RemoteTopicSpaceIterator.PublishConsumePairing)v).setAnycastInputHandler((AnycastInputHandler)object);
                continue;
            }
            RemoteTopicSpaceIterator.PublishConsumePairing publishConsumePairing2 = new RemoteTopicSpaceIterator.PublishConsumePairing(null, (AnycastInputHandler)object);
            hashMap2.put(publishConsumePairing, publishConsumePairing2);
        }
        object = new RemoteTopicSpaceIterator(hashMap2.values().iterator());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteTopicSpaceIterator", (Object)object);
        }
        return object;
    }

    public SIMPRemoteTopicSpaceControllable getRemoteTopicSpaceControlByID(String string) throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteTopicSpaceControlByID", (Object)string);
        }
        SIMPIterator sIMPIterator = this.getRemoteTopicSpaceIterator();
        RemoteTopicSpaceControl remoteTopicSpaceControl = null;
        while (sIMPIterator.hasNext()) {
            RemoteTopicSpaceControl remoteTopicSpaceControl2 = (RemoteTopicSpaceControl)sIMPIterator.next();
            if (!remoteTopicSpaceControl2.getId().equals(string)) continue;
            remoteTopicSpaceControl = remoteTopicSpaceControl2;
        }
        if (remoteTopicSpaceControl == null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRemoteTopicSpaceControlByID", (Object)"SIMPControllableNotFoundException");
            }
            throw new SIMPControllableNotFoundException(nls.getFormattedMessage("SUBSCRIPTION_NOT_FOUND_ERROR_CWSIP0271", new Object[]{string}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteTopicSpaceControlByID", remoteTopicSpaceControl);
        }
        return remoteTopicSpaceControl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/Topicspace.java, SIB.processor, WAS602.SIB, o0610.11 1.34");
        }
    }
}

