/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.msgstore.MessageStoreRuntimeException;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.SourceStream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryStreamTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SIMPDeliveryTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPTransmitMessageControllable;
import com.ibm.ws.sib.processor.runtime.TransmitMessage;
import com.ibm.ws.sib.processor.runtime.TransmitMessageControllableIterator;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;

public class SourceStreamControl
extends AbstractControlAdapter
implements SIMPDeliveryStreamTransmitControllable {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)SourceStreamControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private SourceStream _sourceStream;
    private StreamSet _sourceStreamSet;
    private String _remoteEngineUUID;

    public SourceStreamControl(String string, SourceStream sourceStream, StreamSet streamSet) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SourceStreamControl", (Object)new Object[]{string, sourceStream, streamSet});
        }
        this._sourceStream = sourceStream;
        this._sourceStreamSet = streamSet;
        this._remoteEngineUUID = string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SourceStreamControl", (Object)this);
        }
    }

    public Reliability getReliability() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReliability");
        }
        Reliability reliability = this._sourceStream.getReliability();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)reliability);
        }
        return reliability;
    }

    public int getPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPriority");
        }
        int n = this._sourceStream.getPriority();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPriority", (Object)new Integer(n));
        }
        return n;
    }

    public int getNumberOfActiveMessages() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfActiveMessages");
        }
        int n = (int)this._sourceStream.countAllMessagesOnStream();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfActiveMessages", (Object)new Integer(n));
        }
        return n;
    }

    public SIMPTransmitMessageControllable getTransmitMessageByID(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransmitMessageByID", (Object)string);
        }
        Iterator iterator = this._sourceStream.getAllMessageItemsOnStream(true).iterator();
        TransmitMessage transmitMessage = null;
        while (iterator.hasNext()) {
            MessageItem messageItem = (MessageItem)iterator.next();
            if (Long.parseLong(string) != messageItem.getID()) continue;
            transmitMessage = new TransmitMessage(messageItem, this._sourceStream);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransmitMessageByID", transmitMessage);
        }
        return transmitMessage;
    }

    public SIMPIterator getTransmitMessagesIterator() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransmitMessagesIterator");
        }
        Iterator iterator = this._sourceStream.getAllMessageItemsOnStream(true).iterator();
        LinkedList<TransmitMessage> linkedList = new LinkedList<TransmitMessage>();
        while (iterator.hasNext()) {
            object = (MessageItem)iterator.next();
            linkedList.add(new TransmitMessage((MessageItem)object, this._sourceStream));
        }
        object = new TransmitMessageControllableIterator(linkedList.iterator());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransmitMessagesIterator", (Object)object);
        }
        return object;
    }

    public SIMPDeliveryTransmitControllable.StreamState getStreamState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamState");
        }
        SourceStream.SourceStreamState sourceStreamState = this._sourceStream.getStreamState();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamState", (Object)sourceStreamState);
        }
        return sourceStreamState;
    }

    public SIBUuid12 getStreamID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStreamID");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStreamID", (Object)this._sourceStreamSet.getStreamID());
        }
        return this._sourceStreamSet.getStreamID();
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public String getName() {
        return null;
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String string = this._sourceStream.getID();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)string);
        }
        return string;
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._sourceStream == null || this._sourceStreamSet == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"SourceStreamControl.assertValidControllable", "1:249:1.31", this._sourceStreamSet}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._sourceStream = null;
        this._sourceStreamSet = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
    }

    public long getNumberOfMessagesSent() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfMessagesSent");
        }
        long l = this._sourceStream.getTotalMessagesSent();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfMessagesSent", (Object)new Long(l));
        }
        return l;
    }

    public String getRemoteEngineUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)this._remoteEngineUUID);
        }
        return this._remoteEngineUUID;
    }

    public void deleteMessage(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteMessage", (Object)string);
        }
        try {
            SIMPTransmitMessageControllable sIMPTransmitMessageControllable = this.getTransmitMessageByID(string);
            if (sIMPTransmitMessageControllable != null) {
                sIMPTransmitMessageControllable.removeMessage(true);
            }
        }
        catch (SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException) {
            FFDCFilter.processException((Throwable)sIMPRuntimeOperationFailedException, (String)"com.ibm.ws.sib.processor.runtime.SourceStreamControl.deleteMessage", (String)"1:325:1.31", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.SourceStreamControl.deleteMessage", "1:330:1.31", SIMPUtils.getStackTrace(sIMPRuntimeOperationFailedException)});
            SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
        }
        catch (SIMPControllableNotFoundException sIMPControllableNotFoundException) {
            FFDCFilter.processException((Throwable)sIMPControllableNotFoundException, (String)"com.ibm.ws.sib.processor.runtime.SourceStreamControl.deleteMessage", (String)"1:339:1.31", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.SourceStreamControl.deleteMessage", "1:344:1.31", SIMPUtils.getStackTrace(sIMPControllableNotFoundException)});
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
        }
        catch (MessageStoreRuntimeException messageStoreRuntimeException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreRuntimeException), (String)"com.ibm.ws.sib.processor.runtime.SourceStreamControl.deleteMessage", (String)"1:353:1.31", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.SourceStreamControl.deleteMessage", "1:358:1.31", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreRuntimeException))});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreRuntimeException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteMessage");
        }
    }

    public void moveMessage(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"moveMessage", (Object)string);
        }
        try {
            SIMPTransmitMessageControllable sIMPTransmitMessageControllable = this.getTransmitMessageByID(string);
            if (sIMPTransmitMessageControllable != null) {
                sIMPTransmitMessageControllable.removeMessage(false);
            }
        }
        catch (SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException) {
            FFDCFilter.processException((Throwable)sIMPRuntimeOperationFailedException, (String)"com.ibm.ws.sib.processor.runtime.SourceStreamControl.moveMessage", (String)"1:389:1.31", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.SourceStreamControl.moveMessage", "1:394:1.31", SIMPUtils.getStackTrace(sIMPRuntimeOperationFailedException)});
            SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
        }
        catch (SIMPControllableNotFoundException sIMPControllableNotFoundException) {
            FFDCFilter.processException((Throwable)sIMPControllableNotFoundException, (String)"com.ibm.ws.sib.processor.runtime.SourceStreamControl.moveMessage", (String)"1:403:1.31", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.SourceStreamControl.moveMessage", "1:408:1.31", SIMPUtils.getStackTrace(sIMPControllableNotFoundException)});
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
        }
        catch (MessageStoreRuntimeException messageStoreRuntimeException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreRuntimeException), (String)"com.ibm.ws.sib.processor.runtime.SourceStreamControl.moveMessage", (String)"1:417:1.31", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.SourceStreamControl.moveMessage", "1:422:1.31", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreRuntimeException))});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreRuntimeException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"moveMessage");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/SourceStreamControl.java, SIB.processor, WAS602.SIB, o0610.11 1.31");
        }
    }
}

