/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.JsAdminUtils;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.gd.InternalOutputStreamManager;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener;
import com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter;
import com.ibm.ws.sib.processor.runtime.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPPubSubOutboundTransmitControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.anycast.AttachedRemoteSubscriberIterator;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class RemoteTopicSpaceControl
extends AbstractRegisteredControlAdapter
implements SIMPRemoteTopicSpaceControllable {
    private static final TraceComponent tc = SibTr.register((Class)RemoteTopicSpaceControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private PubSubOutputHandler _outputHandler;
    private AnycastInputHandler _anycastInputHandler;
    private MessageProcessor _messageProcessor;

    public RemoteTopicSpaceControl(PubSubOutputHandler pubSubOutputHandler, AnycastInputHandler anycastInputHandler, MessageProcessor messageProcessor) {
        super(messageProcessor, ControllableType.REMOTE_PUBLICATION_POINT);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteTopicSpaceControl", (Object)new Object[]{pubSubOutputHandler, anycastInputHandler, messageProcessor});
        }
        this._messageProcessor = messageProcessor;
        this.setPubsubOutputHandler(pubSubOutputHandler);
        this.setAnycastInputHandler(anycastInputHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RemoteTopicSpaceControl", (Object)this);
        }
    }

    public void setAnycastInputHandler(AnycastInputHandler anycastInputHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAnycastInputHandler", (Object)anycastInputHandler);
            SibTr.exit((TraceComponent)tc, (String)"setAnycastInputHandler");
        }
        this._anycastInputHandler = anycastInputHandler;
    }

    public void setPubsubOutputHandler(PubSubOutputHandler pubSubOutputHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setPubsubOutputHandler", (Object)pubSubOutputHandler);
            SibTr.exit((TraceComponent)tc, (String)"setPubsubOutputHandler");
        }
        this._outputHandler = pubSubOutputHandler;
    }

    public SIMPTopicSpaceControllable getTopicSpace() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpace");
        }
        String string = this.getUuid();
        SIBUuid12 sIBUuid12 = new SIBUuid12(string);
        SIMPTopicSpaceControllable sIMPTopicSpaceControllable = (SIMPTopicSpaceControllable)((Object)this._messageProcessor.getDestinationManager().getDestinationInternal(sIBUuid12, false).getControlAdapter());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpace", (Object)sIMPTopicSpaceControllable);
        }
        return sIMPTopicSpaceControllable;
    }

    public SIMPIterator getPubSubOutboundTransmitIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubOutboundTransmitIterator");
        }
        BasicSIMPIterator basicSIMPIterator = null;
        if (this._outputHandler != null) {
            InternalOutputStreamManager internalOutputStreamManager = this._outputHandler.getInternalOutputStreamManager();
            basicSIMPIterator = new BasicSIMPIterator(internalOutputStreamManager.getStreamSetIterator());
        }
        if (basicSIMPIterator == null) {
            basicSIMPIterator = new BasicSIMPIterator(new ArrayList().iterator());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPubSubOutboundTransmitIterator", basicSIMPIterator);
        }
        return basicSIMPIterator;
    }

    public SIMPIterator getTopicNameIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicNameIterator");
        }
        BasicSIMPIterator basicSIMPIterator = null;
        if (this._outputHandler != null && this._outputHandler.getTopics() != null) {
            basicSIMPIterator = new BasicSIMPIterator(Arrays.asList(this._outputHandler.getTopics()).iterator());
        }
        if (basicSIMPIterator == null) {
            basicSIMPIterator = new BasicSIMPIterator(new ArrayList().iterator());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicNameIterator", basicSIMPIterator);
        }
        return basicSIMPIterator;
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String string = this.getUuid();
        string = string + this.getRemoteEngineUuid();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)string);
        }
        return string;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        String string = null;
        string = this._outputHandler != null ? this._outputHandler.getDestinationName() : this._anycastInputHandler.getDestName();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)string);
        }
        return string;
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._outputHandler == null && this._anycastInputHandler == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"RemoteTopicSpaceControl.assertValidControllable", "1:288:1.29"}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._outputHandler = null;
        this._messageProcessor = null;
        this._anycastInputHandler = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public synchronized void registerControlAdapterAsMBean() {
        super.registerControlAdapterAsMBean();
    }

    public void deregisterControlAdapterMBean() {
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
    }

    public String getMessagingEngineName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessagingEngineName");
        }
        String string = this.getRemoteEngineUuid();
        String string2 = JsAdminUtils.getMENameByUuid((String)string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessagingEngineName", (Object)string2);
        }
        return string2;
    }

    public String getUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUuid");
        }
        String string = null;
        string = this._outputHandler != null ? this._outputHandler.getTopicSpaceUuid().toString() : this._anycastInputHandler.getBaseDestinationHandler().getUuid().toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUuid", (Object)string);
        }
        return string;
    }

    public String getRemoteEngineUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String string = null;
        string = this._outputHandler != null ? this._outputHandler.getTargetMEUuid().toString() : this._anycastInputHandler.getLocalisationME().getUuid().toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)string);
        }
        return string;
    }

    public SIMPPubSubOutboundTransmitControllable getPubSubOutboundTransmitControllable() {
        SIMPIterator sIMPIterator;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubOutboundTransmitControllable");
        }
        SIMPPubSubOutboundTransmitControllable sIMPPubSubOutboundTransmitControllable = null;
        if (this._outputHandler != null && (sIMPIterator = this.getPubSubOutboundTransmitIterator()).hasNext()) {
            sIMPPubSubOutboundTransmitControllable = (SIMPPubSubOutboundTransmitControllable)sIMPIterator.next();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPubSubOutboundTransmitControllable", sIMPPubSubOutboundTransmitControllable);
        }
        return sIMPPubSubOutboundTransmitControllable;
    }

    public void clearTopics() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearTopics");
        }
        if (this._outputHandler != null) {
            if (this._outputHandler.getTopics() != null) {
                Iterator<String> iterator = Arrays.asList(this._outputHandler.getTopics()).iterator();
                LinkedList<String> linkedList = new LinkedList<String>();
                LinkedList<String> linkedList2 = new LinkedList<String>();
                for (int i = 0; i < this._outputHandler.getTopics().length; ++i) {
                    linkedList.add(this._outputHandler.getTopicSpaceUuid().toString());
                    linkedList2.add(this._outputHandler.getTopicSpaceMapping());
                }
                NeighbourProxyListener neighbourProxyListener = this._messageProcessor.getProxyHandler().getProxyListener();
                try {
                    ExternalAutoCommitTransaction externalAutoCommitTransaction = this._messageProcessor.getTXManager().createAutoCommitTransaction();
                    neighbourProxyListener.deleteProxySubscription(iterator, linkedList.iterator(), linkedList2.iterator(), this._outputHandler.getTargetMEUuid(), this._outputHandler.getBusName(), externalAutoCommitTransaction);
                }
                catch (SIResourceException sIResourceException) {
                    FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.runtime.RemoteTopicSpaceControl.clearTopics", (String)"1:470:1.29", (Object)this);
                    SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.RemoteTopicSpaceControl.clearTopics", "1:475:1.29", SIMPUtils.getStackTrace(sIResourceException)});
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                }
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("No Topics to delete for topicspace with id " + this._outputHandler.getDestinationName()));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clearTopics");
        }
    }

    public SIMPIterator getRemoteSubscriptions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteSubscriptions");
        }
        LinkedList<AnycastInputHandler> linkedList = new LinkedList<AnycastInputHandler>();
        if (this._anycastInputHandler != null) {
            linkedList.add(this._anycastInputHandler);
        }
        AttachedRemoteSubscriberIterator attachedRemoteSubscriberIterator = new AttachedRemoteSubscriberIterator(linkedList);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteSubscriptions", (Object)attachedRemoteSubscriberIterator);
        }
        return attachedRemoteSubscriberIterator;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/RemoteTopicSpaceControl.java, SIB.processor, WAS602.SIB, o0610.11 1.29");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

