/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.gd.AIRequestedTick;
import com.ibm.ws.sib.processor.gd.AIStream;
import com.ibm.ws.sib.processor.gd.AIValueTick;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.store.itemstreams.AIProtocolItemStream;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteMessageRequestControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRequestMessageInfo;
import com.ibm.ws.sib.processor.runtime.SIMPRequestedValueMessageInfo;
import com.ibm.ws.sib.processor.runtime.anycast.RequestMessageInfo;
import com.ibm.ws.sib.processor.runtime.anycast.RequestedValueMessageInfo;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;

public class RemoteMessageRequest
extends AbstractControlAdapter
implements SIMPRemoteMessageRequestControllable {
    private long _tick;
    private AIStream _aiStream;
    private AIProtocolItemStream _aiProtocolItemStream;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)RemoteMessageRequest.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public RemoteMessageRequest(long l, AIStream aIStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteMessageRequest", (Object)new Object[]{new Long(l), aIStream});
        }
        this._tick = l;
        this._aiStream = aIStream;
        this._aiProtocolItemStream = aIStream.getAIProtocolItemStream();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"RemoteMessageRequest", (Object)this);
        }
    }

    private TickRange getTickRange() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTickRange");
        }
        TickRange tickRange = this._aiStream.getTickRange(this._tick);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTickRange", (Object)tickRange);
        }
        return tickRange;
    }

    public JsMessage getJsMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJsMessage");
        }
        InvalidOperationException invalidOperationException = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"RemoteMessageRequest.getJsMessage", "1:137:1.24", this}, null));
        SibTr.exception((TraceComponent)tc, (Exception)((Object)invalidOperationException));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJsMessage");
        }
        throw invalidOperationException;
    }

    public String getState() throws SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        String string = this.getState(this.getTickRange());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)string);
        }
        return string;
    }

    private String getState(TickRange tickRange) throws SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState", (Object)tickRange);
        }
        String string = null;
        byte by = tickRange.type;
        switch (by) {
            case 1: {
                string = SIMPRemoteMessageRequestControllable.State.REQUEST.toString();
                break;
            }
            case 5: {
                string = SIMPRemoteMessageRequestControllable.State.ACKNOWLEDGED.toString();
                break;
            }
            case 6: {
                string = SIMPRemoteMessageRequestControllable.State.REJECT.toString();
                break;
            }
            case 3: {
                string = SIMPRemoteMessageRequestControllable.State.VALUE.toString();
                break;
            }
            case 7: {
                string = SIMPRemoteMessageRequestControllable.State.COMPLETED.toString();
            }
        }
        if (string == null) {
            SIMPException sIMPException = new SIMPException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"RemoteMessageRequest.getState", "1:209:1.24", this}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getState");
            }
            throw sIMPException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)string);
        }
        return string;
    }

    public long getStartTick() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStartTick");
        }
        long l = this.getTickRange().startstamp;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStartTick", (Object)new Long(l));
        }
        return l;
    }

    public long getEndTick() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEndTick");
        }
        long l = this.getTickRange().endstamp;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEndTick", (Object)new Long(l));
        }
        return l;
    }

    public void removeMessage(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMessage", (Object)new Boolean(bl));
        }
        InvalidOperationException invalidOperationException = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"RemoteMessageRequest.removeMessage", "1:269:1.24", this}, null));
        SibTr.exception((TraceComponent)tc, (Exception)((Object)invalidOperationException));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)((Object)invalidOperationException));
        }
        throw invalidOperationException;
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)("" + this.getTick()));
        }
        return "" + this.getTick();
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"No implementation");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", null);
        }
        return null;
    }

    public void formatState(PrintStream printStream, boolean bl) {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"formatState", (Object)"No implementation");
        }
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.getTick() == -1L) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"RemoteMessageRequest.assertValidControllable", "1:331:1.24", new Long(this.getTick())}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"dereferenceControllable", (Object)"No implementation");
        }
    }

    public void registerControlAdapterAsMBean() {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"registerControlAdapterAsMBean", (Object)"No implementation");
        }
    }

    public void deregisterControlAdapterMBean() {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"deregisterControlAdapterMBean", (Object)"No implementation");
        }
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"runtimeEventOccurred", (Object)"No implementation");
        }
    }

    public String getTransactionId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionId");
        }
        String string = null;
        PersistentTranId persistentTranId = this._aiProtocolItemStream.getTransactionId();
        if (persistentTranId != null) {
            string = persistentTranId.toString();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransactionId", (Object)string);
        }
        return string;
    }

    public SIMPRequestMessageInfo getRequestMessageInfo() throws SIMPRuntimeOperationFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRequestMessageInfo");
        }
        RequestMessageInfo requestMessageInfo = null;
        try {
            if (this.getState() == SIMPRemoteMessageRequestControllable.State.REQUEST.toString()) {
                TickRange tickRange = this._aiStream.getTickRange(this._tick);
                requestMessageInfo = new RequestMessageInfo((AIRequestedTick)tickRange.value);
            }
        }
        catch (SIMPException sIMPException) {
            FFDCFilter.processException((Throwable)sIMPException, (String)"com.ibm.ws.sib.processor.runtime.RemoteMessageRequest.getRequestMessageInfo", (String)"1:426:1.24", (Object)this);
            SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"RemoteMessageRequest.getRequestMessageInfo", "1:434:1.24", sIMPException, this._aiStream.getStreamId()}, null), sIMPException);
            SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRequestMessageInfo", (Object)sIMPRuntimeOperationFailedException);
            }
            throw sIMPRuntimeOperationFailedException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRequestMessageInfo", requestMessageInfo);
        }
        return requestMessageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIMPRequestedValueMessageInfo getRequestedValueMessageInfo() throws SIMPRuntimeOperationFailedException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRequestedValueMessageInfo");
        }
        RequestedValueMessageInfo requestedValueMessageInfo = null;
        try {
            TickRange tickRange;
            TickRange tickRange2 = tickRange = this.getTickRange();
            synchronized (tickRange2) {
                if (this.getState(tickRange) == SIMPRemoteMessageRequestControllable.State.VALUE.toString()) {
                    requestedValueMessageInfo = new RequestedValueMessageInfo((AIValueTick)tickRange.value);
                }
            }
        }
        catch (SIMPException sIMPException) {
            FFDCFilter.processException((Throwable)sIMPException, (String)"com.ibm.ws.sib.processor.runtime.RemoteMessageRequest.getRequestedValueMessageInfo", (String)"1:475:1.24", (Object)this);
            SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"RemoteMessageRequest.getRequestedValueMessageInfo", "1:483:1.24", sIMPException, this._aiStream.getStreamId()}, null), sIMPException);
            SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRequestedValueMessageInfo", (Object)sIMPRuntimeOperationFailedException);
            }
            throw sIMPRuntimeOperationFailedException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRequestedValueMessageInfo", (Object)requestedValueMessageInfo);
        }
        return requestedValueMessageInfo;
    }

    public long getTick() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTick");
            SibTr.exit((TraceComponent)tc, (String)"getTick", (Object)new Long(this._tick));
        }
        return this._tick;
    }

    public String getRemoteEngineUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteEngineUuid");
        }
        String string = this._aiStream.getAnycastInputHandler().getLocalisationME().toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteEngineUuid", (Object)string);
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/RemoteMessageRequest.java, SIB.processor, WAS602.SIB, o0610.11 1.24");
        }
    }
}

