/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.PersistentTranId;
import com.ibm.ws.sib.processor.UndeliverableReturnCode;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPRuntimeOperationFailedException;
import com.ibm.ws.sib.processor.impl.ExceptionDestinationHandlerImpl;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.SIMPReceivedMessageControllable;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SIBusMessage;
import java.io.PrintStream;

public class ReceivedMessage
extends AbstractControlAdapter
implements SIMPReceivedMessageControllable {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)ReceivedMessage.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    MessageItem msgItem;
    MessageProcessor messageProcessor;
    DestinationHandler destinationHandler;

    public ReceivedMessage(MessageItem messageItem, MessageProcessor messageProcessor, DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ReceivedMessage", (Object)new Object[]{messageItem, messageProcessor, destinationHandler});
        }
        this.msgItem = messageItem;
        this.messageProcessor = messageProcessor;
        this.destinationHandler = destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ReceivedMessage", (Object)this);
        }
    }

    public JsMessage getJsMessage() throws SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getJsMessage");
        }
        this.assertValidControllable();
        JsMessage jsMessage = this.msgItem.getMessage();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getJsMessage");
        }
        return jsMessage;
    }

    public String getState() throws SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        this.assertValidControllable();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)"Awaiting Delivery");
        }
        return "Awaiting Delivery";
    }

    public String getTransactionId() throws SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTransactionId");
        }
        this.assertValidControllable();
        String string = null;
        PersistentTranId persistentTranId = this.msgItem.getTransactionId();
        if (persistentTranId != null) {
            string = persistentTranId.toString();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTransactionId", (Object)string);
        }
        return string;
    }

    public void removeMessage(boolean bl) throws SIMPControllableNotFoundException, SIMPRuntimeOperationFailedException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeMessage", (Object)new Object[]{new Boolean(bl)});
        }
        this.assertValidControllable();
        ExternalLocalTransaction externalLocalTransaction = this.messageProcessor.getTXManager().createLocalTransaction();
        if (!bl) {
            this.msgItem.setForcePut(true);
            ExceptionDestinationHandlerImpl exceptionDestinationHandlerImpl = new ExceptionDestinationHandlerImpl(this.destinationHandler);
            object = exceptionDestinationHandlerImpl.handleUndeliverableMessage((SIBusMessage)this.msgItem.getMessage(), null, externalLocalTransaction, 36, new String[]{"" + this.msgItem.getID(), this.destinationHandler.toString(), this.messageProcessor.getMessagingEngineName()});
            if (object == UndeliverableReturnCode.OK || object == UndeliverableReturnCode.DISCARD) {
                bl = true;
            } else {
                SIMPRuntimeOperationFailedException sIMPRuntimeOperationFailedException = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"ReceivedMessage.removeMessage", "1:182:1.1", object}, null));
                SibTr.exception((TraceComponent)tc, (Exception)sIMPRuntimeOperationFailedException);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)sIMPRuntimeOperationFailedException);
                }
                throw sIMPRuntimeOperationFailedException;
            }
        }
        if (bl) {
            try {
                if (this.msgItem.isInStore()) {
                    if (this.msgItem.getLockID() == -2L) {
                        long l = this.messageProcessor.getMessageStore().getUniqueLockID(1);
                        this.msgItem.lockItemIfAvailable(l);
                    }
                    this.msgItem.remove(externalLocalTransaction, this.msgItem.getLockID());
                }
            }
            catch (Exception exception) {
                object = null;
                if (this.msgItem.isAdding()) {
                    object = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("MESSAGE_INDOUBT_WARNING_CWSIP0361", new Object[]{new Long(this.msgItem.getID()), this.destinationHandler.getName()}, null), exception);
                } else {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.runtime.ReceivedMessage.removeMessage", (String)"1:328:1.35", (Object)this);
                    object = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"ReceivedMessage.removeMessage", "1:240:1.1", exception, new Long(this.msgItem.getID())}, null), exception);
                }
                SibTr.exception((TraceComponent)tc, (Exception)object);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)object);
                }
                throw object;
            }
        }
        try {
            externalLocalTransaction.commit();
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.runtime.ReceivedMessage.removeMessage", (String)"1:356:1.35", (Object)this);
            object = new SIMPRuntimeOperationFailedException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"ReceivedMessage.removeMessage", "1:268:1.1", sIException, new Long(this.msgItem.getID())}, null), sIException);
            SibTr.exception((TraceComponent)tc, (Exception)object);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeMessage", (Object)object);
            }
            throw object;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeMessage");
        }
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)new Long(this.msgItem.getID()));
        }
        return "" + this.msgItem.getID();
    }

    public String getName() {
        return null;
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.msgItem.getID() == -1L) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"ReceivedMessage.assertValidControllable", "1:324:1.1", new Long(this.msgItem.getID())}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"assertValidControllable", (Object)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this.msgItem = null;
        this.messageProcessor = null;
        this.destinationHandler = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
    }

    public long getSequenceID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSequenceID");
        }
        long l = 0L;
        l = this.msgItem.getMessage().getGuaranteedValueValueTick();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSequenceID", (Object)new Long(l));
        }
        return l;
    }

    public long getPreviousSequenceID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPreviousSequenceID");
        }
        long l = 0L;
        l = this.msgItem.getMessage().getGuaranteedValueStartTick() - 1L;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPreviousSequenceID", (Object)new Long(l));
        }
        return l;
    }

    public long getStartTick() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStartTick");
        }
        long l = 0L;
        l = this.msgItem.getMessage().getGuaranteedValueStartTick();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStartTick", (Object)new Long(l));
        }
        return l;
    }

    public long getEndTick() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getEndTick");
        }
        long l = 0L;
        l = this.msgItem.getMessage().getGuaranteedValueEndTick();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getEndTick", (Object)new Long(l));
        }
        return l;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/ReceivedMessage.java, SIB.processor, WAS602.SIB, o0610.11 1.1");
        }
    }
}

