/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPInvalidRuntimeIDException;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.indexes.DestinationIndex;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.ControllableIterator;
import com.ibm.ws.sib.processor.runtime.MessageProcessorControl;
import com.ibm.ws.sib.processor.runtime.RemoteMediationPoint;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPMediatedMessageHandlerControllable;
import com.ibm.ws.sib.processor.runtime.SIMPMediationPointControllable;
import com.ibm.ws.sib.processor.runtime.SIMPMessageProcessorControllable;
import com.ibm.ws.sib.processor.runtime.SIMPRemoteMediationPointControllable;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationType;
import java.io.PrintStream;
import java.util.Map;

public abstract class MediatedMessageHandlerControl
extends AbstractControlAdapter
implements SIMPMediatedMessageHandlerControllable {
    protected MessageProcessorControl mpControl;
    protected DestinationIndex index;
    protected DestinationManager destinationManager;
    protected BaseDestinationHandler baseDest;
    protected String name;
    protected SIBUuid12 uuid;
    protected MessageProcessor messageProcessor;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static TraceComponent tc = SibTr.register((Class)MediatedMessageHandlerControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public MediatedMessageHandlerControl(MessageProcessor messageProcessor, BaseDestinationHandler baseDestinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MediatedMessageHandlerControl", (Object)new Object[]{messageProcessor, baseDestinationHandler});
        }
        this.mpControl = (MessageProcessorControl)messageProcessor.getControlAdapter();
        this.destinationManager = messageProcessor.getDestinationManager();
        this.messageProcessor = messageProcessor;
        this.index = this.destinationManager.getDestinationIndex();
        this.baseDest = baseDestinationHandler;
        this.name = this.baseDest.getName();
        this.uuid = this.baseDest.getUuid();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MediatedMessageHandlerControl", (Object)this);
        }
    }

    public boolean isSystem() {
        return this.baseDest.isSystem();
    }

    public String getName() {
        return this.name;
    }

    public boolean isTemporary() {
        return this.baseDest.isTemporary();
    }

    public String getState() {
        return this.index.getState(this.baseDest).toString();
    }

    public SIMPIterator getBrowserIterator() {
        return null;
    }

    public SIMPIterator getConsumerIterator() {
        return null;
    }

    public SIMPIterator getProducerIterator() {
        return null;
    }

    public SIMPIterator getRemoteMediationPointIterator() {
        Index index = this.baseDest.getRemoteMediationPoints();
        SIMPIterator sIMPIterator = index.iterator();
        return new ControllableIterator(sIMPIterator);
    }

    public SIMPRemoteMediationPointControllable getRemoteMediationPointControlByID(String string) {
        return null;
    }

    public SIMPIterator getMediationPointIterator() {
        return new ControllableIterator(this.baseDest.getMediationPoints().iterator());
    }

    public SIMPMediationPointControllable getMediationPointControlByID(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        return this.mpControl.getMediationPointControlByID(string);
    }

    public long getAlterationTime() {
        return this.baseDest.getAlterationTime();
    }

    public DestinationType getDestinationType() {
        return this.baseDest.getDestinationType();
    }

    public boolean isMediationEnabled() {
        return this.baseDest.isMediationEnabled();
    }

    public Map getDestinationContext() {
        return this.baseDest.getDefinition().getDestinationContext();
    }

    public boolean isSendAllowed() {
        return this.baseDest.isSendAllowed();
    }

    public boolean isReceiveAllowed() {
        return this.baseDest.isReceiveAllowed();
    }

    public boolean isReceiveExclusive() {
        return this.baseDest.isReceiveExclusive();
    }

    public int getDefaultPriority() {
        return this.baseDest.getDefaultPriority();
    }

    public String getExceptionDestination() {
        return this.baseDest.getExceptionDestination();
    }

    public int getMaxFailedDeliveries() {
        return this.baseDest.getMaxFailedDeliveries();
    }

    public boolean isOverrideOfQOSByProducerAllowed() {
        return this.baseDest.isOverrideOfQOSByProducerAllowed();
    }

    public Reliability getDefaultReliability() {
        return this.baseDest.getDefaultReliability();
    }

    public Reliability getMaxReliability() {
        return this.baseDest.getMaxReliability();
    }

    public SIMPMessageProcessorControllable getMessageProcessor() {
        return this.mpControl;
    }

    public boolean isLocal() {
        return this.baseDest.hasLocal();
    }

    public boolean isAlias() {
        return this.baseDest.isAlias();
    }

    public boolean isForeign() {
        return this.baseDest.isForeign();
    }

    public SIBUuid12 getUUID() {
        return this.uuid;
    }

    public String getDescription() {
        return this.baseDest.getDescription();
    }

    public String getId() {
        return this.uuid.toString();
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.baseDest == null || !this.baseDest.isInStore()) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"MediateMessageHandlerControl.assertValidControllable", "1:376:1.11", this.uuid}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this.destinationManager = null;
        this.baseDest = null;
        this.index = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
    }

    public SIMPRemoteMediationPointControllable getRemoteMediationPointControlByMEUuid(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteMediationPointControlByMEUuid", (Object)new Object[]{string});
        }
        SIBUuid8 sIBUuid8 = null;
        try {
            sIBUuid8 = new SIBUuid8(string);
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.sib.processor.runtime.MediatedMessageHandlerControl.getRemoteMediationPointControlByMEUuid", (String)"1:449:1.11", (Object)this);
            SIMPInvalidRuntimeIDException sIMPInvalidRuntimeIDException = new SIMPInvalidRuntimeIDException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"MediatedMessageHandlerControl.getRemoteMediationPointControlByMEUuid", "1:457:1.11", numberFormatException, string}, null), numberFormatException);
            SibTr.exception((TraceComponent)tc, (Exception)sIMPInvalidRuntimeIDException);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"MediatedMessageHandlerControl.getRemoteMediationPointControlByMEUuid", "1:465:1.11", numberFormatException, string});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRemoteMediationPointControlByMEUuid", (Object)sIMPInvalidRuntimeIDException);
            }
            throw sIMPInvalidRuntimeIDException;
        }
        RemoteMediationPoint remoteMediationPoint = this.baseDest.getRemoteMediationPointControl(sIBUuid8, false);
        if (remoteMediationPoint == null) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"MediatedMessageHandlerControl.getRemoteMediationPointControlByMEUuid", "1:480:1.11", string}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"MediatedMessageHandlerControl.getRemoteMediationPointControlByMEUuid", "1:487:1.11", string});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getRemoteMediationPointControlByMEUuid", (Object)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteMediationPointControlByMEUuid", (Object)remoteMediationPoint);
        }
        return remoteMediationPoint;
    }

    protected void assertMessageHandlerNotCorrupt() throws SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertMessageHandlerNotCorrupt");
        }
        if (this.baseDest.isCorrupt()) {
            String string = nls.getFormattedMessage("MESSAGE_HANDLER_CORRUPT_ERROR_CWSIP0201", null, null);
            SIMPException sIMPException = new SIMPException(string);
            SibTr.exception((TraceComponent)tc, (Exception)sIMPException);
            throw sIMPException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertMessageHandlerNotCorrupt");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/MediatedMessageHandlerControl.java, SIB.processor, WAS602.SIB, o0610.11 1.11");
        }
    }
}

