/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.LocalizationDefinition;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.gd.TargetStreamManager;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.ProducerInputHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLocalTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.SIMPMessageHandlerControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;

public class LocalTopicSpaceControl
extends AbstractRegisteredControlAdapter
implements SIMPLocalTopicSpaceControllable {
    private BaseDestinationHandler destinationHandler;
    private PubSubMessageItemStream itemStream;
    private String id;
    private static TraceComponent tc = SibTr.register((Class)LocalTopicSpaceControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;

    public LocalTopicSpaceControl(MessageProcessor messageProcessor, PubSubMessageItemStream pubSubMessageItemStream) {
        super(messageProcessor, ControllableType.PUBLICATION_POINT);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LocalTopicSpaceControl", (Object)new Object[]{messageProcessor, pubSubMessageItemStream});
        }
        this.itemStream = pubSubMessageItemStream;
        this.destinationHandler = pubSubMessageItemStream.getDestinationHandler();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LocalTopicSpaceControl");
        }
    }

    private ProducerInputHandler getInputHandler() {
        return (ProducerInputHandler)this.destinationHandler.getInputHandler();
    }

    public SIMPTopicSpaceControllable getTopicSpace() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpace");
        }
        SIMPTopicSpaceControllable sIMPTopicSpaceControllable = (SIMPTopicSpaceControllable)this.getMessageHandler();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpace", (Object)sIMPTopicSpaceControllable);
        }
        return sIMPTopicSpaceControllable;
    }

    public SIMPMessageHandlerControllable getMessageHandler() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageHandler");
        }
        SIMPMessageHandlerControllable sIMPMessageHandlerControllable = (SIMPMessageHandlerControllable)((Object)this.destinationHandler.getControlAdapter());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageHandler", (Object)sIMPMessageHandlerControllable);
        }
        return sIMPMessageHandlerControllable;
    }

    public SIMPIterator getPubSubInboundReceiverIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubInboundReceiverIterator");
        }
        TargetStreamManager targetStreamManager = this.getInputHandler().getTargetStreamManager();
        SIMPIterator sIMPIterator = targetStreamManager.getTargetStreamSetControlIterator();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPubSubInboundReceiverIterator", (Object)sIMPIterator);
        }
        return sIMPIterator;
    }

    public String getId() {
        if (this.id == null) {
            this.id = "" + this.itemStream.getID();
        }
        return this.id;
    }

    public String getName() {
        return this.getMessageHandler().getName();
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkValidControllable");
        }
        if (this.itemStream == null || !this.itemStream.isInStore()) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"LocalTopicSpaceControl.assertValidControllable", "1:198:1.28", this.id}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        super.dereferenceControllable();
        this.itemStream = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public boolean isSendAllowed() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSendAllowed");
        }
        boolean bl = this.itemStream.isSendAllowed();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSendAllowed", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void setDestinationHighMsgs(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinationHighMsgs", (Object)new Long(l));
        }
        this.itemStream.setDestHighMsgs(l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setDestinationHighMsgs");
        }
    }

    public long getDestinationHighMsgs() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHighMsgs");
        }
        long l = this.itemStream.getDestHighMsgs();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHighMsgs", (Object)new Long(l));
        }
        return l;
    }

    public void setSendAllowed(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)new Boolean(bl));
        }
        this.itemStream.setSendAllowed(bl);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setSendAllowed", (Object)new Boolean(bl));
        }
    }

    public String getUuid() {
        LocalizationDefinition localizationDefinition = this.itemStream.getLocalizationDefinition();
        String string = null;
        if (localizationDefinition != null) {
            string = localizationDefinition.getUuid();
        }
        return string;
    }

    public String getConfigId() {
        LocalizationDefinition localizationDefinition = this.itemStream.getLocalizationDefinition();
        String string = null;
        if (localizationDefinition != null) {
            string = localizationDefinition.getConfigId();
        }
        return string;
    }

    public String getRemoteEngineUuid() {
        return this.getMessageProcessor().getMessagingEngineUuid().toString();
    }

    public synchronized void registerControlAdapterAsMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        if (!this.isRegistered() && !this.getMessageHandler().isTemporary()) {
            super.registerControlAdapterAsMBean();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    public SIMPIterator getPubSubInboundReceiverStreamSets() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubInboundReceiverIterator");
        }
        TargetStreamManager targetStreamManager = this.getInputHandler().getTargetStreamManager();
        SIMPIterator sIMPIterator = targetStreamManager.getTargetStreamSetControlIterator();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPubSubInboundReceiverIterator", (Object)sIMPIterator);
        }
        return sIMPIterator;
    }

    public SIMPIterator getLocalSubscriptions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptions");
        }
        SIMPIterator sIMPIterator = null;
        try {
            sIMPIterator = this.getTopicSpace().getLocalSubscriptionIterator();
        }
        catch (SIMPException sIMPException) {
            FFDCFilter.processException((Throwable)sIMPException, (String)"com.ibm.ws.sib.processor.runtime.LocalTopicSpaceControl", (String)"1:384:1.28", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.LocalTopicSpaceControl", "1:389:1.28", SIMPUtils.getStackTrace(sIMPException)});
            SibTr.exception((TraceComponent)tc, (Exception)sIMPException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptions", (Object)sIMPIterator);
        }
        return sIMPIterator;
    }

    public SIMPIterator getPubSubDeliveryStreamSetReceiverIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubDeliveryStreamSetReceiverIterator");
        }
        SIMPIterator sIMPIterator = this.getInputHandler().getTargetStreamManager().getTargetStreamSetControlIterator();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubDeliveryStreamSetReceiverIterator");
        }
        return sIMPIterator;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/LocalTopicSpaceControl.java, SIB.processor, WAS602.SIB, o0610.11 1.28");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

