/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ControllableType;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.ReferenceStream;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.exceptions.SIMPInvalidRuntimeIDException;
import com.ibm.ws.sib.processor.impl.AnycastOutputHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.items.MessageItemReference;
import com.ibm.ws.sib.processor.runtime.AbstractRegisteredControlAdapter;
import com.ibm.ws.sib.processor.runtime.BasicSIMPIterator;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPLocalSubscriptionControllable;
import com.ibm.ws.sib.processor.runtime.SIMPQueuedMessageControllable;
import com.ibm.ws.sib.processor.runtime.SIMPTopicSpaceControllable;
import com.ibm.ws.sib.processor.runtime.anycast.AnycastOutputStreamIterator;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class LocalSubscriptionControl
extends AbstractRegisteredControlAdapter
implements SIMPLocalSubscriptionControllable {
    private ConsumerDispatcherState consumerDispatcherState;
    private ReferenceStream referenceItemStream;
    private static TraceComponent tc = SibTr.register((Class)LocalSubscriptionControl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private SIMPTopicSpaceControllable topicspaceControl;
    private ConsumerDispatcher consumerDispatcher;

    public LocalSubscriptionControl(ConsumerDispatcher consumerDispatcher, SIMPTopicSpaceControllable sIMPTopicSpaceControllable, MessageProcessor messageProcessor) {
        super(messageProcessor, ControllableType.SUBSCRIPTION_POINT);
        this.consumerDispatcher = consumerDispatcher;
        this.referenceItemStream = consumerDispatcher.getReferenceStream();
        this.topicspaceControl = sIMPTopicSpaceControllable;
        this.consumerDispatcherState = this.consumerDispatcher.getConsumerDispatcherState();
    }

    public SIMPTopicSpaceControllable getTopicSpace() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpace");
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpace", (Object)this.topicspaceControl);
        }
        return this.topicspaceControl;
    }

    public String getSelector() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSelector");
        }
        String string = this.consumerDispatcherState.getSelectionCriteria().getSelectorString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSelector", (Object)string);
        }
        return string;
    }

    public String getSubscriberID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriberID");
        }
        String string = this.consumerDispatcherState.getSubscriberID();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriberID", (Object)string);
        }
        return string;
    }

    protected String getDurableHome() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDurableHome");
        }
        String string = this.consumerDispatcherState.getDurableHome();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDurableHome", (Object)string);
        }
        return string;
    }

    public String[] getTopics() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopics");
        }
        String[] stringArray = this.consumerDispatcherState.getTopics();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTopics", (Object)stringArray);
        }
        return stringArray;
    }

    public SIMPIterator getConsumerIterator() {
        return null;
    }

    public SIMPIterator getRemoteConsumerTransmit() {
        String string;
        String string2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteConsumerTransmitIterator");
        }
        SIMPIterator sIMPIterator = null;
        BaseDestinationHandler baseDestinationHandler = this.consumerDispatcher.getDestination();
        AnycastOutputHandler anycastOutputHandler = baseDestinationHandler.getAnycastOHForPseudoDest(string2 = baseDestinationHandler.constructPseudoDurableDestName(string = this.consumerDispatcherState.getSubscriberID()));
        if (anycastOutputHandler != null) {
            Iterator iterator = anycastOutputHandler.getIteratorOverAOStreams();
            sIMPIterator = new AnycastOutputStreamIterator(iterator, baseDestinationHandler.getMessageProcessor(), baseDestinationHandler);
        } else {
            sIMPIterator = new BasicSIMPIterator(new LinkedList().iterator());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRemoteConsumerTransmitIterator", (Object)sIMPIterator);
        }
        return sIMPIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SIMPIterator getQueuedMessageIterator() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessageIterator");
        }
        ArrayList<ControlAdapter> arrayList = new ArrayList<ControlAdapter>();
        NonLockingCursor nonLockingCursor = null;
        try {
            nonLockingCursor = this.consumerDispatcher.getReferenceStream().newNonLockingCursor(null);
            nonLockingCursor.allowUnavailableItems();
            MessageItemReference messageItemReference = (MessageItemReference)nonLockingCursor.next();
            while (messageItemReference != null) {
                ((MessageItem)messageItemReference.getReferredItem()).forceCurrentMEArrivalTimeToJsMessage();
                arrayList.add(messageItemReference.getControlAdapter());
                messageItemReference = (MessageItemReference)nonLockingCursor.next();
            }
        }
        catch (MessageStoreException messageStoreException) {
            FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.runtime.LocalSubscriptionControl.getQueuedMessageIterator", (String)"1:257:1.29", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.LocalSubscriptionControl.getQueuedMessageIterator", "1:263:1.29", SIMPUtils.getStackTrace((Throwable)((Object)messageStoreException))});
        }
        finally {
            if (nonLockingCursor != null) {
                nonLockingCursor.finished();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageIterator");
        }
        return new BasicSIMPIterator(arrayList.iterator());
    }

    public SIMPQueuedMessageControllable getQueuedMessageByID(String string) throws SIMPInvalidRuntimeIDException, SIMPControllableNotFoundException, SIMPException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getQueuedMessageByID", (Object)new Object[]{string});
        }
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.sib.processor.runtime.LocalQueuePoint.getQueuedMessageByID", (String)"1:297:1.29", (Object)this);
            throw new SIMPInvalidRuntimeIDException(numberFormatException);
        }
        SIMPMessage sIMPMessage = null;
        sIMPMessage = (SIMPMessage)((Object)this.consumerDispatcher.getReferenceStream().findById(l));
        if (sIMPMessage == null) {
            throw new SIMPControllableNotFoundException(nls.getFormattedMessage("MESSAGE_EXISTS_ERROR_CWSIP0572", new Object[]{string, this.consumerDispatcher.getDestination().getName()}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getQueuedMessageByID");
        }
        return (SIMPQueuedMessageControllable)((Object)sIMPMessage.getControlAdapter());
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String string = this.consumerDispatcher.getSubscriptionUuid().toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)string);
        }
        return string;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        String string = this.consumerDispatcher.getDestination().getName();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)string);
        }
        return string;
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public long getNumberOfQueuedMessages() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNumberOfQueuedMessages");
        }
        long l = this.referenceItemStream.getStatistics().getTotalItemCount();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNumberOfQueuedMessages", (Object)new Long(l));
        }
        return l;
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkValidControllable");
        }
        if (this.referenceItemStream == null || !this.referenceItemStream.isInStore()) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"LocalSubscriptionControl.assertValidControllable", "1:391:1.29", this.referenceItemStream}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this.referenceItemStream = null;
        this.consumerDispatcher = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/LocalSubscriptionControl.java, SIB.processor, WAS602.SIB, o0610.11 1.29");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

