/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.processor.gd.Stream;
import com.ibm.ws.sib.processor.gd.StreamSet;
import com.ibm.ws.sib.processor.gd.TickRange;
import com.ibm.ws.sib.processor.impl.exceptions.InvalidOperationException;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.TransmitMessage;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Iterator;
import java.util.List;

public class GDMessageIterator
implements SIMPIterator {
    private GDRangeListIterator _rangeIterator;
    private StreamSet _streamSet;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)GDMessageIterator.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public GDMessageIterator(StreamSet streamSet) {
        this._streamSet = streamSet;
        this._rangeIterator = new GDRangeListIterator(streamSet.iterator());
    }

    public boolean hasNext() {
        return this._rangeIterator.hasNext();
    }

    public Object next() {
        long l = (Long)this._rangeIterator.next();
        TransmitMessage transmitMessage = null;
        TickRange tickRange = this._rangeIterator.currentStream.getTickRange(l);
        if (tickRange != null) {
            long l2 = tickRange.itemStreamIndex;
            if (l2 != -1L) {
                transmitMessage = new TransmitMessage(l2, this._streamSet);
            } else if (tickRange.value != null && tickRange.value instanceof MessageItem) {
                transmitMessage = new TransmitMessage((MessageItem)tickRange.value, this._rangeIterator.currentStream);
            }
        }
        return transmitMessage;
    }

    public void remove() {
        InvalidOperationException invalidOperationException = new InvalidOperationException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"XmitQueuePointIterator.remove", "1:114:1.12", this}, null));
        SibTr.exception((TraceComponent)tc, (Exception)((Object)invalidOperationException));
        throw invalidOperationException;
    }

    public void finished() {
        this._rangeIterator = null;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/GDMessageIterator.java, SIB.processor, WAS602.SIB, o0610.11 1.12");
        }
    }

    class GDRangeListIterator {
        Iterator streams;
        Stream currentStream;
        List currentRangeList;
        Iterator currentRangeIterator;

        public GDRangeListIterator(Iterator iterator) {
            this.streams = iterator;
            this.currentStream = null;
            this.currentRangeList = null;
            this.currentRangeIterator = null;
        }

        private void nextStream() {
            if (this.streams.hasNext()) {
                do {
                    this.currentStream = (Stream)this.streams.next();
                    this.currentRangeList = this.currentStream.getTicksOnStream();
                    this.currentRangeIterator = this.currentRangeList.iterator();
                } while (!this.currentRangeIterator.hasNext() && this.streams.hasNext());
            } else {
                this.currentStream = null;
                this.currentRangeList = null;
                this.currentRangeIterator = null;
            }
        }

        public boolean hasNext() {
            boolean bl = false;
            if (this.currentRangeIterator == null || !this.currentRangeIterator.hasNext()) {
                this.nextStream();
            }
            if (this.currentRangeIterator != null) {
                bl = this.currentRangeIterator.hasNext();
            }
            return bl;
        }

        public Object next() {
            if (this.currentRangeIterator == null || !this.currentRangeIterator.hasNext()) {
                this.nextStream();
            }
            Object var1_1 = null;
            if (this.currentRangeIterator != null) {
                var1_1 = this.currentRangeIterator.next();
            }
            return var1_1;
        }
    }
}

