/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.DestinationForeignDefinition;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.impl.BusHandler;
import com.ibm.ws.sib.processor.impl.ForeignDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.SIMPForeignBusControllable;
import com.ibm.ws.sib.processor.runtime.SIMPForeignDestinationControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPMessageProcessorControllable;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;
import java.util.Map;

public class ForeignDestination
extends AbstractControlAdapter
implements SIMPForeignDestinationControllable {
    private static TraceComponent tc = SibTr.register((Class)ForeignDestination.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    private ForeignDestinationHandler foreignDest;
    private MessageProcessor messageProcessor;

    public ForeignDestination(MessageProcessor messageProcessor, ForeignDestinationHandler foreignDestinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ForeignDestination", (Object)new Object[]{messageProcessor, foreignDestinationHandler});
        }
        this.foreignDest = foreignDestinationHandler;
        this.messageProcessor = messageProcessor;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ForeignDestination", (Object)this);
        }
    }

    public DestinationForeignDefinition getForeignDestinationDefinition() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignDestinationDefinition");
        }
        DestinationForeignDefinition destinationForeignDefinition = (DestinationForeignDefinition)this.foreignDest.getDefinition();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignDestinationDefinition");
        }
        return destinationForeignDefinition;
    }

    public SIMPForeignBusControllable getTargetForeignBus() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetForeignBus");
        }
        BusHandler busHandler = null;
        try {
            busHandler = this.messageProcessor.getDestinationManager().findBus(this.foreignDest.getBus());
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.runtime.getTargetForeignBus", (String)"1:121:1.16", (Object)this);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.runtime.getTargetForeignBus", "1:126:1.16", SIMPUtils.getStackTrace(sIException)});
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
        }
        SIMPForeignBusControllable sIMPForeignBusControllable = null;
        if (busHandler != null) {
            sIMPForeignBusControllable = (SIMPForeignBusControllable)((Object)busHandler.getControlAdapter());
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTargetForeignBus");
        }
        return sIMPForeignBusControllable;
    }

    public SIMPIterator getProducerIterator() {
        return null;
    }

    public SIMPMessageProcessorControllable getMessageProcessor() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageProcessor");
            SibTr.exit((TraceComponent)tc, (String)"getMessageProcessor");
        }
        return (SIMPMessageProcessorControllable)((Object)this.messageProcessor.getControlAdapter());
    }

    public boolean isLocal() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLocal");
        }
        boolean bl = false;
        if (this.foreignDest.getResolvedDestinationHandler().getPtoPLocalMsgsItemStream() != null) {
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isLocal", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isAlias() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAlias");
            SibTr.exit((TraceComponent)tc, (String)"isAlias", (Object)Boolean.TRUE);
        }
        return true;
    }

    public boolean isForeign() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isForeign");
            SibTr.exit((TraceComponent)tc, (String)"isForeign", (Object)Boolean.TRUE);
        }
        return true;
    }

    public SIBUuid12 getUUID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUUID");
        }
        SIBUuid12 sIBUuid12 = this.foreignDest.getUuid();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUUID", (Object)sIBUuid12);
        }
        return sIBUuid12;
    }

    public String getDescription() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDescription");
        }
        String string = this.foreignDest.getDescription();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDescription", (Object)string);
        }
        return string;
    }

    public Map getDestinationContext() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationContext");
        }
        Map map = this.foreignDest.getDefinition().getDestinationContext();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationContext", (Object)map);
        }
        return map;
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this.foreignDest == null || !this.foreignDest.isInStore()) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"ForeignDest.assertValidControllable", "1:277:1.16", this.foreignDest}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this.foreignDest = null;
        this.messageProcessor = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
    }

    public SIMPIterator getBrowserIterator() {
        return null;
    }

    public SIMPIterator getConsumerIterator() {
        return null;
    }

    public boolean isSystem() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSystem");
        }
        boolean bl = this.foreignDest.isSystem();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSystem", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isTemporary() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTemporary");
        }
        boolean bl = this.foreignDest.isTemporary();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isTemporary", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String getState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        String string = this.messageProcessor.getDestinationManager().getDestinationIndex().getState(this.foreignDest).toString();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        return string;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        String string = this.foreignDest.getName();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)string);
        }
        return string;
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getId");
        }
        String string = this.getUUID().toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getId", (Object)string);
        }
        return string;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/VirtualLinkControl.java, SIB.processor, WASX.SIB 1.10");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

