/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.processor.exceptions.SIMPControllableNotFoundException;
import com.ibm.ws.sib.processor.impl.BusHandler;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.runtime.AbstractControlAdapter;
import com.ibm.ws.sib.processor.runtime.LocalQueuePoint;
import com.ibm.ws.sib.processor.runtime.MessageProcessorControl;
import com.ibm.ws.sib.processor.runtime.SIMPForeignBusControllable;
import com.ibm.ws.sib.processor.runtime.SIMPIterator;
import com.ibm.ws.sib.processor.runtime.SIMPMessageProcessorControllable;
import com.ibm.ws.sib.processor.runtime.SIMPVirtualLinkControllable;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.PrintStream;
import java.util.Map;

public class ForeignBus
extends AbstractControlAdapter
implements SIMPForeignBusControllable {
    private MessageProcessorControl _mpControl;
    private MessageProcessor _messageProcessor;
    private DestinationManager _destinationManager;
    private BusHandler _foreignBus;
    private static final TraceComponent tc = SibTr.register((Class)LocalQueuePoint.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;

    public ForeignBus(MessageProcessor messageProcessor, BusHandler busHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ForeignBus", (Object)new Object[]{messageProcessor, busHandler});
        }
        this._mpControl = (MessageProcessorControl)messageProcessor.getControlAdapter();
        this._destinationManager = messageProcessor.getDestinationManager();
        this._messageProcessor = messageProcessor;
        this._foreignBus = busHandler;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ForeignBus", (Object)this);
        }
    }

    public SIMPIterator getProducerIterator() {
        return null;
    }

    public SIMPVirtualLinkControllable getVirtualLinkControlAdapter() {
        return (SIMPVirtualLinkControllable)((Object)this._foreignBus.getResolvedDestinationHandler().getControlAdapter());
    }

    public SIMPMessageProcessorControllable getMessageProcessor() {
        return this._mpControl;
    }

    public boolean isLocal() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isLocal");
        }
        boolean bl2 = bl = this._foreignBus.getResolvedDestinationHandler().getPtoPLocalMsgsItemStream() != null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isLocal", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isAlias() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isAlias");
            SibTr.exit((TraceComponent)tc, (String)"isAlias", (Object)Boolean.TRUE);
        }
        return true;
    }

    public boolean isForeign() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isForeign");
            SibTr.exit((TraceComponent)tc, (String)"isForeign", (Object)Boolean.FALSE);
        }
        return false;
    }

    public SIBUuid12 getUUID() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUUID");
        }
        SIBUuid12 sIBUuid12 = this._foreignBus.getUuid();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUUID", (Object)sIBUuid12);
        }
        return sIBUuid12;
    }

    public String getDescription() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDescription");
        }
        String string = this._foreignBus.getDescription();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDescription", (Object)string);
        }
        return string;
    }

    public Map getDestinationContext() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationContext");
        }
        Map map = this._foreignBus.getDefinition().getDestinationContext();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationContext", (Object)map);
        }
        return map;
    }

    public void formatState(PrintStream printStream, boolean bl) {
    }

    public void assertValidControllable() throws SIMPControllableNotFoundException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"assertValidControllable");
        }
        if (this._foreignBus == null || !this._foreignBus.isInStore()) {
            SIMPControllableNotFoundException sIMPControllableNotFoundException = new SIMPControllableNotFoundException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"ForeignBus.assertValidControllable", "1:219:1.19", this._foreignBus}, null));
            SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            if (tc.isEntryEnabled()) {
                SibTr.exception((TraceComponent)tc, (Exception)sIMPControllableNotFoundException);
            }
            throw sIMPControllableNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"assertValidControllable");
        }
    }

    public void dereferenceControllable() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControllable");
        }
        this._destinationManager = null;
        this._foreignBus = null;
        this._mpControl = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControllable");
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public void runtimeEventOccurred(RuntimeEvent runtimeEvent) {
    }

    public SIMPIterator getBrowserIterator() {
        return null;
    }

    public SIMPIterator getConsumerIterator() {
        return null;
    }

    public boolean isSystem() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSystem");
        }
        boolean bl = this._foreignBus.isSystem();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSystem", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isTemporary() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTemporary");
        }
        boolean bl = this._foreignBus.isTemporary();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isTemporary", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String getState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState");
        }
        String string = this._destinationManager.getForeignBusIndex().getState(this._foreignBus).toString();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getState", (Object)string);
        }
        return string;
    }

    public String getName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        String string = this._foreignBus.getName();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)string);
        }
        return string;
    }

    public String getId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
        }
        String string = this.getUUID().toString();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)string);
        }
        return string;
    }

    public ForeignBusDefinition getForeignBusDefinition() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignBusDefinition");
        }
        ForeignBusDefinition foreignBusDefinition = this._messageProcessor.getForeignBus(this.getName());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getForeignBusDefinition", (Object)foreignBusDefinition);
        }
        return foreignBusDefinition;
    }

    public int getDefaultPriority() {
        return this._foreignBus.getDefaultPriority();
    }

    public Reliability getDefaultReliability() {
        return this._foreignBus.getDefaultReliability();
    }

    public boolean isSendAllowed() {
        return this._foreignBus.isSendAllowed();
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/runtime/ForeignBus.java, SIB.processor, WAS602.SIB, o0610.11 1.19");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

