/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.control.ControlMessageFactory;
import com.ibm.ws.sib.mfp.control.SubscriptionMessage;
import com.ibm.ws.sib.mfp.control.SubscriptionMessageType;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.proxyhandler.MESubscription;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.List;

final class SubscriptionMessageHandler {
    private static final TraceComponent tc = SibTr.register((Class)SubscriptionMessageHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private SubscriptionMessage iSubscriptionMessage;
    private List iTopics;
    private List iTopicSpaces;
    private List iTopicSpaceMappings;
    private String iMEName;
    private SIBUuid8 iMEUUID;
    private String iBusName;
    private MultiMEProxyHandler iProxyHandler;
    private boolean iInitialised = false;

    protected SubscriptionMessageHandler(MultiMEProxyHandler multiMEProxyHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SubscriptionMessageHandler", (Object)multiMEProxyHandler);
        }
        this.iProxyHandler = multiMEProxyHandler;
        this.iTopics = new ArrayList();
        this.iTopicSpaces = new ArrayList();
        this.iTopicSpaceMappings = new ArrayList();
        this.iMEName = null;
        this.iMEUUID = null;
        this.iBusName = null;
        this.iMEName = this.iProxyHandler.getMessageProcessor().getMessagingEngineName();
        this.iMEUUID = this.iProxyHandler.getMessageProcessor().getMessagingEngineUuid();
        this.iBusName = this.iProxyHandler.getMessageProcessor().getMessagingEngineBus();
        this.iSubscriptionMessage = this.createSubscriptionMessage();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SubscriptionMessageHandler", (Object)this);
        }
    }

    private SubscriptionMessage createSubscriptionMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createSubscriptionMessage");
        }
        ControlMessageFactory controlMessageFactory = null;
        SubscriptionMessage subscriptionMessage = null;
        try {
            controlMessageFactory = MessageProcessor.getControlMessageFactory();
            subscriptionMessage = controlMessageFactory.createNewSubscriptionMessage();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.proxyhandler.SubscriptionMessageHandler.createSubscriptionMessage", (String)"1:159:1.32", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createSubscriptionMessage", (Object)subscriptionMessage);
        }
        return subscriptionMessage;
    }

    private void reset() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reset");
        }
        if (this.iInitialised) {
            this.iTopics.clear();
            this.iTopicSpaces.clear();
            this.iTopicSpaceMappings.clear();
            this.iSubscriptionMessage = this.createSubscriptionMessage();
        } else {
            this.iInitialised = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    protected void resetCreateSubscriptionMessage(MESubscription mESubscription, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetCreateSubscriptionMessage", (Object)new Object[]{mESubscription, new Boolean(bl)});
        }
        this.reset();
        this.iSubscriptionMessage.setSubscriptionMessageType(SubscriptionMessageType.CREATE);
        this.iTopics.add(mESubscription.getTopic());
        if (bl) {
            this.iTopicSpaces.add(mESubscription.getTopicSpaceUuid().toString());
        } else {
            this.iTopicSpaces.add(mESubscription.getTopicSpaceName().toString());
        }
        this.iTopicSpaceMappings.add(mESubscription.getForeignTSName());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetCreateSubscriptionMessage");
        }
    }

    protected void resetDeleteSubscriptionMessage(MESubscription mESubscription, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetDeleteSubscriptionMessage", (Object)new Object[]{mESubscription, new Boolean(bl)});
        }
        this.reset();
        this.iSubscriptionMessage.setSubscriptionMessageType(SubscriptionMessageType.DELETE);
        this.iTopics.add(mESubscription.getTopic());
        if (bl) {
            this.iTopicSpaces.add(mESubscription.getTopicSpaceUuid().toString());
        } else {
            this.iTopicSpaces.add(mESubscription.getTopicSpaceName().toString());
        }
        this.iTopicSpaceMappings.add(mESubscription.getForeignTSName());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetDeleteSubscriptionMessage");
        }
    }

    protected void resetDeleteSubscriptionMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetDeleteSubscriptionMessage");
        }
        this.reset();
        this.iSubscriptionMessage.setSubscriptionMessageType(SubscriptionMessageType.DELETE);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetDeleteSubscriptionMessage");
        }
    }

    protected void resetResetSubscriptionMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetResetSubscriptionMessage");
        }
        this.reset();
        this.iSubscriptionMessage.setSubscriptionMessageType(SubscriptionMessageType.RESET);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetResetSubscriptionMessage");
        }
    }

    protected void resetReplySubscriptionMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetReplySubscriptionMessage");
        }
        this.reset();
        this.iSubscriptionMessage.setSubscriptionMessageType(SubscriptionMessageType.REPLY);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetReplySubscriptionMessage");
        }
    }

    protected void addSubscriptionToMessage(MESubscription mESubscription, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addSubscriptionToMessage", (Object)new Object[]{mESubscription, new Boolean(bl)});
        }
        this.iTopics.add(mESubscription.getTopic());
        if (bl) {
            this.iTopicSpaces.add(mESubscription.getTopicSpaceUuid().toString());
        } else {
            this.iTopicSpaces.add(mESubscription.getTopicSpaceName().toString());
        }
        this.iTopicSpaceMappings.add(mESubscription.getForeignTSName());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSubscriptionToMessage");
        }
    }

    protected SubscriptionMessage getSubscriptionMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionMessage");
        }
        this.iSubscriptionMessage.setTopics(this.iTopics);
        this.iSubscriptionMessage.setMEName(this.iMEName);
        this.iSubscriptionMessage.setMEUUID(this.iMEUUID.toByteArray());
        this.iSubscriptionMessage.setBusName(this.iBusName);
        this.iSubscriptionMessage.setTopicSpaces(this.iTopicSpaces);
        this.iSubscriptionMessage.setTopicSpaceMappings(this.iTopicSpaceMappings);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionMessage", (Object)this.iSubscriptionMessage);
        }
        return this.iSubscriptionMessage;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/proxyhandler/SubscriptionMessageHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.32");
        }
    }
}

