/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.ForeignBusDefinition;
import com.ibm.ws.sib.admin.SIBExceptionNoLinkExists;
import com.ibm.ws.sib.admin.VirtualLinkDefinition;
import com.ibm.ws.sib.mfp.control.SubscriptionMessage;
import com.ibm.ws.sib.msgstore.AbstractItem;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.NonLockingCursor;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ControllableProxySubscription;
import com.ibm.ws.sib.processor.impl.DestinationManager;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.filters.ClassEqualsFilter;
import com.ibm.ws.sib.processor.proxyhandler.BusGroup;
import com.ibm.ws.sib.processor.proxyhandler.MESubscription;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

final class Neighbours {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)Neighbours.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Hashtable _neighbours;
    private Hashtable _recoveredNeighbours;
    private HashMap _topicSpaces;
    private BusGroup[] _buses;
    private MultiMEProxyHandler _proxyHandler;
    private DestinationManager _destinationManager;
    private String _localBusName;

    Neighbours(MultiMEProxyHandler multiMEProxyHandler, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"Neighbours", (Object)new Object[]{multiMEProxyHandler, string});
        }
        this._proxyHandler = multiMEProxyHandler;
        this._neighbours = new Hashtable();
        this._buses = new BusGroup[0];
        this._topicSpaces = new HashMap();
        this._recoveredNeighbours = new Hashtable();
        this._localBusName = string;
        this._destinationManager = this._proxyHandler.getMessageProcessor().getDestinationManager();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"Neighbours", (Object)this);
        }
    }

    final BusGroup[] getAllBuses() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllBuses");
            SibTr.exit((TraceComponent)tc, (String)"getAllBuses", (Object)this._buses);
        }
        return this._buses;
    }

    final Enumeration getAllNeighbours() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllNeighbours");
            SibTr.exit((TraceComponent)tc, (String)"getAllNeighbours");
        }
        return ((Hashtable)this._neighbours.clone()).elements();
    }

    final Enumeration getAllRecoveredNeighbours() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAllRecoveredNeighbours");
            SibTr.exit((TraceComponent)tc, (String)"getAllRecoveredNeighbours");
        }
        return this._recoveredNeighbours.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTopicSpaceReference(SIBUuid8 sIBUuid8, SIBUuid12 sIBUuid12, String string, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTopicSpaceReference", (Object)new Object[]{sIBUuid8, sIBUuid12, string, new Boolean(bl)});
        }
        HashMap hashMap = this._topicSpaces;
        synchronized (hashMap) {
            TemporarySubscription temporarySubscription = (TemporarySubscription)this._topicSpaces.get(sIBUuid12);
            Neighbour neighbour = null;
            neighbour = bl ? (Neighbour)this._recoveredNeighbours.get(sIBUuid8) : this.getNeighbour(sIBUuid8);
            MESubscription mESubscription = neighbour.getSubscription(sIBUuid12, string);
            if (temporarySubscription == null) {
                temporarySubscription = new TemporarySubscription(sIBUuid8, mESubscription);
                this._topicSpaces.put(sIBUuid12, temporarySubscription);
            } else {
                temporarySubscription.addTopic(sIBUuid8, mESubscription);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTopicSpaceReference");
        }
    }

    protected TemporarySubscription getTemporarySubscription(SIBUuid12 sIBUuid12) {
        return (TemporarySubscription)this._topicSpaces.get(sIBUuid12);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTopicSpaceReference(SIBUuid8 sIBUuid8, MESubscription mESubscription, SIBUuid12 sIBUuid12, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeTopicSpaceReference", (Object)new Object[]{sIBUuid8, mESubscription, sIBUuid12, string});
        }
        HashMap hashMap = this._topicSpaces;
        synchronized (hashMap) {
            TemporarySubscription temporarySubscription = (TemporarySubscription)this._topicSpaces.get(sIBUuid12);
            if (temporarySubscription == null) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"TemporarySubscription not found");
                }
            } else if (temporarySubscription.removeTopic(sIBUuid8, mESubscription)) {
                this._topicSpaces.remove(sIBUuid12);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeTopicSpaceReference");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void topicSpaceCreated(DestinationHandler destinationHandler) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"topicSpaceCreated", (Object)destinationHandler);
        }
        HashMap hashMap = this._topicSpaces;
        synchronized (hashMap) {
            if (this._topicSpaces.containsKey(destinationHandler.getUuid())) {
                ArrayList<SIBUuid12> arrayList = new ArrayList<SIBUuid12>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                TemporarySubscription temporarySubscription = (TemporarySubscription)this._topicSpaces.get(destinationHandler.getUuid());
                Iterator iterator = temporarySubscription.iMETopicList.keySet().iterator();
                while (iterator.hasNext()) {
                    boolean bl;
                    arrayList.clear();
                    arrayList2.clear();
                    SIBUuid8 sIBUuid8 = (SIBUuid8)iterator.next();
                    Iterator iterator2 = ((List)temporarySubscription.iMETopicList.get(sIBUuid8)).iterator();
                    Neighbour neighbour = this.getNeighbour(sIBUuid8);
                    boolean bl2 = bl = neighbour == null;
                    if (neighbour == null) {
                        neighbour = (Neighbour)this._recoveredNeighbours.get(sIBUuid8);
                    }
                    while (iterator2.hasNext()) {
                        Object object;
                        MESubscription mESubscription = (MESubscription)iterator2.next();
                        boolean bl3 = this.createProxy(neighbour, destinationHandler, mESubscription, destinationHandler.getUuid(), mESubscription.getTopic(), false);
                        if (!bl) {
                            mESubscription.eventPostCommitAdd(null);
                        }
                        if (bl3) {
                            if (!bl) {
                                arrayList.add(destinationHandler.getUuid());
                                arrayList2.add(mESubscription.getTopic());
                                continue;
                            }
                            object = destinationHandler.getPubSubOutputHandler(neighbour.getUUID());
                            neighbour.addPubSubOutputHandler((PubSubOutputHandler)object);
                            continue;
                        }
                        object = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:491:1.99.1.2"}, null));
                        FFDCFilter.processException((Throwable)object, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbours.topicSpaceCreated", (String)"1:497:1.99.1.2", (Object)this);
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"topicSpaceCreated", (Object)object);
                        }
                        throw object;
                    }
                    this._proxyHandler.subscribeEvent(arrayList, arrayList2, neighbour.getBusId(), null);
                }
                this._topicSpaces.remove(destinationHandler.getUuid());
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"No proxy subscriptions to register");
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"topicSpaceCreated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void topicSpaceDeleted(DestinationHandler destinationHandler) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"topicSpaceDeleted", (Object)destinationHandler);
        }
        HashMap hashMap = this._topicSpaces;
        synchronized (hashMap) {
            HashMap hashMap2 = (HashMap)destinationHandler.getAllPubSubOutputHandlers().clone();
            destinationHandler.unlockPubsubOutputHandlers();
            if (hashMap2 != null && hashMap2.size() > 0) {
                ArrayList<SIBUuid12> arrayList = new ArrayList<SIBUuid12>();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                Iterator iterator = hashMap2.keySet().iterator();
                while (iterator.hasNext()) {
                    arrayList.clear();
                    arrayList2.clear();
                    SIBUuid8 sIBUuid8 = (SIBUuid8)iterator.next();
                    PubSubOutputHandler pubSubOutputHandler = (PubSubOutputHandler)hashMap2.get(sIBUuid8);
                    String[] stringArray = pubSubOutputHandler.getTopics();
                    Neighbour neighbour = this.getNeighbour(sIBUuid8);
                    boolean bl = false;
                    if (neighbour == null) {
                        neighbour = (Neighbour)this._recoveredNeighbours.get(sIBUuid8);
                        bl = true;
                    }
                    if (neighbour != null && stringArray != null) {
                        for (int i = 0; i < stringArray.length; ++i) {
                            if (!bl) {
                                MESubscription mESubscription = neighbour.getSubscription(destinationHandler.getUuid(), stringArray[i]);
                                ControllableProxySubscription controllableProxySubscription = mESubscription.getMatchspaceSub();
                                this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().removePubSubOutputHandlerMatchTarget(controllableProxySubscription);
                                destinationHandler.getSubscriptionIndex().remove((Object)controllableProxySubscription);
                            }
                            pubSubOutputHandler.removeTopic(stringArray[i]);
                            this.addTopicSpaceReference(sIBUuid8, destinationHandler.getUuid(), stringArray[i], bl);
                            arrayList.add(destinationHandler.getUuid());
                            arrayList2.add(stringArray[i]);
                        }
                    }
                    destinationHandler.deletePubSubOutputHandler(sIBUuid8);
                    if (neighbour == null) continue;
                    this._proxyHandler.unsubscribeEvent(arrayList, arrayList2, neighbour.getBusId(), null);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"topicSpaceDeleted");
        }
    }

    final int size() {
        return this._neighbours.size();
    }

    protected Neighbour addNeighbour(SIBUuid8 sIBUuid8, String string, Transaction transaction) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNeighbour", (Object)new Object[]{sIBUuid8, string});
        }
        Neighbour neighbour = null;
        if (this._neighbours.containsKey(sIBUuid8)) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addNeighbour", (Object)"Neighbour already exists");
            }
            return (Neighbour)this._neighbours.get(sIBUuid8);
        }
        neighbour = (Neighbour)this._recoveredNeighbours.get(sIBUuid8);
        if (neighbour != null) {
            this._recoveredNeighbours.remove(sIBUuid8);
            object = neighbour.getPubSubOutputHandlers();
            if (object != null) {
                Iterator iterator = ((HashSet)object).iterator();
                while (iterator.hasNext()) {
                    PubSubOutputHandler pubSubOutputHandler = (PubSubOutputHandler)iterator.next();
                    String[] stringArray = pubSubOutputHandler.getTopics();
                    if (stringArray == null) continue;
                    for (int i = 0; i < stringArray.length; ++i) {
                        MESubscription mESubscription = neighbour.getSubscription(pubSubOutputHandler.getTopicSpaceUuid(), stringArray[i]);
                        ControllableProxySubscription controllableProxySubscription = this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().addPubSubOutputHandlerMatchTarget(pubSubOutputHandler, pubSubOutputHandler.getTopicSpaceUuid(), pubSubOutputHandler.getTopics()[i], mESubscription.isForeignSecuredProxy(), mESubscription.getMESubUserId());
                        mESubscription.setMatchspaceSub(controllableProxySubscription);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Neighbour recovered " + neighbour));
            }
        } else {
            try {
                neighbour = new Neighbour(this._proxyHandler, sIBUuid8, string, this);
                if (transaction == null) {
                    transaction = this._proxyHandler.getMessageProcessor().getTXManager().createAutoCommitTransaction();
                }
                this._proxyHandler.addItemStream(neighbour, transaction);
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbours.addNeighbour", (String)"1:766:1.99.1.2", (Object)this);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addNeighbour", (Object)"SIResourceException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:775:1.99.1.2", messageStoreException, sIBUuid8});
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:784:1.99.1.2", messageStoreException, sIBUuid8}, null), (Throwable)((Object)messageStoreException));
            }
        }
        this._neighbours.put(sIBUuid8, neighbour);
        object = this.findBus(string);
        if (object == null) {
            object = this.createBus(string);
        }
        ((BusGroup)object).addNeighbour(neighbour);
        neighbour.setBus((BusGroup)object);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNeighbour", (Object)neighbour);
        }
        return neighbour;
    }

    protected void removeNeighbour(SIBUuid8 sIBUuid8, String string, Transaction transaction) throws SIConnectionLostException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeNeighbour", (Object)new Object[]{string, transaction});
        }
        boolean bl = false;
        Neighbour neighbour = (Neighbour)this._neighbours.get(sIBUuid8);
        if (neighbour == null) {
            bl = true;
            neighbour = (Neighbour)this._recoveredNeighbours.get(sIBUuid8);
        }
        if (neighbour != null) {
            BusGroup busGroup = neighbour.getBus();
            if (busGroup != null) {
                busGroup.removeNeighbour(neighbour);
                if (busGroup.getMembers().length == 0) {
                    this.deleteBus(busGroup);
                }
            }
            this.removeRegisteredProxies(neighbour, transaction, !bl);
            if (!bl) {
                this._neighbours.remove(sIBUuid8);
            } else {
                this._recoveredNeighbours.remove(sIBUuid8);
            }
        } else {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeNeighbour", (Object)"Neighbour Unknown");
            }
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0005", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:885:1.99.1.2", sIBUuid8});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0005", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:893:1.99.1.2", sIBUuid8}, null));
        }
        neighbour.deleteDestination();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeNeighbour");
        }
    }

    protected void removeRecoveredNeighbour(SIBUuid8 sIBUuid8, Transaction transaction) throws SIConnectionLostException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeRecoveredNeighbour", (Object)new Object[]{sIBUuid8, transaction});
        }
        Neighbour neighbour = (Neighbour)this._recoveredNeighbours.remove(sIBUuid8);
        this.removeRegisteredProxies(neighbour, transaction, false);
        neighbour.deleteDestination();
        neighbour.deleteSystemDestinations();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeRecoveredNeighbour");
        }
    }

    private void removeRegisteredProxies(Neighbour neighbour, Transaction transaction, boolean bl) throws SIResourceException {
        Hashtable hashtable;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeRegisteredProxies", (Object)new Object[]{neighbour, transaction, new Boolean(bl)});
        }
        if (!(hashtable = neighbour.getRegisteredProxies()).isEmpty()) {
            boolean bl2 = false;
            Enumeration enumeration = hashtable.elements();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<SIBUuid12> arrayList2 = new ArrayList<SIBUuid12>();
            while (enumeration.hasMoreElements()) {
                MESubscription mESubscription = (MESubscription)enumeration.nextElement();
                neighbour.proxyDeregistered(mESubscription.getTopicSpaceUuid(), mESubscription.getTopic(), transaction);
                DestinationHandler destinationHandler = this._destinationManager.getDestinationInternal(mESubscription.getTopicSpaceUuid(), false);
                boolean bl3 = this.deleteProxy(destinationHandler, mESubscription, neighbour, mESubscription.getTopicSpaceUuid(), mESubscription.getTopic(), bl, true);
                if (!bl3) continue;
                arrayList.add(mESubscription.getTopic());
                arrayList2.add(mESubscription.getTopicSpaceUuid());
                bl2 = true;
            }
            if (bl2 && bl) {
                this._proxyHandler.unsubscribeEvent(arrayList2, arrayList, neighbour.getBusId(), null);
            }
            try {
                neighbour.remove(transaction, neighbour.getLockID());
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbours.removeRegisteredProxies", (String)"1:1025:1.99.1.2", (Object)this);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeRegisteredProxies", (Object)"SIResourceException");
                }
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0003", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:1034:1.99.1.2", messageStoreException, neighbour.getUUID()});
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0003", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:1043:1.99.1.2", messageStoreException, neighbour.getUUID()}, null), (Throwable)((Object)messageStoreException));
            }
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("no proxies registered for neighbour " + neighbour.getUUID().toString()));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeRegisteredProxies");
        }
    }

    private BusGroup findBus(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findBus", (Object)string);
        }
        for (int i = 0; i < this._buses.length; ++i) {
            if (!this._buses[i].getName().equals(string)) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"findBus", (Object)this._buses[i]);
            }
            return this._buses[i];
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findBus", (Object)"null");
        }
        return null;
    }

    private BusGroup createBus(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createBus", (Object)string);
        }
        boolean bl = string.equals(this._localBusName);
        BusGroup busGroup = new BusGroup(string, this._proxyHandler, bl);
        BusGroup[] busGroupArray = this._buses;
        this._buses = new BusGroup[busGroupArray.length + 1];
        System.arraycopy(busGroupArray, 0, this._buses, 0, busGroupArray.length);
        this._buses[busGroupArray.length] = busGroup;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createBus", (Object)busGroup);
        }
        return busGroup;
    }

    private void deleteBus(BusGroup busGroup) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteBus", (Object)busGroup);
        }
        BusGroup[] busGroupArray = this._buses;
        for (int i = 0; i < this._buses.length; ++i) {
            if (!this._buses[i].equals(busGroup)) continue;
            this._buses = new BusGroup[busGroupArray.length - 1];
            if (i > 0) {
                System.arraycopy(busGroupArray, 0, this._buses, 0, i);
            }
            if (i >= busGroupArray.length - 1) break;
            System.arraycopy(busGroupArray, i + 1, this._buses, i, busGroupArray.length - 1 - i);
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteBus");
        }
    }

    Neighbour getNeighbour(SIBUuid8 sIBUuid8) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNeighbour", (Object)sIBUuid8);
        }
        Neighbour neighbour = (Neighbour)this._neighbours.get(sIBUuid8);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNeighbour", (Object)neighbour);
        }
        return neighbour;
    }

    Neighbour getRecoveredNeighbour(SIBUuid8 sIBUuid8) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRecoveredNeighbour", (Object)sIBUuid8);
        }
        Neighbour neighbour = (Neighbour)this._recoveredNeighbours.get(sIBUuid8);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getRecoveredNeighbour", (Object)neighbour);
        }
        return neighbour;
    }

    Neighbour getBusNeighbour(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBusNeighbour", (Object)string);
        }
        Neighbour neighbour = null;
        Iterator iterator = this._neighbours.keySet().iterator();
        while (iterator.hasNext()) {
            neighbour = this.getNeighbour((SIBUuid8)iterator.next());
            if (!neighbour.getBusId().equals(string)) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getBusNeighbour", (Object)neighbour);
            }
            return neighbour;
        }
        Iterator iterator2 = this._recoveredNeighbours.keySet().iterator();
        while (iterator2.hasNext()) {
            neighbour = (Neighbour)this._recoveredNeighbours.get(iterator2.next());
            if (!neighbour.getBusId().equals(string)) continue;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getBusNeighbour", (Object)neighbour);
            }
            return neighbour;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBusNeighbour", null);
        }
        return null;
    }

    protected boolean createProxy(Neighbour neighbour, DestinationHandler destinationHandler, MESubscription mESubscription, SIBUuid12 sIBUuid12, String string, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createProxy", (Object)new Object[]{neighbour, destinationHandler, mESubscription, sIBUuid12, string, new Boolean(bl)});
        }
        boolean bl2 = false;
        if (destinationHandler != null) {
            PubSubOutputHandler pubSubOutputHandler = destinationHandler.getPubSubOutputHandler(neighbour.getUUID());
            if (pubSubOutputHandler == null) {
                pubSubOutputHandler = destinationHandler.createPubSubOutputHandler(neighbour);
            }
            pubSubOutputHandler.setTopicSpaceMapping(mESubscription.getForeignTSName());
            pubSubOutputHandler.addTopic(string);
            mESubscription.registerForPostCommit(this._proxyHandler, destinationHandler, pubSubOutputHandler, neighbour);
            bl2 = true;
        } else {
            this.addTopicSpaceReference(neighbour.getUUID(), sIBUuid12, string, bl);
            mESubscription.registerForPostCommit(neighbour, this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createProxy", (Object)new Boolean(bl2));
        }
        return bl2;
    }

    protected boolean deleteProxy(DestinationHandler destinationHandler, MESubscription mESubscription, Neighbour neighbour, SIBUuid12 sIBUuid12, String string, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteProxy", (Object)new Object[]{destinationHandler, neighbour, mESubscription, sIBUuid12, string});
        }
        boolean bl3 = false;
        if (destinationHandler != null) {
            PubSubOutputHandler pubSubOutputHandler = destinationHandler.getPubSubOutputHandler(neighbour.getUUID());
            if (pubSubOutputHandler != null) {
                pubSubOutputHandler.removeTopic(string);
                if (!bl2) {
                    pubSubOutputHandler = null;
                }
                if (bl) {
                    mESubscription.registerForPostCommit(this._proxyHandler, destinationHandler, pubSubOutputHandler, neighbour);
                } else {
                    mESubscription.registerForPostCommit(null, destinationHandler, pubSubOutputHandler, neighbour);
                }
                bl3 = true;
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"PubSubOutputHandler not found");
            }
        } else {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Destination object not found");
            }
            if (bl) {
                mESubscription.registerForPostCommit(neighbour, this);
            } else {
                mESubscription.registerForPostCommit(null, destinationHandler, null, neighbour);
            }
            this.removeTopicSpaceReference(neighbour.getUUID(), mESubscription, sIBUuid12, string);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteProxy", (Object)new Boolean(bl3));
        }
        return bl3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverNeighbours() throws MessageStoreException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"recoverNeighbours");
        }
        NonLockingCursor nonLockingCursor = null;
        try {
            nonLockingCursor = this._proxyHandler.newNonLockingItemStreamCursor(new ClassEqualsFilter(Neighbour.class));
            AbstractItem abstractItem = null;
            while ((abstractItem = nonLockingCursor.next()) != null) {
                Neighbour neighbour = null;
                neighbour = (Neighbour)abstractItem;
                this._recoveredNeighbours.put(neighbour.getUUID(), neighbour);
                neighbour.intialiseNonPersistent(this._proxyHandler, this);
                neighbour.recoverSubscriptions(this._proxyHandler);
                if (neighbour.getBusId().equals(this._proxyHandler.getMessageProcessor().getMessagingEngineBus())) continue;
                ForeignBusDefinition foreignBusDefinition = this._proxyHandler.getMessageProcessor().getForeignBus(neighbour.getBusId());
                if (foreignBusDefinition != null) {
                    try {
                        VirtualLinkDefinition virtualLinkDefinition = foreignBusDefinition.getLink();
                        if (virtualLinkDefinition != null && virtualLinkDefinition.getLinkLocalitySet() != null && virtualLinkDefinition.getLinkLocalitySet().size() >= 1) {
                            try {
                                this.addNeighbour(neighbour.getUUID(), neighbour.getBusId(), null);
                                continue;
                            }
                            catch (SIException sIException) {
                                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbours.recoverNeighbours", (String)"1:1463:1.99.1.2", (Object)this);
                                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:1471:1.99.1.2", sIException}, null), (Throwable)sIException);
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.Neighbours", "1:1480:1.99.1.2", sIException});
                                if (tc.isEntryEnabled()) {
                                    SibTr.exit((TraceComponent)tc, (String)"recoverNeighbours", (Object)((Object)sIErrorException));
                                }
                                throw sIErrorException;
                            }
                        }
                        if (!tc.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)tc, (String)("Link no longer exists " + neighbour.getBusId() + " for neighbour " + neighbour.getUUID()));
                    }
                    catch (SIBExceptionNoLinkExists sIBExceptionNoLinkExists) {
                        if (!tc.isDebugEnabled()) continue;
                        SibTr.debug((TraceComponent)tc, (String)("Link no longer exists " + neighbour.getBusId() + " for neighbour " + neighbour.getUUID() + " : " + (Object)((Object)sIBExceptionNoLinkExists)));
                    }
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                SibTr.debug((TraceComponent)tc, (String)("Bus no longer exists " + neighbour.getBusId() + " for neighbour " + neighbour.getUUID()));
            }
        }
        finally {
            if (nonLockingCursor != null) {
                nonLockingCursor.finished();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"recoverNeighbours");
        }
    }

    public void resetForeignBus(String string) throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetForeignBus", (Object)string);
        }
        BusGroup busGroup = this.findBus(string);
        this.addSubscriptionsToBus(busGroup, busGroup.getName());
        SubscriptionMessage subscriptionMessage = busGroup.generateResetSubscriptionMessage();
        if (subscriptionMessage != null) {
            ExternalLocalTransaction externalLocalTransaction = this._proxyHandler.getMessageProcessor().getTXManager().createLocalTransaction();
            busGroup.sendToNeighbours(subscriptionMessage, externalLocalTransaction, false);
            externalLocalTransaction.commit();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetForeignBus");
        }
    }

    private void addSubscriptionsToBus(BusGroup busGroup, String string) throws SIResourceException {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addSubscriptionsToBus", (Object)new Object[]{busGroup, string});
        }
        ArrayList arrayList = this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().getAllCDMatchTargets();
        ListIterator listIterator = arrayList.listIterator();
        while (listIterator.hasNext()) {
            object = (ConsumerDispatcher)listIterator.next();
            busGroup.addLocalSubscription(((ConsumerDispatcher)object).getConsumerDispatcherState(), null, null, false);
        }
        object = this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().getAllPubSubOutputHandlerMatchTargets();
        ArrayList<PubSubOutputHandler> arrayList2 = new ArrayList<PubSubOutputHandler>();
        ListIterator listIterator2 = ((ArrayList)object).listIterator();
        while (listIterator2.hasNext()) {
            PubSubOutputHandler pubSubOutputHandler = (PubSubOutputHandler)listIterator2.next();
            if (arrayList2.contains(pubSubOutputHandler) || !pubSubOutputHandler.neighbourOnDifferentBus(string)) continue;
            String[] stringArray = pubSubOutputHandler.getTopics();
            SIBUuid12 sIBUuid12 = pubSubOutputHandler.getTopicSpaceUuid();
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    busGroup.addRemoteSubscription(sIBUuid12, stringArray[i], null, false);
                }
            }
            arrayList2.add(pubSubOutputHandler);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSubscriptionsToBus");
        }
    }

    protected void resetBusSubscriptionList() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetBusSubscriptionList");
        }
        for (int i = 0; i < this._buses.length; ++i) {
            BusGroup busGroup = this._buses[i];
            busGroup.reset();
            try {
                this.addSubscriptionsToBus(busGroup, busGroup.getName());
                SubscriptionMessage subscriptionMessage = busGroup.generateResetSubscriptionMessage();
                ExternalLocalTransaction externalLocalTransaction = this._proxyHandler.getMessageProcessor().getTXManager().createLocalTransaction();
                busGroup.sendToNeighbours(subscriptionMessage, externalLocalTransaction, true);
                externalLocalTransaction.commit();
                continue;
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.Neighbours.resetBusSubscriptionList", (String)"1:1766:1.99.1.2", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"resetBusSubscriptionList", (Object)((Object)sIException));
                }
                throw new SIErrorException((Throwable)sIException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetBusSubscriptionList");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/proxyhandler/Neighbours.java, SIB.processor, WAS602.SIB, o0610.11 1.99.1.2");
        }
    }

    class TemporarySubscription {
        private HashMap iMETopicList;

        TemporarySubscription(SIBUuid8 sIBUuid8, MESubscription mESubscription) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"TemporarySubscription", (Object)new Object[]{sIBUuid8, mESubscription});
            }
            this.iMETopicList = new HashMap();
            LinkedList<MESubscription> linkedList = new LinkedList<MESubscription>();
            linkedList.add(mESubscription);
            this.iMETopicList.put(sIBUuid8, linkedList);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"TemporarySubscription", (Object)this);
            }
        }

        protected void addTopic(SIBUuid8 sIBUuid8, MESubscription mESubscription) {
            LinkedList<MESubscription> linkedList;
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"addTopic", (Object)new Object[]{sIBUuid8, mESubscription});
            }
            if ((linkedList = (LinkedList<MESubscription>)this.iMETopicList.get(sIBUuid8)) == null) {
                linkedList = new LinkedList<MESubscription>();
            }
            linkedList.add(mESubscription);
            this.iMETopicList.put(sIBUuid8, linkedList);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addTopic");
            }
        }

        protected boolean removeTopic(SIBUuid8 sIBUuid8, MESubscription mESubscription) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"removeTopic", (Object)new Object[]{sIBUuid8, mESubscription});
            }
            boolean bl = false;
            List list = (List)this.iMETopicList.get(sIBUuid8);
            if (list != null) {
                list.remove(mESubscription);
                if (list.isEmpty()) {
                    this.iMETopicList.remove(sIBUuid8);
                    bl = this.iMETopicList.isEmpty();
                }
            }
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeTopic", (Object)new Boolean(bl));
            }
            return bl;
        }
    }
}

