/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.SIDestinationAddress;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.proxyhandler.BusGroup;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.processor.proxyhandler.NeighbourProxyListener;
import com.ibm.ws.sib.processor.proxyhandler.Neighbours;
import com.ibm.ws.sib.processor.proxyhandler.SubscriptionMessageHandler;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.ws.util.ObjectPool;
import com.ibm.wsspi.sib.core.AsynchConsumerCallback;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SIRollbackException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;

public final class MultiMEProxyHandler
extends SIMPItemStream {
    private static final int NUM_MESSAGES = 2;
    private static final TraceComponent tc = SibTr.register((Class)MultiMEProxyHandler.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Neighbours _neighbours = null;
    private MessageProcessor _messageProcessor;
    private ObjectPool _subscriptionMessagePool;
    private NeighbourProxyListener _proxyListener;
    private LockManager _lockManager;
    private ConsumerSession _proxyAsyncConsumer;
    private SIMPTransactionManager _transactionManager;
    private boolean _reconciling = false;
    private boolean _started = false;

    public MultiMEProxyHandler() {
    }

    public MultiMEProxyHandler(MessageProcessor messageProcessor, SIMPTransactionManager sIMPTransactionManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MultiMEProxyHandler", (Object)new Object[]{messageProcessor, sIMPTransactionManager});
        }
        this.initialiseNonPersistent(messageProcessor, sIMPTransactionManager);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MultiMEProxyHandler", (Object)this);
        }
    }

    public void initialiseNonPersistent(MessageProcessor messageProcessor, SIMPTransactionManager sIMPTransactionManager) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialiseNonPersistent", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        this._subscriptionMessagePool = new ObjectPool("SubscriptionMessages", 2);
        this._neighbours = new Neighbours(this, this._messageProcessor.getMessagingEngineBus());
        this._lockManager = new LockManager();
        this._transactionManager = sIMPTransactionManager;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialiseNonPersistent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initalised() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initalised");
        }
        try {
            this._lockManager.lockExclusive();
            this._started = true;
            if (this._proxyListener == null) {
                this.createProxyListener();
            }
            this._reconciling = false;
            this._neighbours.resetBusSubscriptionList();
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initalised");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        try {
            this._lockManager.lockExclusive();
            this._started = false;
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void removeUnusedNeighbours() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeUnusedNeighbours");
        }
        Enumeration enumeration = this._neighbours.getAllRecoveredNeighbours();
        ExternalLocalTransaction externalLocalTransaction = null;
        try {
            this._lockManager.lockExclusive();
            externalLocalTransaction = this._transactionManager.createLocalTransaction();
            while (enumeration.hasMoreElements()) {
                Neighbour neighbour = (Neighbour)enumeration.nextElement();
                if (this._messageProcessor.getDestinationManager().getLinkDefinition(neighbour.getBusId()) != null) continue;
                this._neighbours.removeRecoveredNeighbour(neighbour.getUUID(), externalLocalTransaction);
            }
            externalLocalTransaction.commit();
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler.removeUnusedNeighbours", (String)"1:367:1.85", (Object)this);
            try {
                if (externalLocalTransaction != null) {
                    externalLocalTransaction.rollback();
                }
            }
            catch (SIException sIException2) {
                FFDCFilter.processException((Throwable)sIException2, (String)"com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler.removeUnusedNeighbours", (String)"1:381:1.85", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException2));
            }
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"removeUnusedNeighbours", (Object)"SIErrorException");
            }
            throw new SIErrorException((Throwable)sIException);
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeUnusedNeighbours");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeEvent(ConsumerDispatcherState consumerDispatcherState, Transaction transaction, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"subscribeEvent", (Object)new Object[]{consumerDispatcherState, transaction, new Boolean(bl)});
        }
        try {
            this._lockManager.lock();
            if (!this._started) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"subscribeEvent", (Object)"Returning as stopped");
                }
                return;
            }
            BusGroup[] busGroupArray = this._neighbours.getAllBuses();
            SubscriptionMessageHandler subscriptionMessageHandler = null;
            if (!this._reconciling) {
                for (int i = 0; i < busGroupArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Forwarding topic " + consumerDispatcherState.getTopic() + " to Bus " + busGroupArray[i]));
                    }
                    subscriptionMessageHandler = busGroupArray[i].addLocalSubscription(consumerDispatcherState, subscriptionMessageHandler, transaction, bl);
                }
            }
            if (subscriptionMessageHandler != null) {
                this.addMessageHandler(subscriptionMessageHandler);
            }
        }
        finally {
            this._lockManager.unlock();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"subscribeEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void subscribeEvent(List list, List list2, String string, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"subscribeEvent", (Object)new Object[]{list2, list, string, transaction});
        }
        try {
            this._lockManager.lock();
            if (!this._started) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"subscribeEvent", (Object)"Returning as stopped");
                }
                return;
            }
            if (!this._reconciling) {
                this.remoteSubscribeEvent(list, list2, string, transaction, true);
            }
        }
        finally {
            this._lockManager.unlock();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"subscribeEvent");
        }
    }

    protected void remoteSubscribeEvent(List list, List list2, String string, Transaction transaction, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remoteSubscribeEvent", (Object)new Object[]{list, list2, string, transaction});
        }
        BusGroup[] busGroupArray = this._neighbours.getAllBuses();
        for (int i = 0; i < busGroupArray.length; ++i) {
            if (busGroupArray[i].getName().equals(string)) continue;
            SubscriptionMessageHandler subscriptionMessageHandler = null;
            ListIterator listIterator = list2.listIterator();
            ListIterator listIterator2 = list.listIterator();
            while (listIterator.hasNext()) {
                SIBUuid12 sIBUuid12 = (SIBUuid12)listIterator2.next();
                String string2 = (String)listIterator.next();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Forwarding topic " + sIBUuid12 + string2 + " to bus " + busGroupArray[i]));
                }
                subscriptionMessageHandler = busGroupArray[i].addRemoteSubscription(sIBUuid12, string2, subscriptionMessageHandler, bl);
            }
            if (subscriptionMessageHandler == null) continue;
            busGroupArray[i].sendToNeighbours(subscriptionMessageHandler.getSubscriptionMessage(), transaction, false);
            this.addMessageHandler(subscriptionMessageHandler);
            subscriptionMessageHandler = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remoteSubscribeEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeEvent(ConsumerDispatcherState consumerDispatcherState, Transaction transaction, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unsubscribeEvent", (Object)new Object[]{consumerDispatcherState, transaction, new Boolean(bl)});
        }
        try {
            this._lockManager.lock();
            if (!this._started) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"unsubscribeEvent", (Object)"Returning as stopped");
                }
                return;
            }
            BusGroup[] busGroupArray = this._neighbours.getAllBuses();
            SubscriptionMessageHandler subscriptionMessageHandler = null;
            if (!this._reconciling) {
                for (int i = 0; i < busGroupArray.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Forwarding topic " + consumerDispatcherState.getTopicSpaceUuid() + ":" + consumerDispatcherState.getTopic() + " to Bus " + busGroupArray[i]));
                    }
                    subscriptionMessageHandler = busGroupArray[i].removeLocalSubscription(consumerDispatcherState, subscriptionMessageHandler, transaction, bl);
                }
            }
            if (subscriptionMessageHandler != null) {
                this.addMessageHandler(subscriptionMessageHandler);
            }
        }
        finally {
            this._lockManager.unlock();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unsubscribeEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeEvent(List list, List list2, String string, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unsubscribeEvent", (Object)new Object[]{list, list2, string});
        }
        try {
            this._lockManager.lock();
            if (!this._started) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"unsubscribeEvent", (Object)"Returning as stopped");
                }
                return;
            }
            if (!this._reconciling) {
                this.remoteUnsubscribeEvent(list, list2, string, transaction, true);
            }
        }
        finally {
            this._lockManager.unlock();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unsubscribeEvent");
        }
    }

    protected void remoteUnsubscribeEvent(List list, List list2, String string, Transaction transaction, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remoteUnsubscribeEvent", (Object)new Object[]{list, list2, string, transaction});
        }
        BusGroup[] busGroupArray = this._neighbours.getAllBuses();
        for (int i = 0; i < busGroupArray.length; ++i) {
            if (busGroupArray[i].getName().equals(string)) continue;
            SubscriptionMessageHandler subscriptionMessageHandler = null;
            ListIterator listIterator = list2.listIterator();
            ListIterator listIterator2 = list.listIterator();
            while (listIterator.hasNext()) {
                SIBUuid12 sIBUuid12 = (SIBUuid12)listIterator2.next();
                String string2 = (String)listIterator.next();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Forwarding topic " + sIBUuid12 + ":" + string2 + " to Bus " + busGroupArray[i]));
                }
                if ((subscriptionMessageHandler = busGroupArray[i].removeRemoteSubscription(sIBUuid12, string2, subscriptionMessageHandler, bl)) == null) continue;
                busGroupArray[i].sendToNeighbours(subscriptionMessageHandler.getSubscriptionMessage(), transaction, false);
                this.addMessageHandler(subscriptionMessageHandler);
                subscriptionMessageHandler = null;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remoteUnsubscribeEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void topicSpaceCreatedEvent(DestinationHandler destinationHandler) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"topicSpaceCreatedEvent", (Object)destinationHandler);
        }
        try {
            this._lockManager.lockExclusive();
            this._neighbours.topicSpaceCreated(destinationHandler);
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"topicSpaceCreatedEvent");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void topicSpaceDeletedEvent(DestinationHandler destinationHandler) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"topicSpaceDeletedEvent", (Object)destinationHandler);
        }
        try {
            this._lockManager.lockExclusive();
            this._neighbours.topicSpaceDeleted(destinationHandler);
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"topicSpaceDeletedEvent");
        }
    }

    public void linkStarted(String string, SIBUuid8 sIBUuid8) throws SIIncorrectCallException, SIErrorException, SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException {
        Neighbour neighbour;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"linkStarted", (Object)new Object[]{string, sIBUuid8});
        }
        if ((neighbour = this.getNeighbour(sIBUuid8)) == null) {
            ExternalLocalTransaction externalLocalTransaction = this._transactionManager.createLocalTransaction();
            neighbour = this.createNeighbour(sIBUuid8, string, externalLocalTransaction);
            externalLocalTransaction.commit();
        }
        this._neighbours.resetBusSubscriptionList();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"linkStarted");
        }
    }

    public void cleanupLinkNeighbour(String string) throws SIRollbackException, SIConnectionLostException, SIIncorrectCallException, SIResourceException, SIErrorException {
        Neighbour neighbour;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"cleanupLinkNeighbour");
        }
        if ((neighbour = this._neighbours.getBusNeighbour(string)) != null) {
            ExternalLocalTransaction externalLocalTransaction = this._messageProcessor.getTXManager().createLocalTransaction();
            this.deleteNeighbourForced(neighbour.getUUID(), string, externalLocalTransaction);
            externalLocalTransaction.commit();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"cleanupLinkNeighbour");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Neighbour createNeighbour(SIBUuid8 sIBUuid8, String string, Transaction transaction) throws SIDiscriminatorSyntaxException, SISelectorSyntaxException, SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createNeighbour", (Object)new Object[]{sIBUuid8, string, transaction});
        }
        Neighbour neighbour = null;
        try {
            this._lockManager.lockExclusive();
            neighbour = this._neighbours.addNeighbour(sIBUuid8, string, transaction);
            if (!this._reconciling && this._proxyListener == null) {
                this.createProxyListener();
            }
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createNeighbour", (Object)neighbour);
        }
        return neighbour;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNeighbourForced(SIBUuid8 sIBUuid8, String string, Transaction transaction) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deleteNeighbourForced", (Object)new Object[]{sIBUuid8, string, transaction});
        }
        try {
            this._lockManager.lockExclusive();
            this._neighbours.removeNeighbour(sIBUuid8, string, transaction);
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteNeighbourForced");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetNeighbourState(SIBUuid8 sIBUuid8) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetNeighbourState");
        }
        try {
            this._lockManager.lockExclusive();
            Neighbour neighbour = this._neighbours.getNeighbour(sIBUuid8);
            neighbour.sendResetProxySubscriptions();
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetNeighbourState");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverNeighbours() throws SIResourceException, MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"recoverNeighbours");
        }
        try {
            this._lockManager.lockExclusive();
            this._reconciling = true;
            this._neighbours.recoverNeighbours();
        }
        finally {
            this._lockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"recoverNeighbours");
        }
    }

    Enumeration reportAllNeighbours() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reportAllNeighbours");
        }
        Enumeration enumeration = this._neighbours.getAllNeighbours();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reportAllNeighbours");
        }
        return enumeration;
    }

    protected BusGroup[] getAllBusGroups() {
        return this._neighbours.getAllBuses();
    }

    final ObjectPool getMessageObjectPool() {
        return this._subscriptionMessagePool;
    }

    void addMessageHandler(SubscriptionMessageHandler subscriptionMessageHandler) {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addMessageHandler", (Object)subscriptionMessageHandler);
        }
        if (!(bl = this._subscriptionMessagePool.add((Object)subscriptionMessageHandler)) && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"SubscriptionObjectPool size exceeded");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addMessageHandler");
        }
    }

    SubscriptionMessageHandler getMessageHandler() {
        SubscriptionMessageHandler subscriptionMessageHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessageHandler");
        }
        if ((subscriptionMessageHandler = (SubscriptionMessageHandler)this._subscriptionMessagePool.remove()) == null) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"doProxySubscribeOp", (Object)"Creating a new Message Handler as none available");
            }
            subscriptionMessageHandler = new SubscriptionMessageHandler(this);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMessageHandler", (Object)subscriptionMessageHandler);
        }
        return subscriptionMessageHandler;
    }

    private void createProxyListener() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createProxyListener");
        }
        this._proxyListener = new NeighbourProxyListener(this._neighbours, this);
        try {
            this._proxyAsyncConsumer = this._messageProcessor.getSystemConnection().createSystemConsumerSession((SIDestinationAddress)this._messageProcessor.getProxyHandlerDestAddr(), null, null, Reliability.ASSURED_PERSISTENT, false, false, null, false);
            this._proxyAsyncConsumer.registerAsynchConsumerCallback((AsynchConsumerCallback)this._proxyListener, 0, 0L, 1, null);
            this._proxyAsyncConsumer.start(false);
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler.createProxyListener", (String)"1:1324:1.85", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"createProxyListener", (Object)"SIResourceException");
            }
            throw new SIResourceException((Throwable)sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createProxyListener");
        }
    }

    public NeighbourProxyListener getProxyListener() {
        return this._proxyListener;
    }

    final MessageProcessor getMessageProcessor() {
        return this._messageProcessor;
    }

    public final Neighbour getNeighbour(SIBUuid8 sIBUuid8) {
        return this._neighbours.getNeighbour(sIBUuid8);
    }

    final Neighbours getNeighbours() {
        return this._neighbours;
    }

    final SIMPTransactionManager getTransactionManager() {
        return this._transactionManager;
    }

    public String toString() {
        return "Instance " + super.toString();
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        formattedWriter.write(this.toString());
    }

    protected LockManager getLockManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLockManager");
            SibTr.exit((TraceComponent)tc, (String)"getLockManager", (Object)this._lockManager);
        }
        return this._lockManager;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/proxyhandler/MultiMEProxyHandler.java, SIB.processor, WAS602.SIB, o0610.11 1.85");
        }
    }
}

