/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.ControllableProxySubscription;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.store.items.SIMPItem;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.processor.proxyhandler.Neighbours;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public final class MESubscription
extends SIMPItem {
    static final int NOP = 0;
    static final int SUBSCRIBE = 1;
    static final int UNSUBSCRIBE = 2;
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)MESubscription.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 1;
    private String _topic;
    private SIBUuid12 _topicSpaceUuid;
    private String _topicSpaceName;
    private String _foreignTopicSpaceName;
    private int _refCount;
    private boolean _marked = false;
    private MultiMEProxyHandler _proxyHandler;
    private PubSubOutputHandler _handler;
    private Neighbour _neighbour;
    private Neighbours _neighbours;
    DestinationHandler _destination;
    private boolean _foreignSecuredProxy;
    private String _meSubUserId;
    private ControllableProxySubscription _controllableProxySubscription = null;

    public MESubscription() {
    }

    MESubscription(SIBUuid12 sIBUuid12, String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MESubscription", (Object)new Object[]{sIBUuid12, string, string2, string3});
        }
        this._topicSpaceUuid = sIBUuid12;
        this._topic = string2;
        this._foreignTopicSpaceName = string3;
        this._foreignSecuredProxy = false;
        this._meSubUserId = null;
        this._topicSpaceName = string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MESubscription", (Object)this);
        }
    }

    MESubscription(SIBUuid12 sIBUuid12, String string, String string2, String string3, boolean bl, String string4) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MESubscription", (Object)new Object[]{sIBUuid12, string, string2, string3, new Boolean(bl), string4});
        }
        this._topicSpaceUuid = sIBUuid12;
        this._topic = string2;
        this._foreignTopicSpaceName = string3;
        this._foreignSecuredProxy = bl;
        this._meSubUserId = string4;
        this._topicSpaceName = string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MESubscription", (Object)this);
        }
    }

    int addRef() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addRef");
        }
        int n = 0;
        if (this._refCount++ == 0) {
            n = 1;
        }
        this.checkRefCount();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addRef", (Object)(String.valueOf(n) + ":" + String.valueOf(this._refCount)));
        }
        return n;
    }

    int removeRef() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeRef");
        }
        int n = 0;
        if (--this._refCount == 0) {
            n = 2;
        }
        this.checkRefCount();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeRef", (Object)(String.valueOf(n) + ":" + String.valueOf(this._refCount)));
        }
        return n;
    }

    final String getTopic() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopic");
            SibTr.exit((TraceComponent)tc, (String)"getTopic", (Object)this._topic);
        }
        return this._topic;
    }

    private final void checkRefCount() {
        if (this._refCount < 0) {
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:329:1.51"});
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:336:1.51"}, null));
        }
    }

    final SIBUuid12 getTopicSpaceUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpaceUuid");
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpaceUuid", (Object)this._topicSpaceUuid);
        }
        return this._topicSpaceUuid;
    }

    final String getTopicSpaceName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTopicSpaceName");
            SibTr.exit((TraceComponent)tc, (String)"getTopicSpaceName", (Object)this._topicSpaceName);
        }
        return this._topicSpaceName;
    }

    final String getMESubUserId() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMESubUserId");
            SibTr.exit((TraceComponent)tc, (String)"getMESubUserId", (Object)this._meSubUserId);
        }
        return this._meSubUserId;
    }

    public void setMESubUserId(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMESubUserId", (Object)string);
        }
        this._meSubUserId = string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMESubUserId");
        }
    }

    final boolean isForeignSecuredProxy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isForeignSecuredProxy");
            SibTr.exit((TraceComponent)tc, (String)"isForeignSecuredProxy", (Object)new Boolean(this._foreignSecuredProxy));
        }
        return this._foreignSecuredProxy;
    }

    public void setForeignSecuredProxy(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setForeignSecuredProxy", (Object)new Boolean(bl));
        }
        this._foreignSecuredProxy = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setForeignSecuredProxy");
        }
    }

    void mark() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"mark");
            SibTr.exit((TraceComponent)tc, (String)"mark");
        }
        this._marked = true;
    }

    void unmark() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unmark");
            SibTr.exit((TraceComponent)tc, (String)"unmark");
        }
        this._marked = false;
    }

    boolean isMarked() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isMarked");
            SibTr.exit((TraceComponent)tc, (String)"isMarked", (Object)new Boolean(this._marked));
        }
        return this._marked;
    }

    public String toString() {
        return "MESubscription to topicspace " + this._topicSpaceUuid + " topic " + this._topic + " Count " + this._refCount;
    }

    public int getStorageStrategy() {
        return 4;
    }

    protected void registerForPostCommit(MultiMEProxyHandler multiMEProxyHandler, DestinationHandler destinationHandler, PubSubOutputHandler pubSubOutputHandler, Neighbour neighbour) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForPostCommit", (Object)new Object[]{multiMEProxyHandler, destinationHandler, pubSubOutputHandler, neighbour});
        }
        this._proxyHandler = multiMEProxyHandler;
        this._destination = destinationHandler;
        this._handler = pubSubOutputHandler;
        this._neighbour = neighbour;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForPostCommit");
        }
    }

    protected void registerForPostCommit(Neighbour neighbour, Neighbours neighbours) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForPostCommit", (Object)new Object[]{neighbour, neighbours});
        }
        this._proxyHandler = null;
        this._destination = null;
        this._handler = null;
        this._neighbour = neighbour;
        this._neighbours = neighbours;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForPostCommit");
        }
    }

    public void eventPostCommitAdd(Transaction transaction) {
        super.eventPostCommitAdd(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)transaction);
        }
        try {
            if (this._proxyHandler != null) {
                this._controllableProxySubscription = this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().addPubSubOutputHandlerMatchTarget(this._handler, this._topicSpaceUuid, this._topic, this._foreignSecuredProxy, this._meSubUserId);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.MESubscription.eventPostCommitAdd", (String)"1:588:1.51", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:595:1.51", sIException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:605:1.51", sIException}, null), (Throwable)sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd");
        }
    }

    public void eventPostCommitRemove(Transaction transaction) {
        super.eventPostCommitRemove(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitRemove", (Object)transaction);
        }
        if (this._proxyHandler != null) {
            this._destination.getSubscriptionIndex().remove((Object)this._controllableProxySubscription);
            this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().removePubSubOutputHandlerMatchTarget(this._controllableProxySubscription);
        }
        if (this._handler != null && (this._handler.getTopics() == null || this._handler.getTopics().length == 0)) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Deleting PubSubOutputHandler " + this._handler));
            }
            this._destination.deletePubSubOutputHandler(this._neighbour.getUUID());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove");
        }
    }

    public void eventPostRollbackAdd(Transaction transaction) {
        super.eventPostRollbackAdd(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)transaction);
        }
        if (this._handler != null) {
            this._handler.removeTopic(this._topic);
            if (this._handler.getTopics() == null || this._handler.getTopics().length == 0) {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Deleting PubSubOutputHandler " + this._handler));
                }
                this._destination.deletePubSubOutputHandler(this._neighbour.getUUID());
            }
        } else if (this._neighbours != null) {
            this._neighbours.removeTopicSpaceReference(this._neighbour.getUUID(), this, this._topicSpaceUuid, this._topic);
        }
        this._neighbour.removeSubscription(this._topicSpaceUuid, this._topic);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackAdd");
        }
    }

    public void eventPostRollbackRemove(Transaction transaction) {
        super.eventPostRollbackRemove(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)transaction);
        }
        this._neighbour.addSubscription(this._topicSpaceUuid, this._topic, this);
        if (this._handler != null) {
            this._handler.addTopic(this._topic);
        } else if (this._neighbours != null) {
            this._neighbours.addTopicSpaceReference(this._neighbour.getUUID(), this._topicSpaceUuid, this._topic, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove");
        }
    }

    public void eventPostCommitUpdate(Transaction transaction) {
        super.eventPostCommitAdd(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitUpdate", (Object)transaction);
        }
        if (this._proxyHandler != null) {
            this._destination.getSubscriptionIndex().remove((Object)this._controllableProxySubscription);
            this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().removePubSubOutputHandlerMatchTarget(this._controllableProxySubscription);
        }
        try {
            if (this._proxyHandler != null) {
                this._controllableProxySubscription = this._proxyHandler.getMessageProcessor().getMessageProcessorMatching().addPubSubOutputHandlerMatchTarget(this._handler, this._topicSpaceUuid, this._topic, this._foreignSecuredProxy, this._meSubUserId);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.MESubscription.eventPostCommitUpdate", (String)"1:769:1.51", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:776:1.51", sIException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostCommitUpdate", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:786:1.51", sIException}, null), (Throwable)sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitUpdate");
        }
    }

    public void restore(ObjectInputStream objectInputStream, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{objectInputStream, new Integer(n)});
        }
        try {
            HashMap hashMap = (HashMap)objectInputStream.readObject();
            this._topicSpaceUuid = new SIBUuid12((String)hashMap.get("iTopicSpace"));
            this._topic = (String)hashMap.get("iTopic");
            this._foreignTopicSpaceName = (String)hashMap.get("iForeignTopicSpaceName");
            if (hashMap.containsKey("isForeignSecuredProxy")) {
                this._foreignSecuredProxy = (Boolean)hashMap.get("isForeignSecuredProxy");
                this._meSubUserId = (String)hashMap.get("MESubUserId");
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.proxyhandler.MESubscription.restore", (String)"1:823:1.51", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:835:1.51", exception}, null), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public int getPersistentVersion() {
        return 1;
    }

    public void getPersistentData(ObjectOutputStream objectOutputStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)objectOutputStream);
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("iTopicSpace", this._topicSpaceUuid.toString());
            hashMap.put("iTopic", this._topic);
            hashMap.put("iForeignTopicSpaceName", this._foreignTopicSpaceName);
            hashMap.put("isForeignSecuredProxy", new Boolean(this._foreignSecuredProxy));
            hashMap.put("MESubUserId", this._meSubUserId);
            objectOutputStream.writeObject(hashMap);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.processor.proxyhandler.MESubscription.getPersistentData", (String)"1:879:1.51", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)iOException);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:886:1.51", iOException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.proxyhandler.MESubscription", "1:896:1.51", iOException}, null), (Throwable)iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        formattedWriter.write(this.toString());
    }

    final String getForeignTSName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getForeignTSName");
            SibTr.exit((TraceComponent)tc, (String)"getForeignTSName", (Object)this._foreignTopicSpaceName);
        }
        return this._foreignTopicSpaceName;
    }

    public void setMatchspaceSub(ControllableProxySubscription controllableProxySubscription) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMatchspaceSub", (Object)((Object)controllableProxySubscription));
        }
        this._controllableProxySubscription = controllableProxySubscription;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMatchspaceSub");
        }
    }

    public ControllableProxySubscription getMatchspaceSub() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMatchspaceSub");
            SibTr.exit((TraceComponent)tc, (String)"getMatchspaceSub", (Object)((Object)this._controllableProxySubscription));
        }
        return this._controllableProxySubscription;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/proxyhandler/MESubscription.java, SIB.processor, WAS602.SIB, o0610.11 1.51");
        }
    }
}

