/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.proxyhandler;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.SubscriptionMessage;
import com.ibm.ws.sib.mfp.control.SubscriptionMessageType;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcherState;
import com.ibm.ws.sib.processor.proxyhandler.MESubscription;
import com.ibm.ws.sib.processor.proxyhandler.MultiMEProxyHandler;
import com.ibm.ws.sib.processor.proxyhandler.Neighbour;
import com.ibm.ws.sib.processor.proxyhandler.SubscriptionMessageHandler;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Enumeration;
import java.util.Hashtable;

final class BusGroup {
    private static final TraceComponent tc = SibTr.register((Class)BusGroup.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private Hashtable iLocalSubscriptions = new Hashtable();
    private Hashtable iRemoteSubscriptions = new Hashtable();
    private String iBusName;
    private Neighbour[] iNeighbours = new Neighbour[0];
    private MultiMEProxyHandler iProxyHandler;
    private Object subscriptionLock = new Object();
    private boolean isLocalBus;

    BusGroup(String string, MultiMEProxyHandler multiMEProxyHandler, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"BusGroup", (Object)new Object[]{string, multiMEProxyHandler, new Boolean(bl)});
        }
        this.iBusName = string;
        this.iProxyHandler = multiMEProxyHandler;
        this.isLocalBus = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"BusGroup", (Object)this);
        }
    }

    final String getName() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getName");
            SibTr.exit((TraceComponent)tc, (String)"getName", (Object)this.iBusName);
        }
        return this.iBusName;
    }

    Neighbour[] getMembers() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMembers");
            SibTr.exit((TraceComponent)tc, (String)"getMembers");
        }
        return this.iNeighbours;
    }

    Hashtable getLocalSubscriptions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLocalSubscriptions");
            SibTr.exit((TraceComponent)tc, (String)"getLocalSubscriptions", (Object)this.iLocalSubscriptions);
        }
        return (Hashtable)this.iLocalSubscriptions.clone();
    }

    Hashtable getRemoteSubscriptions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getRemoteSubscriptions");
            SibTr.exit((TraceComponent)tc, (String)"getRemoteSubscriptions", (Object)this.iRemoteSubscriptions);
        }
        return (Hashtable)this.iRemoteSubscriptions.clone();
    }

    SubscriptionMessageHandler addLocalSubscription(ConsumerDispatcherState consumerDispatcherState, SubscriptionMessageHandler subscriptionMessageHandler, Transaction transaction, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addLocalSubscription", (Object)new Object[]{consumerDispatcherState, subscriptionMessageHandler, transaction, new Boolean(bl)});
        }
        if ((subscriptionMessageHandler = this.addSubscription(consumerDispatcherState.getTopicSpaceUuid(), consumerDispatcherState.getTopic(), subscriptionMessageHandler, this.iLocalSubscriptions, bl)) != null && bl) {
            this.sendToNeighbours(subscriptionMessageHandler.getSubscriptionMessage(), transaction, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addLocalSubscription");
        }
        return subscriptionMessageHandler;
    }

    SubscriptionMessageHandler addRemoteSubscription(SIBUuid12 sIBUuid12, String string, SubscriptionMessageHandler subscriptionMessageHandler, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addRemoteSubscription", (Object)new Object[]{sIBUuid12, string, subscriptionMessageHandler});
        }
        subscriptionMessageHandler = this.addSubscription(sIBUuid12, string, subscriptionMessageHandler, this.iRemoteSubscriptions, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addRemoteSubscription", (Object)subscriptionMessageHandler);
        }
        return subscriptionMessageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubscriptionMessageHandler addSubscription(SIBUuid12 sIBUuid12, String string, SubscriptionMessageHandler subscriptionMessageHandler, Hashtable hashtable, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addSubscription", (Object)new Object[]{sIBUuid12, string, subscriptionMessageHandler, hashtable, new Boolean(bl)});
        }
        String string2 = BusGroup.subscriptionKey(sIBUuid12, string);
        Object object = this.subscriptionLock;
        synchronized (object) {
            Object object2;
            MESubscription mESubscription = (MESubscription)hashtable.get(string2);
            String string3 = null;
            try {
                object2 = this.iProxyHandler.getMessageProcessor().getDestinationManager().getDestination(sIBUuid12, false);
                if (object2 != null) {
                    string3 = object2.getName();
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.proxyhandler.BusGroup.addSubscription", (String)"1:353:1.43", (Object)this);
                SIErrorException sIErrorException = new SIErrorException((Throwable)sIException);
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"addSubscription", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
            if (string3 != null && (object2 = this.iProxyHandler.getMessageProcessor().getDestinationManager().getTopicSpaceMapping(this.iBusName, sIBUuid12)) != null) {
                if (mESubscription == null) {
                    mESubscription = new MESubscription(sIBUuid12, string3, string, (String)object2);
                    hashtable.put(string2, mESubscription);
                }
                subscriptionMessageHandler = this.doProxySubscribeOp(mESubscription.addRef(), mESubscription, subscriptionMessageHandler, hashtable, bl);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addSubscription");
        }
        return subscriptionMessageHandler;
    }

    SubscriptionMessageHandler removeLocalSubscription(ConsumerDispatcherState consumerDispatcherState, SubscriptionMessageHandler subscriptionMessageHandler, Transaction transaction, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeLocalSubscription", (Object)new Object[]{consumerDispatcherState, subscriptionMessageHandler, new Boolean(bl), transaction});
        }
        if ((subscriptionMessageHandler = this.removeSubscription(consumerDispatcherState.getTopicSpaceUuid(), consumerDispatcherState.getTopic(), subscriptionMessageHandler, this.iLocalSubscriptions, bl)) != null && bl) {
            this.sendToNeighbours(subscriptionMessageHandler.getSubscriptionMessage(), transaction, false);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeLocalSubscription", (Object)subscriptionMessageHandler);
        }
        return subscriptionMessageHandler;
    }

    SubscriptionMessageHandler removeRemoteSubscription(SIBUuid12 sIBUuid12, String string, SubscriptionMessageHandler subscriptionMessageHandler, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeRemoteSubscription", (Object)new Object[]{sIBUuid12, string, subscriptionMessageHandler});
        }
        subscriptionMessageHandler = this.removeSubscription(sIBUuid12, string, subscriptionMessageHandler, this.iRemoteSubscriptions, bl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeRemoteSubscription", (Object)subscriptionMessageHandler);
        }
        return subscriptionMessageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SubscriptionMessageHandler removeSubscription(SIBUuid12 sIBUuid12, String string, SubscriptionMessageHandler subscriptionMessageHandler, Hashtable hashtable, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeSubscription", (Object)new Object[]{sIBUuid12, string, subscriptionMessageHandler, hashtable, new Boolean(bl)});
        }
        String string2 = BusGroup.subscriptionKey(sIBUuid12, string);
        Object object = this.subscriptionLock;
        synchronized (object) {
            MESubscription mESubscription = (MESubscription)hashtable.get(string2);
            if (mESubscription == null) {
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeSubscription", (Object)("Non Existent Subscription " + sIBUuid12 + ":" + string));
                }
                return subscriptionMessageHandler;
            }
            subscriptionMessageHandler = this.doProxySubscribeOp(mESubscription.removeRef(), mESubscription, subscriptionMessageHandler, hashtable, bl);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeSubscription", (Object)subscriptionMessageHandler);
        }
        return subscriptionMessageHandler;
    }

    protected void sendToNeighbours(SubscriptionMessage subscriptionMessage, Transaction transaction, boolean bl) throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToNeighbours", (Object)new Object[]{subscriptionMessage, transaction, new Boolean(bl)});
        }
        for (int i = 0; i < this.iNeighbours.length; ++i) {
            if (bl) {
                subscriptionMessage.setSubscriptionMessageType(SubscriptionMessageType.REQUEST);
                this.iNeighbours[i].setRequestedProxySubscriptions();
            }
            this.iNeighbours[i].sendToNeighbour((JsMessage)subscriptionMessage, transaction);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToNeighbours");
        }
    }

    void addNeighbour(Neighbour neighbour) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNeighbour", (Object)neighbour);
        }
        Neighbour[] neighbourArray = new Neighbour[this.iNeighbours.length + 1];
        System.arraycopy(this.iNeighbours, 0, neighbourArray, 0, this.iNeighbours.length);
        neighbourArray[this.iNeighbours.length] = neighbour;
        this.iNeighbours = neighbourArray;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNeighbour");
        }
    }

    void removeNeighbour(Neighbour neighbour) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeNeighbour", (Object)neighbour);
        }
        Neighbour[] neighbourArray = this.iNeighbours;
        for (int i = 0; i < this.iNeighbours.length; ++i) {
            if (!this.iNeighbours[i].equals(neighbour)) continue;
            neighbourArray = new Neighbour[this.iNeighbours.length - 1];
            System.arraycopy(this.iNeighbours, 0, neighbourArray, 0, i);
            System.arraycopy(this.iNeighbours, i + 1, neighbourArray, i, this.iNeighbours.length - i - 1);
            this.iNeighbours = neighbourArray;
            break;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeNeighbour");
        }
    }

    private SubscriptionMessageHandler doProxySubscribeOp(int n, MESubscription mESubscription, SubscriptionMessageHandler subscriptionMessageHandler, Hashtable hashtable, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"doProxySubscribeOp", (Object)new Object[]{new Integer(n), mESubscription, subscriptionMessageHandler, new Boolean(bl)});
        }
        if (!bl) {
            if (n == 2) {
                hashtable.remove(BusGroup.subscriptionKey(mESubscription.getTopicSpaceUuid(), mESubscription.getTopic()));
            }
            n = 0;
        }
        switch (n) {
            case 1: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Publishing new Subscription " + mESubscription + "," + bl));
                }
                if (subscriptionMessageHandler == null) {
                    subscriptionMessageHandler = this.iProxyHandler.getMessageHandler();
                    subscriptionMessageHandler.resetCreateSubscriptionMessage(mESubscription, this.isLocalBus);
                    break;
                }
                subscriptionMessageHandler.addSubscriptionToMessage(mESubscription, this.isLocalBus);
                break;
            }
            case 2: {
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Publishing Delete subscription " + mESubscription + "," + bl));
                }
                subscriptionMessageHandler = this.iProxyHandler.getMessageHandler();
                subscriptionMessageHandler.resetDeleteSubscriptionMessage(mESubscription, this.isLocalBus);
                hashtable.remove(BusGroup.subscriptionKey(mESubscription.getTopicSpaceUuid(), mESubscription.getTopic()));
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                SibTr.debug((TraceComponent)tc, (String)("Doing nothing for subscription " + mESubscription + "," + bl));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"doProxySubscribeOp", (Object)subscriptionMessageHandler);
        }
        return subscriptionMessageHandler;
    }

    public static final String subscriptionKey(SIBUuid12 sIBUuid12, String string) {
        return sIBUuid12 + "+" + string;
    }

    public String toString() {
        return "Bus name " + this.iBusName;
    }

    public boolean equals(BusGroup busGroup) {
        boolean bl = false;
        if (this.iBusName.equals(busGroup.getName())) {
            bl = true;
        }
        return bl;
    }

    protected void reset() {
        this.iLocalSubscriptions = new Hashtable();
        this.iRemoteSubscriptions = new Hashtable();
    }

    protected SubscriptionMessage generateResetSubscriptionMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"generateResetSubscriptionMessage");
        }
        SubscriptionMessageHandler subscriptionMessageHandler = this.iProxyHandler.getMessageHandler();
        subscriptionMessageHandler.resetResetSubscriptionMessage();
        this.addToMessage(subscriptionMessageHandler, this.iLocalSubscriptions);
        this.addToMessage(subscriptionMessageHandler, this.iRemoteSubscriptions);
        SubscriptionMessage subscriptionMessage = subscriptionMessageHandler.getSubscriptionMessage();
        this.iProxyHandler.addMessageHandler(subscriptionMessageHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"generateResetSubscriptionMessage", (Object)subscriptionMessage);
        }
        return subscriptionMessage;
    }

    protected SubscriptionMessage generateReplySubscriptionMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"generateReplySubscriptionMessage");
        }
        SubscriptionMessageHandler subscriptionMessageHandler = this.iProxyHandler.getMessageHandler();
        subscriptionMessageHandler.resetReplySubscriptionMessage();
        if (this.iLocalSubscriptions.size() > 0) {
            this.addToMessage(subscriptionMessageHandler, this.iLocalSubscriptions);
        }
        if (this.iRemoteSubscriptions.size() > 0) {
            this.addToMessage(subscriptionMessageHandler, this.iRemoteSubscriptions);
        }
        SubscriptionMessage subscriptionMessage = subscriptionMessageHandler.getSubscriptionMessage();
        this.iProxyHandler.addMessageHandler(subscriptionMessageHandler);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"generateReplySubscriptionMessage", (Object)subscriptionMessage);
        }
        return subscriptionMessage;
    }

    private final void addToMessage(SubscriptionMessageHandler subscriptionMessageHandler, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addToMessage", (Object)new Object[]{subscriptionMessageHandler, hashtable});
        }
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            MESubscription mESubscription = (MESubscription)enumeration.nextElement();
            subscriptionMessageHandler.addSubscriptionToMessage(mESubscription, this.isLocalBus);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addToMessage");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/proxyhandler/BusGroup.java, SIB.processor, WAS602.SIB, o0610.11 1.43");
        }
    }
}

