/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.SecurityContext;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.matching.MPPrincipal;
import com.ibm.ws.sib.processor.matching.MessageProcessorMatching;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.matching.TopicAcl;
import com.ibm.ws.sib.processor.matching.TopicAclTraversalResults;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import java.security.Principal;

public class TopicAuthorization {
    private static final TraceComponent tc = SibTr.register((Class)TopicAuthorization.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessor _messageProcessor;
    private MessageProcessorMatching _messageProcessorMatching;
    private AuthUtils _authorisationUtils;
    private boolean _pendingRefresh = false;
    protected Object _refreshRequestLock = new Object();
    protected Object _refreshLock = new Object();
    private int _refreshCount = 0;

    public TopicAuthorization(MessageProcessor messageProcessor, MessageProcessorMatching messageProcessorMatching, AuthUtils authUtils) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"TopicAuthorization", (Object)new Object[]{messageProcessor, messageProcessorMatching, authUtils});
        }
        this._messageProcessor = messageProcessor;
        this._messageProcessorMatching = messageProcessorMatching;
        this._authorisationUtils = authUtils;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"TopicAuthorization", (Object)this);
        }
    }

    public void addTopicAcl(SIBUuid12 sIBUuid12, String string, int n, Principal principal) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addTopicAcl", (Object)new Object[]{sIBUuid12, string, new Integer(n), principal});
        }
        TopicAcl topicAcl = new TopicAcl(string, n, principal);
        this._messageProcessorMatching.addTopicAcl(sIBUuid12, topicAcl);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addTopicAcl");
        }
    }

    public boolean checkPermissionToPublish(DestinationHandler destinationHandler, String string, Principal principal) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPermissionToPublish", (Object)new Object[]{destinationHandler, string, principal});
        }
        boolean bl = false;
        this.handleAclRefresh();
        MessageProcessorSearchResults messageProcessorSearchResults = (MessageProcessorSearchResults)this._messageProcessor.getSearchResultsObjectPool().remove();
        messageProcessorSearchResults.reset();
        this._messageProcessorMatching.retrieveMatchingTopicAcls(destinationHandler, string, null, messageProcessorSearchResults);
        TopicAclTraversalResults topicAclTraversalResults = (TopicAclTraversalResults)messageProcessorSearchResults.getResults(null)[0];
        bl = topicAclTraversalResults.checkPermission(principal, 1);
        this._messageProcessor.getSearchResultsObjectPool().add(messageProcessorSearchResults);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPermissionToPublish", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean checkPermissionToPublish(DestinationHandler destinationHandler, String string, SecurityContext securityContext) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPermissionToPublish", (Object)new Object[]{destinationHandler, string, securityContext});
        }
        boolean bl = false;
        this.handleAclRefresh();
        MessageProcessorSearchResults messageProcessorSearchResults = (MessageProcessorSearchResults)this._messageProcessor.getSearchResultsObjectPool().remove();
        messageProcessorSearchResults.reset();
        this._messageProcessorMatching.retrieveMatchingTopicAcls(destinationHandler, string, null, messageProcessorSearchResults);
        TopicAclTraversalResults topicAclTraversalResults = (TopicAclTraversalResults)messageProcessorSearchResults.getResults(null)[0];
        MPPrincipal mPPrincipal = null;
        if (securityContext.isAlternateUserBased()) {
            mPPrincipal = new MPPrincipal(securityContext.getAlternateUser(), this._authorisationUtils);
            bl = topicAclTraversalResults.checkPermission(mPPrincipal, 1);
        } else if (securityContext.isSubjectBased()) {
            mPPrincipal = new MPPrincipal(securityContext.getSubject(), this._authorisationUtils);
            bl = topicAclTraversalResults.checkPermission(mPPrincipal, 1);
        } else if (securityContext.isUserIdBased()) {
            mPPrincipal = new MPPrincipal(securityContext.getUserId(), this._authorisationUtils);
            bl = topicAclTraversalResults.checkPermission(mPPrincipal, 1);
        } else if (securityContext.isMsgBased()) {
            mPPrincipal = new MPPrincipal(securityContext.getMsg().getSecurityUserid(), this._authorisationUtils);
            bl = topicAclTraversalResults.checkPermission(mPPrincipal, 1);
        }
        this._messageProcessor.getSearchResultsObjectPool().add(messageProcessorSearchResults);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPermissionToPublish", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean checkPermissionToSubscribe(DestinationHandler destinationHandler, String string, SecurityContext securityContext) throws SIDiscriminatorSyntaxException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPermissionToSubscribe", (Object)new Object[]{destinationHandler, string, securityContext});
        }
        boolean bl = false;
        this.handleAclRefresh();
        MessageProcessorSearchResults messageProcessorSearchResults = (MessageProcessorSearchResults)this._messageProcessor.getSearchResultsObjectPool().remove();
        messageProcessorSearchResults.reset();
        this._messageProcessorMatching.retrieveMatchingTopicAcls(destinationHandler, string, null, messageProcessorSearchResults);
        TopicAclTraversalResults topicAclTraversalResults = (TopicAclTraversalResults)messageProcessorSearchResults.getResults(null)[0];
        MPPrincipal mPPrincipal = null;
        if (securityContext.isAlternateUserBased()) {
            mPPrincipal = new MPPrincipal(securityContext.getAlternateUser(), this._authorisationUtils);
            bl = topicAclTraversalResults.checkPermission(mPPrincipal, 0);
        } else if (securityContext.isSubjectBased()) {
            mPPrincipal = new MPPrincipal(securityContext.getSubject(), this._authorisationUtils);
            bl = topicAclTraversalResults.checkPermission(mPPrincipal, 0);
        } else if (securityContext.isUserIdBased()) {
            mPPrincipal = new MPPrincipal(securityContext.getUserId(), this._authorisationUtils);
            bl = topicAclTraversalResults.checkPermission(mPPrincipal, 0);
        } else if (securityContext.isMsgBased()) {
            mPPrincipal = new MPPrincipal(securityContext.getMsg().getSecurityUserid(), this._authorisationUtils);
            bl = topicAclTraversalResults.checkPermission(mPPrincipal, 0);
        }
        this._messageProcessor.getSearchResultsObjectPool().add(messageProcessorSearchResults);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPermissionToSubscribe", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean checkPermissionToSubscribe(String string, String string2, TopicAclTraversalResults topicAclTraversalResults) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPermissionToSubscribe", (Object)new Object[]{string, string2});
        }
        boolean bl = false;
        MPPrincipal mPPrincipal = new MPPrincipal(string2, this._authorisationUtils);
        bl = topicAclTraversalResults.checkPermission(mPPrincipal, 0);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPermissionToSubscribe", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void prepareToRefresh() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"prepareToRefresh");
        }
        Object object = this._refreshRequestLock;
        synchronized (object) {
            this._pendingRefresh = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"prepareToRefresh");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleAclRefresh() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleAclRefresh");
        }
        Object object = this._refreshLock;
        synchronized (object) {
            if (this._pendingRefresh) {
                while (this._pendingRefresh) {
                    Object object2 = this._refreshRequestLock;
                    synchronized (object2) {
                        this._pendingRefresh = false;
                    }
                    this._messageProcessorMatching.removeAllTopicAcls();
                    this._messageProcessor.getAccessChecker().listTopicAuthorisations();
                    ++this._refreshCount;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleAclRefresh");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAclRefreshVersion() {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAclRefreshVersion");
        }
        Object object = this._refreshLock;
        synchronized (object) {
            n = this._refreshCount;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAclRefreshVersion", (Object)new Integer(n));
        }
        return n;
    }

    final boolean isBusSecure() {
        return this._messageProcessor.isBusSecure();
    }
}

