/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.processor.matching.MPGroup;
import com.ibm.ws.sib.processor.matching.TopicAcl;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TopicAclTraversalResults {
    private static final TraceComponent tc = SibTr.register((Class)TopicAclTraversalResults.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    MPGroup everyone = new MPGroup("everyone");
    MPGroup allAuthenticated = new MPGroup("allauthenticated");
    public List levelUsersAllowedToSubscribe = new ArrayList();
    public List levelUsersAllowedToPublish = new ArrayList();
    public List accumUsersAllowedToSubscribe = new ArrayList();
    public List accumUsersAllowedToPublish = new ArrayList();
    public List levelGroupAllowedToSubscribe = new ArrayList();
    public List levelGroupAllowedToPublish = new ArrayList();
    public List accumGroupAllowedToSubscribe = new ArrayList();
    public List accumGroupAllowedToPublish = new ArrayList();

    public void reset() {
        this.accumUsersAllowedToSubscribe.clear();
        this.accumUsersAllowedToPublish.clear();
        this.accumGroupAllowedToSubscribe.clear();
        this.accumGroupAllowedToPublish.clear();
    }

    public void consolidate(List list) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"consolidate", (Object)list);
        }
        Iterator iterator = list.iterator();
        this.levelUsersAllowedToSubscribe.clear();
        this.levelUsersAllowedToPublish.clear();
        this.levelGroupAllowedToSubscribe.clear();
        this.levelGroupAllowedToPublish.clear();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof TopicAcl)) continue;
            Principal principal = ((TopicAcl)((Object)e)).getPrincipal();
            if (((TopicAcl)((Object)e)).getOperationType() == 1) {
                if (principal == null) {
                    this.accumUsersAllowedToPublish.clear();
                    this.accumGroupAllowedToPublish.clear();
                    continue;
                }
                if (principal instanceof Group) {
                    this.levelGroupAllowedToPublish.add(principal);
                    continue;
                }
                this.levelUsersAllowedToPublish.add(principal);
                continue;
            }
            if (principal == null) {
                this.accumUsersAllowedToSubscribe.clear();
                this.accumGroupAllowedToSubscribe.clear();
                continue;
            }
            if (principal instanceof Group) {
                this.levelGroupAllowedToSubscribe.add(principal);
                continue;
            }
            this.levelUsersAllowedToSubscribe.add(principal);
        }
        if (!this.levelUsersAllowedToSubscribe.isEmpty()) {
            this.accumUsersAllowedToSubscribe.addAll(this.levelUsersAllowedToSubscribe);
        }
        if (!this.levelUsersAllowedToPublish.isEmpty()) {
            this.accumUsersAllowedToPublish.addAll(this.levelUsersAllowedToPublish);
        }
        if (!this.levelGroupAllowedToSubscribe.isEmpty()) {
            this.accumGroupAllowedToSubscribe.addAll(this.levelGroupAllowedToSubscribe);
        }
        if (!this.levelGroupAllowedToPublish.isEmpty()) {
            this.accumGroupAllowedToPublish.addAll(this.levelGroupAllowedToPublish);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"consolidate");
        }
    }

    public boolean checkPermission(Principal principal, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPermission", (Object)new Object[]{principal, new Integer(n)});
        }
        boolean bl = false;
        if (n == 1) {
            if (this.accumGroupAllowedToPublish.size() > 0 && this.accumGroupAllowedToPublish.contains(this.everyone)) {
                bl = true;
            } else if (principal.getName() != null && principal.getName().length() > 0) {
                if (this.accumUsersAllowedToPublish.size() > 0 && this.accumUsersAllowedToPublish.contains(principal)) {
                    bl = true;
                } else if (this.accumGroupAllowedToPublish.size() > 0) {
                    if (this.accumGroupAllowedToPublish.contains(this.allAuthenticated)) {
                        bl = true;
                    } else {
                        Iterator iterator = this.accumGroupAllowedToPublish.iterator();
                        while (iterator.hasNext()) {
                            Group group = (Group)iterator.next();
                            if (!group.isMember(principal)) continue;
                            bl = true;
                            break;
                        }
                    }
                }
            }
        } else if (this.accumGroupAllowedToSubscribe.size() > 0 && this.accumGroupAllowedToSubscribe.contains(this.everyone)) {
            bl = true;
        } else if (principal.getName() != null && principal.getName().length() > 0) {
            if (this.accumUsersAllowedToSubscribe.size() > 0 && this.accumUsersAllowedToSubscribe.contains(principal)) {
                bl = true;
            } else if (this.accumGroupAllowedToSubscribe.size() > 0) {
                if (this.accumGroupAllowedToSubscribe.contains(this.allAuthenticated)) {
                    bl = true;
                } else {
                    Iterator iterator = this.accumGroupAllowedToSubscribe.iterator();
                    while (iterator.hasNext()) {
                        Group group = (Group)iterator.next();
                        if (!group.isMember(principal)) continue;
                        bl = true;
                        break;
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPermission", (Object)new Boolean(bl));
        }
        return bl;
    }
}

