/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.matchspace.SearchResults;
import com.ibm.ws.sib.processor.impl.ControllableProxySubscription;
import com.ibm.ws.sib.processor.impl.PubSubOutputHandler;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.matching.ConsumerFlexHandler;
import com.ibm.ws.sib.processor.matching.MessageProcessorMatchTarget;
import com.ibm.ws.sib.processor.matching.NeighbourFlexHandler;
import com.ibm.ws.sib.processor.matching.SubscriptionFlexHandler;
import com.ibm.ws.sib.processor.matching.TopicAclFlexHandler;
import com.ibm.ws.sib.processor.matching.TopicAuthorization;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class MessageProcessorSearchResults
implements SearchResults {
    private static final TraceComponent tc = SibTr.register((Class)MessageProcessorSearchResults.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    protected Object[] finalResults;
    protected Object[] cachedResults;
    protected boolean postProcessed = false;
    protected List matchingPSOHs;
    protected boolean generatedMatchingPSOHs = false;
    protected static Handler[] handlers = new Handler[4];
    private DestinationHandler destinationHandler;

    public MessageProcessorSearchResults(TopicAuthorization topicAuthorization) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageProcessorSearchResults", (Object)topicAuthorization);
        }
        this.finalResults = new Object[4];
        for (int i = 0; i < 4; ++i) {
            if (handlers[i] != null) {
                this.finalResults[i] = handlers[i].initResult();
                handlers[i].setAuthorization(topicAuthorization);
                continue;
            }
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"MessageProcessorSearchResults", (Object)("No flex handler for " + MessageProcessorMatchTarget.TARGET_NAMES[i]));
            }
            this.finalResults[i] = null;
        }
        this.cachedResults = null;
        this.destinationHandler = null;
        this.matchingPSOHs = new ArrayList();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageProcessorSearchResults", (Object)this);
        }
    }

    public void addObjects(List[] listArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addObjects");
        }
        if (listArray.length > 4) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"addObjects", (Object)"IllegalStateException");
            }
            throw new IllegalStateException();
        }
        for (int i = 0; i < listArray.length; ++i) {
            if (listArray[i] == null || handlers[i] == null) continue;
            handlers[i].processIntermediateMatches(listArray[i], this.finalResults[i]);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addObjects");
        }
    }

    public void reset() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reset");
        }
        if (this.finalResults != null) {
            for (int i = 0; i < 4; ++i) {
                if (handlers[i] == null) continue;
                handlers[i].resetResult(this.finalResults[i]);
            }
        } else {
            this.finalResults = new Object[4];
            for (int i = 0; i < 4; ++i) {
                this.finalResults[i] = handlers[i] != null ? handlers[i].initResult() : null;
            }
        }
        this.cachedResults = null;
        this.postProcessed = false;
        this.destinationHandler = null;
        this.matchingPSOHs.clear();
        this.generatedMatchingPSOHs = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    public Object provideCacheable(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"provideCacheable", (Object)object);
        }
        this.postProcess((String)object);
        this.cachedResults = this.finalResults;
        this.finalResults = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"provideCacheable", (Object)this.cachedResults);
        }
        return this.cachedResults;
    }

    public boolean acceptCacheable(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"acceptCacheable", (Object)object);
        }
        boolean bl = false;
        if (object instanceof Object[]) {
            this.cachedResults = (Object[])object;
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"acceptCacheable", (Object)("result: " + new Boolean(bl)));
        }
        return bl;
    }

    public Object[] getResults(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getResults", (Object)string);
        }
        if (this.cachedResults != null) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getResults", (Object)this.cachedResults);
            }
            return this.cachedResults;
        }
        this.postProcess(string);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getResults", (Object)("finalResults: " + this.finalResults));
        }
        return this.finalResults;
    }

    public Set getConsumerDispatchers(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerDispatchers", (Object)string);
        }
        Object[] objectArray = this.getResults(string);
        Set set = (Set)objectArray[1];
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getConsumerDispatchers", (Object)set);
        }
        return set;
    }

    public List getPubSubOutputHandlers(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPubSubOutputHandlers", (Object)string);
        }
        if (!this.generatedMatchingPSOHs) {
            Object[] objectArray = this.getResults(string);
            this.generateMatchingPSOHs(objectArray);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPubSubOutputHandlers", (Object)this.matchingPSOHs);
        }
        return this.matchingPSOHs;
    }

    protected void postProcess(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"postProcess", (Object)string);
        }
        if (!this.postProcessed) {
            for (int i = 0; i < this.finalResults.length; ++i) {
                if (handlers[i] == null) continue;
                handlers[i].postProcessMatches(this.destinationHandler, string, this.finalResults, i);
            }
            this.postProcessed = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"postProcess");
        }
    }

    protected void postProcess(int n, String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"postProcess", (Object)new Object[]{new Integer(n), string});
        }
        handlers[n].postProcessMatches(this.destinationHandler, string, this.finalResults, n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"postProcess");
        }
    }

    protected void generateMatchingPSOHs(Object[] objectArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"generateMatchingPSOHs");
        }
        if (!this.generatedMatchingPSOHs) {
            Set set = (Set)objectArray[3];
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                PubSubOutputHandler pubSubOutputHandler = (PubSubOutputHandler)((ControllableProxySubscription)((Object)iterator.next())).getOutputHandler();
                if (tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)("Found pubsuboutputhandler: " + pubSubOutputHandler));
                }
                this.matchingPSOHs.add(pubSubOutputHandler);
            }
            this.generatedMatchingPSOHs = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"generateMatchingPSOHs");
        }
    }

    public void setTopicSpace(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setTopicSpace", (Object)destinationHandler);
        }
        this.destinationHandler = destinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setTopicSpace");
        }
    }

    static {
        MessageProcessorSearchResults.handlers[1] = new SubscriptionFlexHandler();
        MessageProcessorSearchResults.handlers[2] = new ConsumerFlexHandler();
        MessageProcessorSearchResults.handlers[3] = new NeighbourFlexHandler();
        MessageProcessorSearchResults.handlers[0] = new TopicAclFlexHandler();
    }

    public static interface Handler {
        public Object initResult();

        public void resetResult(Object var1);

        public void processIntermediateMatches(List var1, Object var2);

        public void postProcessMatches(DestinationHandler var1, String var2, Object[] var3, int var4);

        public void setAuthorization(TopicAuthorization var1);
    }
}

