/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.matching;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.matching.MPGroup;
import com.ibm.ws.sib.processor.matching.MPPrincipal;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.security.auth.TopicAuthorisations;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;

public class MPTopicAuths
implements TopicAuthorisations {
    private static final TraceComponent tc = SibTr.register((Class)MPTopicAuths.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private MessageProcessor messageProcessor;
    private AuthUtils authorisationUtils;

    public MPTopicAuths(MessageProcessor messageProcessor, AuthUtils authUtils) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MPTopicAuths", (Object)new Object[]{messageProcessor, authUtils});
        }
        this.messageProcessor = messageProcessor;
        this.authorisationUtils = authUtils;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MPTopicAuths", (Object)this);
        }
    }

    public void authoriseTopic(String string, String string2, String[] stringArray, String[] stringArray2, boolean bl, String[] stringArray3, String[] stringArray4, boolean bl2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"authoriseTopic", (Object)new Object[]{string, string2, stringArray, stringArray2, new Boolean(bl), stringArray3, stringArray4, new Boolean(bl2)});
        }
        try {
            SIBUuid12 sIBUuid12 = null;
            if (string != null) {
                DestinationHandler destinationHandler = this.messageProcessor.getDestinationManager().getDestination(string, false);
                sIBUuid12 = destinationHandler.getUuid();
            } else {
                string2 = "";
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    try {
                        this.messageProcessor.getDiscriminatorAccessChecker().addTopicAcl(sIBUuid12, string2, 0, new MPPrincipal(stringArray[i], this.authorisationUtils));
                        continue;
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Exception when adding acl on topic, " + string2 + ", for user,  " + stringArray[i] + "caught: " + exception));
                        }
                        SibTr.warning((TraceComponent)tc, (String)"ACL_ADD_WARNING_CWSIP0374", (Object)new Object[]{string2, stringArray[i], exception});
                    }
                }
            }
            if (stringArray2 != null) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    try {
                        this.messageProcessor.getDiscriminatorAccessChecker().addTopicAcl(sIBUuid12, string2, 0, new MPGroup(stringArray2[i]));
                        continue;
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Exception when adding acl on topic, " + string2 + ", for group,  " + stringArray2[i] + "caught: " + exception));
                        }
                        SibTr.warning((TraceComponent)tc, (String)"ACL_ADD_WARNING_CWSIP0374", (Object)new Object[]{string2, stringArray2[i], exception});
                    }
                }
            }
            if (stringArray3 != null) {
                for (int i = 0; i < stringArray3.length; ++i) {
                    try {
                        this.messageProcessor.getDiscriminatorAccessChecker().addTopicAcl(sIBUuid12, string2, 1, new MPPrincipal(stringArray3[i], this.authorisationUtils));
                        continue;
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Exception when adding acl on topic, " + string2 + ", for user,  " + stringArray3[i] + "caught: " + exception));
                        }
                        SibTr.warning((TraceComponent)tc, (String)"ACL_ADD_WARNING_CWSIP0374", (Object)new Object[]{string2, stringArray3[i], exception});
                    }
                }
            }
            if (stringArray4 != null) {
                for (int i = 0; i < stringArray4.length; ++i) {
                    try {
                        this.messageProcessor.getDiscriminatorAccessChecker().addTopicAcl(sIBUuid12, string2, 1, new MPGroup(stringArray4[i]));
                        continue;
                    }
                    catch (Exception exception) {
                        if (tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Exception when adding acl on topic, " + string2 + ", for group,  " + stringArray4[i] + "caught: " + exception));
                        }
                        SibTr.warning((TraceComponent)tc, (String)"ACL_ADD_WARNING_CWSIP0374", (Object)new Object[]{string2, stringArray4[i], exception});
                    }
                }
            }
            if (!bl) {
                try {
                    this.messageProcessor.getDiscriminatorAccessChecker().addTopicAcl(sIBUuid12, string2, 0, null);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Exception when adding acl on topic, " + string2 + "to block receive, caught: " + exception));
                    }
                    SibTr.warning((TraceComponent)tc, (String)"ACL_ADD_WARNING_CWSIP0375", (Object)new Object[]{string2, exception});
                }
            }
            if (!bl2) {
                try {
                    this.messageProcessor.getDiscriminatorAccessChecker().addTopicAcl(sIBUuid12, string2, 1, null);
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Exception when adding acl on topic, " + string2 + "to block send, caught: " + exception));
                    }
                    SibTr.warning((TraceComponent)tc, (String)"ACL_ADD_WARNING_CWSIP0375", (Object)new Object[]{string2, exception});
                }
            }
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Exception when adding acls on topicspace, " + string + "to block send, caught: " + exception));
            }
            SibTr.warning((TraceComponent)tc, (String)"ACL_ADD_WARNING_CWSIP0373", (Object)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"authoriseTopic");
        }
    }

    public void update() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"update");
        }
        this.messageProcessor.getDiscriminatorAccessChecker().prepareToRefresh();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"update");
        }
    }
}

