/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.io.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.comms.MEConnection;
import com.ibm.ws.sib.comms.MEConnectionListener;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.control.ControlMessage;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.RemoteMessageReceiver;
import com.ibm.ws.sib.processor.io.impl.JsMessageWrapper;
import com.ibm.ws.sib.processor.io.impl.MessageBuffer;
import com.ibm.ws.sib.processor.utils.Enumarray;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.processor.utils.Queue;
import com.ibm.ws.sib.trm.contact.CommsErrorListener;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.CellulePair;
import com.ibm.ws.sib.trm.topology.LinkCellule;
import com.ibm.ws.sib.trm.topology.MessagingEngine;
import com.ibm.ws.sib.trm.topology.RoutingManager;
import com.ibm.ws.sib.trm.topology.TopologyListener;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Hashtable;
import java.util.Iterator;

public class MPIO
implements TopologyListener,
MEConnectionListener {
    private MessageProcessor _messageProcessor;
    private CommsErrorListener _commsErrorListener;
    private RoutingManager _routingManager;
    private RemoteMessageReceiver _remoteMessageReceiver;
    private Hashtable _connectionMap = new Hashtable();
    private LockManager _mpioLockManager = new LockManager();
    private boolean _started;
    private static final TraceComponent tc = SibTr.register((Class)MPIO.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public MPIO(MessageProcessor messageProcessor) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MPIO", (Object)messageProcessor);
        }
        this._messageProcessor = messageProcessor;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MPIO", (Object)this);
        }
    }

    MessageProcessor getMessageProcessor() {
        return this._messageProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(CommsErrorListener commsErrorListener, RoutingManager routingManager, RemoteMessageReceiver remoteMessageReceiver) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"init", (Object)new Object[]{commsErrorListener, routingManager, remoteMessageReceiver});
        }
        this._mpioLockManager.lockExclusive();
        try {
            this._started = true;
        }
        finally {
            this._mpioLockManager.unlockExclusive();
        }
        this._commsErrorListener = commsErrorListener;
        this._routingManager = routingManager;
        this._remoteMessageReceiver = remoteMessageReceiver;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"init");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(MEConnection mEConnection, JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"receiveMessage", (Object)new Object[]{this, mEConnection, jsMessage, "data"});
        }
        this._mpioLockManager.lock();
        try {
            if (this._started) {
                this._remoteMessageReceiver.receiveMessage(mEConnection, jsMessage);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Ignoring message as in stopped state");
            }
        }
        finally {
            this._mpioLockManager.unlock();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"receiveMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveMessage(MEConnection mEConnection, ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"receiveMessage", (Object)new Object[]{this, mEConnection, controlMessage, "control"});
        }
        this._mpioLockManager.lock();
        try {
            if (this._started) {
                this._remoteMessageReceiver.receiveMessage(mEConnection, controlMessage);
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Ignoring message as in stopped state");
            }
        }
        finally {
            this._mpioLockManager.unlock();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"receiveMessage");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"stop");
        }
        this._mpioLockManager.lockExclusive();
        try {
            this._started = false;
        }
        finally {
            this._mpioLockManager.unlockExclusive();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"stop");
        }
    }

    public void capacityChange(MEConnection mEConnection) {
        MessageBuffer messageBuffer;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"capacityChange", (Object)new Object[]{this, mEConnection});
        }
        if ((messageBuffer = (MessageBuffer)this._connectionMap.get(mEConnection)) != null) {
            messageBuffer.processCapacityChange();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"capacityChange");
        }
    }

    public void error(MEConnection mEConnection, Throwable throwable) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"error", (Object)new Object[]{this, mEConnection, throwable});
        }
        this._commsErrorListener.error(mEConnection, throwable);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"error");
        }
    }

    public synchronized void increaseInReachability(LinkCellule[] linkCelluleArray, MessagingEngine[] messagingEngineArray) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decreaseInReachability(MEConnection mEConnection, LinkCellule[] linkCelluleArray, MessagingEngine[] messagingEngineArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"decreaseInReachability", (Object)new Object[]{this, mEConnection, new Enumarray(linkCelluleArray), new Enumarray(messagingEngineArray)});
        }
        Hashtable hashtable = this._connectionMap;
        synchronized (hashtable) {
            MessageBuffer messageBuffer = (MessageBuffer)this._connectionMap.get(mEConnection);
            if (messageBuffer != null) {
                Queue queue = messageBuffer.extractNonRoutable(linkCelluleArray, messagingEngineArray);
                while (!queue.isEmpty()) {
                    this.rerouteMessage((JsMessageWrapper)queue.dequeue());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"decreaseInReachability");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeConnection(MEConnection mEConnection, MEConnection mEConnection2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"changeConnection", (Object)new Object[]{this, mEConnection, mEConnection2});
        }
        Hashtable hashtable = this._connectionMap;
        synchronized (hashtable) {
            if (mEConnection2 != null && mEConnection != null) {
                MessageBuffer messageBuffer = (MessageBuffer)this._connectionMap.get(mEConnection);
                this._connectionMap.remove(mEConnection);
                this._connectionMap.put(mEConnection2, messageBuffer);
                messageBuffer.resetConnection(mEConnection2);
            } else if (mEConnection2 != null) {
                this._connectionMap.put(mEConnection2, new MessageBuffer(mEConnection2, this));
            } else {
                MessageBuffer messageBuffer = (MessageBuffer)this._connectionMap.get(mEConnection);
                this._connectionMap.remove(mEConnection);
                Queue queue = messageBuffer.extractAll();
                while (!queue.isEmpty()) {
                    this.rerouteMessage((JsMessageWrapper)queue.dequeue());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"changeConnection");
        }
    }

    public void send(Object object, int n, JsMessage jsMessage) {
        MessageBuffer messageBuffer;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"send", (Object)new Object[]{this, object, new Integer(n), jsMessage});
        }
        if ((messageBuffer = (MessageBuffer)this._connectionMap.get(object)) != null) {
            messageBuffer.sendOrEnqueue(JsMessageWrapper.wrapDirect(jsMessage, n));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"send");
        }
    }

    public void send(Object object, int n, ControlMessage controlMessage) {
        MessageBuffer messageBuffer;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"send", (Object)new Object[]{this, object, new Integer(n), controlMessage});
        }
        if ((messageBuffer = (MessageBuffer)this._connectionMap.get(object)) != null) {
            messageBuffer.sendOrEnqueue(JsMessageWrapper.wrapDirect(controlMessage, n));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"send");
        }
    }

    public void sendToMe(MessagingEngine messagingEngine, int n, int n2, JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToMe", (Object)new Object[]{this, messagingEngine, new Integer(n), new Integer(n2), jsMessage});
        }
        if (this._routingManager != null) {
            CellulePair cellulePair = new CellulePair(this._messageProcessor.getMECellule(), messagingEngine);
            this.sendToMeHelper(JsMessageWrapper.wrapPtp(jsMessage, n2, cellulePair), n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToMe");
        }
    }

    public void sendToMe(MessagingEngine messagingEngine, int n, int n2, ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToMe", (Object)new Object[]{this, messagingEngine, new Integer(n), new Integer(n2), controlMessage});
        }
        if (this._routingManager != null) {
            CellulePair cellulePair = new CellulePair(this._messageProcessor.getMECellule(), messagingEngine);
            this.sendToMeHelper(JsMessageWrapper.wrapPtp(controlMessage, n2, cellulePair), n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToMe");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendToMeHelper(JsMessageWrapper jsMessageWrapper, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendToMeHelper", (Object)new Object[]{this, jsMessageWrapper, new Integer(n)});
        }
        MEConnection[] mEConnectionArray = this._routingManager.listConnections(jsMessageWrapper.ptpTarget[0].target);
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"sendToMeHelper", (Object)mEConnectionArray);
        }
        if (mEConnectionArray != null && mEConnectionArray.length != 0) {
            MessageBuffer messageBuffer = null;
            MEConnection mEConnection = null;
            Hashtable hashtable = this._connectionMap;
            synchronized (hashtable) {
                mEConnection = mEConnectionArray[n % mEConnectionArray.length];
                messageBuffer = (MessageBuffer)this._connectionMap.get(mEConnection);
                if (messageBuffer == null) {
                    this.changeConnection(null, mEConnection);
                    messageBuffer = (MessageBuffer)this._connectionMap.get(mEConnection);
                    if (tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"sendToMeHelper", (Object)this._connectionMap);
                        Iterator iterator = this._connectionMap.values().iterator();
                        while (iterator.hasNext()) {
                            SibTr.debug((TraceComponent)tc, (String)"queues - ", iterator.next());
                        }
                    }
                }
            }
            messageBuffer.sendOrEnqueue(jsMessageWrapper);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"sendToMeHelper");
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendToMeHelper");
        }
    }

    public void sendDownTree(CellulePair[] cellulePairArray, int n, int n2, JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendDownTree", (Object)new Object[]{this, new Enumarray(cellulePairArray), new Integer(n), new Integer(n2), jsMessage});
        }
        if (this._routingManager != null) {
            this.sendDownTreeHelper(JsMessageWrapper.wrapPubSub(jsMessage, n2, cellulePairArray, false), n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendDownTree");
        }
    }

    public void sendDownTree(CellulePair[] cellulePairArray, int n, int n2, ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendDownTree", (Object)new Object[]{this, new Enumarray(cellulePairArray), new Integer(n), new Integer(n2), controlMessage});
        }
        if (this._routingManager != null) {
            this.sendDownTreeHelper(JsMessageWrapper.wrapPubSub(controlMessage, n2, cellulePairArray, false), n);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendDownTree");
        }
    }

    private void sendDownTreeHelper(JsMessageWrapper jsMessageWrapper, int n) {
        int n2;
        MEConnection[] mEConnectionArray;
        int n3;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendDownTreeHelper", (Object)new Object[]{this, jsMessageWrapper, new Integer(n)});
        }
        CellulePair[] cellulePairArray = jsMessageWrapper.pubsubTarget;
        int n4 = jsMessageWrapper.priority;
        int n5 = cellulePairArray.length;
        int n6 = 0;
        MEConnection[] mEConnectionArray2 = new MEConnection[n5];
        MEConnection[] mEConnectionArray3 = new MEConnection[n5];
        int[] nArray = new int[n5];
        block0: for (n3 = 0; n3 < n5; ++n3) {
            mEConnectionArray = this._routingManager.listConnections(jsMessageWrapper.pubsubTarget[n3].target);
            if (mEConnectionArray != null && mEConnectionArray.length == 0) {
                mEConnectionArray2[n3] = null;
                ++n6;
                continue;
            }
            mEConnectionArray2[n3] = mEConnectionArray[n % mEConnectionArray.length];
            for (n2 = 0; n2 < n3 && mEConnectionArray3[n2] != null; ++n2) {
                if (!mEConnectionArray3[n2].equals(mEConnectionArray2[n3])) continue;
                int n7 = n2;
                nArray[n7] = nArray[n7] + 1;
                continue block0;
            }
            mEConnectionArray3[n2] = mEConnectionArray2[n3];
            int n8 = n2;
            nArray[n8] = nArray[n8] + 1;
        }
        mEConnectionArray = new MEConnection[n5 - n6];
        n2 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if (mEConnectionArray2[n3] == null) continue;
            mEConnectionArray[n2++] = mEConnectionArray2[n3];
        }
        for (n3 = 0; n3 < n5 && mEConnectionArray3[n3] != null; ++n3) {
            MessageBuffer messageBuffer = (MessageBuffer)this._connectionMap.get(mEConnectionArray3[n3]);
            CellulePair[] cellulePairArray2 = new CellulePair[nArray[n3]];
            int n9 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                if (mEConnectionArray2[n2] == null || !mEConnectionArray2[n2].equals(mEConnectionArray3[n3])) continue;
                cellulePairArray2[n9++] = cellulePairArray[n2];
            }
            if (messageBuffer == null) continue;
            JsMessageWrapper jsMessageWrapper2 = null;
            jsMessageWrapper2 = jsMessageWrapper.jsMsg != null ? JsMessageWrapper.wrapPubSub(jsMessageWrapper.jsMsg, n4, cellulePairArray, false) : JsMessageWrapper.wrapPubSub(jsMessageWrapper.cMsg, n4, cellulePairArray, false);
            messageBuffer.sendOrEnqueue(jsMessageWrapper2);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendDownTreeHelper");
        }
    }

    public void sendUpTree(Cellule cellule, Cellule cellule2, Object object, int n, ControlMessage controlMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendUpTree", (Object)new Object[]{this, cellule, cellule2, object, new Integer(n), controlMessage});
        }
        this.sendUpTreeHelper(JsMessageWrapper.wrapPubSub(controlMessage, n, new CellulePair[]{new CellulePair(cellule, cellule2)}, true), (MEConnection)object);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendUpTree");
        }
    }

    private void sendUpTreeHelper(JsMessageWrapper jsMessageWrapper, MEConnection mEConnection) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"sendUpTreeHelper", (Object)new Object[]{this, jsMessageWrapper, mEConnection});
        }
        if (this._routingManager != null) {
            MEConnection[] mEConnectionArray = this._routingManager.listConnections(jsMessageWrapper.pubsubTarget[0].target);
            MEConnection[] mEConnectionArray2 = new MEConnection[1];
            if (mEConnectionArray != null && mEConnectionArray.length != 0) {
                MessageBuffer messageBuffer;
                mEConnectionArray2[0] = mEConnectionArray[0];
                if (mEConnection != null) {
                    for (int i = 0; i < mEConnectionArray.length; ++i) {
                        if (!mEConnectionArray[i].equals(mEConnection)) continue;
                        mEConnectionArray2[0] = mEConnection;
                        break;
                    }
                }
                if ((messageBuffer = (MessageBuffer)this._connectionMap.get(mEConnectionArray2[0])) != null) {
                    messageBuffer.sendOrEnqueue(jsMessageWrapper);
                    if (tc.isEntryEnabled()) {
                        SibTr.exit((TraceComponent)tc, (String)"sendUpTreeHelper");
                    }
                    return;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"sendUpTreeHelper");
        }
    }

    private void rerouteMessage(JsMessageWrapper jsMessageWrapper) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"rerouteMessage", (Object)new Object[]{this, jsMessageWrapper});
        }
        if (jsMessageWrapper.ptpTarget != null) {
            this.sendToMeHelper(jsMessageWrapper, 0);
        } else if (jsMessageWrapper.pubsubTarget != null) {
            if (jsMessageWrapper.upstream) {
                this.sendUpTreeHelper(jsMessageWrapper, null);
            } else {
                this.sendDownTreeHelper(jsMessageWrapper, 0);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"rerouteMessage");
        }
    }

    public boolean isMEReachable(MessagingEngine messagingEngine) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isMEReachable", (Object)new Object[]{this, messagingEngine});
        }
        boolean bl = false;
        if (this._routingManager != null) {
            MEConnection[] mEConnectionArray = this._routingManager.listConnections(messagingEngine);
            boolean bl2 = bl = mEConnectionArray != null && mEConnectionArray.length > 0;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isMEReachable", (Object)new Boolean(bl));
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/io/impl/MPIO.java, SIB.processor, WAS602.SIB, o0610.11 1.48");
        }
    }
}

