/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.ItemReference;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.OutOfCacheSpace;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.msgstore.transactions.ExternalLocalTransaction;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MessageReferenceStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.utils.LockManager;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public class SubscriptionItemStream
extends MessageReferenceStream
implements MessageEventListener {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int BATCH_DELETE_SIZE = 10;
    private static final TraceComponent tc = SibTr.register((Class)SubscriptionItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ConsumerDispatcher consumerDispatcher = null;
    protected boolean toBeDeleted = false;
    private DestinationHandler destinationHandler = null;
    private boolean removingAvailableReferences = false;
    private LockManager _subscriptionLockManager = new LockManager();

    public SubscriptionItemStream() {
    }

    public SubscriptionItemStream(PubSubMessageItemStream pubSubMessageItemStream, SIMPTransactionManager sIMPTransactionManager) throws OutOfCacheSpace, MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SubscriptionItemStream", (Object)new Object[]{pubSubMessageItemStream, sIMPTransactionManager});
        }
        this.setStorageStrategy(2);
        ExternalAutoCommitTransaction externalAutoCommitTransaction = sIMPTransactionManager.createAutoCommitTransaction();
        pubSubMessageItemStream.addReferenceStream(this, externalAutoCommitTransaction);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SubscriptionItemStream", (Object)this);
        }
    }

    public void setConsumerDispatcher(ConsumerDispatcher consumerDispatcher) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setConsumerDispatcher", (Object)consumerDispatcher);
        }
        this.consumerDispatcher = consumerDispatcher;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setConsumerDispatcher");
        }
    }

    public ConsumerDispatcher getConsumerDispatcher() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getConsumerDispatcher");
            SibTr.exit((TraceComponent)tc, (String)"getConsumerDispatcher", (Object)this.consumerDispatcher);
        }
        return this.consumerDispatcher;
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        if (this.consumerDispatcher != null) {
            formattedWriter.write(this.consumerDispatcher.toString());
        } else {
            formattedWriter.write("Non Durable Subscription");
        }
    }

    public void registerForEvents(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerForEvents");
        }
        sIMPMessage.registerMessageEventListener(3, this);
        sIMPMessage.registerMessageEventListener(5, this);
        sIMPMessage.registerMessageEventListener(2, this);
        sIMPMessage.registerMessageEventListener(4, this);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerForEvents");
        }
    }

    public void messageEventOccurred(int n, SIMPMessage sIMPMessage, Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageEventOccurred", (Object)new Object[]{new Integer(n), sIMPMessage, transaction});
        }
        switch (n) {
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.deleteIfPossible(true);
                break;
            }
            default: {
                SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0001", new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:232:1.40"}, null));
                FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream.messageEventOccurred", (String)"1:238:1.40", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0001", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:245:1.40"});
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred", (Object)((Object)sIErrorException));
                }
                throw sIErrorException;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageEventOccurred");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIfPossible(boolean bl) {
        block27: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"deleteIfPossible", (Object)new Boolean(bl));
            }
            this._subscriptionLockManager.lockExclusive();
            try {
                Statistics statistics;
                boolean bl2;
                Object object;
                block28: {
                    if (this.destinationHandler == null) {
                        object = (PubSubMessageItemStream)this.getItemStream();
                        this.destinationHandler = (DestinationHandler)((Object)((ItemStream)object).getItemStream());
                    }
                    if (!this.toBeDeleted && !this.destinationHandler.isToBeDeleted()) break block27;
                    object = this.destinationHandler.getTxManager();
                    bl2 = false;
                    statistics = this.getStatistics();
                    long l = statistics.getAvailableItemCount();
                    if (l <= 0L) break block28;
                    try {
                        this.removeAllAvailableReferences();
                    }
                    catch (SIResourceException sIResourceException) {
                        if (tc.isEntryEnabled()) {
                            SibTr.exit((TraceComponent)tc, (String)"deleteIfPossible", (Object)((Object)sIResourceException));
                        }
                        Object var11_9 = null;
                        if (!bl2) {
                            this.destinationHandler.getDestinationManager().addSubscriptionToDelete(this);
                            if (bl) {
                                this.destinationHandler.getDestinationManager().startAsynchDeletion();
                            }
                        }
                        this._subscriptionLockManager.unlockExclusive();
                        return;
                    }
                }
                try {
                    try {
                        statistics = this.getStatistics();
                        long l = statistics.getTotalItemCount();
                        if (l == 0L) {
                            if (this.destinationHandler.isToBeDeleted()) {
                                this.destinationHandler.getDestinationManager().markDestinationAsCleanUpPending(this.destinationHandler);
                            }
                            try {
                                this.remove(((SIMPTransactionManager)object).createAutoCommitTransaction(), -2L);
                                bl2 = true;
                            }
                            catch (MessageStoreException messageStoreException) {
                                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream.deleteIfPossible", (String)"1:336:1.40", (Object)this);
                                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:343:1.40", messageStoreException});
                            }
                        }
                        Object var11_10 = null;
                        if (!bl2) {
                            this.destinationHandler.getDestinationManager().addSubscriptionToDelete(this);
                            if (bl) {
                                this.destinationHandler.getDestinationManager().startAsynchDeletion();
                            }
                        }
                    }
                    catch (Exception exception) {
                        SibTr.exception((TraceComponent)tc, (Exception)exception);
                        Object var11_11 = null;
                        if (!bl2) {
                            this.destinationHandler.getDestinationManager().addSubscriptionToDelete(this);
                            if (bl) {
                                this.destinationHandler.getDestinationManager().startAsynchDeletion();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var11_12 = null;
                    if (!bl2) {
                        this.destinationHandler.getDestinationManager().addSubscriptionToDelete(this);
                        if (bl) {
                            this.destinationHandler.getDestinationManager().startAsynchDeletion();
                        }
                    }
                    throw throwable;
                }
            }
            finally {
                this._subscriptionLockManager.unlockExclusive();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deleteIfPossible");
        }
    }

    public boolean isToBeDeleted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isToBeDeleted");
            SibTr.exit((TraceComponent)tc, (String)"isToBeDeleted", (Object)new Boolean(this.toBeDeleted));
        }
        return this.toBeDeleted;
    }

    public void markAsToBeDeleted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"markAsToBeDeleted");
        }
        this.toBeDeleted = true;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"markAsToBeDeleted");
        }
    }

    public void removeAllAvailableReferences() throws SIResourceException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeAllAvailableReferences");
        }
        ExternalLocalTransaction externalLocalTransaction = null;
        ItemReference itemReference = null;
        PubSubMessageItemStream pubSubMessageItemStream = (PubSubMessageItemStream)this.getItemStream();
        DestinationHandler destinationHandler = (DestinationHandler)((Object)pubSubMessageItemStream.getItemStream());
        SIMPTransactionManager sIMPTransactionManager = destinationHandler.getTxManager();
        this.removingAvailableReferences = true;
        if (sIMPTransactionManager != null) {
            try {
                externalLocalTransaction = sIMPTransactionManager.createLocalTransaction();
                int n = 0;
                while (true) {
                    if ((itemReference = this.removeFirstMatching(null, externalLocalTransaction)) != null) {
                        ++n;
                    }
                    if (itemReference != null && n < 10) continue;
                    if (n > 0) {
                        externalLocalTransaction.commit();
                        if (itemReference != null) {
                            externalLocalTransaction = sIMPTransactionManager.createLocalTransaction();
                        }
                        n = 0;
                    }
                    if (itemReference == null) break;
                }
            }
            catch (MessageStoreException messageStoreException) {
                FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream.removeAllAvailableReferences", (String)"1:464:1.40", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:471:1.40", messageStoreException});
                if (externalLocalTransaction != null) {
                    this.handleRollback(externalLocalTransaction);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeAllAvailableReferences");
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:485:1.40", messageStoreException}, null), (Throwable)((Object)messageStoreException));
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream.removeAllAvailableReferences", (String)"1:495:1.40", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:502:1.40", sIException});
                if (externalLocalTransaction != null) {
                    this.handleRollback(externalLocalTransaction);
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"removeAllAvailableReferences");
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream", "1:516:1.40", sIException}, null), (Throwable)sIException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeAllAvailableReferences");
        }
    }

    private void handleRollback(ExternalLocalTransaction externalLocalTransaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"handleRollback", (Object)externalLocalTransaction);
        }
        if (externalLocalTransaction != null) {
            try {
                externalLocalTransaction.rollback();
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SubscriptionItemStream.handleRollback", (String)"1:551:1.40", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"handleRollback");
        }
    }

    public void registerListeners(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerListeners", (Object)sIMPMessage);
        }
        if (!this.removingAvailableReferences) {
            this.consumerDispatcher.registerForEvents(sIMPMessage);
            this.registerForEvents(sIMPMessage);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerListeners");
        }
    }

    public void registerForEventsPostAddItem(SIMPMessage sIMPMessage) {
    }

    public LockManager getSubscriptionLockManager() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSubscriptionLockManager");
            SibTr.exit((TraceComponent)tc, (String)"getSubscriptionLockManager", (Object)this._subscriptionLockManager);
        }
        return this._subscriptionLockManager;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/itemstreams/SubscriptionItemStream.java, SIB.processor, WAS602.SIB, o0610.11 1.40");
        }
    }
}

