/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.store.items.MessageItem;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPReferenceStream;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class SIMPItemStream
extends ItemStream {
    private static final TraceComponent tc = SibTr.register((Class)SIMPItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private final int DEFAULT_PERSISTENT_VERSION = 1;
    private int storageStrategy = 4;
    private List unrestoredMsgIds = new ArrayList();

    public void removeAll(Transaction transaction) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeAll", (Object)transaction);
        }
        Item item = null;
        SIMPItemStream sIMPItemStream = null;
        SIMPReferenceStream sIMPReferenceStream = null;
        while (null != (item = this.findFirstMatchingItem(null))) {
            item.remove(transaction, -2L);
        }
        while (null != (sIMPItemStream = (SIMPItemStream)this.findFirstMatchingItemStream(null))) {
            sIMPItemStream.removeAll(transaction);
        }
        while (null != (sIMPReferenceStream = (SIMPReferenceStream)this.findFirstMatchingReferenceStream(null))) {
            sIMPReferenceStream.removeAll(transaction);
        }
        this.removeItemStream(transaction, -2L);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeAllItems");
        }
    }

    public void removeItemStream(Transaction transaction, long l) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeItemStream", (Object)new Object[]{transaction, new Long(l)});
        }
        this.remove(transaction, l);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeItemStream");
        }
    }

    public final int getStorageStrategy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStorageStrategy");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStorageStrategy", (Object)new Integer(this.storageStrategy));
        }
        return this.storageStrategy;
    }

    protected final void setStorageStrategy(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStorageStrategy", (Object)new Integer(n));
        }
        this.storageStrategy = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setStorageStrategy");
        }
    }

    public int getPersistentVersion() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentVersion");
            SibTr.exit((TraceComponent)tc, (String)"getPersistentVersion", (Object)new Integer(1));
        }
        return 1;
    }

    protected void getPersistentData(ObjectOutputStream objectOutputStream) {
    }

    protected void restore(ObjectInputStream objectInputStream, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Integer(n));
        }
        this.checkPersistentVersionId(n);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public final byte[] getPersistentData() {
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            object = new ObjectOutputStream(byteArrayOutputStream);
            ((ObjectOutputStream)object).writeInt(this.getPersistentVersion());
            this.getPersistentData((ObjectOutputStream)object);
            ((ObjectOutputStream)object).close();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream.getPersistentData", (String)"1:321:1.43", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)exception);
            }
            throw new SIErrorException((Throwable)exception);
        }
        object = byteArrayOutputStream.toByteArray();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)object);
        }
        return object;
    }

    protected void checkPersistentVersionId(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"checkPersistentVersionId", (Object)new Integer(n));
        }
        if (n != this.getPersistentVersion()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkPersistentVersionId", (Object)"SIErrorException");
            }
            SibTr.error((TraceComponent)tc, (String)"ITEM_RESTORE_ERROR_CWSIP0261", (Object)new Object[]{new Integer(this.getPersistentVersion()), new Integer(n)});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkPersistentVersionId", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("ITEM_RESTORE_ERROR_CWSIP0261", new Object[]{new Integer(this.getPersistentVersion()), new Integer(n)}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"checkPersistentVersionId");
        }
    }

    public final void restore(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)byArray);
        }
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
            this.restore(objectInputStream, objectInputStream.readInt());
            objectInputStream.close();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream.restore", (String)"1:391:1.43", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)iOException);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)iOException);
            }
            throw new SIErrorException((Throwable)iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public byte[] getSpillData() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSpillData");
        }
        byte[] byArray = this.getPersistentData();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSpillData", (Object)byArray);
        }
        return byArray;
    }

    public void unspill(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unspill", (Object)byArray);
        }
        this.restore(byArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unspill");
        }
    }

    public void addUnrestoredMsgId(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addUnrestoredMsgId", (Object)new Long(l));
        }
        this.unrestoredMsgIds.add(new Long(l));
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addUnrestoredMsgId");
        }
    }

    public Collection clearUnrestoredMessages() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearUnrestoredMessages");
        }
        List list = this.unrestoredMsgIds;
        this.unrestoredMsgIds = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"clearUnrestoredMessages", (Object)list);
        }
        return list;
    }

    public void initialiseUnrestoredMsgIds() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialiseUnrestoredMsgIds");
        }
        if (this.unrestoredMsgIds != null && this.unrestoredMsgIds.size() > 0) {
            Iterator iterator = this.unrestoredMsgIds.iterator();
            MessageItem messageItem = null;
            while (iterator.hasNext()) {
                messageItem = (MessageItem)this.findById((Long)iterator.next());
                messageItem.initialiseNonPersistent();
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialiseUnrestoredMsgIds");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/itemstreams/SIMPItemStream.java, SIB.processor, WAS602.SIB, o0610.11 1.43");
        }
    }
}

