/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.admin.JsEngineComponentWithEventListener;
import com.ibm.ws.sib.admin.JsMessagingEngine;
import com.ibm.ws.sib.admin.RuntimeEvent;
import com.ibm.ws.sib.admin.RuntimeEventListener;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.msgstore.transactions.ExternalAutoCommitTransaction;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.LinkHandler;
import com.ibm.ws.sib.processor.impl.PtoPOutputHandler;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.GatewayLinkControlAdapter;
import com.ibm.ws.sib.processor.runtime.MPRuntimeEvent;
import com.ibm.ws.sib.processor.runtime.RemoteQueuePoint;
import com.ibm.ws.sib.processor.runtime.XmitPointControl;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Properties;

public class PtoPXmitMsgsItemStream
extends PtoPMessageItemStream {
    private static final TraceComponent tc = SibTr.register((Class)PtoPXmitMsgsItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;

    public PtoPXmitMsgsItemStream() {
    }

    public PtoPXmitMsgsItemStream(BaseDestinationHandler baseDestinationHandler, SIBUuid8 sIBUuid8) {
        super(baseDestinationHandler, sIBUuid8, true);
    }

    protected void setDestLimits(long l, long l2) {
    }

    public boolean reallocateMsgs() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reallocateMsgs");
        }
        boolean bl = true;
        try {
            if (this.getOutputHandler() instanceof PtoPOutputHandler) {
                ((PtoPOutputHandler)this.getOutputHandler()).reallocateMsgs(this.getDestinationHandler(), false, false);
            } else {
                bl = false;
            }
        }
        catch (SIException sIException) {
            bl = false;
        }
        if (bl) {
            if (this.getStatistics().getTotalItemCount() > 0L) {
                bl = false;
            } else if (this.isToBeDeleted() || this.destinationHandler.isToBeDeleted()) {
                ExternalAutoCommitTransaction externalAutoCommitTransaction = this.getDestinationHandler().getTxManager().createAutoCommitTransaction();
                try {
                    this.removeItemStream(externalAutoCommitTransaction, -2L);
                }
                catch (MessageStoreException messageStoreException) {
                    FFDCFilter.processException((Throwable)((Object)messageStoreException), (String)"com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPXmitMsgsItemStream.reallocateMsgs", (String)"1:192:1.46", (Object)this);
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)messageStoreException));
                    bl = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reallocateMsgs", (Object)new Boolean(bl));
        }
        return bl;
    }

    public void reconstitute(BaseDestinationHandler baseDestinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"reconstitute", (Object)baseDestinationHandler);
        }
        super.reconstitute(baseDestinationHandler);
        this._destHighMsgs = baseDestinationHandler.getMessageProcessor().getHighMessageThreshold();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"reconstitute");
        }
    }

    public void createControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        if (!this.destinationHandler.isLink()) {
            RemoteQueuePoint remoteQueuePoint = this.destinationHandler.getRemoteQueuePointControl(this.getMessagingEngineUuid(), true);
            this.controlAdapter = new XmitPointControl(remoteQueuePoint, this, this.destinationHandler);
        } else {
            JsMessagingEngine jsMessagingEngine = this.destinationHandler.getMessageProcessor().getMessagingEngine();
            String string = this.destinationHandler.getName();
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)("Get engine component associated with link: " + string));
            }
            JsEngineComponentWithEventListener jsEngineComponentWithEventListener = (JsEngineComponentWithEventListener)jsMessagingEngine.getGatewayLinkEngineComponent(string);
            RuntimeEventListener runtimeEventListener = null;
            if (jsEngineComponentWithEventListener != null) {
                runtimeEventListener = jsEngineComponentWithEventListener.getRuntimeEventListener();
            } else if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Null EngineComponent, cannot set listener");
            }
            this.controlAdapter = new GatewayLinkControlAdapter(jsMessagingEngine, runtimeEventListener);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    public void deregisterControlAdapterMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
        this.getControlAdapter().deregisterControlAdapterMBean();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterControlAdapterMBean");
        }
    }

    public void registerControlAdapterAsMBean() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
        this.getControlAdapter().registerControlAdapterAsMBean();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerControlAdapterAsMBean");
        }
    }

    public void fireDepthThresholdReachedEvent(ControlAdapter controlAdapter, boolean bl, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)new Object[]{controlAdapter, new Boolean(bl), new Long(l), this.messagingEngineUuid});
        }
        if (controlAdapter != null) {
            Object object;
            String string = this.destinationHandler.getMessageProcessor().getMessagingEngineName();
            String string2 = null;
            Properties properties = new Properties();
            String string3 = null;
            if (this.destinationHandler.isLink()) {
                object = ((LinkHandler)this.destinationHandler).getBusName();
                string3 = "SIB.link.depth.threshold.reached";
                properties.put("foreign.bus.name", object);
                properties.put("link.name", this.destinationHandler.getName());
                properties.put("link.UUID", this.destinationHandler.getUuid().toString());
                string2 = bl ? nls.getFormattedMessage("NOTIFY_SIBLINK_DEPTH_THRESHOLD_REACHED_CWSIP0559", new Object[]{this.destinationHandler.getName(), object, string}, null) : nls.getFormattedMessage("NOTIFY_SIBLINK_DEPTH_THRESHOLD_REACHED_CWSIP0560", new Object[]{this.destinationHandler.getName(), object, string}, null);
            } else {
                string3 = "SIB.remote.messagepoint.depth.threshold.reached";
                properties.put("destination.name", this.destinationHandler.getName());
                properties.put("destination.UUID", this.destinationHandler.getUuid().toString());
                string2 = bl ? nls.getFormattedMessage("NOTIFY_REMOTE_DEPTH_THRESHOLD_REACHED_CWSIP0555", new Object[]{string, this.destinationHandler.getName(), this.messagingEngineUuid.toString()}, null) : nls.getFormattedMessage("NOTIFY_REMOTE_DEPTH_THRESHOLD_REACHED_CWSIP0556", new Object[]{string, this.destinationHandler.getName(), this.messagingEngineUuid.toString()}, null);
            }
            properties.put("remote.messaging.engine.UUID", this.messagingEngineUuid.toString());
            if (bl) {
                properties.put("depth.threshold.reached", "depth.threshold.reached.high");
            } else {
                properties.put("depth.threshold.reached", "depth.threshold.reached.low");
            }
            properties.put("messages", String.valueOf(l));
            object = new MPRuntimeEvent(string3, string2, properties);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)("Drive runtimeEventOccurred against Control adapter: " + controlAdapter));
            }
            controlAdapter.runtimeEventOccurred((RuntimeEvent)object);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)"Control adapter is null, cannot fire event");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/itemstreams/PtoPXmitMsgsItemStream.java, SIB.processor, WAS602.SIB, o0610.11 1.46");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

