/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.itemstreams;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.sib.msgstore.Statistics;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableResource;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.MPRuntimeEvent;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Properties;

public abstract class BaseMessageItemStream
extends SIMPItemStream
implements ControllableResource {
    private static final TraceComponent tc = SibTr.register((Class)BaseMessageItemStream.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls;
    protected ControlAdapter controlAdapter;
    protected BaseDestinationHandler destinationHandler;
    protected boolean _isEventNotificationEnabled = false;
    protected long _destHighMsgs;
    protected long _destLowMsgs;
    boolean wlmRemoved = false;

    protected void initializeNonPersistent(BaseDestinationHandler baseDestinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initializeNonPersistent", (Object)baseDestinationHandler);
        }
        this.destinationHandler = baseDestinationHandler;
        this._isEventNotificationEnabled = baseDestinationHandler.getMessageProcessor().getMessagingEngine().isEventNotificationEnabled();
        this.createControlAdapter();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initializeNonPersistent");
        }
    }

    public void setDefaultDestLimits() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDefaultDestLimits");
        }
        this._destHighMsgs = this.destinationHandler.getMessageProcessor().getHighMessageThreshold();
        this._destLowMsgs = this._destHighMsgs * 8L / 10L;
        if (this._isEventNotificationEnabled) {
            this.setWatermarks(this._destLowMsgs, this._destHighMsgs, -1L, -1L);
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDefaultDestLimits");
        }
    }

    public long getDestHighMsgs() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestHighMsgs");
            SibTr.exit((TraceComponent)tc, (String)"getDestHighMsgs", (Object)new Long(this._destHighMsgs));
        }
        return this._destHighMsgs;
    }

    public long getDestLowMsgs() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestLowMsgs");
            SibTr.exit((TraceComponent)tc, (String)"getDestLowMsgs", (Object)new Long(this._destLowMsgs));
        }
        return this._destLowMsgs;
    }

    public void setDestHighMsgs(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestHighMsgs", (Object)new Long(l));
        }
        this.setDestLimits(l, this._destLowMsgs);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestHighMsgs");
        }
    }

    public void setDestLowMsgs(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestLowMsgs", (Object)new Long(l));
        }
        this.setDestLimits(this._destHighMsgs, l);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestLowMsgs");
        }
    }

    protected void setDestLimits(long l, long l2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestLimits", (Object)new Object[]{new Long(l), new Long(l2)});
        }
        this._destHighMsgs = l;
        if (l2 > this._destHighMsgs) {
            long l3 = (long)((double)this._destHighMsgs * SIMPConstants.DEST_LOW_UNSET_PERCENTAGE_DECREASE);
            this._destLowMsgs = this._destHighMsgs - l3;
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"setDestLowMsgs", (Object)("Cannot set destLowMsgs to be higher than destHighMsgs. New destLowMsgs=" + this._destLowMsgs));
            }
        } else {
            this._destLowMsgs = l2;
        }
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestLimits");
        }
    }

    public boolean isQHighLimit() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isQHighLimit");
        }
        boolean bl = false;
        if (this._destHighMsgs != -1L) {
            Statistics statistics = this.getStatistics();
            boolean bl2 = bl = statistics.getTotalItemCount() >= this._destHighMsgs;
        }
        if (bl) {
            this.notifyClients();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isQHighLimit", (Object)new Boolean(bl));
        }
        return bl;
    }

    public boolean isQLowLimit() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isQLowLimit");
        }
        boolean bl = false;
        if (this._destLowMsgs != -1L) {
            Statistics statistics = this.getStatistics();
            bl = statistics.getTotalItemCount() < this._destLowMsgs;
        } else {
            boolean bl2 = bl = !this.isQHighLimit();
        }
        if (bl) {
            this.notifyClients();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isQLowLimit", (Object)new Boolean(bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClients() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyClients");
        }
        if (this._isEventNotificationEnabled) {
            BaseMessageItemStream baseMessageItemStream = this;
            synchronized (baseMessageItemStream) {
                long l = this.getStatistics().getTotalItemCount();
                if (this.wlmRemoved && (this._destLowMsgs == -1L || l < this._destLowMsgs)) {
                    this.wlmRemoved = false;
                    this.fireDepthThresholdReachedEvent(this.getControlAdapter(), false, l);
                } else if (!this.wlmRemoved && this._destHighMsgs != -1L && this._destLowMsgs != -1L && l >= this._destHighMsgs) {
                    this.wlmRemoved = true;
                    this.fireDepthThresholdReachedEvent(this.getControlAdapter(), true, l);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyClients");
        }
    }

    public long getByteHighWaterMark() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getByteHighWaterMark");
            SibTr.exit((TraceComponent)tc, (String)"getByteHighWaterMark");
        }
        return -1L;
    }

    public long getByteLowWaterMark() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getByteLowWaterMark");
            SibTr.exit((TraceComponent)tc, (String)"getByteLowWaterMark");
        }
        return -1L;
    }

    public long getCountHighWaterMark() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCountHighWaterMark");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCountHighWaterMark", (Object)new Long(this._destHighMsgs));
        }
        return this._destHighMsgs;
    }

    public long getCountLowWaterMark() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getCountLowWaterMark");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getCountLowWaterMark", (Object)new Long(this._destLowMsgs));
        }
        return this._destLowMsgs;
    }

    public void eventWatermarkBreached() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventWatermarkBreached");
        }
        this.notifyClients();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventWatermarkBreached");
        }
    }

    public ControlAdapter getControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.controlAdapter);
        }
        return this.controlAdapter;
    }

    public void deregisterControlAdapterMBean() {
    }

    public void registerControlAdapterAsMBean() {
    }

    public void dereferenceControlAdapter() {
        this.controlAdapter.dereferenceControllable();
        this.controlAdapter = null;
    }

    public void fireDepthThresholdReachedEvent(ControlAdapter controlAdapter, boolean bl, long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)new Object[]{controlAdapter, new Boolean(bl), new Long(l)});
        }
        if (controlAdapter != null) {
            String string = this.destinationHandler.getName();
            String string2 = this.destinationHandler.getMessageProcessor().getMessagingEngineName();
            String string3 = null;
            string3 = bl ? nls.getFormattedMessage("NOTIFY_DEPTH_THRESHOLD_REACHED_CWSIP0553", new Object[]{string, string2}, null) : nls.getFormattedMessage("NOTIFY_DEPTH_THRESHOLD_REACHED_CWSIP0554", new Object[]{string, string2}, null);
            Properties properties = new Properties();
            properties.put("destination.name", string);
            properties.put("destination.UUID", this.destinationHandler.getUuid().toString());
            if (bl) {
                properties.put("depth.threshold.reached", "depth.threshold.reached.high");
            } else {
                properties.put("depth.threshold.reached", "depth.threshold.reached.low");
            }
            properties.put("messages", String.valueOf(l));
            MPRuntimeEvent mPRuntimeEvent = new MPRuntimeEvent("SIB.messagepoint.depth.threshold.reached", string3, properties);
            if (tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)("Drive runtimeEventOccurred against Control adapter: " + controlAdapter));
            }
            controlAdapter.runtimeEventOccurred(mPRuntimeEvent);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent", (Object)"Control adapter is null, cannot fire event");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"fireDepthThresholdReachedEvent");
        }
    }

    public abstract BaseDestinationHandler getDestinationHandler();

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/itemstreams/BaseMessageItemStream.java, SIB.processor, WAS602.SIB, o0610.11 1.12");
        }
        nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    }
}

