/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.items;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsApiMessage;
import com.ibm.ws.sib.mfp.JsDestinationAddress;
import com.ibm.ws.sib.mfp.JsJmsTextMessage;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.JsMessageFactory;
import com.ibm.ws.sib.mfp.MessageEncodeFailedException;
import com.ibm.ws.sib.msgstore.Item;
import com.ibm.ws.sib.msgstore.ItemStream;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.NotInMessageStore;
import com.ibm.ws.sib.msgstore.PersistentDataEncodingException;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.msgstore.transactions.TransactionCallback;
import com.ibm.ws.sib.processor.impl.AbstractDestinationHandler;
import com.ibm.ws.sib.processor.impl.BaseDestinationHandler;
import com.ibm.ws.sib.processor.impl.MessageProcessor;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.impl.interfaces.MessageEventListener;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.impl.store.itemstreams.MediationInputItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PtoPMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.PubSubMessageItemStream;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.processor.matching.MessageProcessorSearchResults;
import com.ibm.ws.sib.processor.runtime.ControlAdapter;
import com.ibm.ws.sib.processor.runtime.QueuedMessage;
import com.ibm.ws.sib.processor.utils.SIMPUtils;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;

public class MessageItem
extends Item
implements SIMPMessage,
TransactionCallback {
    private static final TraceNLS nls_mt = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSJUMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)MessageItem.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private ControlAdapter controlAdapter;
    private int producerSeed = 0;
    private int maintainPersistence = -1;
    private boolean streamIsGuess = false;
    private int fanOut;
    private JsDestinationAddress address;
    private Reliability msgReliability;
    private int msgPriority = -2;
    private SIBUuid12 guaranteedStreamUuid;
    private long currentMEArrivalTimeStamp;
    private long messageWaitTime = -1L;
    private boolean arrivalTimeStored = true;
    private String debugName;
    private String _busName;
    private MessageEventListener PRE_COMMIT_ADD;
    private MessageEventListener PRE_COMMIT_REMOVE;
    private MessageEventListener POST_COMMIT_ADD_1;
    private MessageEventListener POST_COMMIT_ADD_2;
    private MessageEventListener POST_COMMIT_REMOVE_1;
    private MessageEventListener POST_COMMIT_REMOVE_2;
    private MessageEventListener POST_COMMIT_REMOVE_3;
    private MessageEventListener POST_ROLLBACK_ADD_1;
    private MessageEventListener POST_ROLLBACK_ADD_2;
    private MessageEventListener POST_ROLLBACK_REMOVE_1;
    private MessageEventListener POST_ROLLBACK_REMOVE_2;
    private MessageEventListener POST_ROLLBACK_REMOVE_3;
    private MessageEventListener UNLOCKED;
    private MessageEventListener REFERENCES_DROPPED_TO_ZERO;
    private MessageEventListener PRE_PREPARE_TRANSACTION;
    private MessageEventListener POST_COMMITTED_TRANSACTION;
    private MessageEventListener EXPIRY_NOTIFICATION;
    private MessageEventListener COD_CALLBACK;
    protected JsMessage msg;
    private boolean transacted = false;
    private int maxStorageStrategy = 4;
    private boolean requiresNewId = false;
    private boolean storeAtSendTime = false;
    private boolean fromRemoteME = false;
    private boolean fromRemoteBus = false;
    private SIBUuid12 producerConnectionUuid = null;
    private MessageProcessorSearchResults searchResults;
    private long latestWaitTimeUpdate;
    private Byte _reportCOD;
    private boolean _reportCODSet = false;
    private boolean guaranteedStreamUuidSet = false;
    private boolean reavailable = false;
    private boolean forcePut = false;

    public MessageItem() {
    }

    public MessageItem(JsMessage jsMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageItem", (Object)jsMessage);
        }
        this.msg = jsMessage;
        this.setOriginatingBus(jsMessage.getBus());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageItem", (Object)this);
        }
    }

    public MessageItem(JsMessage jsMessage, long l) {
        this(jsMessage);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageItem", (Object)new Object[]{jsMessage, new Long(l)});
        }
        this.messageWaitTime = l;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageItem", (Object)this);
        }
    }

    public JsMessage getMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessage");
            SibTr.exit((TraceComponent)tc, (String)"getMessage", (Object)this.msg);
        }
        return this.msg;
    }

    public int getStorageStrategy() {
        Reliability reliability;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStorageStrategy");
        }
        int n = (reliability = this.getReliability()) == Reliability.BEST_EFFORT_NONPERSISTENT ? 1 : (this.maintainPersistence != 0 && reliability == Reliability.RELIABLE_PERSISTENT ? 3 : (this.maintainPersistence != 0 && reliability == Reliability.ASSURED_PERSISTENT ? 4 : 2));
        int n2 = n = n < this.maxStorageStrategy ? n : this.maxStorageStrategy;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStorageStrategy", (Object)new Integer(n));
        }
        return n;
    }

    public void restore(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)byArray);
        }
        try {
            JsMessageFactory jsMessageFactory = MessageProcessor.getJsMessageFactory();
            this.msg = jsMessageFactory.restoreJsMessage(byArray, (Object)this.getOwningMessageStore());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.restore", (String)"1:532:1.197", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)exception);
            }
            throw new SIErrorException((Throwable)exception);
        }
        this.initialiseNonPersistent();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    private BaseDestinationHandler getDestinationHandler(boolean bl, SIMPItemStream sIMPItemStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationHandler", (Object)new Object[]{new Boolean(bl), sIMPItemStream});
        }
        BaseDestinationHandler baseDestinationHandler = null;
        if (sIMPItemStream instanceof PubSubMessageItemStream) {
            PubSubMessageItemStream pubSubMessageItemStream = (PubSubMessageItemStream)sIMPItemStream;
            baseDestinationHandler = pubSubMessageItemStream.getDestinationHandler();
        } else {
            PtoPMessageItemStream ptoPMessageItemStream = (PtoPMessageItemStream)sIMPItemStream;
            baseDestinationHandler = ptoPMessageItemStream.getDestinationHandler();
            if (bl) {
                MessageEventListener messageEventListener = (MessageEventListener)((Object)ptoPMessageItemStream.getOutputHandler());
                if (messageEventListener != null) {
                    messageEventListener.registerForEvents(this);
                } else if (sIMPItemStream instanceof MediationInputItemStream) {
                    MediationInputItemStream mediationInputItemStream = (MediationInputItemStream)sIMPItemStream;
                    mediationInputItemStream.registerForEvents(this);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDestinationHandler", (Object)baseDestinationHandler);
        }
        return baseDestinationHandler;
    }

    public void initialiseNonPersistent() {
        SIMPItemStream sIMPItemStream;
        BaseDestinationHandler baseDestinationHandler;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"initialiseNonPersistent");
        }
        if ((baseDestinationHandler = this.getDestinationHandler(true, sIMPItemStream = (SIMPItemStream)this.getItemStream())) != null) {
            SIBUuid8 sIBUuid8;
            baseDestinationHandler.registerForEvents(this);
            if (this.msg.getReportCOD() != null) {
                this.registerMessageEventListener(11, baseDestinationHandler);
            }
            this.debugName = baseDestinationHandler.getName();
            String string = this.msg.getBus();
            this.setOriginatingBus(string);
            MessageProcessor messageProcessor = baseDestinationHandler.getMessageProcessor();
            if (string != null && !string.equals(messageProcessor.getMessagingEngineBus())) {
                this.fromRemoteBus = true;
            }
            if ((sIBUuid8 = this.msg.getGuaranteedSourceMessagingEngineUUID()) != null && !messageProcessor.getMessagingEngineUuid().equals((Object)sIBUuid8)) {
                this.fromRemoteME = true;
            }
        } else {
            sIMPItemStream.addUnrestoredMsgId(this.getID());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"initialiseNonPersistent");
        }
    }

    public void unspill(byte[] byArray) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"unspill", (Object)byArray);
        }
        this.restore(byArray);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"unspill");
        }
    }

    public byte[] getPersistentData() throws PersistentDataEncodingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData");
        }
        if (!this.arrivalTimeStored) {
            this.msg.setCurrentMEArrivalTimestamp(this.currentMEArrivalTimeStamp);
            this.arrivalTimeStored = true;
        }
        if (this.producerConnectionUuid != null) {
            this.msg.setConnectionUuid(this.producerConnectionUuid);
        }
        byte[] byArray = null;
        try {
            byArray = this.msg.flatten((Object)this.getOwningMessageStore());
        }
        catch (MessageEncodeFailedException messageEncodeFailedException) {
            FFDCFilter.processException((Throwable)messageEncodeFailedException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.getPersistentData", (String)"1:700:1.197", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)messageEncodeFailedException));
            SibTr.error((TraceComponent)tc, (String)"MESSAGE_CORRUPT_ERROR_CWSIP0262", (Object)new Object[]{SIMPUtils.getStackTrace(messageEncodeFailedException)});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)((Object)messageEncodeFailedException));
            }
            throw new PersistentDataEncodingException(nls.getFormattedMessage("MESSAGE_CORRUPT_ERROR_CWSIP0262", new Object[]{messageEncodeFailedException}, null), messageEncodeFailedException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
        return byArray;
    }

    public int getPersistentDataSize() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentDataSize");
        }
        int n = this.msg.getApproximateLength();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentDataSize", (Object)new Integer(n));
        }
        return n;
    }

    public byte[] getSpillData() throws PersistentDataEncodingException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSpillData");
            SibTr.exit((TraceComponent)tc, (String)"getSpillData");
        }
        return this.getPersistentData();
    }

    public Reliability getReliability() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getReliability");
        }
        if (this.msgReliability == null) {
            this.msgReliability = this.msg.getReliability();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getReliability", (Object)this.msgReliability);
        }
        return this.msgReliability;
    }

    public void setReliability(Reliability reliability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setReliability", (Object)reliability);
        }
        this.msgReliability = reliability;
        this.msg.setReliability(this.msgReliability);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setReliability");
        }
    }

    public long getExpiryStartTime() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getExpiryStartTime");
        }
        long l = this.getCurrentMEArrivalTimestamp();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getExpiryStartTime", (Object)new Long(l));
        }
        return l;
    }

    public long getMaximumTimeInStore() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMaximumTimeInStore");
        }
        long l = this.msg.getTimeToLive();
        long l2 = -2L;
        if (l > 0L) {
            l2 = l - this.getAggregateWaitTime();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getMaximumTimeInStore", (Object)new Long(l2));
        }
        return l2;
    }

    public long calculateWaitTimeUpdate(long l) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"calculateWaitTimeUpdate");
        }
        long l2 = l - this.getCurrentMEArrivalTimestamp();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"calculateWaitTimeUpdate", (Object)new Long(l2));
        }
        return l2;
    }

    public boolean canExpireSilently() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"canExpireSilently");
        }
        if (this.msg.getReportExpiry() != null || UserTrace.tc_mt.isDebugEnabled()) {
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"canExpireSilently", (Object)Boolean.FALSE);
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"canExpireSilently");
        }
        return super.canExpireSilently();
    }

    public void eventExpiryNotification(Transaction transaction) {
        super.eventExpiryNotification(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventExpiryNotification", (Object)transaction);
        }
        if (UserTrace.tc_mt.isDebugEnabled()) {
            String string = null;
            if (this.getMessage() instanceof JsApiMessage) {
                string = ((JsApiMessage)this.getMessage()).getApiMessageId();
            } else if (this.getMessage().getApiMessageIdAsBytes() != null) {
                string = this.getMessage().getApiMessageIdAsBytes().toString();
            }
            SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("MESSAGE_EXPIRED_CWSJU0011", new Object[]{string, this.getMessage().getSystemMessageId(), this.debugName}, null));
        }
        if (this.EXPIRY_NOTIFICATION != null) {
            try {
                if (this.getMessage().getReportExpiry() != null) {
                    this.EXPIRY_NOTIFICATION.messageEventOccurred(10, this, transaction);
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.eventExpiryNotification", (String)"1:917:1.197", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"eventExpiryNotification", (Object)((Object)sIException));
                }
                throw new SIErrorException((Throwable)sIException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventExpiryNotification");
        }
    }

    public void eventPostCommitRemove(Transaction transaction) {
        super.eventPostCommitRemove(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitRemove", (Object)transaction);
        }
        this.dereferenceControlAdapter();
        try {
            if (this.POST_COMMIT_REMOVE_1 != null) {
                this.POST_COMMIT_REMOVE_1.messageEventOccurred(3, this, transaction);
            }
            if (this.POST_COMMIT_REMOVE_2 != null) {
                this.POST_COMMIT_REMOVE_2.messageEventOccurred(3, this, transaction);
            }
            if (this.POST_COMMIT_REMOVE_3 != null) {
                this.POST_COMMIT_REMOVE_3.messageEventOccurred(3, this, transaction);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.eventPostCommitRemove", (String)"1:965:1.197", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove", (Object)((Object)sIException));
            }
            throw new SIErrorException((Throwable)sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitRemove");
        }
    }

    public void eventPostCommitAdd(Transaction transaction) {
        block18: {
            super.eventPostCommitAdd(transaction);
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)transaction);
            }
            if (UserTrace.tc_mt.isDebugEnabled()) {
                try {
                    Object object;
                    Object object2;
                    Object object3;
                    boolean bl = false;
                    String string = null;
                    if (this.debugName != null) {
                        object3 = (SIMPItemStream)this.getItemStream();
                        object2 = this.getDestinationHandler(false, (SIMPItemStream)object3);
                        if (object2 != null && (((BaseDestinationHandler)object2).isMediatedLocally() || ((BaseDestinationHandler)object2).isMediatedRemotely()) && !this.getMessage().isMediated()) {
                            bl = true;
                        }
                        string = object3 instanceof PubSubMessageItemStream ? ((AbstractDestinationHandler)object2).getMessageProcessor().getMessagingEngineName() : ((object = ((PtoPMessageItemStream)object3).getMessagingEngineUuid()).equals((Object)((AbstractDestinationHandler)object2).getMessageProcessor().getMessagingEngineUuid()) ? ((AbstractDestinationHandler)object2).getMessageProcessor().getMessagingEngineName() : object.toString());
                    }
                    object3 = null;
                    object2 = null;
                    if (this.getMessage() instanceof JsApiMessage) {
                        object3 = ((JsApiMessage)this.getMessage()).getApiMessageId();
                        object2 = ((JsApiMessage)this.getMessage()).getCorrelationId();
                    } else {
                        if (this.getMessage().getApiMessageIdAsBytes() != null) {
                            object3 = new String(this.getMessage().getApiMessageIdAsBytes());
                        }
                        if (this.getMessage().getCorrelationIdAsBytes() != null) {
                            object2 = new String(this.getMessage().getCorrelationIdAsBytes());
                        }
                    }
                    object = "PRODUCER_SEND_COMMIT_CWSJU0003";
                    if (bl) {
                        object = "PRODUCER_SEND_COMMIT_CWSJU0053";
                    }
                    SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage((String)object, new Object[]{object3, this.getMessage().getSystemMessageId(), object2, this.debugName, string}, null));
                }
                catch (NotInMessageStore notInMessageStore) {
                    if (!tc.isDebugEnabled()) break block18;
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)notInMessageStore));
                }
            }
        }
        if (!transaction.isAutoCommit()) {
            try {
                if (this.POST_COMMIT_ADD_1 != null) {
                    this.POST_COMMIT_ADD_1.messageEventOccurred(2, this, transaction);
                }
                if (this.POST_COMMIT_ADD_2 != null) {
                    this.POST_COMMIT_ADD_2.messageEventOccurred(2, this, transaction);
                }
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.eventPostCommitAdd", (String)"1:1086:1.197", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)((Object)sIException));
                }
                throw new SIErrorException((Throwable)sIException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd");
        }
    }

    public void eventPostRollbackAdd(Transaction transaction) {
        super.eventPostRollbackAdd(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)transaction);
        }
        try {
            if (this.POST_ROLLBACK_ADD_1 != null) {
                this.POST_ROLLBACK_ADD_1.messageEventOccurred(4, this, transaction);
            }
            if (this.POST_ROLLBACK_ADD_2 != null) {
                this.POST_ROLLBACK_ADD_2.messageEventOccurred(4, this, transaction);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.eventPostRollbackAdd", (String)"1:1127:1.197", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)((Object)sIException));
            }
            throw new SIErrorException((Throwable)sIException);
        }
        this.resetEvents();
        if (UserTrace.tc_mt.isDebugEnabled()) {
            String string = null;
            if (this.getMessage() instanceof JsApiMessage) {
                string = ((JsApiMessage)this.getMessage()).getApiMessageId();
            } else if (this.getMessage().getApiMessageIdAsBytes() != null) {
                string = this.getMessage().getApiMessageIdAsBytes().toString();
            }
            SibTr.debug((TraceComponent)UserTrace.tc_mt, (String)nls_mt.getFormattedMessage("MESSAGE_ROLLBACK_CWSJU0010", new Object[]{string, this.getMessage().getSystemMessageId(), this.debugName}, null));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackAdd");
        }
    }

    public void eventPostRollbackRemove(Transaction transaction) {
        super.eventPostRollbackRemove(transaction);
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)transaction);
        }
        try {
            if (this.POST_ROLLBACK_REMOVE_1 != null) {
                this.POST_ROLLBACK_REMOVE_1.messageEventOccurred(5, this, transaction);
            }
            if (this.POST_ROLLBACK_REMOVE_2 != null) {
                this.POST_ROLLBACK_REMOVE_2.messageEventOccurred(5, this, transaction);
            }
            if (this.POST_ROLLBACK_REMOVE_3 != null) {
                this.POST_ROLLBACK_REMOVE_3.messageEventOccurred(5, this, transaction);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.eventPostRollbackRemove", (String)"1:1195:1.197", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove", (Object)((Object)sIException));
            }
            throw new SIErrorException((Throwable)sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackRemove");
        }
    }

    private void resetEvents() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"resetEvents");
        }
        this.PRE_COMMIT_ADD = null;
        this.PRE_COMMIT_REMOVE = null;
        this.POST_COMMIT_ADD_1 = null;
        this.POST_COMMIT_ADD_2 = null;
        this.POST_COMMIT_REMOVE_1 = null;
        this.POST_COMMIT_REMOVE_2 = null;
        this.POST_COMMIT_REMOVE_3 = null;
        this.POST_ROLLBACK_ADD_1 = null;
        this.POST_ROLLBACK_ADD_2 = null;
        this.POST_ROLLBACK_REMOVE_1 = null;
        this.POST_ROLLBACK_REMOVE_2 = null;
        this.POST_ROLLBACK_REMOVE_3 = null;
        this.UNLOCKED = null;
        this.REFERENCES_DROPPED_TO_ZERO = null;
        this.PRE_PREPARE_TRANSACTION = null;
        this.POST_COMMITTED_TRANSACTION = null;
        this.EXPIRY_NOTIFICATION = null;
        this.COD_CALLBACK = null;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"resetEvents");
        }
    }

    public void eventUnlocked() {
        super.eventUnlocked();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventUnlocked");
        }
        this.reavailable = true;
        if (this.UNLOCKED != null) {
            try {
                this.UNLOCKED.messageEventOccurred(6, this, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.eventUnlocked", (String)"1:1265:1.197", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"eventUnlocked", (Object)((Object)sIException));
                }
                throw new SIErrorException((Throwable)sIException);
            }
        }
        this.reavailable = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventUnlocked");
        }
    }

    public void eventLocked() {
    }

    public void itemReferencesDroppedToZero() {
        super.itemReferencesDroppedToZero();
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"itemReferencesDroppedToZero");
        }
        if (this.REFERENCES_DROPPED_TO_ZERO != null) {
            try {
                this.REFERENCES_DROPPED_TO_ZERO.messageEventOccurred(7, this, null);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.itemReferencesDroppedToZero", (String)"1:1313:1.197", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"itemReferencesDroppedToZero", (Object)((Object)sIException));
                }
                throw new SIErrorException((Throwable)sIException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"itemReferencesDroppedToZero");
        }
    }

    public SIBUuid12 getProducerConnectionUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProducerConnectionUuid");
        }
        if (this.producerConnectionUuid == null) {
            this.producerConnectionUuid = this.msg.getConnectionUuid();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getProducerConnectionUuid", (Object)this.producerConnectionUuid);
        }
        return this.producerConnectionUuid;
    }

    public void setProducerConnectionUuid(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setProducerConnectionUuid", (Object)sIBUuid12);
        }
        this.producerConnectionUuid = sIBUuid12;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setProducerConnectionUuid");
        }
    }

    public void setProducerSeed(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setProducerSeed", (Object)new Integer(n));
        }
        this.producerSeed = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setProducerSeed");
        }
    }

    public void setForcePut(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setForcePut", (Object)new Boolean(bl));
        }
        this.forcePut = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setForcePut");
        }
    }

    public boolean isForcePut() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isForcePut");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isForcePut", (Object)new Boolean(this.forcePut));
        }
        return this.forcePut;
    }

    public String toString() {
        if (this.msg instanceof JsJmsTextMessage) {
            String string = ((JsJmsTextMessage)this.msg).getText();
            if (string != null && string.length() > 50) {
                string = string.substring(0, 50);
            }
            return super.toString() + " -- " + string;
        }
        return super.toString() + " -- " + this.msg.toString();
    }

    public void setTransacted(boolean bl) {
        this.transacted = bl;
    }

    public boolean isTransacted() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isTransacted");
            SibTr.exit((TraceComponent)tc, (String)"isTransacted", (Object)new Boolean(this.transacted));
        }
        return this.transacted;
    }

    public int getProducerSeed() {
        return this.producerSeed;
    }

    public void setMaxStorageStrategy(int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMaxStorageStrategy", (Object)new Integer(n));
        }
        this.maxStorageStrategy = n;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMaxStorageStrategy");
        }
    }

    public int getPriority() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPriority");
        }
        if (this.msgPriority == -2) {
            this.msgPriority = this.msg.getPriority();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPriority", (Object)new Integer(this.msgPriority));
        }
        return this.msgPriority;
    }

    public void setPriority(int n) {
        this.msgPriority = n;
        this.msg.setPriority(n);
    }

    public void registerMessageEventListener(int n, MessageEventListener messageEventListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"registerMessageEventListener", (Object)new Object[]{new Integer(n), messageEventListener});
        }
        boolean bl = false;
        switch (n) {
            case 2: {
                if (this.POST_COMMIT_ADD_1 == null) {
                    this.POST_COMMIT_ADD_1 = messageEventListener;
                    break;
                }
                if (this.POST_COMMIT_ADD_2 == null) {
                    this.POST_COMMIT_ADD_2 = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 3: {
                if (this.POST_COMMIT_REMOVE_1 == null) {
                    this.POST_COMMIT_REMOVE_1 = messageEventListener;
                    break;
                }
                if (this.POST_COMMIT_REMOVE_2 == null) {
                    this.POST_COMMIT_REMOVE_2 = messageEventListener;
                    break;
                }
                if (this.POST_COMMIT_REMOVE_3 == null) {
                    this.POST_COMMIT_REMOVE_3 = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 4: {
                if (this.POST_ROLLBACK_ADD_1 == null) {
                    this.POST_ROLLBACK_ADD_1 = messageEventListener;
                    break;
                }
                if (this.POST_ROLLBACK_ADD_2 == null) {
                    this.POST_ROLLBACK_ADD_2 = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 5: {
                if (this.POST_ROLLBACK_REMOVE_1 == null) {
                    this.POST_ROLLBACK_REMOVE_1 = messageEventListener;
                    break;
                }
                if (this.POST_ROLLBACK_REMOVE_2 == null) {
                    this.POST_ROLLBACK_REMOVE_2 = messageEventListener;
                    break;
                }
                if (this.POST_ROLLBACK_REMOVE_3 == null) {
                    this.POST_ROLLBACK_REMOVE_3 = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 0: {
                if (this.PRE_COMMIT_ADD == null) {
                    this.PRE_COMMIT_ADD = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 1: {
                if (this.PRE_COMMIT_REMOVE == null) {
                    this.PRE_COMMIT_REMOVE = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 7: {
                if (this.REFERENCES_DROPPED_TO_ZERO == null) {
                    this.REFERENCES_DROPPED_TO_ZERO = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 6: {
                if (this.UNLOCKED == null) {
                    this.UNLOCKED = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 8: {
                if (this.PRE_PREPARE_TRANSACTION == null) {
                    this.PRE_PREPARE_TRANSACTION = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 9: {
                if (this.POST_COMMITTED_TRANSACTION == null) {
                    this.POST_COMMITTED_TRANSACTION = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 10: {
                if (this.EXPIRY_NOTIFICATION == null) {
                    this.EXPIRY_NOTIFICATION = messageEventListener;
                    break;
                }
                bl = true;
                break;
            }
            case 11: {
                if (this.COD_CALLBACK == null) {
                    this.COD_CALLBACK = messageEventListener;
                    break;
                }
                bl = true;
            }
        }
        if (bl) {
            SIErrorException sIErrorException = new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.items.MessageItem.registerMessageEventListener", "1:1589:1.197", new Integer(n)}, null));
            FFDCFilter.processException((Throwable)sIErrorException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.registerMessageEventListener", (String)"1:1595:1.197", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.items.MessageItem.registerMessageEventListener", "1:1602:1.197", new Integer(n)});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"registerMessageEventListener", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"registerMessageEventListener");
        }
    }

    public void deregisterMessageEventListener(int n, MessageEventListener messageEventListener) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregisterMessageEventListener", (Object)new Object[]{new Integer(n), messageEventListener});
        }
        switch (n) {
            case 2: {
                if (this.POST_COMMIT_ADD_1 == messageEventListener) {
                    this.POST_COMMIT_ADD_1 = null;
                    break;
                }
                if (this.POST_COMMIT_ADD_2 != messageEventListener) break;
                this.POST_COMMIT_ADD_2 = null;
                break;
            }
            case 3: {
                if (this.POST_COMMIT_REMOVE_1 == messageEventListener) {
                    this.POST_COMMIT_REMOVE_1 = null;
                    break;
                }
                if (this.POST_COMMIT_REMOVE_2 == messageEventListener) {
                    this.POST_COMMIT_REMOVE_2 = null;
                    break;
                }
                if (this.POST_COMMIT_REMOVE_3 != messageEventListener) break;
                this.POST_COMMIT_REMOVE_3 = null;
                break;
            }
            case 4: {
                if (this.POST_ROLLBACK_ADD_1 == messageEventListener) {
                    this.POST_ROLLBACK_ADD_1 = null;
                    break;
                }
                if (this.POST_ROLLBACK_ADD_2 != messageEventListener) break;
                this.POST_ROLLBACK_ADD_2 = null;
                break;
            }
            case 5: {
                if (this.POST_ROLLBACK_REMOVE_1 == messageEventListener) {
                    this.POST_ROLLBACK_REMOVE_1 = null;
                    break;
                }
                if (this.POST_ROLLBACK_REMOVE_2 == messageEventListener) {
                    this.POST_ROLLBACK_REMOVE_2 = null;
                    break;
                }
                if (this.POST_ROLLBACK_REMOVE_3 != messageEventListener) break;
                this.POST_ROLLBACK_REMOVE_3 = null;
                break;
            }
            case 0: {
                if (this.PRE_COMMIT_ADD != messageEventListener) break;
                this.PRE_COMMIT_ADD = null;
                break;
            }
            case 1: {
                if (this.PRE_COMMIT_REMOVE != messageEventListener) break;
                this.PRE_COMMIT_REMOVE = null;
                break;
            }
            case 7: {
                if (this.REFERENCES_DROPPED_TO_ZERO != messageEventListener) break;
                this.REFERENCES_DROPPED_TO_ZERO = null;
                break;
            }
            case 6: {
                if (this.UNLOCKED != messageEventListener) break;
                this.UNLOCKED = null;
                break;
            }
            case 8: {
                if (this.PRE_PREPARE_TRANSACTION != messageEventListener) break;
                this.PRE_PREPARE_TRANSACTION = null;
                break;
            }
            case 9: {
                if (this.POST_COMMITTED_TRANSACTION != messageEventListener) break;
                this.POST_COMMITTED_TRANSACTION = null;
                break;
            }
            case 10: {
                if (this.EXPIRY_NOTIFICATION != messageEventListener) break;
                this.EXPIRY_NOTIFICATION = null;
                break;
            }
            case 11: {
                if (this.COD_CALLBACK != messageEventListener) break;
                this.COD_CALLBACK = null;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregisterMessageEventListener");
        }
    }

    public void addPersistentRef() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addPersistentRef");
        }
        this.maintainPersistence = 1;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addPersistentRef");
        }
    }

    public void addNonPersistentRef() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addNonPersistentRef");
        }
        if (this.maintainPersistence == -1) {
            this.maintainPersistence = 0;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addNonPersistentRef");
        }
    }

    public MessageProcessorSearchResults getSearchResults() {
        return this.searchResults;
    }

    public void setSearchResults(MessageProcessorSearchResults messageProcessorSearchResults) {
        this.searchResults = messageProcessorSearchResults;
    }

    public long getAggregateWaitTime() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getAggregateWaitTime");
        }
        if (this.messageWaitTime == -1L) {
            this.messageWaitTime = this.msg.getMessageWaitTime();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getAggregateWaitTime", (Object)new Long(this.messageWaitTime));
        }
        return this.messageWaitTime;
    }

    public long getLatestWaitTimeUpdate() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getLatestWaitTimeUpdate");
            SibTr.exit((TraceComponent)tc, (String)"getLatestWaitTimeUpdate", (Object)new Long(this.latestWaitTimeUpdate));
        }
        return this.latestWaitTimeUpdate;
    }

    public void beforeCompletion(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"beforeCompletion", (Object)transaction);
        }
        try {
            if (this.PRE_PREPARE_TRANSACTION != null) {
                this.PRE_PREPARE_TRANSACTION.messageEventOccurred(8, this, transaction);
                this.PRE_PREPARE_TRANSACTION = null;
            } else if (this.COD_CALLBACK != null) {
                this.COD_CALLBACK.messageEventOccurred(11, this, transaction);
            }
        }
        catch (SIException sIException) {
            FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.beforeCompletion", (String)"1:1808:1.197", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"beforeCompletion", (Object)((Object)sIException));
            }
            throw new SIErrorException((Throwable)sIException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"beforeCompletion");
        }
    }

    public void afterCompletion(Transaction transaction, boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"afterCompletion", (Object)transaction);
        }
        if (bl && this.POST_COMMITTED_TRANSACTION != null) {
            try {
                this.POST_COMMITTED_TRANSACTION.messageEventOccurred(9, this, transaction);
            }
            catch (SIException sIException) {
                FFDCFilter.processException((Throwable)sIException, (String)"com.ibm.ws.sib.processor.impl.store.items.MessageItem.afterCompletion", (String)"1:1845:1.197", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)sIException));
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"afterCompletion", (Object)((Object)sIException));
                }
                throw new SIErrorException((Throwable)sIException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"afterCompletion");
        }
    }

    public void setStreamIsGuess(boolean bl) {
        this.streamIsGuess = bl;
    }

    public boolean getStreamIsGuess() {
        return this.streamIsGuess;
    }

    public void setFanOut(int n) {
        this.fanOut = n;
    }

    public int getFanOut() {
        return this.fanOut;
    }

    public boolean getRequiresNewId() {
        return this.requiresNewId;
    }

    public void setRequiresNewId(boolean bl) {
        this.requiresNewId = bl;
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        formattedWriter.write(this.toString());
    }

    public void setStoreAtSendTime(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setStoreAtSendTime");
            SibTr.exit((TraceComponent)tc, (String)"setStoreAtSendTime");
        }
        this.storeAtSendTime = bl;
    }

    public boolean isToBeStoredAtSendTime() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isToBeStoredAtSendTime");
            SibTr.exit((TraceComponent)tc, (String)"isToBeStoredAtSendTime");
        }
        return this.storeAtSendTime;
    }

    public JsDestinationAddress getDestinationAddress() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDestinationAddress");
            SibTr.exit((TraceComponent)tc, (String)"getDestinationAddress", (Object)this.address);
        }
        return this.address;
    }

    public void setDestinationAddress(JsDestinationAddress jsDestinationAddress) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setDestinationAddress", (Object)jsDestinationAddress);
            SibTr.exit((TraceComponent)tc, (String)"setDestinationAddress");
        }
        this.address = jsDestinationAddress;
    }

    public ControlAdapter getControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getControlAdapter");
        }
        if (this.controlAdapter == null) {
            this.createControlAdapter();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getControlAdapter", (Object)this.controlAdapter);
        }
        return this.controlAdapter;
    }

    public void createControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"createControlAdapter");
        }
        BaseDestinationHandler baseDestinationHandler = null;
        ItemStream itemStream = this.getItemStream();
        if (itemStream instanceof PubSubMessageItemStream) {
            baseDestinationHandler = ((PubSubMessageItemStream)itemStream).getDestinationHandler();
            this.controlAdapter = new QueuedMessage((SIMPMessage)this, (DestinationHandler)baseDestinationHandler, itemStream);
        } else if (itemStream instanceof PtoPMessageItemStream) {
            baseDestinationHandler = ((PtoPMessageItemStream)itemStream).getDestinationHandler();
            this.controlAdapter = new QueuedMessage((SIMPMessage)this, (DestinationHandler)baseDestinationHandler, itemStream);
        } else if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)("Unknown item stream type " + itemStream));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"createControlAdapter");
        }
    }

    public void registerControlAdapterAsMBean() {
    }

    public void deregisterControlAdapterMBean() {
    }

    public boolean isFromRemoteME() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isFromRemoteME");
            SibTr.exit((TraceComponent)tc, (String)"isFromRemoteME", (Object)new Boolean(this.fromRemoteME));
        }
        return this.fromRemoteME;
    }

    public void setFromRemoteME(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setFromRemoteME", (Object)new Boolean(bl));
            SibTr.exit((TraceComponent)tc, (String)"setFromRemoteME");
        }
        this.fromRemoteME = bl;
    }

    public boolean isFromRemoteBus() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isFromRemoteBus");
            SibTr.exit((TraceComponent)tc, (String)"isFromRemoteBus", (Object)new Boolean(this.fromRemoteBus));
        }
        return this.fromRemoteBus;
    }

    public void setFromRemoteBus(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setFromRemoteBus", (Object)new Boolean(bl));
            SibTr.exit((TraceComponent)tc, (String)"setFromRemoteBus");
        }
        this.fromRemoteBus = bl;
    }

    public void dereferenceControlAdapter() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
        if (this.controlAdapter != null) {
            this.controlAdapter.dereferenceControllable();
            this.controlAdapter = null;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"dereferenceControlAdapter");
        }
    }

    public SIBUuid12 getGuaranteedStreamUuid() {
        if (!this.guaranteedStreamUuidSet) {
            this.guaranteedStreamUuidSet = true;
            this.guaranteedStreamUuid = this.msg.getGuaranteedStreamUUID();
        }
        return this.guaranteedStreamUuid;
    }

    public void setGuaranteedStreamUuid(SIBUuid12 sIBUuid12) {
        this.guaranteedStreamUuid = sIBUuid12;
        this.guaranteedStreamUuidSet = true;
        this.msg.setGuaranteedStreamUUID(this.guaranteedStreamUuid);
    }

    public Byte getReportCOD() {
        if (!this._reportCODSet) {
            this._reportCODSet = true;
            this._reportCOD = this.msg.getReportCOD();
        }
        return this._reportCOD;
    }

    public long getCurrentMEArrivalTimestamp() {
        if (this.currentMEArrivalTimeStamp == 0L) {
            this.currentMEArrivalTimeStamp = this.msg.getCurrentMEArrivalTimestamp();
        }
        return this.currentMEArrivalTimeStamp;
    }

    public void setCurrentMEArrivalTimestamp(long l) {
        this.currentMEArrivalTimeStamp = l;
        this.arrivalTimeStored = false;
    }

    public long updateStatisticsMessageWaitTime() {
        long l = System.currentTimeMillis();
        this.latestWaitTimeUpdate = this.calculateWaitTimeUpdate(l);
        this.messageWaitTime = this.latestWaitTimeUpdate + this.getAggregateWaitTime();
        return this.messageWaitTime;
    }

    public MessageStore getMessageStore() {
        return this.getOwningMessageStore();
    }

    public void setDebugName(String string) {
        this.debugName = string;
    }

    public boolean isReavailable() {
        return this.reavailable;
    }

    public int guessRedeliveredCount() {
        return super.guessUnlockCount();
    }

    private void setOriginatingBus(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setOriginatingBus", (Object)string);
        }
        this._busName = string;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setOriginatingBus");
        }
    }

    public String getOriginatingBus() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getOriginatingBus");
            SibTr.exit((TraceComponent)tc, (String)"getOriginatingBus", (Object)this._busName);
        }
        return this._busName;
    }

    public boolean isPersistentDataImmutable() {
        return true;
    }

    public boolean isPersistentDataNeverUpdated() {
        return true;
    }

    public void forceCurrentMEArrivalTimeToJsMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"forceCurrentMEArrivalTimeToJsMessage");
        }
        if (!this.arrivalTimeStored) {
            this.msg.setCurrentMEArrivalTimestamp(this.currentMEArrivalTimeStamp);
            this.arrivalTimeStored = true;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"forceCurrentMEArrivalTimeToJsMessage");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/items/MessageItem.java, SIB.processor, WAS602.SIB, o0610.11 1.197");
        }
    }
}

