/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store.items;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.transactions.Transaction;
import com.ibm.ws.sib.processor.impl.AIStreamKey;
import com.ibm.ws.sib.processor.impl.AnycastInputHandler;
import com.ibm.ws.sib.processor.impl.store.items.SIMPItem;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

public class AIProtocolItem
extends SIMPItem
implements Comparable {
    private long _tick;
    private byte _protocolState;
    private int _storagePolicy;
    private AnycastInputHandler _aihCallbackTarget;
    private boolean _unavailableAfterRecovery;
    private static final TraceComponent tc = SibTr.register((Class)AIProtocolItem.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 1;

    public AIProtocolItem(long l, byte by, Reliability reliability, AnycastInputHandler anycastInputHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIProtocolItem", (Object)new Object[]{new Long(l), new Byte(by), reliability, anycastInputHandler});
        }
        this._tick = l;
        this._protocolState = by;
        this._storagePolicy = this.computeStoragePolicy(reliability);
        this._aihCallbackTarget = anycastInputHandler;
        this._unavailableAfterRecovery = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIProtocolItem", (Object)this);
        }
    }

    public AIProtocolItem() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"AIProtocolItem");
        }
        this._storagePolicy = 3;
        this._aihCallbackTarget = null;
        this._unavailableAfterRecovery = false;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"AIProtocolItem", (Object)this);
        }
    }

    public int compareTo(Object object) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"compareTo", (Object)object);
        }
        if (object instanceof AIProtocolItem) {
            AIProtocolItem aIProtocolItem = (AIProtocolItem)object;
            int n = aIProtocolItem._tick < this._tick ? -1 : (aIProtocolItem._tick > this._tick ? 1 : 0);
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"compareTo");
            }
            return n;
        }
        ClassCastException classCastException = new ClassCastException();
        FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ws.sib.processor.impl.store.items.AIProtocolItem.compareTo", (String)"1:151:1.23", (Object)this);
        SibTr.exception((TraceComponent)tc, (Exception)classCastException);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"compareTo");
        }
        throw classCastException;
    }

    public int getStorageStrategy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStorageStrategy");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStorageStrategy", (Object)new Integer(this._storagePolicy));
        }
        return this._storagePolicy;
    }

    public long getMaximumTimeInStore() {
        return -2L;
    }

    public int getPersistentVersion() {
        return 1;
    }

    public void getPersistentData(ObjectOutputStream objectOutputStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)objectOutputStream);
        }
        try {
            HashMap<String, Number> hashMap = new HashMap<String, Number>();
            hashMap.put("tick", new Long(this._tick));
            hashMap.put("protocolState", new Byte(this._protocolState));
            hashMap.put("storagePolicy", new Integer(this._storagePolicy));
            objectOutputStream.writeObject(hashMap);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.processor.impl.store.items.AIProtocolItem.getPersistentData", (String)"1:211:1.23", (Object)this);
            SIErrorException sIErrorException = new SIErrorException((Throwable)iOException);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void restore(ObjectInputStream objectInputStream, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{objectInputStream, new Integer(n)});
        }
        this.checkPersistentVersionId(n);
        try {
            HashMap hashMap = (HashMap)objectInputStream.readObject();
            this._tick = (Long)hashMap.get("tick");
            this._protocolState = (Byte)hashMap.get("protocolState");
            this._storagePolicy = (Integer)hashMap.get("storagePolicy");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.store.items.AIProtocolItem.restore", (String)"1:252:1.23", (Object)this);
            SIErrorException sIErrorException = new SIErrorException((Throwable)exception);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIErrorException));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)((Object)sIErrorException));
            }
            throw sIErrorException;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void eventPostCommitAdd(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostCommitAdd", (Object)transaction);
        }
        if (this._aihCallbackTarget != null) {
            AIStreamKey aIStreamKey = new AIStreamKey(this._tick);
            aIStreamKey.setAcceptedItem(this);
            this._aihCallbackTarget.committed(aIStreamKey);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostCommitAdd");
        }
    }

    public void eventPostRollbackAdd(Transaction transaction) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"eventPostRollbackAdd", (Object)transaction);
        }
        if (this._aihCallbackTarget != null && this._unavailableAfterRecovery) {
            AIStreamKey aIStreamKey = new AIStreamKey(this._tick);
            aIStreamKey.setAcceptedItem(this);
            this._aihCallbackTarget.rolledback(aIStreamKey);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"eventPostRollbackAdd");
        }
    }

    public long getTick() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTick");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTick", (Object)new Long(this._tick));
        }
        return this._tick;
    }

    public byte getProtocolState() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getProtocolState");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getProtocolState", (Object)new Byte(this._protocolState));
        }
        return this._protocolState;
    }

    public final long getStoragePolicy() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getStoragePolicy");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getStoragePolicy", (Object)new Integer(this._storagePolicy));
        }
        return this._storagePolicy;
    }

    public void setAIHCallbackTarget(AnycastInputHandler anycastInputHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setAIHCallbackTarget", (Object)anycastInputHandler);
        }
        this._aihCallbackTarget = anycastInputHandler;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setAIHCallbackTarget");
        }
    }

    public boolean isUnavailableAfterRecovery() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isUnavailableAfterRecovery");
            SibTr.exit((TraceComponent)tc, (String)"isUnavailableAfterRecovery", (Object)new Boolean(this._unavailableAfterRecovery));
        }
        return this._unavailableAfterRecovery;
    }

    public void setUnavailableAfterRecovery(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setUnavailableAfterRecovery", (Object)new Boolean(bl));
        }
        this._unavailableAfterRecovery = bl;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setUnavailableAfterRecovery");
        }
    }

    private int computeStoragePolicy(Reliability reliability) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"computeStoragePolicy", (Object)reliability);
        }
        int n = 0;
        n = reliability.compareTo((Object)Reliability.ASSURED_PERSISTENT) == 0 ? 4 : (reliability.compareTo((Object)Reliability.RELIABLE_PERSISTENT) == 0 ? 3 : 1);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"computeStoragePolicy", (Object)new Integer(n));
        }
        return n;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/items/AIProtocolItem.java, SIB.processor, WAS602.SIB, o0610.11 1.23");
        }
    }
}

