/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.store;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.msgstore.MessageStore;
import com.ibm.ws.sib.msgstore.MessageStoreException;
import com.ibm.ws.sib.processor.impl.store.SIMPTransactionManager;
import com.ibm.ws.sib.processor.impl.store.itemstreams.SIMPItemStream;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.FormattedWriter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class MessageProcessorStore
extends SIMPItemStream {
    private static final TraceComponent tc = SibTr.register((Class)MessageProcessorStore.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final int PERSISTENT_VERSION = 1;
    private SIBUuid8 messagingEngineUuid;

    public MessageProcessorStore() {
    }

    public MessageProcessorStore(SIBUuid8 sIBUuid8, MessageStore messageStore, SIMPTransactionManager sIMPTransactionManager) throws MessageStoreException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"MessageProcessorStore", (Object)new Object[]{sIBUuid8, messageStore, sIMPTransactionManager});
        }
        this.setMessagingEngineUuid(sIBUuid8);
        messageStore.add(this, sIMPTransactionManager.createAutoCommitTransaction());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"MessageProcessorStore", (Object)this);
        }
    }

    public SIBUuid8 getMessagingEngineUuid() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getMessagingEngineUuid");
            SibTr.exit((TraceComponent)tc, (String)"getMessagingEngineUuid", (Object)this.messagingEngineUuid);
        }
        return this.messagingEngineUuid;
    }

    private void setMessagingEngineUuid(SIBUuid8 sIBUuid8) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"setMessagingEngineUuid", (Object)new Object[]{sIBUuid8});
        }
        this.messagingEngineUuid = sIBUuid8;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"setMessagingEngineUuid");
        }
    }

    public int getPersistentVersion() {
        return 1;
    }

    public void getPersistentData(ObjectOutputStream objectOutputStream) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getPersistentData", (Object)objectOutputStream);
        }
        try {
            objectOutputStream.writeObject(this.messagingEngineUuid.toByteArray());
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.sib.processor.impl.store.MessageProcessorStore.getPersistentData", (String)"1:210:1.42", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)iOException);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.MessageProcessorStore", "1:217:1.42", iOException});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"getPersistentData", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.MessageProcessorStore", "1:228:1.42", iOException}, null), (Throwable)iOException);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getPersistentData");
        }
    }

    public void restore(ObjectInputStream objectInputStream, int n) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"restore", (Object)new Object[]{objectInputStream, new Integer(n)});
        }
        this.checkPersistentVersionId(n);
        try {
            this.messagingEngineUuid = new SIBUuid8((byte[])objectInputStream.readObject());
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.sib.processor.impl.store.MessageProcessorStore.restore", (String)"1:258:1.42", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)exception);
            SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.store.MessageProcessorStore", "1:265:1.42", exception});
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"restore", (Object)"SIErrorException");
            }
            throw new SIErrorException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.store.MessageProcessorStore", "1:275:1.42", exception}, null), (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"restore");
        }
    }

    public void xmlWriteOn(FormattedWriter formattedWriter) throws IOException {
        formattedWriter.newLine();
        formattedWriter.startTag("messagingEngineUuid");
        formattedWriter.write(this.messagingEngineUuid.toString());
        formattedWriter.endTag("messagingEngineUuid");
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/store/MessageProcessorStore.java, SIB.processor, WAS602.SIB, o0610.11 1.42");
        }
    }
}

