/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.indexes;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.interfaces.ControllableSubscription;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.processor.utils.index.IndexFilter;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;

public class SubscriptionIndex
extends Index {
    private static final TraceComponent tc = SibTr.register((Class)SubscriptionIndex.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private int durableSubscriptions = 0;
    private int nonDurableSubscriptions = 0;

    public synchronized Index.Entry put(ControllableSubscription controllableSubscription) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{controllableSubscription});
        }
        SubscriptionType subscriptionType = new SubscriptionType();
        subscriptionType.durable = controllableSubscription.isDurable();
        subscriptionType.local = controllableSubscription.isLocal();
        SubscriptionEntry subscriptionEntry = new SubscriptionEntry(controllableSubscription, subscriptionType);
        this.add(subscriptionEntry);
        if (controllableSubscription.isDurable()) {
            ++this.durableSubscriptions;
        } else {
            ++this.nonDurableSubscriptions;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)subscriptionEntry);
        }
        return subscriptionEntry;
    }

    public synchronized void remove(ControllableSubscription controllableSubscription) {
        ControllableSubscription controllableSubscription2;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{controllableSubscription});
        }
        if ((controllableSubscription2 = (ControllableSubscription)this.remove(controllableSubscription.getSubscriptionUuid())) != null) {
            if (controllableSubscription2.isDurable()) {
                --this.durableSubscriptions;
            } else {
                --this.nonDurableSubscriptions;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public synchronized ControllableSubscription findByUuid(SIBUuid12 sIBUuid12, IndexFilter indexFilter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findByUuid", (Object)new Object[]{sIBUuid12, indexFilter});
        }
        ControllableSubscription controllableSubscription = (ControllableSubscription)this.get(sIBUuid12, indexFilter);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findByUuid", (Object)controllableSubscription);
        }
        return controllableSubscription;
    }

    public synchronized SubscriptionType getType(SIBUuid12 sIBUuid12) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getType", (Object)new Object[]{sIBUuid12});
        }
        SubscriptionType subscriptionType = (SubscriptionType)super.getType(sIBUuid12).clone();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getType", (Object)subscriptionType);
        }
        return subscriptionType;
    }

    public synchronized int getDurableSubscriptions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getDurableSubscriptions");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getDurableSubscriptions", (Object)new Integer(this.durableSubscriptions));
        }
        return this.durableSubscriptions;
    }

    public synchronized int getNonDurableSubscriptions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getNonDurableSubscriptions");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getNonDurableSubscriptions", (Object)new Integer(this.nonDurableSubscriptions));
        }
        return this.nonDurableSubscriptions;
    }

    public synchronized int getTotalSubscriptions() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getTotalSubscriptions");
        }
        int n = this.durableSubscriptions + this.nonDurableSubscriptions;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getTotalSubscriptions", (Object)new Integer(n));
        }
        return n;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/indexes/SubscriptionIndex.java, SIB.processor, WAS602.SIB, o0610.11 1.7");
        }
    }

    protected static class SubscriptionEntry
    extends Index.Entry {
        SubscriptionEntry(ControllableSubscription controllableSubscription, SubscriptionType subscriptionType) {
            super(controllableSubscription.getSubscriptionUuid(), controllableSubscription, subscriptionType);
        }

        ControllableSubscription getControllableSubscription() {
            return (ControllableSubscription)this.data;
        }
    }

    public static class SubscriptionType
    extends Index.Type {
        public boolean local = true;
        public boolean durable = false;
    }
}

