/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.indexes;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.MQLinkHandler;
import com.ibm.ws.sib.processor.impl.indexes.AbstractDestinationIndex;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.processor.utils.index.IndexFilter;
import com.ibm.ws.sib.utils.SIBUuid8;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;

public class LinkIndex
extends AbstractDestinationIndex {
    private static final TraceComponent tc = SibTr.register((Class)LinkIndex.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private HashMap nameIndex;
    private HashMap mqLinkIndex;

    public LinkIndex() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LinkIndex");
        }
        this.nameIndex = new HashMap(10);
        this.mqLinkIndex = new HashMap(10);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LinkIndex", (Object)this);
        }
    }

    public synchronized Index.Entry put(DestinationHandler destinationHandler, AbstractDestinationIndex.AbstractDestinationType abstractDestinationType) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{destinationHandler, abstractDestinationType});
        }
        Index.Entry entry = super.put(destinationHandler, abstractDestinationType);
        this.nameIndex.put(destinationHandler.getName(), entry);
        Type type = (Type)abstractDestinationType;
        if (type.mqLink.booleanValue()) {
            MQLinkHandler mQLinkHandler = (MQLinkHandler)destinationHandler;
            this.mqLinkIndex.put(mQLinkHandler.getMqLinkUuid(), entry);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)entry);
        }
        return entry;
    }

    public synchronized DestinationHandler findByName(String string, IndexFilter indexFilter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findByName", (Object)new Object[]{string, indexFilter});
        }
        DestinationHandler destinationHandler = null;
        Index.Entry entry = (Index.Entry)this.nameIndex.get(string);
        if (entry != null && (indexFilter == null || indexFilter.matches(entry.type))) {
            destinationHandler = (DestinationHandler)entry.data;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findByName", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public synchronized DestinationHandler findByMQLinkUuid(SIBUuid8 sIBUuid8, IndexFilter indexFilter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findByMQLinkUuid", (Object)new Object[]{sIBUuid8, indexFilter});
        }
        DestinationHandler destinationHandler = null;
        Index.Entry entry = (Index.Entry)this.mqLinkIndex.get(sIBUuid8);
        if (entry != null && (indexFilter == null || indexFilter.matches(entry.type))) {
            destinationHandler = (DestinationHandler)entry.data;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findByMQLinkUuid", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    public synchronized void remove(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{destinationHandler});
        }
        super.remove(destinationHandler);
        if (destinationHandler.isMQLink()) {
            this.removeFromMQLinkIndex(destinationHandler);
        }
        AbstractDestinationIndex.DestinationEntry destinationEntry = (AbstractDestinationIndex.DestinationEntry)this.nameIndex.get(destinationHandler.getName());
        if (destinationEntry.data == destinationHandler) {
            this.nameIndex.remove(destinationHandler.getName());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public synchronized void remove(Index.Entry entry) {
        AbstractDestinationIndex.DestinationEntry destinationEntry;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{entry});
        }
        super.remove(entry);
        DestinationHandler destinationHandler = (DestinationHandler)entry.data;
        if (destinationHandler.isMQLink()) {
            this.removeFromMQLinkIndex(destinationHandler);
        }
        if ((destinationEntry = (AbstractDestinationIndex.DestinationEntry)this.nameIndex.get(destinationHandler.getName())) == entry) {
            this.nameIndex.remove(destinationHandler.getName());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    private void removeFromMQLinkIndex(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"removeFromMQLinkIndex", (Object)destinationHandler);
        }
        MQLinkHandler mQLinkHandler = (MQLinkHandler)destinationHandler;
        this.mqLinkIndex.remove(mQLinkHandler.getMqLinkUuid());
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"removeFromMQLinkIndex");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/indexes/LinkIndex.java, SIB.processor, WAS602.SIB, o0610.11 1.7");
        }
    }

    public static class Type
    extends AbstractDestinationIndex.AbstractDestinationType {
        public Boolean local = null;
        public Boolean mqLink = null;
        public Boolean remote = null;
    }
}

