/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl.indexes;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.processor.impl.indexes.AbstractDestinationIndex;
import com.ibm.ws.sib.processor.impl.interfaces.DestinationHandler;
import com.ibm.ws.sib.processor.utils.index.Index;
import com.ibm.ws.sib.processor.utils.index.IndexFilter;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.HashMap;

public class DestinationIndex
extends AbstractDestinationIndex {
    private static final TraceComponent tc = SibTr.register((Class)DestinationIndex.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private HashMap busIndex;

    public DestinationIndex(String string) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"DestinationIndex", (Object)string);
        }
        this.busIndex = new HashMap(1);
        HashMap hashMap = new HashMap(10);
        this.busIndex.put(string, hashMap);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"DestinationIndex", (Object)this);
        }
    }

    public synchronized Index.Entry put(DestinationHandler destinationHandler, AbstractDestinationIndex.AbstractDestinationType abstractDestinationType) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"put", (Object)new Object[]{destinationHandler, abstractDestinationType});
        }
        Index.Entry entry = super.put(destinationHandler, abstractDestinationType);
        this.addToBusMap(destinationHandler, entry);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"put", (Object)entry);
        }
        return entry;
    }

    synchronized void addToBusMap(DestinationHandler destinationHandler, Index.Entry entry) {
        HashMap hashMap;
        AbstractDestinationIndex.DestinationEntry destinationEntry;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"addToBusMap", (Object)new Object[]{destinationHandler, entry});
        }
        if ((destinationEntry = (AbstractDestinationIndex.DestinationEntry)(hashMap = this.getBusMap(destinationHandler.getBus())).get(destinationHandler.getName())) != null && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"*** put, duplicate name", (Object)new Object[]{destinationHandler, destinationEntry.data});
        }
        hashMap.put(destinationHandler.getName(), entry);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addToBusMap");
        }
    }

    public synchronized void remove(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{destinationHandler});
        }
        super.remove(destinationHandler);
        HashMap hashMap = this.getBusMap(destinationHandler.getBus());
        AbstractDestinationIndex.DestinationEntry destinationEntry = (AbstractDestinationIndex.DestinationEntry)hashMap.get(destinationHandler.getName());
        if (destinationEntry != null && destinationEntry.data == destinationHandler) {
            hashMap.remove(destinationHandler.getName());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public synchronized DestinationHandler findByName(String string, String string2, IndexFilter indexFilter) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"findByName", (Object)new Object[]{string2, string, indexFilter});
        }
        DestinationHandler destinationHandler = null;
        HashMap hashMap = this.getBusMap(string2);
        AbstractDestinationIndex.DestinationEntry destinationEntry = (AbstractDestinationIndex.DestinationEntry)hashMap.get(string);
        if (destinationEntry != null && (indexFilter == null || indexFilter.matches(destinationEntry.type))) {
            destinationHandler = destinationEntry.getHandler();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"findByName", (Object)destinationHandler);
        }
        return destinationHandler;
    }

    private synchronized HashMap getBusMap(String string) {
        HashMap hashMap;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBusMap", (Object)new Object[]{string});
        }
        if ((hashMap = (HashMap)this.busIndex.get(string)) == null) {
            hashMap = new HashMap(10);
            this.busIndex.put(string, hashMap);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBusMap", hashMap);
        }
        return hashMap;
    }

    public synchronized void remove(Index.Entry entry) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"remove", (Object)new Object[]{entry});
        }
        super.remove(entry);
        DestinationHandler destinationHandler = (DestinationHandler)entry.data;
        HashMap hashMap = this.getBusMap(destinationHandler.getBus());
        AbstractDestinationIndex.DestinationEntry destinationEntry = (AbstractDestinationIndex.DestinationEntry)hashMap.get(destinationHandler.getName());
        if (destinationEntry == entry) {
            hashMap.remove(destinationHandler.getName());
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"remove");
        }
    }

    public synchronized boolean containsKey(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"containsKey", (Object)new Object[]{string, string2});
        }
        HashMap hashMap = this.getBusMap(string);
        boolean bl = hashMap.containsKey(string2);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"containsKey", (Object)new Boolean(bl));
        }
        return bl;
    }

    public synchronized void create(DestinationHandler destinationHandler) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"create", (Object)new Object[]{destinationHandler});
        }
        AbstractDestinationIndex.AbstractDestinationType abstractDestinationType = this._getType(destinationHandler);
        abstractDestinationType.state = abstractDestinationType.state.create();
        if (abstractDestinationType.state.isVisible()) {
            this.addToBusMap(destinationHandler, (Index.Entry)this.index.get(destinationHandler.getUuid()));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"create");
        }
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/indexes/DestinationIndex.java, SIB.processor, WAS602.SIB, o0610.11 1.10");
        }
    }

    public static class Type
    extends AbstractDestinationIndex.AbstractDestinationType {
        public Boolean queue = null;
        public Boolean alias = null;
        public Boolean foreignDestination = null;
        public Boolean local = null;
        public Boolean remote = null;
    }
}

