/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIIncorrectCallException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.mfp.MessageCopyFailedException;
import com.ibm.ws.sib.processor.MPLockedMessageEnumeration;
import com.ibm.ws.sib.processor.impl.ConnectionImpl;
import com.ibm.ws.sib.processor.impl.LocalConsumerPoint;
import com.ibm.ws.sib.processor.impl.corespitrace.CoreSPILockedMessageEnumeration;
import com.ibm.ws.sib.processor.impl.interfaces.SIMPMessage;
import com.ibm.ws.sib.processor.utils.UserTrace;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.ConsumerSession;
import com.ibm.wsspi.sib.core.SIBusMessage;
import com.ibm.wsspi.sib.core.SITransaction;
import com.ibm.wsspi.sib.core.exception.SIConnectionLostException;
import com.ibm.wsspi.sib.core.exception.SISessionDroppedException;
import com.ibm.wsspi.sib.core.exception.SISessionUnavailableException;

final class SingleLockedMessageEnumerationImpl
implements MPLockedMessageEnumeration {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceNLS nls_cwsir = TraceNLS.getTraceNLS((String)"com.ibm.wsspi.sib.core.CWSIRMessages");
    private static TraceComponent tc = SibTr.register((Class)SingleLockedMessageEnumerationImpl.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private LocalConsumerPoint _localConsumerPoint;
    private boolean _isPubsub;
    private boolean _seenSingleMessage = false;
    private boolean _messageAvailable = false;
    private SIMPMessage _singleMessage = null;
    private boolean _validState = true;

    SingleLockedMessageEnumerationImpl(LocalConsumerPoint localConsumerPoint, SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SingleLockedMessageEnumerationImpl", (Object)new Object[]{localConsumerPoint, sIMPMessage});
        }
        this._localConsumerPoint = localConsumerPoint;
        this._isPubsub = localConsumerPoint.getConsumerDispatcher().isPubSub();
        this._singleMessage = sIMPMessage;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SingleLockedMessageEnumerationImpl", (Object)this);
        }
    }

    void clearMessage() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"clearMessage");
            SibTr.exit((TraceComponent)tc, (String)"clearMessage");
        }
        this._validState = false;
        this._singleMessage = null;
    }

    void newMessage(SIMPMessage sIMPMessage) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"newMessage", (Object)sIMPMessage);
            SibTr.exit((TraceComponent)tc, (String)"newMessage");
        }
        this._validState = true;
        this._singleMessage = sIMPMessage;
        this._seenSingleMessage = false;
        this._messageAvailable = false;
    }

    public SIBusMessage nextLocked() throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIErrorException, SIIncorrectCallException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)this);
        }
        this.checkValidState("nextLocked");
        this._localConsumerPoint.checkNotClosed();
        if (this._seenSingleMessage || this._singleMessage == null) {
            this._messageAvailable = false;
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"nextLocked", null);
            }
            return null;
        }
        this._seenSingleMessage = true;
        JsMessage jsMessage = null;
        if (this._isPubsub && ((ConnectionImpl)this._localConsumerPoint.getConsumerSession().getConnection()).getMessageCopiedWhenReceived()) {
            try {
                jsMessage = this._singleMessage.getMessage().getReceived();
            }
            catch (MessageCopyFailedException messageCopyFailedException) {
                FFDCFilter.processException((Throwable)messageCopyFailedException, (String)"com.ibm.ws.sib.processor.impl.SingleLockedMessageEnumerationImpl.nextLocked", (String)"1:187:1.37.1.1", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)((Object)messageCopyFailedException));
                SibTr.error((TraceComponent)tc, (String)"INTERNAL_MESSAGING_ERROR_CWSIP0002", (Object)new Object[]{"com.ibm.ws.sib.processor.impl.SingleLockedMessageEnumerationImpl", "1:194:1.37.1.1", messageCopyFailedException});
                this._seenSingleMessage = false;
                this._messageAvailable = false;
                if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)((Object)messageCopyFailedException));
                }
                throw new SIResourceException(nls.getFormattedMessage("INTERNAL_MESSAGING_ERROR_CWSIP0002", new Object[]{"com.ibm.ws.sib.processor.impl.SingleLockedMessageEnumerationImpl", "1:208:1.37.1.1", messageCopyFailedException}, null), (Throwable)messageCopyFailedException);
            }
        } else {
            jsMessage = this._singleMessage.getMessage();
        }
        this._messageAvailable = true;
        if (UserTrace.tc_mt.isDebugEnabled()) {
            UserTrace.trace_Receive(null, jsMessage, this._localConsumerPoint.getConsumerSession().getDestinationAddress(), this._localConsumerPoint.getConsumerSession().getIdInternal());
        }
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"nextLocked", (Object)jsMessage);
        }
        return jsMessage;
    }

    public void unlockCurrent() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException, SIErrorException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)this);
        }
        this.deleteCurrent(null);
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent");
        }
    }

    public void unlockCurrent(boolean bl) throws SISessionUnavailableException, SISessionDroppedException, SIResourceException, SIConnectionLostException, SIIncorrectCallException, SIErrorException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent", (Object)new Object[]{this, new Boolean(bl)});
        }
        this.deleteCurrent(null);
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"unlockCurrent");
        }
    }

    public void deleteCurrent(SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException, SIErrorException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent", (Object)this);
        }
        this.checkValidState("deleteCurrent");
        this._localConsumerPoint.checkNotClosed();
        if (!this._messageAvailable) {
            if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent", (Object)"Invalid current Message");
            }
            throw new SIIncorrectCallException(nls.getFormattedMessage("INVALID_MESSAGE_ERROR_CWSIP0191", new Object[]{this._localConsumerPoint.getConsumerDispatcher().getDestination().getName(), this._localConsumerPoint.getConsumerDispatcher().messageProcessor.getMessagingEngineName()}, null));
        }
        this._singleMessage = null;
        this._messageAvailable = false;
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteCurrent");
        }
    }

    public void deleteSeen(SITransaction sITransaction) throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException, SIErrorException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteSeen", (Object)new Object[]{this, sITransaction});
        }
        this.deleteCurrent(sITransaction);
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"deleteSeen");
        }
    }

    public ConsumerSession getConsumerSession() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getConsumerSession", (Object)this);
        }
        this.checkValidState("getConsumerSession");
        this._localConsumerPoint.checkNotClosed();
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getConsumerSession", (Object)this._localConsumerPoint.getConsumerSession());
        }
        return this._localConsumerPoint.getConsumerSession();
    }

    public void resetCursor() throws SISessionUnavailableException, SISessionDroppedException, SIErrorException, SIIncorrectCallException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"resetCursor", (Object)this);
        }
        this.checkValidState("resetCursor");
        this._localConsumerPoint.checkNotClosed();
        this._seenSingleMessage = false;
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"resetCursor");
        }
    }

    public int getRemainingMessageCount() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getRemainingMessageCount", (Object)this);
        }
        this.checkValidState("getRemainingMessageCount");
        this._localConsumerPoint.checkNotClosed();
        int n = 0;
        if (!this._seenSingleMessage) {
            n = 1;
        }
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"getRemainingMessageCount", (Object)new Integer(n));
        }
        return n;
    }

    private void checkValidState(String string) throws SIIncorrectCallException {
        if (!this._validState) {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"checkValidState");
            }
            SIIncorrectCallException sIIncorrectCallException = new SIIncorrectCallException(nls_cwsir.getFormattedMessage("LME_ERROR_CWSIR0131", new Object[]{string}, null));
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"checkValidState", (Object)((Object)sIIncorrectCallException));
            }
            throw sIIncorrectCallException;
        }
    }

    public boolean hasNext() throws SISessionUnavailableException, SISessionDroppedException, SIIncorrectCallException {
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"hasNext", (Object)this);
        }
        this.checkValidState("hasNext");
        this._localConsumerPoint.checkNotClosed();
        boolean bl = false;
        if (!this._seenSingleMessage) {
            bl = true;
        }
        if (CoreSPILockedMessageEnumeration.tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)CoreSPILockedMessageEnumeration.tc, (String)"hasNext", (Object)new Boolean(bl));
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/SingleLockedMessageEnumerationImpl.java, SIB.processor, WAS602.SIB, o0610.11 1.37.1.1");
        }
    }
}

