/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sib.mfp.JsMessage;
import com.ibm.ws.sib.security.auth.AuthUtils;
import com.ibm.ws.sib.utils.ras.SibTr;
import javax.security.auth.Subject;

public class SecurityContext {
    private static final TraceComponent tc = SibTr.register((Class)SecurityContext.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private AuthUtils authorisationUtils = null;
    private Subject subject = null;
    private String userId = null;
    private String alternateUser = null;
    private String discriminator = null;
    private JsMessage msg = null;

    public SecurityContext(String string, String string2) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SecurityContext", (Object)new Object[]{"userid(" + string + ")", string2});
        }
        this.userId = string;
        this.discriminator = string2;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SecurityContext", (Object)this);
        }
    }

    public SecurityContext(Subject subject, String string, String string2, AuthUtils authUtils) {
        if (tc.isEntryEnabled()) {
            String string3 = "<null>";
            if (subject != null) {
                string3 = "subject(" + authUtils.getUserName(subject) + ")";
            }
            SibTr.entry((TraceComponent)tc, (String)"SecurityContext", (Object)new Object[]{string3, string, string2, authUtils});
        }
        this.authorisationUtils = authUtils;
        this.subject = subject;
        this.alternateUser = string;
        this.discriminator = string2;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SecurityContext", (Object)this);
        }
    }

    public SecurityContext(JsMessage jsMessage, String string, String string2, AuthUtils authUtils) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"SecurityContext", (Object)new Object[]{"Message(" + jsMessage + ")", string, string2});
        }
        this.msg = jsMessage;
        this.authorisationUtils = authUtils;
        this.alternateUser = string;
        this.discriminator = string2;
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"SecurityContext", (Object)this);
        }
    }

    public String toString() {
        String string = null;
        if (this.isSubjectBased()) {
            if (this.authorisationUtils != null) {
                string = "subject(" + this.authorisationUtils.getUserName(this.subject) + ")";
            }
        } else if (this.isUserIdBased()) {
            string = "id(" + this.userId + ")";
        } else if (this.isMsgBased()) {
            string = "msg(" + this.msg.getSecurityUserid() + ")";
        }
        if (this.alternateUser != null) {
            string = string + ", alt user(" + this.alternateUser + ")";
        }
        if (this.discriminator != null) {
            string = string + ", discriminator(" + this.discriminator + ")";
        }
        return string;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public boolean testDiscriminatorAtCreate() {
        return this.discriminator != null;
    }

    public boolean isSubjectBased() {
        return this.subject != null;
    }

    public boolean isUserIdBased() {
        return this.userId != null;
    }

    public boolean isAlternateUserBased() {
        return this.alternateUser != null;
    }

    public boolean isMsgBased() {
        return this.msg != null;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAlternateUser() {
        return this.alternateUser;
    }

    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    public void setUserId(String string) {
        this.userId = string;
    }

    public void setDiscriminator(String string) {
        this.discriminator = string;
    }

    public JsMessage getMsg() {
        return this.msg;
    }

    public boolean alternateUserCheck() {
        boolean bl = false;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"alternateUserCheck");
        }
        if (this.authorisationUtils != null && this.subject != null && !this.authorisationUtils.getUserName(this.subject).equals(this.alternateUser)) {
            bl = this.isAlternateUserBased();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"alternateUserCheck", (Object)new Boolean(bl));
        }
        return bl;
    }

    public String getUserName(boolean bl) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getUserName", (Object)new Object[]{new Boolean(bl)});
        }
        String string = null;
        if (!bl && this.isAlternateUserBased()) {
            string = this.alternateUser;
        } else if (this.isSubjectBased()) {
            if (this.authorisationUtils != null) {
                string = this.authorisationUtils.getUserName(this.subject);
            }
        } else if (this.isUserIdBased()) {
            string = this.userId;
        } else if (this.isMsgBased()) {
            string = this.msg.getSecurityUserid();
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getUserName", (Object)string);
        }
        return string;
    }

    public boolean isSIBServerSubject() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"isSIBServerSubject");
        }
        boolean bl = false;
        if (this.isSubjectBased()) {
            if (this.authorisationUtils != null) {
                bl = this.authorisationUtils.isSIBServerSubject(this.subject);
            }
        } else if (this.isMsgBased() && this.authorisationUtils != null) {
            bl = this.authorisationUtils.sentBySIBServer(this.msg);
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"isSIBServerSubject", (Object)new Boolean(bl));
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: ");
        }
    }
}

