/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.sib.Reliability;
import com.ibm.websphere.sib.exception.SIErrorException;
import com.ibm.websphere.sib.exception.SIException;
import com.ibm.websphere.sib.exception.SINotPossibleInCurrentConfigurationException;
import com.ibm.websphere.sib.exception.SIResourceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.SIMPConstants;
import com.ibm.ws.sib.processor.impl.AIStreamKey;
import com.ibm.ws.sib.processor.impl.ConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.ConsumerKey;
import com.ibm.ws.sib.processor.impl.RemoteConsumerDispatcher;
import com.ibm.ws.sib.processor.impl.RemoteConsumerKeyGroup;
import com.ibm.ws.sib.processor.impl.interfaces.ConsumerPoint;
import com.ibm.ws.sib.processor.impl.interfaces.RemoteDispatchableKey;
import com.ibm.ws.sib.utils.SIBUuid12;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.SelectionCriteria;
import com.ibm.wsspi.sib.core.exception.SIDiscriminatorSyntaxException;
import com.ibm.wsspi.sib.core.exception.SISelectorSyntaxException;

public final class RemoteConsumerKey
extends ConsumerKey
implements RemoteDispatchableKey {
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.processor.CWSIPMessages");
    private static final TraceComponent tc = SibTr.register((Class)RemoteConsumerKey.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");
    final SelectionCriteria[] criteria;
    private final RemoteConsumerDispatcher rcd;
    final boolean readAhead;
    private int prefetchWindowSize;
    private int consumptionInterval;
    static final double alpha = 0.5;
    private long lastNotReadyTime;
    private boolean usable;
    private int countOfOutstandingInfiniteTimeoutGets;
    private int countOfUnlockedMessages;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RemoteConsumerKey(ConsumerPoint consumerPoint, ConsumerDispatcher consumerDispatcher, SelectionCriteria selectionCriteria, SIBUuid12 sIBUuid12, boolean bl, boolean bl2) throws SISelectorSyntaxException, SIDiscriminatorSyntaxException, SIResourceException {
        super(consumerPoint, consumerDispatcher, selectionCriteria, sIBUuid12, bl2);
        Object object;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"RemoteConsumerKey", (Object)new Object[]{consumerPoint, consumerDispatcher, selectionCriteria, sIBUuid12, new Boolean(bl), new Boolean(bl2)});
        }
        this.criteria = new SelectionCriteria[1];
        if (super.isSpecific()) {
            this.criteria[0] = selectionCriteria;
        } else {
            object = null;
            this.criteria[0] = object = consumerDispatcher.getMessageProcessor().getSelectionCriteriaFactory().createSelectionCriteria();
            if (tc.isEntryEnabled()) {
                SibTr.exit((TraceComponent)tc, (String)"RemoteConsumerKey", (Object)this);
            }
        }
        this.rcd = (RemoteConsumerDispatcher)consumerDispatcher;
        this.readAhead = bl;
        object = this;
        synchronized (object) {
            this.prefetchWindowSize = 0;
            this.consumptionInterval = 2 * SIMPConstants.MAX_INTERVAL_FOR_PREFETCH;
            this.lastNotReadyTime = 0L;
            this.usable = false;
            this.countOfOutstandingInfiniteTimeoutGets = 0;
            this.countOfUnlockedMessages = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long waiting(long l, boolean bl) {
        block21: {
            if (tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"waiting", (Object)new Object[]{new Long(l), new Boolean(bl)});
            }
            try {
                Object object;
                long l2;
                if (l == 0L) {
                    l2 = SIMPConstants.INFINITE_TIMEOUT;
                } else if (l == -1L) {
                    l = this.rcd.getRoundTripTime();
                    l2 = 0L;
                } else {
                    long l3 = this.rcd.getRoundTripTime();
                    l = l2 = l + l3;
                }
                boolean bl2 = true;
                if (this.readAhead) {
                    object = this;
                    synchronized (object) {
                        if (this.countOfOutstandingInfiniteTimeoutGets > 0) {
                            bl2 = false;
                        } else if (this.keyGroup == null && l2 == SIMPConstants.INFINITE_TIMEOUT) {
                            ++this.countOfOutstandingInfiniteTimeoutGets;
                        }
                    }
                    this.tryPrefetching();
                }
                if (!bl2 || (object = this.keyGroup == null ? this.rcd.issueGet(this.criteria, l2, (RemoteDispatchableKey)this) : ((RemoteConsumerKeyGroup)this.keyGroup).issueGet(l2)) != null) break block21;
                Object object2 = this;
                synchronized (object2) {
                    if (this.keyGroup == null && l2 == SIMPConstants.INFINITE_TIMEOUT) {
                        --this.countOfOutstandingInfiniteTimeoutGets;
                    }
                }
                object2 = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0481", new Object[]{this.rcd.getDestName(), this.rcd.getLocalisationME().toString()}, null));
                FFDCFilter.processException((Throwable)object2, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerKey.waiting", (String)"1:258:1.38", (Object)this);
                SibTr.exception((TraceComponent)tc, (Exception)object2);
                this.consumerPoint.notifyException((SIException)((Object)object2));
            }
            catch (SIResourceException sIResourceException) {
                FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerKey.waiting", (String)"1:271:1.38", (Object)this);
                if (tc.isEventEnabled()) {
                    SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
                }
                if (tc.isEntryEnabled()) {
                    SibTr.exit((TraceComponent)tc, (String)"waiting", (Object)"SIErrorException");
                }
                throw new SIErrorException((Throwable)sIResourceException);
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"waiting", (Object)new Long(l));
        }
        return l;
    }

    protected void notReady() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notReady");
        }
        this.updateLastNotReadyTime();
        super.notReady();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notReady");
        }
    }

    public void ready(Reliability reliability) throws SINotPossibleInCurrentConfigurationException {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"ready", (Object)reliability);
        }
        this.updateConsumptionInterval();
        super.ready(reliability);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"ready");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateLastNotReadyTime() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateLastNotReadyTime");
        }
        if (this.readAhead) {
            RemoteConsumerKey remoteConsumerKey = this;
            synchronized (remoteConsumerKey) {
                if (!this.usable) {
                    this.lastNotReadyTime = System.currentTimeMillis();
                    this.usable = true;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateLastNotReadyTime");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void updateConsumptionInterval() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"updateConsumptionInterval");
        }
        if (this.readAhead) {
            RemoteConsumerKey remoteConsumerKey = this;
            synchronized (remoteConsumerKey) {
                if (this.usable) {
                    this.usable = false;
                    long l = System.currentTimeMillis() - this.lastNotReadyTime;
                    this.consumptionInterval = (int)(0.5 * (double)l + 0.5 * (double)this.consumptionInterval);
                    if (this.consumptionInterval == 0) {
                        this.prefetchWindowSize = SIMPConstants.MAX_PREFETCH_WINDOW;
                    } else if (this.consumptionInterval > SIMPConstants.MAX_INTERVAL_FOR_PREFETCH) {
                        this.prefetchWindowSize = 0;
                    } else if ((long)this.consumptionInterval > this.rcd.getRoundTripTime()) {
                        this.prefetchWindowSize = 1;
                    } else {
                        this.prefetchWindowSize = (int)Math.ceil(this.rcd.getRoundTripTime() / (long)this.consumptionInterval);
                        if (this.prefetchWindowSize > SIMPConstants.MAX_PREFETCH_WINDOW) {
                            this.prefetchWindowSize = SIMPConstants.MAX_PREFETCH_WINDOW;
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateConsumptionInterval");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void messageReceived(AIStreamKey aIStreamKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageReceived", (Object)aIStreamKey);
        }
        RemoteConsumerKey remoteConsumerKey = this;
        synchronized (remoteConsumerKey) {
            ++this.countOfUnlockedMessages;
            if (aIStreamKey.getOriginalTimeout() == SIMPConstants.INFINITE_TIMEOUT) {
                --this.countOfOutstandingInfiniteTimeoutGets;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageReceived");
        }
    }

    protected final void completedReceived(AIStreamKey aIStreamKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"completedReceived", (Object)aIStreamKey);
        }
        this.completedReceivedNoPrefetch(aIStreamKey);
        try {
            if (this.readAhead) {
                this.tryPrefetching();
            }
        }
        catch (SIResourceException sIResourceException) {
            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerKey.completedReceived", (String)"1:419:1.38", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"completedReceived");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void completedReceivedNoPrefetch(AIStreamKey aIStreamKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"completedReceivedNoPrefetch", (Object)aIStreamKey);
        }
        RemoteConsumerKey remoteConsumerKey = this;
        synchronized (remoteConsumerKey) {
            if (aIStreamKey.getOriginalTimeout() == SIMPConstants.INFINITE_TIMEOUT) {
                --this.countOfOutstandingInfiniteTimeoutGets;
            }
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"completedReceivedNoPrefetch");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void messageLocked(AIStreamKey aIStreamKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageLocked", (Object)aIStreamKey);
        }
        RemoteConsumerKey remoteConsumerKey = this;
        synchronized (remoteConsumerKey) {
            --this.countOfUnlockedMessages;
        }
        try {
            if (this.readAhead) {
                this.tryPrefetching();
            }
        }
        catch (SIResourceException sIResourceException) {
            FFDCFilter.processException((Throwable)sIResourceException, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerKey.messageLocked", (String)"1:469:1.38", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)sIResourceException));
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageLocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void messageUnlocked(AIStreamKey aIStreamKey) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"messageUnlocked", (Object)aIStreamKey);
        }
        RemoteConsumerKey remoteConsumerKey = this;
        synchronized (remoteConsumerKey) {
            ++this.countOfUnlockedMessages;
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"messageUnlocked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private final void tryPrefetching() throws SIResourceException {
        int n;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"tryPrefetching");
        }
        int n2 = 0;
        AIStreamKey[] aIStreamKeyArray = this;
        // MONITORENTER : this
        if (!this.detached && (n = this.countOfOutstandingInfiniteTimeoutGets + this.countOfUnlockedMessages) < this.prefetchWindowSize && (double)(this.prefetchWindowSize - n) / (double)this.prefetchWindowSize > SIMPConstants.MIN_PREFETCH_SIZE) {
            n2 = this.prefetchWindowSize - n;
            this.countOfOutstandingInfiniteTimeoutGets += n2;
        }
        // MONITOREXIT : aIStreamKeyArray
        if (n2 > 0 && (n = (aIStreamKeyArray = this.rcd.issueGet(this.criteria, n2, (RemoteDispatchableKey)this)) == null ? 0 : aIStreamKeyArray.length) < n2) {
            Object object = this;
            // MONITORENTER : this
            this.countOfOutstandingInfiniteTimeoutGets -= n2 - n;
            // MONITOREXIT : object
            object = new SIResourceException(nls.getFormattedMessage("ANYCAST_STREAM_UNAVAILABLE_CWSIP0481", new Object[]{this.rcd.getDestName(), this.rcd.getLocalisationME().toString()}, null));
            FFDCFilter.processException((Throwable)object, (String)"com.ibm.ws.sib.processor.impl.RemoteConsumerKey.tryPrefetching", (String)"1:541:1.38", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)object);
            this.consumerPoint.notifyException((SIException)((Object)object));
        }
        if (!tc.isEntryEnabled()) return;
        SibTr.exit((TraceComponent)tc, (String)"tryPrefetching");
    }

    public final SelectionCriteria[] getSelectionCriteria() {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getSelectionCriteria");
        }
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getSelectionCriteria", (Object)this.criteria);
        }
        return this.criteria;
    }

    public void notifyException(SIException sIException) {
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"notifyException");
        }
        this.consumerPoint.notifyException(sIException);
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"notifyException");
        }
    }

    public boolean hasNonSpecificConsumers() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"hasNonSpecificConsumers");
        }
        boolean bl2 = bl = !this.isSpecific();
        if (tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"hasNonSpecificConsumers", (Object)bl);
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info:  @(#)SIB/ws/code/sib.processor.impl/src/com/ibm/ws/sib/processor/impl/RemoteConsumerKey.java, SIB.processor, WAS602.SIB, o0610.11 1.38");
        }
    }
}

